﻿aui.io = {
    fso: null,

    createObject: function() {
        if (this.fso) return;

        this.fso = new ActiveXObject("Scripting.FileSystemObject");
    },

    /**
    /Folder
    **/

    //Delete
    deleteFolder: function(dir) {
    },

    //Copy
    copyFolder: function(from, to) {
    },

    //Move
    moveFolder: function(from, to) {
    },

    //Create - if dir not exitst , it will create for you
    createFolder: function(dir) {
        this.createObject();
        if (dir.charAt(dir.length - 1) == '/')
            dir = dir.slice(0, dir.length - 1);

        var temp = dir.split('/');
        var parentDir = dir.replace('/' + temp[temp.length - 1], '');

        if (!this.isFolder(parentDir))
            this.createFolder(parentDir);

        if (!this.isFolder(dir))
            this.fso.CreateFolder(dir.replaceAll('/', '\\'));
    },

    isFolder: function(dir) {
        this.createObject();
        return this.fso.FolderExists(dir);
    },

    //Delete
    deleteFile: function(dir) {
    },

    //Copy
    copyFile: function(from, to) {
    },

    //Move
    moveFile: function(from, to) {
    },

    //is File
    isFile: function(dir) {
        return this.fso.FileExists(dir);
    },

    //Open
    //Encoding: -1 unicode -2 ascii
    openFile: function(dir, encoding) {
        this.createObject();
        if (this.isFile(dir)) {
            var file = this.fso.OpenTextFile(dir, aui.io.mode.Reading, true, encoding || -1); //-1 unicode -2 ascii
            var content = file.ReadAll();
            file.Close();

            return content;
        }

        exception("File Not Found", "aui.io.openFile");
    },

    //Save
    saveFile: function(dir, content) {
        this.createObject();
        var temp = dir.split('/');

        var fileName = temp[temp.length - 1];
        var filepath = dir.replace('/' + fileName, '/');

        this.createFolder(filepath);

        var file = this.fso.OpenTextFile(filepath + fileName, aui.io.mode.Writing, aui.io.mode.TristateTrue);
        file.Write(content);
        file.Close();
    }
}

aui.io.mode = {
    Reading: 1,
    Writing: 2,
    Appending: 8,
    TristateUseDefault: -2,
    TristateTrue: -1,
    TristateFalse: 0

}

/**
* @constructor
* @param {string} path 
* Optional. A string containing a URL that specifies the location of the XML file.
* @property {XMLDom} Document
* @property {string} FilePath
*/
aui.io.XMLFile = function(path) {
    function getXMLDom() {
        var tmpXmlDoc = Try.these( //IE9 bug, use Microsoft.XMLDOM
        //			    function() { return document.implementation.createDocument("", "", null); },
        //			    function() { return new ActiveXObject("Msxml2.XMLDOM"); },
			    function() { return new ActiveXObject("Microsoft.XMLDOM"); }
		    ) || false;
        return tmpXmlDoc;
    };

    this.Document = getXMLDom();
    this.FilePath = path;
    if (this.FilePath) {
        this.Document.async = false;
        this.Document.load(this.FilePath);
    }
}

aui.io.XMLFile.prototype = {
    /** @lends aui.io.XMLFile.prototype */
    /**
    * @function
    * @param {string} destination
    * Optional, 
    * An object. The object can represent a file name, 
    * an ASP Response object, a DOMDocument object, 
    * or a custom object that supports persistence.
    * Use last destination if null.
    * @remark
    * <p>
    * The behavior differs based on the object specified 
    * by the objTarget parameter.
    * </p>
    * <table>
    * <tr><td>{string}</td><td>
    * Specifies the file name. This must be a file name 
    * rather than a URL. The file is created, if necessary, 
    * and the contents are replaced entirely with the contents 
    * of the saved document. This mode is not intended for 
    * use from a secure client, such as Microsoft Internet Explorer.
    * </td></tr>
    * <tr><td>{IXMLDocument Object}</td><td>
    * Duplicates the original document. It is the equivalent 
    * of saving the document and reparsing it. The document 
    * goes through full persistence through XML markup, 
    * thereby testing the persistability of your XML document. 
    * </td></tr>
    * </table>
    */
    save: function(destination) {
        this.FilePath = (destination) ? destination : this.FilePath;
        if (this.FilePath) {
            var ex = null;

            try {
                this.Document.save(this.FilePath);
            } catch (e) {
                ex = e;
            }

            if (ex) {
                try {
                    aui.io.saveFile(this.FilePath, this.Document.xml);
                    //aui.io.saveFile("C:/device.xml", this.Document.xml);
                    ex = null;
                } catch (e) {
                    ex = e;
                }
            }

            if (ex)
                exception(ex.message, "aui.io.XMLFile.save()");
        } else {
            exception("Destination not found", "aui.io.XMLFile.save()");
        }
        alert(this.FilePath + " saved!");
    },

    /**
    * Return xml string.
    * @function
    */
    toString: function() {
        return this.Document.xml;
    }
}

var HTTPRequestQueue = [];
var HTTPRequest = new XMLHttpRequest();

aui.io.HTTPRequest = {
    abort: function(){
        while(HTTPRequestQueue.length)
            HTTPRequestQueue.pop();
        
        if(HTTPRequest.onreadystatechange){
            HTTPRequest.onreadystatechange = null;
            HTTPRequest.ontimeout = null;            
            HTTPRequest.abort();
        }
    },
    
    queue: function(config){//url, callback, data, header, async, mode, timeout, user, password){
        if(config)
            HTTPRequestQueue.push(config);
        
        if(!HTTPRequest.onreadystatechange && HTTPRequestQueue.length)
            this.send(HTTPRequestQueue.shift());
    },
    
    queueCallback: function(result, callback){   
        if(callback)
            callback(result);
        
        HTTPRequest.onreadystatechange = null;
        HTTPRequest.ontimeout = null;
        
        var me = this;
        function queue(){
            me.queue();
        }
        if(HTTPRequestQueue.length)
            window.setTimeout(queue, 15);
    },
    
    _retryTime: 0,//retry 1 times
    
    connectFailure: function(config, status){
        if(this._retryTime || !config.retry){
            if(!status) status = 'ERROR';
            this._retryTime = 1;
            this.queueCallback(status, config.callback);
        }else{
            HTTPRequestQueue.unshift(config);
            this._retryTime++;
            HTTPRequest.onreadystatechange = null;
            HTTPRequest.ontimeout = null;
            
            var me = this;
            function queue(){
                me.queue();
            }
            window.setTimeout(queue, 15);
        }
    },
    
    send: function(config){
        var me = this;
        config.async = (config.async || config.async == null);
        config.retry = (config.retry || config.retry == null);
        config.mode = config.mode || 'GET';

        HTTPRequest.ontimeout = function(){
            me.connectFailure(config, 'TIMEOUT');
        };
        
        try{
            var account = config.account || null;
            var password = config.password || null;
            
            HTTPRequest.open(config.mode, config.url, config.async, account, password);
            HTTPRequest.onreadystatechange = sendDataBack;
            
            HTTPRequest.timeout = (config.timeout != null) ? config.timeout : 60000; //default 30secs, julio modified to 60secs.
            
            HTTPRequest.setRequestHeader('Content-Type', config.header || 'application/x-www-form-urlencoded');
            HTTPRequest.send(config.data);
        }catch(e){
            me.connectFailure(config);
        }

        function sendDataBack(){
            var result;
            if(HTTPRequest.readyState == 4){
                switch (HTTPRequest.status) {
                    case 200: case 204: case 1223:
                        result = [1, 0];
                        break;
                    case 12152:
                        result = [0, 1];
                        break;
                    case 12029:
                        result = [0, 0];
                        break;
                    default:
                        result = [1, 1];
                        break;
                }
                try {
                    switch(config.header){
                        case 'text/plain':
                            me.queueCallback(HTTPRequest.responseText, config.callback, result);
                            break;
                        case 'text/xml':
                            me.queueCallback(HTTPRequest.responseXML, config.callback, result);
                            break;
                        default:
                            me.queueCallback(HTTPRequest, config.callback, result);
                    }
                }catch(e){
                    me.queueCallback('ERROR', config.callback);
                }
            }
        }
    },
    
    updateXML: function(config){
        this.queue({
            url:config.url,
            callback:config.callback,
            data:config.data,
            header:'text/xml',
            async:config.async,
            retry:config.retry,
            mode:'POST',
            timeout:config.timeout,
            account:config.account,
            password:config.password});
    },

    updateText: function(config){
        this.queue({
            url:config.url,
            callback:config.callback,
            data:config.data,
            header:'text/plain',
            async:config.async,
            retry:config.retry,
            mode:'POST',
            timeout:config.timeout,
            account:config.account,
            password:config.password});
    },

    updateJSON: function(config){
        this.queue({
            url:config.url,
            callback:function(data){
                if(config.callback){
                    try{ data = eval('('+data+')'); }
                    catch(e){ data = {}; }
                    config.callback(data);
                }
            },
            data:config.data,
            header:'text/plain',
            async:config.async,
            retry:config.retry,
            mode:'POST',
            timeout:config.timeout,
            account:config.account,
            password:config.password});
    },

    loadXML: function(config){
        this.queue({
            url:config.url,
            callback:config.callback,
            header:'text/xml',
            async:config.async,
            retry:config.retry,
            mode:'GET',
            timeout:config.timeout,
            account:config.account,
            password:config.password});
    },
        
    loadText: function(config){
        this.queue({
            url:config.url,
            callback:config.callback,
            header:'text/plain',
            async:config.async,
            retry:config.retry,
            mode:'GET',
            timeout:config.timeout,
            account:config.account,
            password:config.password});
    },
    	
    loadJSON: function(config){ 
        this.queue({
            url:config.url,
            callback:function(data){  
                if(config.callback){  
                    if(data != "ERROR"){
                        try{ data = eval('('+data+')'); }
                        catch(e){ data = {}; }
                    }else{
                        data = {};
                    }
                    config.callback(data);
                }
            },
            header:'text/plain',
            async:config.async,
            retry:config.retry,
            mode:'GET',
            timeout:config.timeout,
            account:config.account,
            password:config.password});
    },
    
    loadXMLFile: function(path, callback, async) {
        
        function getXMLDom(){
            var tmpXmlDoc = false;
            try{
                tmpXmlDoc = new ActiveXObject("Microsoft.XMLDOM");
            }
            catch(e){ }
            
            return tmpXmlDoc;
        };
        
        var xmlDocument = getXMLDom();
            xmlDocument.async = false;
            xmlDocument.load(path);
        
        if (callback) callback(xmlDocument);
        return xmlDocument;
    }
};

aui.io.Text2Object = function(text){
    
    var obj = {};
        obj = text;
    
    return obj;
}

aui.io.JSON2Object = function(text){
    
    var obj = {};
        obj = JSON.parse(text);
    
    return obj;
}

aui.io.XML2Object = function(xml){
    
    // Create the return object
    var obj = {};

    switch(xml.nodeType){
    
        case 1: // element
            
            if(xml.attributes.length > 0){ // attributes
                for(var j = 0; j < xml.attributes.length; j++){
                    var attribute = xml.attributes.item(j);
                    obj[attribute.nodeName] = attribute.nodeValue;
                }
                
                if(xml.firstChild){
                    if(xml.firstChild.nodeName == "#text"){
                        obj._Value = xml.text;
                    }
                }
            }
            else if(xml.firstChild){
                if(xml.firstChild.nodeName == "#text"){
                    obj = xml.text;
                }
            }
            
            break;
        
        case 3: // text
            
            obj = xml.nodeValue;
            
            break;
    }
    
    if(xml.hasChildNodes()){ // childrens
        for(var i = 0; i < xml.childNodes.length; i++) {
            var item = xml.childNodes.item(i);
            var nodeName = item.nodeName;
            
            if(nodeName != "#text"){
                if(typeof(obj[nodeName]) == "undefined"){
                    
                    obj[nodeName] = aui.io.XML2Object(item);
                }
                else{
                    if(typeof(obj[nodeName].length) == "undefined" || typeof(obj[nodeName]) == "string"){
                        var old = obj[nodeName];
                        obj[nodeName] = [];
                        obj[nodeName].push(old);
                    }
                    obj[nodeName].push(aui.io.XML2Object(item));
                }
            }
            
        }
    }
    return obj;
}


aui.io.RemoteCommand = function() { this.pvt = null; };
aui.io.RemoteCommand.prototype = {
    send: function(request) {
        this.request = {
            method: "GET",
            url: "",
            user: null,
            password: null,
            headers: {},
            body: null,
            onSuccess: null,
            onFailure: null,
            async: false,
            timeout: 60000
        }
        var me = this;

        this.request = aui.lang.merge(this.request, request || {});
        if (!this.pvt) {
            this.pvt = Try.these(
                function() { return new XMLHttpRequest() },
                function() { return new ActiveXObject('Msxml2.XMLHTTP') },
                function() { return new ActiveXObject('Microsoft.XMLHTTP') }
            ) || false;

            this.pvt.onreadystatechange = function() {
                me.response = null;
                function convert(data) {
                    var output = {};
                    var line = data.split('\r\n');
                    for (var key in line) {
                        var pair = line[key].split(':');
                        if (pair.length == 2)
                            output[pair[0]] = pair[1];
                    }
                    return output;
                }
                if (this.readyState == 4) {
                    if (this.status == 200) {
                        if (me.request && me.request.onSuccess) {
                            rep = new aui.io.Response();
                            rep.status = this.status;
                            rep.text = this.responseText;
                            rep.xml = this.responseXML;
                            rep.headers = convert(this.getAllResponseHeaders());
                            me.request.onSuccess(rep);
                            me.response = rep;
                        }
                    } else {
                        if (me.request && me.request.onFailure) {
                            rep = new aui.io.Response();
                            rep.status = this.status;
                            rep.text = this.responseText;
                            rep.xml = this.responseXML;
                            rep.headers = convert(this.getAllResponseHeaders());
                            me.request.onFailure(rep);
                            me.response = rep;
                        }
                    }
                }
            }
            this.pvt.ontimeout = function() {
                if (me.request && me.request.onFailure) {
                    rep = new aui.io.Response();
                    me.request.onFailure(rep);
                    me.response = rep;
                    me.pvt.onreadystatechange = null; /* Judy modified for Bug 11676, handle HTTPRequest timeout exception in IE8;
                                                         In IE8, after ontimeout, HTTPRequest fire one more time onreadystatechange,
                                                         will cause exception because there's no status in HTTPRequest */
                }
            }
        }

        try {
            this.pvt.open(
                this.request.method,
                this.request.url,
                this.request.async,
                this.request.user,
                this.request.password);
            this.pvt.timeout = this.request.timeout;

            for (var key in this.request.headers)
                this.pvt.setRequestHeader(key, this.request.headers[key]);

            if (this.request.body) {
                this.pvt.send(this.request.body);
            } else {
                this.pvt.send();
            }
        } catch (e) {
            trace(e.message);
            if (me.request.onFailure)
                me.request.onFailure(null);
        }
        return this.response;
    }
}

aui.io.Request = function() { };
aui.io.Request.prototype = {
    method: "GET",
    url: "",
    user: null,
    password: null,
    headers: {},
    body: null,
    onSuccess: null,
    onFailure: null,
    async: false
}

aui.io.Response = function() { };
aui.io.Response.prototype = {
    status: 0,
    headers: null,
    text: null,
    xml: null,
    toObject: function() { return eval(this.text); },
    toString: function() { return this.text; },
    toDom: function() { return this.xml; }
}

/* Path parser */
aui.io.Path = function(path) {
    var me = this;
    var str = aui.text.String.trim(path).replace(/[^\\\/:*?\"\'<>|]+\.[a-z]+$/i, function(a, b) {
        a.replace(/\.([^.]*)/, function(c, d) {
            me.fileName = a.replace(new RegExp(c + "$"), "");
            me.extension = d;
        });
    });
    this.directory = /[\\\/]$/.test(str) ? str : str + "\\";
}
aui.io.Path.prototype = {
    fileName: null,        /* file name without extension */
    extension: null,       /* file extension */
    directory: null        /* directory of this path */
}

aui.io.Path.getFullPath = function(path) { return new aui.io.Path(path).directory; }
aui.io.Path.getExtension = function(path) { return new aui.io.Path(path).extension; }
aui.io.Path.getFileName = function(path) { return new aui.io.Path(path).fileName; }
aui.io.Path.getFileNameWithExtension = function(path) { var obj = new aui.io.Path(path); return obj.fileName + "." + obj.extension; }