﻿var Delegate = aui.lang.util.CustomEvent;

/**
 * Create a collection of associated string keys.
 * @class Represents a collection of associated String keys and 
 * String values that can be accessed either with the key or 
 * with the index.
 * @constructor
 */
aui.collections.NameValueCollection = function(){
    this._collections = {};
};

aui.collections.NameValueCollection.prototype = {
    /** @lends aui.collections.NameValueCollection.prototype */

    /** 
     * @private 
     * @function 
     */
	_initObj: function(key){
    	this._collections[key] = this._collections[key] || [];	
	},

    /** Find value by given key.
     * @private
     * @function 
     */
    _ValueOfKey: function(key){
    	return this._collections[key] || null;
    },

    /** Find key by given value.
     * @private
     * @function 
     */
    _KeyOfValue: function(item){
        for(var key in this._collections)
            for(var i in this._collections[key])
                if(this._collections[key][i]==item) return key;
            
        return false;
    },
    
    /** Change value to the item with the given key.
     * @private
     * @function 
     */
    _UpdateValueOfKey: function(key, value){
    	this.remove(key);
    	this.add(key, value);
    },

    /**
     * Get key as collection.
     * @public
     * @function
     * @return {aui.collections.KeyCollection}
     * Gets all the keys in this collection. 
     */
    getAllKeys: function(){
        return this.getKeys();
    },

    /** 
     * Gets the number of key/value pairs contained in instance.
     * @public
     * @function
     * @return {number}
     * Returns the number of key/value pairs contained in instance. 
     */
    getCount: function(){
    	var count = 0;
    	for(var i in this._collections) count++;
        return count;
    },

    /** 
     * Gets a KeysCollection instance that contains all the keys in instance.
     * @public
     * @function
     * @return {aui.collections.KeyCollection}
     * Returns a KeysCollection instance that contains all the keys in instance. 
     */
    getKeys: function(){
        var keys = new aui.collections.KeyCollection();
        for(var i in this._collections) keys.add(i);
        return keys;
    },

    /** 
     * Get the value indexed with specify key.
     * @public
     * @function
     * @param {string} key
     * The key index for indexing value.
     * @return {array}
     * Return all value indexed with specified key as an array.
     */
    getItem: function(key){
        return this._ValueOfKey(key);
    },
    
    /** 
     * Change the value which indexed with specify key.
     * @public
     * @function
     * @param {string} key
     * The key index for indexing value.
     * @param {object} value
     * New value for specify key.
     */
    setItem: function(key, value){
        this._UpdateValueOfKey(key, value);
    },

    /**
     * Add a new key/value pair into current instance.
     * @public
     * @function
     * @param {string} key
     * New key index for new value.
     * @param {object} value
     * The value for new key.
     */
    add: function(key,value){
    	this._initObj(key);
        this._collections[key].push(value);
    },

    /**
     * Clear all keys and values in current instance.
     * @public
     * @function
     */
    clear: function(){
    	for(var i in this._collections) this.remove(i);
    },
    
    /**
     * Detemine if the specify object is contained in this collection.
     * @public
     * @function
     * @param {object} item
     * Object for test.
     * @return {bool}
     * Return if the specify object reference is found in this collection.
     */
    contains: function(item){
        for(var key in this._collections)
            for(var i in this._collections[key])
                if(this._collections[key][i]==item) return true;
            
        return false;
    },
    
    /**
     * @public
     * @function {string}
     * @param {string} key
     */
    get: function(key){return this._ValueOfKey(key);},

    /**
     * @public
     * @function
     * @param {number} index
     * @return {string}
     */
    getKey: function(index){exception("GetKey wasn't implement yet." , "NameValueCollection");},

    /**
     * @public
     * @function
     * @param {string} key
     * @return {object}
     */
    getValues: function(key){return this._ValueOfKey(key);},

    /**
     * @public
     * @function
     */
    hasKeys: function(){return (this._collections!={})},

    //GetObjectData= function(){},
    //OnDeserialization= function(){},
    
    /**
     * @public
     * @function
     * @param {string} key
     */
    remove: function(key){
    	this._initObj(key);
    	while(this._collections[key].length>0) this._collections[key].pop();
    	this._collections[key] = null;
    	delete this._collections[key];
    },

    /**
     * @public
     * @function
     * @param {string} key
     * @param {object} value
     */
    set: function(key,value){
        this._UpdateValueOfKey(key,value);
    },
    
    
    /**
     * Enumerate each item with specify callback function.
     * @public
     * @function
     * @param {function} callback
     * The callback function to access each item.
     */
    each: function(callback){
        var value;
    	for(var i in this._collections) {
    		value = callback( {index: i, item: this._collections[i]} );
    		if (value == "break") break;
    	}
    },
    
    /**
     * Export all values into a new collection.
     * @public
     * @function
     * @return {aui.collections.ArrayList}
     * New collection which contains all value in this collection.
     */
    toArrayList: function(){
        var output = new aui.collections.ArrayList();
        this.each(function(each){
            output.add(each.item);
//        	for(var i in each.item) 
//        	        output.add(each.item[i]);
        });
        return output;
    }
};

/**
 * Represent a set of value ordered with index.
 * @constructor
 * @param {bool} withEvent
 * Specify whether you need the collection to trigger event
 * or not. The default is false if not giving any value.
 */
aui.collections.CollectionBase = function(withEvent) {
    this._array = [];
    this.pvtWithEvent = withEvent || false;

    // template methods
    if (this.pvtWithEvent) {
        this.onClear = new Delegate("onClear", this);
        this.onClearComplete = new Delegate("onClearComplete", this);
        this.onInsert = new Delegate("onInsert", this);
        this.onInsertComplete = new Delegate("onInsertComplete", this);
        this.onRemove = new Delegate("onRemove", this);
        this.onRemoveComplete = new Delegate("onRemoveComplete", this);
        this.onSet = new Delegate("onSet", this);
        this.onSetComplete = new Delegate("onSetComplete", this);
        this.onValidate = new Delegate("onValidate", this);
    }
};

aui.collections.CollectionBase.prototype = {
    /** @lends aui.collections.CollectionBase.prototype */

    _array: null,
    _readOnly: false,
    _isFixedSize: false,
    _synchronized: false,
    _throwEx: function(event) {
        if (event.lastError)
            exception(event.lastError.message, "aui.collections.CollectionBase");
    },

    /** 
    * Gets the number of key/value pairs contained in instance.
    * @public
    * @function
    * @return {number}
    * Returns the number of key/value pairs contained in instance. 
    */
    getCount: function() {
        return this._array.length;
    },
    
    getRealCount: function(){
    	var count = 0;
    	for(var i in this._array) count++;
        return count;
    },

    /**
    * @function
    * @return {bool}
    */
    getIsFixedSize: function() {
        return this._isFixedSize;
    },

    /**
    * @function
    * @return {bool}
    */
    getIsReadOnly: function() {
        return this._readOnly;
    },

    /**
    * @function
    * @return {bool}
    */
    getIsSynchronized: function() {
        return this._synchronized;
    },

    /**
    * @function
    * @return {object}
    */
    getSyncRoot: function() {
        exception("This interface wasn't implemented yet.", "CollectionBase");
        return null;
    },

    /** 
    * Get the value indexed with specify number.
    * @public
    * @function
    * @param {number} index
    * The index for indexing value.
    * @return {array}
    * Return a value indexed with specified number.
    */
    getItem: function(index) {
        return this._array[index];
    },
    
    getItemByAttribute: function(attribute, name){
        for(var i = 0; i < this.getCount(); i++){
            if(this._array[i][attribute] == name) return this._array[i];
        }
    },

    /** 
    * Change the value which indexed with specify number.
    * @public
    * @function
    * @param {number} index
    * The index for indexing value.
    * @param {object} value
    * New value for specify index.
    */
    setItem: function(index, newItem) {
        var oldItem = this._array[index];
        if (this.pvtWithEvent) {
            this.onSet.fire({ index: index, oldItem: oldItem, newItem: newItem });
            this._throwEx(this.onSet);
            this.onValidate.fire({ item: newItem });
            this._throwEx(this.onValidate);
        }
        this._array[index] = newItem;
        if (this.pvtWithEvent) {
            this.onSetComplete.fire({ index: index, oldItem: oldItem, newItem: newItem });
            this._throwEx(this.onSetComplete);
        }
    },

    /**
    * Add a new value into current instance.
    * @public
    * @function
    * @param {object} value
    * The new value.
    */
    add: function(value) {
        var newIndex = this.getCount();
        this.insert(newIndex, value);
        return newIndex;
    },

    /**
    * Clear all values in current instance.
    * @public
    * @function
    */
    clear: function() {
        if (this.pvtWithEvent) {
            this.onClear.fire();
            this._throwEx(this.onClear);
        }
        //this._array.clear();
        while (this._array.length > 0) {
            this._array.pop();
        }
        this._array = new Array();

        if (this.pvtWithEvent) {
            this.onClearComplete.fire();
            this._throwEx(this.onClearComplete);
        }
    },

    /**
    * Detemine if the specify object is contained in this collection.
    * @public
    * @function
    * @param {object} item
    * Object for test.
    * @return {bool}
    * Return if the specify object reference is found in this collection.
    */
    contains: function(item) {
        return this.indexOf(item) >= 0;
    },

    /**
    * @public
    * @function
    * @param {array} targetArray
    * @param {number} index
    */
    copyTo: function(targetArray, index) {
        for (var i = 0; i < this._array.length; i++) {
            if (index == 0) {
                targetArray.push(item);
            }
            else if (index > 0) {
                index--;
            }
        }
    },


    /**
    * Find the index of specified object.
    * @public
    * @function
    * @param {object} item
    * Object for test.
    * @return {number}
    * Return the index of specified object. 
    * If the object isn't contained, returns -1.
    */
    indexOf: function(item) {
        for (var i = 0; i < this._array.length; i++) {
            if (this._array[i] == item) return i;
        }
        return -1;
    },

    /**
    * @public
    * @function
    * @param {number} index
    * @param {object} item
    */
    insert: function(index, item) {
        if (this.pvtWithEvent) {
            this.onInsert.fire({ index: index, item: item });
            this._throwEx(this.onInsert);
            this.onValidate.fire({ item: item });
            this._throwEx(this.onValidate);
        }

        this._array.splice(index, 0, item);

        if (this.pvtWithEvent) {
            this.onInsertComplete.fire({ index: index, item: item });
            this._throwEx(this.onInsertComplete);
        }
    },

    /**
    * @public
    * @function
    * @param {object} item
    */
    remove: function(item) {
        var index = this.indexOf(item);
        //deray. when obj not found.don't cause exception
        if (index < 0) return false;//exception("Specified item not found.", "ArrayList");

        this.removeAt(index);
    },

    /**
    * @public
    * @function
    * @param {number} index
    */
    removeAt: function(index) {
        var item = this._array[index];
        if (item == null) exception("Specified item not found.", "ArrayList");

        if (this.pvtWithEvent) {
            this.onRemove.fire({ index: index, item: item });
            this._throwEx(this.onRemove);
        }

        if (this._array.length > 1)
            this._array.splice(index, 1);
        else
            this._array.pop();

        if (this.pvtWithEvent) {
            this.onRemoveComplete.fire({ index: index, item: item });
            this._throwEx(this.onRemoveComplete);
        }
    },

    /**
    * Enumerate each item with specify callback function.
    * @public
    * @function
    * @param {function} callback
    * The callback function to access each item.
    */
    each: function(callback) {
        var value;
        for (var i = 0; i < this._array.length; i++) {
            value = callback({ index: i, item: this._array[i] });
            if (value == "break") break;
        }
    },

    /**
    * @public
    * @function
    * @param {function} compare
    */
    sort: function(compare) {
        this._array.sort(compare);
    }
};

/**
 * Represent the collections of keys for {aui.collections.NameValueCollection}.
 * @constructor
 * @extends aui.collections.CollectionBase
 */
aui.collections.KeyCollection = function() {
    aui.collections.KeyCollection.superclass.constructor.call(this, false);
};
aui.lang.Class.extend(aui.collections.KeyCollection, aui.collections.CollectionBase);

/**
 * An implement of collection which collects any type of instance.
 * @constructor
 * @extends aui.collections.CollectionBase
 */
aui.collections.ArrayList = function(withEvent) {
    withEvent = withEvent || false;
    aui.collections.ArrayList.superclass.constructor.call(this, withEvent);
};
aui.lang.Class.extend(aui.collections.ArrayList, aui.collections.CollectionBase);

/**
* An implement of collection which collects any type of instance.
* The collection will ensure no duplicate reference to one instance.
* @constructor
* @extends aui.collections.CollectionBase
*/
aui.collections.SingleReferenceCollection = function(withevent) {
    aui.collections.SingleReferenceCollection.superclass.constructor.call(this, withevent);
};
aui.lang.Class.extend(aui.collections.SingleReferenceCollection, aui.collections.CollectionBase, {
    insert: function(index, item) {
        if(this.contains(item))
            this.remove(item);
        aui.collections.SingleReferenceCollection.superclass.insert.call(this, index, item);
    },
    setItem: function(index, newItem) {
        if(this.contains(newItem))
            this.remove(item);
        aui.collections.SingleReferenceCollection.superclass.setItem.call(this, index, newItem);
    }
});