﻿aui.ui.DropDownList = function(options) {
    var me = this;
    /* merge options */
    this.options = {
        className: "aui-ui-DropDownList"
    }
    this.options = aui.lang.merge(this.options, options || {});

    this.pvtContainer = NewObj("div", this.options.className);
    this.pvtTextContainer = NewObj("div", "dropdown-containter");
    this.pvtContainer.appendChild(this.pvtTextContainer);

    this.pvtText = NewObj("div", "dropdown-text");
    this.pvtIcon = NewObj("div", "dropdown-icon");
    this.pvtTextContainer.appendChild(this.pvtText);
    this.pvtTextContainer.appendChild(this.pvtIcon);

    /* select */
    this.object = document.createElement("select");
    this.object.className = "dropdown-select"; //this.options.className;
    this.pvtContainer.appendChild(this.object);

    /* events */
    this.onSet = new aui.lang.util.CustomEvent("onSet", this);
    this.onClick = new aui.lang.util.CustomEvent("onClick", this);
    this.onChange = new aui.lang.util.CustomEvent("onChange", this);
    this.object.onclick = function() { me.onClick.fire() };
    this.object.onchange = function() {
        me.onChange.fire();
        if (me.object.selectedIndex == -1) return;
        me.pvtText.innerText = me.object.options[me.object.selectedIndex].text;
        me.pvtContainer.title = me.object.options[me.object.selectedIndex].text;

    };
    this.object.onmousedown = function() { event.cancelBubble = true; };    //Albert add, UI 3.0.01.13-006
}

aui.ui.DropDownList.prototype = {
    render: function(nodeToAppend) {
        //	    nodeToAppend.appendChild(this.object);
        nodeToAppend.appendChild(this.pvtContainer);
        this._appendToNode = nodeToAppend;

        //default value
        if (this.object.selectedIndex == -1) return;
        this.pvtText.innerText = this.object.options[this.object.selectedIndex].text;
        this.pvtContainer.title = this.object.options[this.object.selectedIndex].text;
    },

    unrender: function() {
        //	    if(this.object.parentElement) this.object.parentNode.removeChild(this.object);
        if (this.pvtContainer.parentElement) this.pvtContainer.parentNode.removeChild(this.pvtContainer);
    },

    setWidth: function(width) {
        width = Number(width) + 2;

        if (width <= 21) return;
        this.pvtContainer.style.width = width + "px";
        this.pvtTextContainer.style.width = width + "px";
        this.pvtText.style.width = (width - 21) + "px";
        this.object.style.width = width + "px";   //Albert Modify, Bug 11031 IE8 cna't auto fit width.
        //this.object.style.minWidth = width + "px";    //IE8限制，Bug 11276, limitation S3.0.01.12-003, 
                                                        //指定下拉選單的寬度，在IE8中，下拉的選項內容超過選單的部分會被cut off，但在IE9中會自動延展, 此為IE8原本的限制.
    },

    getCount: function() {
        return this.object.options.length;
    },

    getValue: function(index) {
        if (!index && this.object.selectedIndex == -1) return;
        else if (index == undefined) return this.object.options[this.object.selectedIndex].value;
        else return this.object.options[index].value;
    },

    getText: function(index) {
        if (!index && this.object.selectedIndex == -1) return;
        else if (index == undefined) return this.object.options[this.object.selectedIndex].text;
        else return this.object.options[index].text;
    },

    setValue: function(value, fire) {
        value = (value == null || value == undefined) ? '' : value;
        value = value.toString();
        var obj = this.object.options;

        this.object.selectedIndex = 0;

        if (this.object.options.length) {
            this.pvtText.innerText = this.object.options[this.object.selectedIndex].text;
            this.pvtContainer.title = this.object.options[this.object.selectedIndex].text;
        }
        else {
            this.pvtText.innerText = '';
            this.pvtContainer.title = '';
        }

        if (fire) this.onChange.fire(this);

        for (var i = 0; i < obj.length; i++) {
            if (obj[i].value === value) {
                this.object.selectedIndex = i;
                this.pvtText.innerText = this.object.options[i].text;
                this.pvtContainer.title = this.object.options[i].text;
                this.onSet.fire();
                return;
            }
        }

    },
    
    setIndex: function(index, fire) {
        index = (index == null || index == undefined) ? 0 : index;
        this.object.selectedIndex = index;
        if (this.object.selectedIndex < 0) return;
        this.pvtText.innerText = this.object.options[this.object.selectedIndex].text;
        this.pvtContainer.title = this.object.options[this.object.selectedIndex].text;
        this.onSet.fire();
    
        if (fire) this.onSet.fire(this);
        if (fire) this.onChange.fire(this);
    },

    clear: function(index) { // also can remove all
        
        var obj = this.object.options;
        
        if (index == undefined){
            while (obj.length > 0) obj.remove(0);
            
            this.pvtText.innerText = ''; // Julio modified to clear the text when there is no options in list.
            this.pvtContainer.title = '';
        }
        else
            obj.remove(index);
         
    },
    //Albert Added, 改進效能版本，針對大量資料
    clearAll: function() {        
        this.object.innerHTML = "";
    },

    addOption: function(key, value) {
        if (value == undefined) value = key;
        if (typeof key == 'object') key = key.innerText;
        
        /* Julio modified for bug #12174, space can't display correctly. */
        var option = document.createElement('option');
            option.innerText = key;
            option.value = value;
            
        this.object.options.appendChild(option);
        
        if(this.pvtText.innerText == ''){
            this.pvtText.innerText = key; // Julio modified to set the text as the first option when it was empty.
            this.pvtContainer.title = key;
        }
        
    },
    
    enable: function(value) {
        this.object.disabled = !value;
        this.pvtText.className = value ? "dropdown-text" : "dropdown-text-disable";
        this.pvtIcon.className = value ? "dropdown-icon" : "dropdown-icon-disable";
        if (!value) YAHOO.util.Dom.removeClass(this.pvtContainer, "error");
    },

    getEnable: function() {
        return !this.object.disabled;
    },

    error: function(value) {
        if (value) YAHOO.util.Dom.addClass(this.pvtContainer, "error");
        else YAHOO.util.Dom.removeClass(this.pvtContainer, "error");
    },

    focus: function() {
        if (this.object.focus) {
            try {
                this.object.focus();
            } catch (e) { }
        }
    },

    show: function() {
        this.pvtContainer.style.display = "";
    },

    hide: function() {
        this.pvtContainer.style.display = "none";
    }
}