﻿/**
 * @namespace 
 * <p>The aui namespace contains fundamental classes 
 * and base classes that define commonly-used value and reference 
 * data types, events and event handlers, interfaces, attributes, 
 * and processing exceptions.</p>
 * <p>Other classes provide services supporting data type 
 * conversion, method parameter manipulation, mathematics, remote 
 * and local program invocation, application environment 
 * management, and supervision of managed and unmanaged 
 * applications.</p>
 */
this.aui = {
    /**
    * @setting
    * <p>To enable or Disable debug window.</p>
    */
    debug: false,
    /** @lends aui */
    
    /**
    * @namespace
    * <p>This namespace defines an official way to build a software.
    * In this defination, a software contains three parts:</p><p><ul>
    * <li><strong>Program (aui.applications.ProgramBase)</strong><br/>
    * The Main entry point of software. When the system is loaded,
    * The method ProgramBase.run() will be called before any other 
    * service works. In this case, every software should initial
    * exactly one ProgarmBase instance within the main page</li>
    * <li><strong>Core (aui.applications.CoreBase)</strong><br/>
    * The Static service provider. Each software sholud implement
    * it's own Core services to provide User Management, Server 
    * Management and Localization services. And there should be
    * only one instance of CoreBase, too.</li>
    * <li><strong>Application (aui.applications.ApplicationBase)</strong><br/>
    * An program may contain more than one application, it depends
    * on how many page you wish to provide. For developing 
    * application, please fellow these steps:<ol>
    * <li>Define an new application class extends from
    * {aui.applications.ApplicationBase}.</li>
    * <li>Implement the initialize() method to initial layouts.</li>
    * <li>Create and regisit instance by overriding 
    * ProgramBase.onApplicationLoading(applications).</li>
    * </ol></li></ul></p>
    */
    applications: {
        getWidth: function() {
            return 440;
//            return document.documentElement.clientWidth || document.body.clientWidth;
        },
        getHeight: function() {
            return 227;
//            return document.documentElement.clientHeight || document.body.clientHeight;
        }
    },

    /**
    * @namespace
    * <p>The aui.collections namespace contains 
    * interfaces and classes that define various collections of
    * objects, such as lists, queues, bit arrays, hash tables 
    * and dictionaries.</p>
    */
    collections: {},
    /**
    * @namespace
    * <p>The aui.data namespace provides access to classes 
    * that represent the "ADO.NET Like" architecture. This architecture 
    * lets you build components that efficiently manage data from 
    * multiple data sources.</p>
    * <p>For current version, this library provide DataSet for caching
    * data from database, and those classes for accessing via different
    * database isn't contain in this version</p>
    */
    data: {},
    /**
    * @namespace The aui.diagnostics namespace provides classes 
    * that allow you to output debug message. 
    */
    diagnostics: {},
    /**
    * @namespace
    */
    drawing: {},
    /**
    * @namespace
    */
    lang: {},
    /**
    * @namespace
    * <p>
    * aui.nvr contains services of operating NetworkVideoRecorder.
    * Including Network Device Configuration, Grouping and Remote Control.
    * </p>
    *
    * <strong>The Relationship between Groups and Devices</strong>
    *
    * <p>This figure shows the structure of groups and devices:</p>
    *
    * <p><img src="images/nvr_model.png"/></p>
    *
    * <p>As the figure shows, all item of group were extended form aui.nvr.GroupItem,
    * aui.nvr.GroupItem則更進一步區分為aui.nvr.Group及
    * aui.nvr.NetworkDevice兩種。aui.nvr.Group係根節點，其中包含一集合
    * aui.nvr.Group.Items，可包括零到多個aui.nvr.GroupItem子結點，而
    * aui.nvr.NetworkDevice則為葉節點，目前已知的明確葉節點實作有
    * aui.nvr.Camera, aui.nvr.VideoServer, aui.nvr.NVR等三種。</p>
    *
    * <strong>Sample: List all nodes.</strong>
    *
    * @example
    *     function writeItems(item, prefix){
    *         // print the Name member of GroupItem
    *         document.write(
    *             prefix + 
    *             ((item instanceof aui.nvr.Group)?"+(Group) ":"-(Device) ") + 
    *             item.Name + 
    *             "&lt;/br&gt;"
    *         );
    * 
    *         if (item instanceof aui.nvr.Group)
    *         {
    *             prefix += "----";
    *             for(var i = 0 ; i < item.Items.getCount() ; i++)
    *             {
    *                 // access child nodes contained in Items.
    *                 writeItems(item.Items.getItem(i), prefix);
    *             }
    *         }
    *    }
    *    
    *    (function(){
    *          writeItems(aui.nvr.core.getRootGroup(), "");
    *    })();
    */
    nvr: {
        /**
        * @namespace
        * <p>The aui.nvr.data namespace contain classes for 
        * accessing nvr data sources.<p>
        * <p>
        * aui.nvr.data 命名空間提供所有對NVR資料讀取、儲存所需的服務。
        * 以DataService為主，DataService為提供資料讀取服務的抽象類別，
        * 該類別中定義各種資料存取的Template。
        * </p>
        * <p>
        * 當使用遠端資料庫時，需採用AjaxDeviceDataService來與遠端資料服務取得
        * 聯繫，並進行資料存取。而使用本機資料庫時，則可以直接透過
        * ADODBDeviceDataService來存取本機資料服務。
        * </p>
        *
        * <strong>資料服務與結構的關聯：</strong>
        *
        * <p><img src="images/nvr_and_data_service.png"/></p>
        *
        * <strong>各資料服務的階層關係：</strong>
        *
        * <p><img src="images/data_services.png"/></p>
        */
        data: {},
        ap: {},
        ui: {}
    },
    /**
    * @namespace
    */
    ui: {},
    schedule: {},
    cookie: {},
    input: {},
    ivs: {
        ui: {},
        data: {},
        view: {}
    }
};

var Try = {
  these: function() {
    var returnValue;

    for (var i = 0, length = arguments.length; i < length; i++) {
      try {
        returnValue = arguments[i]();
        break;
      } catch (e) { }
    }

    return returnValue;
  },
  
  all: function(){
    var returnValue = [];
    for (var i = 0, length = arguments.length; i < length; i++) {
      try {
        returnValue[i] = arguments[i]();
      } catch (e) { }
    }
    return returnValue;
  }
};

//String ReplaceAll
String.prototype.replaceAll = function(str , rep){
    var reg = new RegExp(str ,"g");
    return this.replace(reg,rep);
}

String.prototype.trim = function () {
    return this.replace(/^\s*/, "").replace(/\s*$/, "");
}
//Number Round at Fix float point (default 2-point, exp: 12.22225 ==> 12.22)
Number.prototype.round2 = function(num) { 
    num = (num) ? num : 2;
    var base = Math.pow(10,num);
    return Math.round(this * base) / base;
}
Number.prototype.toHex = function(){
    return this.toString(16).toUpperCase();
}
// for cross browse
if(window.HTMLElement)
    HTMLElement.prototype.attachEvent = function(sEventType, fnHandler){
        this.addEventListener(sEventType.replace('on', ''), fnHandler, false);
    }

if (!window.attachEvent)
    window.attachEvent = function(sEventType, fnHandler) {
        this.addEventListener(sEventType.replace('on', ''), fnHandler, false);
    }