﻿/**
* @constructor
* @extend {aui.ui.Dialog.DialogBase}
*/
aui.ui.Dialog.MessageBox = function(options) {
    this.options = {
        className: 'aui-ui-Dialog-MessageBox',
        title: null,
        message: '...',
        params: null,
        icon: aui.ui.Dialog.Icon.None, //aui.ui.Dialog.Icon.Information
        buttonSet: aui.ui.Dialog.ButtonSet.None, //aui.ui.Dialog.ButtonSet.OK
        defaultButton: aui.ui.Dialog.DialogResult.OK, //null
        width: '400',
        height: '250',
        timeout: null,
        roundCorner: true,
        destructor: false
    }

    this.options = aui.lang.merge(this.options, options || {});
    this.title = this.options.title;
    this.message = this.options.message;
    this.params = this.options.params;
    this.icon = this.options.icon;
    this.buttonSet = this.options.buttonSet;
    this.defaultButton = this.options.defaultButton;
    this.width = this.options.width;
    this.height = this.options.height;
    this.timeout = this.options.timeout;
    this.buttonList = [];

    var me = this;

    var messageStyle = (this.icon == aui.ui.Dialog.Icon.None)
	                    ? "dialog-service-text-noicon" : "dialog-service-text";
    var pMessage = NewObj("div", messageStyle); // , this.message , this.params);

    this.setMessage = function(message) {
        while (pMessage.childNodes.length)
            pMessage.removeChild(pMessage.firstChild);

        if (typeof message == 'string')
            var message = document.createTextNode(message);

        pMessage.appendChild(message);

        return this;
    };

    this.prepareDialog = function(nodeToAppend) {
        this.dTitle = (this.title) ? NewObj("div", "dialog-service-title", this.title) : null;
        var dframe = NewObj("iframe", "dialog-service-frame");
        var dIcon = NewObj("img", "dialog-service-icon", szFileBase + "resources/img/icon/" + this.icon + ".png");
        var dMessage = NewObj("div", "dialog-service-message");
        this.dButtons = NewObj("div", "dialog-service-buttons");

        if (this.message)
            this.setMessage(Lang(this.message, this.params));

        dframe.frameBorder = '0';

        var topAndButtomSpace = 0;
        if (this.dTitle) {
            dMessage.style.top = "40px"            
            topAndButtomSpace += 40;
        } else {
            dMessage.style.top = "0px";
        }

        if (this.buttonSet != aui.ui.Dialog.ButtonSet.None)
            topAndButtomSpace += 50;

        //pMessage.style.height = (this.height - topAndButtomSpace - 60)+"px";
        dMessage.style.height = (this.height - topAndButtomSpace - 30) + "px";  //Albert Modify, Bug 12395 語系文字過長自動出Scroll bar
        //pMessage.style.marginTop = Math.round((this.height-topAndButtomSpace)/2.3) + "px"
        //pMessage.style.lineHeight = pMessage.style.height;

        if (this.icon !== aui.ui.Dialog.Icon.None) {
            pMessage.style.width = (this.width - 200) + "px";
        }

        this.buttonList = [];
        this.pvtInsertButton();
        this.refresh();
        //        for (var index in this.buttonSet) {
        //            var classname = this.buttonSet.join("") + "-" + this.buttonSet[index];
        //            var dButton = new aui.nvr.ui.CheckButton({
        //                //                var dButton = new aui.nvr.ui.Button({
        //                //                    className:"button "+classname ,
        //                caption: Lang("TXT_" + this.buttonSet[index])
        //            });

        //            if (me.defaultButton == aui.ui.Dialog.DialogResult[this.buttonSet[index]]) dButton.setActivation(true);
        //            this.buttonList.push(dButton);
        //            switch (classname) {
        //                case "OK-OK":
        //                    //                    dButton._managedNode.style.left = Math.round(this.width * 0.4) + "px";
        //                    dButton._managedNode.style.marginLeft = Math.round(this.width * 0.4) + "px";
        //                    break;
        //                case "YESNO-YES":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.2) + "px";
        //                    break;
        //                case "YESNO-NO":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.6) + "px";
        //                    break;
        //                case "YESNOCANCEL-YES":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.725) + "px";
        //                    break;
        //                case "YESNOCANCEL-NO":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.4) + "px";
        //                    break;
        //                case "YESNOCANCEL-CANCEL":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.075) + "px";
        //                    break;
        //                case "ABORTRETRYIGNORE-IGNORE":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.725) + "px";
        //                    break;
        //                case "ABORTRETRYIGNORE-RETRY":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.4) + "px";
        //                    break;
        //                case "ABORTRETRYIGNORE-ABORT":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.075) + "px";
        //                    break;
        //                case "OKCANCEL-CANCEL": case "CANCELOK-OK":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.6) + "px";
        //                    break;
        //                case "OKCANCEL-OK": case "CANCELOK-CANCEL":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.2) + "px";
        //                    break;
        //                case "RETRYCANCEL-CANCEL":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.2) + "px";
        //                    break;
        //                case "RETRYCANCEL-RETRY":
        //                    dButton._managedNode.style.left = Math.round(this.width * 0.6) + "px";
        //                    break;
        //            }

        //            dButton.onclick.subscribe(function(type, args, result) {
        //                me.setResult(aui.ui.Dialog.DialogResult[result]);
        //            }, this.buttonSet[index]);


        //            dButton.render(this.dButtons);
        //        }

        dMessage.appendChild(dIcon);
        dMessage.appendChild(pMessage);
        nodeToAppend.appendChild(dframe);
        if (this.dTitle) nodeToAppend.appendChild(this.dTitle);
        nodeToAppend.appendChild(dMessage);
        nodeToAppend.appendChild(this.dButtons);

        if (this.options.roundCorner) {
            nodeToAppend.appendChild(NewObj("div", "round-tl-gray round-corner"));
            nodeToAppend.appendChild(NewObj("div", "round-tr-gray round-corner"));
            nodeToAppend.appendChild(NewObj("div", "round-bl-gray round-corner"));
            nodeToAppend.appendChild(NewObj("div", "round-br-gray round-corner"));
        }
    }
    aui.ui.Dialog.MessageBox.superclass.constructor.call(this, this.options);
}
aui.lang.Class.extend(aui.ui.Dialog.MessageBox, aui.ui.Dialog.DialogBase, {
    showDialog: function(config) {
        var me = this;
        this.constructor.superclass.showDialog.call(this, config);
        if (this.timeout)
            setTimeout(function() { me.hideDialog() }, this.timeout);
    },

    setTitle: function(title) {
        if (this.title) {
            this.dTitle.innerText = title;
        }
    },

    setButton: function(buttonSet) {
        if (this.buttonSet) {
            try {
                for (var i in this.buttonList) {
                    var obj = this.buttonList[i];
                    obj.unrender(this.dButtons);
                }
                this.buttonList = [];
            } catch (e) { }
        }
        this.buttonSet = buttonSet;

        this.pvtInsertButton();
        this.refresh();
    },

    pvtInsertButton: function() {
        var me = this;
        if (this.buttonSet) {
            for (var index in this.buttonSet) {
                var classname = this.buttonSet.join("") + "-" + this.buttonSet[index];
                var dButton = new aui.nvr.ui.CheckButton({
                    caption: Lang("TXT_" + this.buttonSet[index])
                });
                dButton.dialogType = classname;
                if (me.defaultButton == aui.ui.Dialog.DialogResult[this.buttonSet[index]]) dButton.setActivation(true);
                this.buttonList.push(dButton);

                dButton.onclick.subscribe(function(type, args, result) {
                    for (var i in me.buttonSet) {
                        if (me.buttonSet[i] == result) {
                            if (!me.buttonList[i].getEnable()) return;
                        }
                    }
                    me.setResult(aui.ui.Dialog.DialogResult[result]);
                }, this.buttonSet[index]);

                dButton.render(this.dButtons);
            }
        }
    },

    refresh: function() {
        aui.ui.Dialog.MessageBox.superclass.refresh.call(this);
        //title width
        if (this.dTitle) this.dTitle.style.maxWidth = Math.max(this.width - 40, 0) + "px";

        //button width
        var totalW = 0;
        var maxButtonWidth = Math.max(Math.floor((this.width - 20) / this.buttonList.length) - 20, 0);
        
        for (var index in this.buttonList) {
            var dButton = this.buttonList[index];
            //reset btn status
            var enable = dButton.getEnable();
            dButton.setEnable(enable);
            if (this.defaultButton == aui.ui.Dialog.DialogResult[this.buttonList[index]]) dButton.setActivation(true);
            //set max width
            dButton.setMaxWidth(maxButtonWidth);
            //get width
            var dButtonW = (dButton.getWidth() <= 100) ? 100 : dButton.getWidth();
            totalW += dButtonW;
            if (index > 0) dButton._managedNode.style.marginLeft = "20px";            
        }

        totalW = totalW + (this.buttonList.length - 1) * 20;
        this.dButtons.style.width = Math.abs(totalW) + "px";
        this.dButtons.style.top = Math.abs(this.height - 45) + "px";
        this.dButtons.style.left = Math.abs(this.width - totalW) / 2 + 'px';
    }
})