﻿aui.nvr.ap.IPPortChecker.MainPage = function() {
    this.options = {
        className: "aui-nvr-ap-IPPortChecker-MainPage"
    };
    aui.nvr.ap.IPPortChecker.MainPage.superclass.constructor.call(this);
}
aui.lang.Class.extend(aui.nvr.ap.IPPortChecker.MainPage, aui.ui.ControlBase, {
    prepareNode: function(nodeToAppend) {
        var me = this;
        nodeToAppend.className = this.options.className;
          
        var MainPanel = NewObj("div", "main-panel");   

		this.localBlock = NewObj("div", "localBlock");
		this.buttonsBlock = NewObj("div", "buttonsBlock");
		
		MainPanel.appendChild(this.localBlock);
		MainPanel.appendChild(this.buttonsBlock);
		
		this.localArea = NewObj("div", "localArea");
		this.localBlock.appendChild(this.localArea);
			
		this.localAreaTitle = NewObj("div", "localAreaTitle", "Local");
		this.localArea.appendChild(this.localAreaTitle);

		/* Local Info */
		/* items */
    	this.items = {
		    IPAddress       : NewObj("div", "localAreaItem"),
		    ListenPort      : NewObj("div", "localAreaItem"),
		    HostRoot        : NewObj("div", "localAreaItem")
    	};
		/* inputs */
		this.inputs = {
		    IPAddress       : new aui.ui.DropDownList({id: 'IPADDRESS'}),
		    ListenPort      : new aui.ui.PortInput({id: 'LISTENPORT', required: true})		    
    	};
        /* labels */
        this.labels = {
            HostRoot        : NewObj("div", "localAreaLabel")
        };
    	/* captions */
    	this.captions = {
		    IPAddress       : NewObj("div", "localAreaCaption", "TXT_IPADDRESS"),
		    ListenPort      : NewObj("div", "localAreaCaption", "TXT_PORT"),
		    HostRoot        : NewObj("div", "localAreaCaption", "TXT_HOSTROOT")
    	};
		
		this.inputs.ListenPort.setMaxLength(5);
    	
    	this.localArea.appendChild(this.items.IPAddress);
    	this.localArea.appendChild(this.items.ListenPort);
    	this.localArea.appendChild(this.items.HostRoot);
    	
    	this.items.IPAddress.appendChild(this.captions.IPAddress);
    	this.items.ListenPort.appendChild(this.captions.ListenPort);
    	this.items.HostRoot.appendChild(this.captions.HostRoot);
    	
    	this.inputs.IPAddress.render(this.items.IPAddress);
    	this.inputs.ListenPort.render(this.items.ListenPort);
    	this.items.HostRoot.appendChild(this.labels.HostRoot);
    	
    	this.inputs.IPAddress.setWidth("150");
    	this.inputs.ListenPort.setWidth("150");
		
		/* Buttons */
		this.buttons = {
            Reset   :   new aui.nvr.ui.CheckButton({ caption: LangText("TXT_RESET"), className: 'checkbutton buttons' }),
            Apply   :   new aui.nvr.ui.CheckButton({ caption: LangText("TXT_APPLY"), id: "APPLY", className: 'checkbutton buttons' })            
        };
        
        this.buttons.Apply.render(this.buttonsBlock);
		this.buttons.Reset.render(this.buttonsBlock);
        
        this.buttons.Apply.onclick.subscribe( function(){
            aui.ui.Dialog.Waiting.ProcessingWindow.showDialog();
		    me.buttons.Apply.setEnable(false);
			document.getElementById('ACTION').innerHTML = "Save," + me.inputs.IPAddress.getValue() + "," + me.inputs.ListenPort.getValue();
            document.getElementById('ACTION').click();
		});
		this.buttons.Reset.onclick.subscribe( function(){ me.reset(); } );
        
        nodeToAppend.appendChild(MainPanel);

        if (!aui.ui.Dialog.MessageBox.Error)
            aui.ui.Dialog.MessageBox.Error =
                new aui.ui.Dialog.MessageBox({
                    title: LangText("TXT_ERROR"),
                    icon: aui.ui.Dialog.Icon.Error,
                    buttonSet: aui.ui.Dialog.ButtonSet.OK,
                    height: '280',
                    width: '450'
                });

        if (!aui.ui.Dialog.MessageBox.Information)
            aui.ui.Dialog.MessageBox.Information =
                new aui.ui.Dialog.MessageBox({
                    title: LangText("TXT_MESSAGE"),
                    icon: aui.ui.Dialog.Icon.Information,
                    buttonSet: aui.ui.Dialog.ButtonSet.OK,
                    height: '280',
                    width: '450'
                });

        if (!aui.ui.Dialog.MessageBox.Warning)
            aui.ui.Dialog.MessageBox.Warning =
                new aui.ui.Dialog.MessageBox({
                    title: LangText("TXT_WARNING"),
                    icon: aui.ui.Dialog.Icon.Warning,
                    buttonSet: aui.ui.Dialog.ButtonSet.OK,
                    defaultButton: aui.ui.Dialog.DialogResult.OK,
                    height: '280',
                    width: '450'
                });

        if (!aui.ui.Dialog.MessageBox.NoResponse)
            aui.ui.Dialog.MessageBox.NoResponse =
                new aui.ui.Dialog.MessageBox({
                    title: LangText("TXT_ERROR"),
                    icon: aui.ui.Dialog.Icon.Error,
                    buttonSet: aui.ui.Dialog.ButtonSet.OK,
                    height: '280',
                    width: '450',
                    message: LangText("MSG_SERVERNORESPONSE")
                });
        if (!aui.ui.Dialog.Waiting.ProcessingWindow)
            aui.ui.Dialog.Waiting.ProcessingWindow =
                new aui.ui.Dialog.Waiting({
                    message: LangText("MSG_PROCESSING")
                });
    },
    load: function() {
        var me = this;
		
		var ipAddress = document.getElementById('IP_ADDRESS').value;
        
        ipAddress = ipAddress.split(',');
        
        this.inputs.IPAddress.clear();
        
        //for(var i in ipAddress) this.inputs.IPAddress.addOption(ipAddress[i], ipAddress[i]);
		//Albert Modified, '0.0.0.0' display 'Auto-Detection'
		for(var i in ipAddress) {
            if (aui.text.String.trim(ipAddress[i]) == '0.0.0.0') {
                this.inputs.IPAddress.addOption(LangText("TXT_AUTODETECTION"), ipAddress[i]);
	        } else {
                this.inputs.IPAddress.addOption(ipAddress[i], ipAddress[i]);
            }
        }
		
        var configRoot = document.getElementById('HOST_ROOT').value + '\\config.xml';

        //var config = aui.io.HTTPRequest.loadXMLFile(configRoot, function(data) {
        var xmlData = loadXMLbyShell(configRoot);
        if (xmlData) {
            try {
                var xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
                    xmlDoc.async = false;
                    xmlDoc.loadXML(xmlData);

                    var mediaServerNode = xmlDoc.selectNodes("/Configuration/MediaServer")[0];
        
                    me.configuration = {};
        
                    me.configuration.ipAddress = mediaServerNode.selectNodes("IPAddress")[0].text;
                    me.configuration.listenPort = mediaServerNode.selectNodes("TCPPort")[0].text;
                    me.configuration.hostRoot = mediaServerNode.selectNodes("RootDir/DirPath")[0].text;
		
		            me.inputs.IPAddress.setValue(me.configuration.ipAddress);
                    me.inputs.ListenPort.setValue(me.configuration.listenPort);
    	            me.labels.HostRoot.innerText = me.configuration.hostRoot;
            } 
            catch(e){ }
        }                   

		//});
    },
        
    reset: function(){
        this.load();
    },

    activate: function() {

    },
    deactivate: function() {
        
    },
    applyFinished: function() {
        this.buttons.Apply.setEnable(true);
        this.load();
        aui.ui.Dialog.Waiting.ProcessingWindow.hideDialog();
    }
});

XmlNodeGetValue = function(node , tag){
    if(!node) return '';
    var tNode = node.getElementsByTagName(tag)[0];
    return ((tNode) ? tNode.text : '');
}

function loadLanguage() {
    var hostRoot = document.getElementById('HOST_ROOT').value;
    
    //Language
    var currentLanguage = aui.nvr.core.pvtCurrentLanguage = new aui.collections.NameValueCollection();
    var enLanguage = {};
    var enusPath = document.getElementById('HOST_ROOT').value + '\\Language\\en-us.xml';

    //xmlDoc = aui.io.HTTPRequest.loadXMLFile(enusPath);
    
    var xmlData = loadXMLbyShell(enusPath);

    if (xmlData) {
        try {
            var xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
                xmlDoc.async = false;
                xmlDoc.loadXML(xmlData);

            var nodes = xmlDoc.selectNodes("Language")[0].childNodes;
            for (var i=0; i<nodes.length; i++) {
                enLanguage[ nodes[i].tagName ] = nodes[i].text;
            }
    
            for (var key in enLanguage) {
                currentLanguage.add(key, enLanguage[key]);
            }
        } 
        catch(e){ }
    }  
}

function applyFinished(){
    IPPortChecker.MainPage.applyFinished();
}

function loadXMLbyShell(path) {
    document.getElementById('XML_FILE').innerHTML = path;
    document.getElementById('XML_FILE').click();

    return document.getElementById('XML_FILE').value;
}   

IPPortChecker = {};

if (document.body.readyState == "complete") {
    loadLanguage();
    IPPortChecker.MainPage = new aui.nvr.ap.IPPortChecker.MainPage();
    IPPortChecker.MainPage.render(document.body);
    IPPortChecker.MainPage.load();
    IPPortChecker.MainPage.activate();
} else {    
    document.body.onload = function() {
        loadLanguage();
        IPPortChecker.MainPage = new aui.nvr.ap.IPPortChecker.MainPage();
        IPPortChecker.MainPage.render(document.body);
        IPPortChecker.MainPage.load();
        IPPortChecker.MainPage.activate();
    };
}
window.onunload = function() {
    IPPortChecker.MainPage.deactivate();
};  