/* ActiTester.c
   Generated by gSOAP 2.7.16 from onvif.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/
/*
   Stand-alone server auto-test code:
   Takes request from standard input and returns response to standard output

   Compile:
   cc soapTester.c soapServer.c soapC.c stdsoap2.c

   Command line usage:
   $ a.out < SomeTest.req.xml
   $ a.out 12288 < SomeTest.req.xml
     note: 12288 = SOAP_XML_INDENT | SOAP_XML_STRICT
*/

#include "DeviceBinding.nsmap"

#ifndef SOAP_DEFMAIN
# define SOAP_DEFMAIN main	/* redefine to use your own main() */
#endif

static char *POSIX_TZString[] = {
	"<GMT+12>12",  /*-12:00*/
	"SST11", 	/*-11:00*/
	"HAST10HADT",  /*-10:00*/
	"MART9:30",  /*-09:30*/
	"AKST9AKDT",  /*-09:00*/
	"PST8PDT",  /*-08:00*/
	"MST7MDT",  /*-07:00*/
	"CST6CDT",  /*-06:00*/
	"EST5EDT",  /*-05:00*/
	"VET4:30",  /*-04:30*/
	"PYT4PYST",  /*-04:00*/
	"NST3:30NDT",  /*-03:30*/
	"BRT3BRST",  /*-03:00*/
	"FNT2",  /*-02:00*/
	"AZOT1AZOST",  /*-01:00*/
	"GMT0BST",  /*+00:00*/
	"CET-1CEST",  /*+01:00*/
	"EET-2EEST",  /*+02:00*/
	"MSK-3MSD",  /*+03:00*/
	"IRST-3:30IRDT",  /*+03:30*/
	"AZT-4AZST",  /*+04:00*/
	"AFT-4:30",  /*+04:30*/
	"PKT-5",  /*+05:00*/
	"IST-5:30",  /*+05:30*/
	"NPT-5:45",  /*+05:45*/
	"OMST-6OMSST",  /*+06:00*/
	"CCT-6:30",  /*+06:30*/
	"WIT-7",  /*+07:00*/
	"CST-8",  /*+08:00*/
	"JST-9",  /*+09:00*/
	"CST-9:30CST",  /*+09:30*/
	"EST-10EST",  /*+10:00*/
	"SBT-11",  /*+11:00*/
	"NFT-11:30",  /*+11:30*/
	"NZST-12NZDT",  /*+12:00*/
	"CHAST-12:45CHADT",  /*+12:45*/
	"TOT-13",  /*+13:00*/
};

int SOAP_DEFMAIN(int argc, char **argv)
{ return soap_serve(soap_new1(argc > 1 ? atoi(argv[1]) : 0)); }


/** Auto-test server operation __tds__GetDeviceInformation */
int __tds__GetDeviceInformation(struct soap *soap, struct _tds__GetDeviceInformation *tds__GetDeviceInformation, struct _tds__GetDeviceInformationResponse *tds__GetDeviceInformationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetSystemDateAndTime */
int __tds__SetSystemDateAndTime(struct soap *soap, struct _tds__SetSystemDateAndTime *tds__SetSystemDateAndTime, struct _tds__SetSystemDateAndTimeResponse *tds__SetSystemDateAndTimeResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetSystemDateAndTime */
int __tds__GetSystemDateAndTime(struct soap *soap, struct _tds__GetSystemDateAndTime *tds__GetSystemDateAndTime, struct _tds__GetSystemDateAndTimeResponse *tds__GetSystemDateAndTimeResponse)
{	
	int dlsen = 0;
	static struct tt__SystemDateTime systime;
	static struct tt__TimeZone timezone;
	static struct tt__DateTime utc;
	static struct tt__DateTime local;
	static struct tt__Time utcTime;
	static struct tt__Date utcDate;
	static struct tt__Time llTime;
	static struct tt__Date llDate;
	time_t rawtime; 
	struct tm *ptm;

	{
//		putenv("TZ=EST5EDT,M3.2.0,M11.1.0");
		tzset();
		printf("daylight %d, timezone %d, tzname[0] %s, tzname[1] %s\n",daylight, timezone, tzname[0], tzname[1]);
	}

	tds__GetSystemDateAndTimeResponse->SystemDateAndTime = &systime;
//	systime.DateTimeType = (gSrvConf.conf.date.date.type == DATE_TYPE_NTP) ?\
		tt__SetDateTimeType__NTP:tt__SetDateTimeType__Manual;
	systime.DateTimeType = 1;
//	if(sscanf(gSrvConf.conf.date.date.dls,"%d,", &dlsen) == 1) {
//		systime.DaylightSavings = dlsen;
//	}
	time(&rawtime);
	ptm = gmtime(&rawtime);
	systime.TimeZone = &timezone;
	timezone.TZ = POSIX_TZString[0];
	systime.UTCDateTime = &utc;
	utc.Date = &utcDate;
	utcDate.Year = ptm->tm_year;
	utcDate.Month = ptm->tm_mon;
	utcDate.Day = ptm->tm_mday;
	utc.Time = &utcTime;
	utcTime.Hour = ptm->tm_hour;
	utcTime.Minute = ptm->tm_min;
	utcTime.Second = ptm->tm_sec;
//	rawtime = rawtime - gSrvConf.conf.date.date.zone;
	ptm = gmtime(&rawtime);
	systime.LocalDateTime = &local;
	local.Date = &llDate;
	llDate.Year = ptm->tm_year;
	llDate.Month = ptm->tm_mon;
	llDate.Day = ptm->tm_mday;
	local.Time = &llTime;
	llTime.Hour = ptm->tm_hour;
	llTime.Minute = ptm->tm_min;
	llTime.Second = ptm->tm_sec;
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetSystemFactoryDefault */
int __tds__SetSystemFactoryDefault(struct soap *soap, struct _tds__SetSystemFactoryDefault *tds__SetSystemFactoryDefault, struct _tds__SetSystemFactoryDefaultResponse *tds__SetSystemFactoryDefaultResponse)
{	
	if(tds__SetSystemFactoryDefault->FactoryDefault == tt__FactoryDefaultType__Soft) {
//		FlashCtrlFactoryDefault(&gSrvConf.flash, 0);
	}
	
	return SOAP_OK;
}


/** Auto-test server operation __tds__SystemReboot */
int __tds__SystemReboot(struct soap *soap, struct _tds__SystemReboot *tds__SystemReboot, struct _tds__SystemRebootResponse *tds__SystemRebootResponse)
{	
	/* Return incomplete response with default data values */
//	system("/usr/sbin/MsgSender reboot &");
	tds__SystemRebootResponse->Message = "Reboot Device now...";
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetScopes */
int __tds__GetScopes(struct soap *soap, struct _tds__GetScopes *tds__GetScopes, struct _tds__GetScopesResponse *tds__GetScopesResponse)
{	
	/* Return incomplete response with default data values */
	//tds__GetScopesResponse->__sizeScopes;
    
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetScopes */
int __tds__SetScopes(struct soap *soap, struct _tds__SetScopes *tds__SetScopes, struct _tds__SetScopesResponse *tds__SetScopesResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__AddScopes */
int __tds__AddScopes(struct soap *soap, struct _tds__AddScopes *tds__AddScopes, struct _tds__AddScopesResponse *tds__AddScopesResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__RemoveScopes */
int __tds__RemoveScopes(struct soap *soap, struct _tds__RemoveScopes *tds__RemoveScopes, struct _tds__RemoveScopesResponse *tds__RemoveScopesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetDiscoveryMode */
int __tds__GetDiscoveryMode(struct soap *soap, struct _tds__GetDiscoveryMode *tds__GetDiscoveryMode, struct _tds__GetDiscoveryModeResponse *tds__GetDiscoveryModeResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetDiscoveryMode */
int __tds__SetDiscoveryMode(struct soap *soap, struct _tds__SetDiscoveryMode *tds__SetDiscoveryMode, struct _tds__SetDiscoveryModeResponse *tds__SetDiscoveryModeResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetRemoteDiscoveryMode */
int __tds__GetRemoteDiscoveryMode(struct soap *soap, struct _tds__GetRemoteDiscoveryMode *tds__GetRemoteDiscoveryMode, struct _tds__GetRemoteDiscoveryModeResponse *tds__GetRemoteDiscoveryModeResponse)
{	
	/* Return incomplete response with default data values */
	tds__GetRemoteDiscoveryModeResponse->RemoteDiscoveryMode = tt__DiscoveryMode__Discoverable;
	return SOAP_ERR;
}


/** Auto-test server operation __tds__SetRemoteDiscoveryMode */
int __tds__SetRemoteDiscoveryMode(struct soap *soap, struct _tds__SetRemoteDiscoveryMode *tds__SetRemoteDiscoveryMode, struct _tds__SetRemoteDiscoveryModeResponse *tds__SetRemoteDiscoveryModeResponse)
{	
	//return soap_sender_fault(soap, "Power function domain error", 0);
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetDPAddresses */
int __tds__GetDPAddresses(struct soap *soap, struct _tds__GetDPAddresses *tds__GetDPAddresses, struct _tds__GetDPAddressesResponse *tds__GetDPAddressesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetUsers */
int __tds__GetUsers(struct soap *soap, struct _tds__GetUsers *tds__GetUsers, struct _tds__GetUsersResponse *tds__GetUsersResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__CreateUsers */
int __tds__CreateUsers(struct soap *soap, struct _tds__CreateUsers *tds__CreateUsers, struct _tds__CreateUsersResponse *tds__CreateUsersResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__DeleteUsers */
int __tds__DeleteUsers(struct soap *soap, struct _tds__DeleteUsers *tds__DeleteUsers, struct _tds__DeleteUsersResponse *tds__DeleteUsersResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetUser */
int __tds__SetUser(struct soap *soap, struct _tds__SetUser *tds__SetUser, struct _tds__SetUserResponse *tds__SetUserResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetWsdlUrl */
int __tds__GetWsdlUrl(struct soap *soap, struct _tds__GetWsdlUrl *tds__GetWsdlUrl, struct _tds__GetWsdlUrlResponse *tds__GetWsdlUrlResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetCapabilities */
int __tds__GetCapabilities(struct soap *soap, struct _tds__GetCapabilities *tds__GetCapabilities, struct _tds__GetCapabilitiesResponse *tds__GetCapabilitiesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetDPAddresses */
int __tds__SetDPAddresses(struct soap *soap, struct _tds__SetDPAddresses *tds__SetDPAddresses, struct _tds__SetDPAddressesResponse *tds__SetDPAddressesResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetHostname */
int __tds__GetHostname(struct soap *soap, struct _tds__GetHostname *tds__GetHostname, struct _tds__GetHostnameResponse *tds__GetHostnameResponse)
{	
	/* Return incomplete response with default data values */
	static struct tt__HostnameInformation hostinfo;

	tds__GetHostnameResponse->HostnameInformation = &hostinfo;

	hostinfo.FromDHCP = 1;
	hostinfo.Name = "ACTi";
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetHostname */
int __tds__SetHostname(struct soap *soap, struct _tds__SetHostname *tds__SetHostname, struct _tds__SetHostnameResponse *tds__SetHostnameResponse)
{	
	return SOAP_OK;
}


#if 0
/** Auto-test server operation __tds__GetDNS */
int __tds__GetDNS(struct soap *soap, struct _tds__GetDNS *tds__GetDNS, struct _tds__GetDNSResponse *tds__GetDNSResponse)
{	
	static char *ip1 = "172.16.15.33";
	static char *ip2 = "172.16.15.34";
	/* Return incomplete response with default data values */
	static struct tt__DNSInformation dns;
	static struct tt__IPAddress ipaddr[2];
	tds__GetDNSResponse->DNSInformation = &dns;
	dns.FromDHCP = 1;//true:1, false:0
	dns.__sizeSearchDomain = 0;
	if(dns.FromDHCP) {
		dns.__sizeDNSFromDHCP = 2;
		dns.DNSFromDHCP = &ipaddr;
		ipaddr[0].Type = tt__IPType__IPv4;
		ipaddr[0].IPv4Address = &ip1;
		ipaddr[1].Type = tt__IPType__IPv4;
		ipaddr[1].IPv4Address = &ip2;
	}

	return SOAP_OK;
}
#else
/** Auto-test server operation __tds__GetDNS */
int __tds__GetDNS(struct soap *soap, struct _tds__GetDNS *tds__GetDNS, struct _tds__GetDNSResponse *tds__GetDNSResponse)
{	
	static struct tt__DNSInformation dns;
	static struct tt__IPAddress ipaddr[2];
	static char *ip[2];

	ip[0] = "172.16.15.33";
	ip[1] = "172.16.15.34";
	tds__GetDNSResponse->DNSInformation = &dns;
	dns.FromDHCP = 1;//true:1, false:0
	dns.__sizeSearchDomain = 0;
	if(dns.FromDHCP) {
		dns.__sizeDNSFromDHCP = 2;
		dns.DNSFromDHCP = &ipaddr;
		ipaddr[0].Type = tt__IPType__IPv4;
		ipaddr[0].IPv4Address = &ip[0];
		ipaddr[1].Type = tt__IPType__IPv4;
		ipaddr[1].IPv4Address = &ip[1];
		printf("ip[0] %x, &ip[0] %x\n", ip[0], &ip[0]);
	}

	return SOAP_OK;
}
#endif

/** Auto-test server operation __tds__SetDNS */
int __tds__SetDNS(struct soap *soap, struct _tds__SetDNS *tds__SetDNS, struct _tds__SetDNSResponse *tds__SetDNSResponse)
{	
	int i;
	struct tt__IPAddress *sipaddr;
	char *ip;

	if(tds__SetDNS->FromDHCP) {
		return SOAP_OK;
	}
	printf("false: searchDomain %d, DNSManual count %d\n", tds__SetDNS->__sizeSearchDomain, tds__SetDNS->__sizeDNSManual);
	for(i=0;i<tds__SetDNS->__sizeDNSManual;i++) {
		sipaddr = &tds__SetDNS->DNSManual[i];
		printf("%d: %s\n", sipaddr->Type, sipaddr->IPv4Address[0]);
	}
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetNTP */
int __tds__GetNTP(struct soap *soap, struct _tds__GetNTP *tds__GetNTP, struct _tds__GetNTPResponse *tds__GetNTPResponse)
{	
	/* Return incomplete response with default data values */
	static struct tt__NTPInformation ntp;
	static struct tt__NetworkHost ntpHost;
	static char *ntpip = "172.16.15.33";//gSrvConf.conf.date.date.host;

	tds__GetNTPResponse->NTPInformation = &ntp;
	ntp.FromDHCP = xsd__boolean__false_;
	ntp.__sizeNTPFromDHCP = 0;
	ntp.NTPFromDHCP = NULL;
	ntp.__sizeNTPManual = 1;
	ntp.NTPManual = &ntpHost;
	ntpHost.DNSname = NULL;
	ntpHost.IPv4Address = &ntpip;
	ntpHost.Type = tt__NetworkHostType__IPv4;
	printf("%s\n", ntpHost.IPv4Address[0]);
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetNTP */
int __tds__SetNTP(struct soap *soap, struct _tds__SetNTP *tds__SetNTP, struct _tds__SetNTPResponse *tds__SetNTPResponse)
{	
	if(tds__SetNTP->FromDHCP)
		return SOAP_OK;
	printf("SetNTP %s\n", tds__SetNTP->NTPManual->IPv4Address[0]);
//	strcpy(gSrvConf.conf.date.date.host, *tds__SetNTP->NTPManual->IPv4Address);
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetDynamicDNS */
int __tds__GetDynamicDNS(struct soap *soap, struct _tds__GetDynamicDNS *tds__GetDynamicDNS, struct _tds__GetDynamicDNSResponse *tds__GetDynamicDNSResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetDynamicDNS */
int __tds__SetDynamicDNS(struct soap *soap, struct _tds__SetDynamicDNS *tds__SetDynamicDNS, struct _tds__SetDynamicDNSResponse *tds__SetDynamicDNSResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetNetworkInterfaces */
int __tds__GetNetworkInterfaces(struct soap *soap, struct _tds__GetNetworkInterfaces *tds__GetNetworkInterfaces, struct _tds__GetNetworkInterfacesResponse *tds__GetNetworkInterfacesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetNetworkInterfaces */
int __tds__SetNetworkInterfaces(struct soap *soap, struct _tds__SetNetworkInterfaces *tds__SetNetworkInterfaces, struct _tds__SetNetworkInterfacesResponse *tds__SetNetworkInterfacesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetNetworkProtocols */
int __tds__GetNetworkProtocols(struct soap *soap, struct _tds__GetNetworkProtocols *tds__GetNetworkProtocols, struct _tds__GetNetworkProtocolsResponse *tds__GetNetworkProtocolsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetNetworkProtocols */
int __tds__SetNetworkProtocols(struct soap *soap, struct _tds__SetNetworkProtocols *tds__SetNetworkProtocols, struct _tds__SetNetworkProtocolsResponse *tds__SetNetworkProtocolsResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetNetworkDefaultGateway */
int __tds__GetNetworkDefaultGateway(struct soap *soap, struct _tds__GetNetworkDefaultGateway *tds__GetNetworkDefaultGateway, struct _tds__GetNetworkDefaultGatewayResponse *tds__GetNetworkDefaultGatewayResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetNetworkDefaultGateway */
int __tds__SetNetworkDefaultGateway(struct soap *soap, struct _tds__SetNetworkDefaultGateway *tds__SetNetworkDefaultGateway, struct _tds__SetNetworkDefaultGatewayResponse *tds__SetNetworkDefaultGatewayResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetZeroConfiguration */
int __tds__GetZeroConfiguration(struct soap *soap, struct _tds__GetZeroConfiguration *tds__GetZeroConfiguration, struct _tds__GetZeroConfigurationResponse *tds__GetZeroConfigurationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetZeroConfiguration */
int __tds__SetZeroConfiguration(struct soap *soap, struct _tds__SetZeroConfiguration *tds__SetZeroConfiguration, struct _tds__SetZeroConfigurationResponse *tds__SetZeroConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetAccessPolicy */
int __tds__GetAccessPolicy(struct soap *soap, struct _tds__GetAccessPolicy *tds__GetAccessPolicy, struct _tds__GetAccessPolicyResponse *tds__GetAccessPolicyResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetAccessPolicy */
int __tds__SetAccessPolicy(struct soap *soap, struct _tds__SetAccessPolicy *tds__SetAccessPolicy, struct _tds__SetAccessPolicyResponse *tds__SetAccessPolicyResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__CreateCertificate */
int __tds__CreateCertificate(struct soap *soap, struct _tds__CreateCertificate *tds__CreateCertificate, struct _tds__CreateCertificateResponse *tds__CreateCertificateResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetCertificates */
int __tds__GetCertificates(struct soap *soap, struct _tds__GetCertificates *tds__GetCertificates, struct _tds__GetCertificatesResponse *tds__GetCertificatesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetCertificatesStatus */
int __tds__GetCertificatesStatus(struct soap *soap, struct _tds__GetCertificatesStatus *tds__GetCertificatesStatus, struct _tds__GetCertificatesStatusResponse *tds__GetCertificatesStatusResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetCertificatesStatus */
int __tds__SetCertificatesStatus(struct soap *soap, struct _tds__SetCertificatesStatus *tds__SetCertificatesStatus, struct _tds__SetCertificatesStatusResponse *tds__SetCertificatesStatusResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__DeleteCertificates */
int __tds__DeleteCertificates(struct soap *soap, struct _tds__DeleteCertificates *tds__DeleteCertificates, struct _tds__DeleteCertificatesResponse *tds__DeleteCertificatesResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetPkcs10Request */
int __tds__GetPkcs10Request(struct soap *soap, struct _tds__GetPkcs10Request *tds__GetPkcs10Request, struct _tds__GetPkcs10RequestResponse *tds__GetPkcs10RequestResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__LoadCertificates */
int __tds__LoadCertificates(struct soap *soap, struct _tds__LoadCertificates *tds__LoadCertificates, struct _tds__LoadCertificatesResponse *tds__LoadCertificatesResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetClientCertificateMode */
int __tds__GetClientCertificateMode(struct soap *soap, struct _tds__GetClientCertificateMode *tds__GetClientCertificateMode, struct _tds__GetClientCertificateModeResponse *tds__GetClientCertificateModeResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetClientCertificateMode */
int __tds__SetClientCertificateMode(struct soap *soap, struct _tds__SetClientCertificateMode *tds__SetClientCertificateMode, struct _tds__SetClientCertificateModeResponse *tds__SetClientCertificateModeResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__GetRelayOutputs */
int __tds__GetRelayOutputs(struct soap *soap, struct _tds__GetRelayOutputs *tds__GetRelayOutputs, struct _tds__GetRelayOutputsResponse *tds__GetRelayOutputsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetRelayOutputSettings */
int __tds__SetRelayOutputSettings(struct soap *soap, struct _tds__SetRelayOutputSettings *tds__SetRelayOutputSettings, struct _tds__SetRelayOutputSettingsResponse *tds__SetRelayOutputSettingsResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tds__SetRelayOutputState */
int __tds__SetRelayOutputState(struct soap *soap, struct _tds__SetRelayOutputState *tds__SetRelayOutputState, struct _tds__SetRelayOutputStateResponse *tds__SetRelayOutputStateResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetVideoSources */
int __trt__GetVideoSources(struct soap *soap, struct _trt__GetVideoSources *trt__GetVideoSources, struct _trt__GetVideoSourcesResponse *trt__GetVideoSourcesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetAudioSources */
int __trt__GetAudioSources(struct soap *soap, struct _trt__GetAudioSources *trt__GetAudioSources, struct _trt__GetAudioSourcesResponse *trt__GetAudioSourcesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__CreateProfile */
int __trt__CreateProfile(struct soap *soap, struct _trt__CreateProfile *trt__CreateProfile, struct _trt__CreateProfileResponse *trt__CreateProfileResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetProfile */
int __trt__GetProfile(struct soap *soap, struct _trt__GetProfile *trt__GetProfile, struct _trt__GetProfileResponse *trt__GetProfileResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetProfiles */
int __trt__GetProfiles(struct soap *soap, struct _trt__GetProfiles *trt__GetProfiles, struct _trt__GetProfilesResponse *trt__GetProfilesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__AddVideoEncoderConfiguration */
int __trt__AddVideoEncoderConfiguration(struct soap *soap, struct _trt__AddVideoEncoderConfiguration *trt__AddVideoEncoderConfiguration, struct _trt__AddVideoEncoderConfigurationResponse *trt__AddVideoEncoderConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__AddVideoSourceConfiguration */
int __trt__AddVideoSourceConfiguration(struct soap *soap, struct _trt__AddVideoSourceConfiguration *trt__AddVideoSourceConfiguration, struct _trt__AddVideoSourceConfigurationResponse *trt__AddVideoSourceConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__AddAudioEncoderConfiguration */
int __trt__AddAudioEncoderConfiguration(struct soap *soap, struct _trt__AddAudioEncoderConfiguration *trt__AddAudioEncoderConfiguration, struct _trt__AddAudioEncoderConfigurationResponse *trt__AddAudioEncoderConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__AddAudioSourceConfiguration */
int __trt__AddAudioSourceConfiguration(struct soap *soap, struct _trt__AddAudioSourceConfiguration *trt__AddAudioSourceConfiguration, struct _trt__AddAudioSourceConfigurationResponse *trt__AddAudioSourceConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__RemoveVideoEncoderConfiguration */
int __trt__RemoveVideoEncoderConfiguration(struct soap *soap, struct _trt__RemoveVideoEncoderConfiguration *trt__RemoveVideoEncoderConfiguration, struct _trt__RemoveVideoEncoderConfigurationResponse *trt__RemoveVideoEncoderConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__RemoveVideoSourceConfiguration */
int __trt__RemoveVideoSourceConfiguration(struct soap *soap, struct _trt__RemoveVideoSourceConfiguration *trt__RemoveVideoSourceConfiguration, struct _trt__RemoveVideoSourceConfigurationResponse *trt__RemoveVideoSourceConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__RemoveAudioEncoderConfiguration */
int __trt__RemoveAudioEncoderConfiguration(struct soap *soap, struct _trt__RemoveAudioEncoderConfiguration *trt__RemoveAudioEncoderConfiguration, struct _trt__RemoveAudioEncoderConfigurationResponse *trt__RemoveAudioEncoderConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__RemoveAudioSourceConfiguration */
int __trt__RemoveAudioSourceConfiguration(struct soap *soap, struct _trt__RemoveAudioSourceConfiguration *trt__RemoveAudioSourceConfiguration, struct _trt__RemoveAudioSourceConfigurationResponse *trt__RemoveAudioSourceConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__DeleteProfile */
int __trt__DeleteProfile(struct soap *soap, struct _trt__DeleteProfile *trt__DeleteProfile, struct _trt__DeleteProfileResponse *trt__DeleteProfileResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetVideoSourceConfigurations */
int __trt__GetVideoSourceConfigurations(struct soap *soap, struct _trt__GetVideoSourceConfigurations *trt__GetVideoSourceConfigurations, struct _trt__GetVideoSourceConfigurationsResponse *trt__GetVideoSourceConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetVideoEncoderConfigurations */
int __trt__GetVideoEncoderConfigurations(struct soap *soap, struct _trt__GetVideoEncoderConfigurations *trt__GetVideoEncoderConfigurations, struct _trt__GetVideoEncoderConfigurationsResponse *trt__GetVideoEncoderConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetAudioSourceConfigurations */
int __trt__GetAudioSourceConfigurations(struct soap *soap, struct _trt__GetAudioSourceConfigurations *trt__GetAudioSourceConfigurations, struct _trt__GetAudioSourceConfigurationsResponse *trt__GetAudioSourceConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetAudioEncoderConfigurations */
int __trt__GetAudioEncoderConfigurations(struct soap *soap, struct _trt__GetAudioEncoderConfigurations *trt__GetAudioEncoderConfigurations, struct _trt__GetAudioEncoderConfigurationsResponse *trt__GetAudioEncoderConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetVideoSourceConfiguration */
int __trt__GetVideoSourceConfiguration(struct soap *soap, struct _trt__GetVideoSourceConfiguration *trt__GetVideoSourceConfiguration, struct _trt__GetVideoSourceConfigurationResponse *trt__GetVideoSourceConfigurationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetVideoEncoderConfiguration */
int __trt__GetVideoEncoderConfiguration(struct soap *soap, struct _trt__GetVideoEncoderConfiguration *trt__GetVideoEncoderConfiguration, struct _trt__GetVideoEncoderConfigurationResponse *trt__GetVideoEncoderConfigurationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetAudioSourceConfiguration */
int __trt__GetAudioSourceConfiguration(struct soap *soap, struct _trt__GetAudioSourceConfiguration *trt__GetAudioSourceConfiguration, struct _trt__GetAudioSourceConfigurationResponse *trt__GetAudioSourceConfigurationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetAudioEncoderConfiguration */
int __trt__GetAudioEncoderConfiguration(struct soap *soap, struct _trt__GetAudioEncoderConfiguration *trt__GetAudioEncoderConfiguration, struct _trt__GetAudioEncoderConfigurationResponse *trt__GetAudioEncoderConfigurationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetCompatibleVideoEncoderConfigurations */
int __trt__GetCompatibleVideoEncoderConfigurations(struct soap *soap, struct _trt__GetCompatibleVideoEncoderConfigurations *trt__GetCompatibleVideoEncoderConfigurations, struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *trt__GetCompatibleVideoEncoderConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetCompatibleVideoSourceConfigurations */
int __trt__GetCompatibleVideoSourceConfigurations(struct soap *soap, struct _trt__GetCompatibleVideoSourceConfigurations *trt__GetCompatibleVideoSourceConfigurations, struct _trt__GetCompatibleVideoSourceConfigurationsResponse *trt__GetCompatibleVideoSourceConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetCompatibleAudioEncoderConfigurations */
int __trt__GetCompatibleAudioEncoderConfigurations(struct soap *soap, struct _trt__GetCompatibleAudioEncoderConfigurations *trt__GetCompatibleAudioEncoderConfigurations, struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *trt__GetCompatibleAudioEncoderConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetCompatibleAudioSourceConfigurations */
int __trt__GetCompatibleAudioSourceConfigurations(struct soap *soap, struct _trt__GetCompatibleAudioSourceConfigurations *trt__GetCompatibleAudioSourceConfigurations, struct _trt__GetCompatibleAudioSourceConfigurationsResponse *trt__GetCompatibleAudioSourceConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__SetVideoSourceConfiguration */
int __trt__SetVideoSourceConfiguration(struct soap *soap, struct _trt__SetVideoSourceConfiguration *trt__SetVideoSourceConfiguration, struct _trt__SetVideoSourceConfigurationResponse *trt__SetVideoSourceConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__SetVideoEncoderConfiguration */
int __trt__SetVideoEncoderConfiguration(struct soap *soap, struct _trt__SetVideoEncoderConfiguration *trt__SetVideoEncoderConfiguration, struct _trt__SetVideoEncoderConfigurationResponse *trt__SetVideoEncoderConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__SetAudioSourceConfiguration */
int __trt__SetAudioSourceConfiguration(struct soap *soap, struct _trt__SetAudioSourceConfiguration *trt__SetAudioSourceConfiguration, struct _trt__SetAudioSourceConfigurationResponse *trt__SetAudioSourceConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__SetAudioEncoderConfiguration */
int __trt__SetAudioEncoderConfiguration(struct soap *soap, struct _trt__SetAudioEncoderConfiguration *trt__SetAudioEncoderConfiguration, struct _trt__SetAudioEncoderConfigurationResponse *trt__SetAudioEncoderConfigurationResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetVideoSourceConfigurationOptions */
int __trt__GetVideoSourceConfigurationOptions(struct soap *soap, struct _trt__GetVideoSourceConfigurationOptions *trt__GetVideoSourceConfigurationOptions, struct _trt__GetVideoSourceConfigurationOptionsResponse *trt__GetVideoSourceConfigurationOptionsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetVideoEncoderConfigurationOptions */
int __trt__GetVideoEncoderConfigurationOptions(struct soap *soap, struct _trt__GetVideoEncoderConfigurationOptions *trt__GetVideoEncoderConfigurationOptions, struct _trt__GetVideoEncoderConfigurationOptionsResponse *trt__GetVideoEncoderConfigurationOptionsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetAudioSourceConfigurationOptions */
int __trt__GetAudioSourceConfigurationOptions(struct soap *soap, struct _trt__GetAudioSourceConfigurationOptions *trt__GetAudioSourceConfigurationOptions, struct _trt__GetAudioSourceConfigurationOptionsResponse *trt__GetAudioSourceConfigurationOptionsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetAudioEncoderConfigurationOptions */
int __trt__GetAudioEncoderConfigurationOptions(struct soap *soap, struct _trt__GetAudioEncoderConfigurationOptions *trt__GetAudioEncoderConfigurationOptions, struct _trt__GetAudioEncoderConfigurationOptionsResponse *trt__GetAudioEncoderConfigurationOptionsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetStreamUri */
int __trt__GetStreamUri(struct soap *soap, struct _trt__GetStreamUri *trt__GetStreamUri, struct _trt__GetStreamUriResponse *trt__GetStreamUriResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


/** Auto-test server operation __trt__GetSnapshotUri */
int __trt__GetSnapshotUri(struct soap *soap, struct _trt__GetSnapshotUri *trt__GetSnapshotUri, struct _trt__GetSnapshotUriResponse *trt__GetSnapshotUriResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}
