/* soapC.c
   Generated by gSOAP 2.7.16 from wsademo.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.16 2010-07-23 06:28:04 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_unsignedLONG64:
		return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE__wsa5__IsReferenceParameter:
		return soap_in__wsa5__IsReferenceParameter(soap, NULL, NULL, "wsa5:IsReferenceParameter");
	case SOAP_TYPE_wsa5__FaultCodesType:
		return soap_in_wsa5__FaultCodesType(soap, NULL, NULL, "wsa5:FaultCodesType");
	case SOAP_TYPE_wsa5__RelationshipType:
		return soap_in_wsa5__RelationshipType(soap, NULL, NULL, "wsa5:RelationshipType");
	case SOAP_TYPE_ns__wsademo:
		return soap_in_ns__wsademo(soap, NULL, NULL, "ns:wsademo");
	case SOAP_TYPE_ns__wsademoResult:
		return soap_in_ns__wsademoResult(soap, NULL, NULL, "ns:wsademoResult");
	case SOAP_TYPE_wsa5__ProblemActionType:
		return soap_in_wsa5__ProblemActionType(soap, NULL, NULL, "wsa5:ProblemActionType");
	case SOAP_TYPE_wsa5__RelatesToType:
		return soap_in_wsa5__RelatesToType(soap, NULL, NULL, "wsa5:RelatesToType");
	case SOAP_TYPE_wsa5__MetadataType:
		return soap_in_wsa5__MetadataType(soap, NULL, NULL, "wsa5:MetadataType");
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		return soap_in_wsa5__ReferenceParametersType(soap, NULL, NULL, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		return soap_in_wsa5__EndpointReferenceType(soap, NULL, NULL, "wsa5:EndpointReferenceType");
	case SOAP_TYPE_PointerTons__wsademoResult:
		return soap_in_PointerTons__wsademoResult(soap, NULL, NULL, "ns:wsademoResult");
	case SOAP_TYPE_PointerTo_wsa5__FaultTo:
		return soap_in_PointerTo_wsa5__FaultTo(soap, NULL, NULL, "wsa5:FaultTo");
	case SOAP_TYPE_PointerTo_wsa5__ReplyTo:
		return soap_in_PointerTo_wsa5__ReplyTo(soap, NULL, NULL, "wsa5:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa5__From:
		return soap_in_PointerTo_wsa5__From(soap, NULL, NULL, "wsa5:From");
	case SOAP_TYPE_PointerTo_wsa5__RelatesTo:
		return soap_in_PointerTo_wsa5__RelatesTo(soap, NULL, NULL, "wsa5:RelatesTo");
	case SOAP_TYPE__wsa5__ProblemHeaderQName:
	{	char **s;
		s = soap_in__wsa5__ProblemHeaderQName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTowsa5__MetadataType:
		return soap_in_PointerTowsa5__MetadataType(soap, NULL, NULL, "wsa5:MetadataType");
	case SOAP_TYPE_PointerTowsa5__ReferenceParametersType:
		return soap_in_PointerTowsa5__ReferenceParametersType(soap, NULL, NULL, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__FaultCodesOpenEnumType:
	{	char **s;
		s = soap_in_wsa5__FaultCodesOpenEnumType(soap, NULL, NULL, "wsa5:FaultCodesOpenEnumType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wsa5__RelationshipTypeOpenEnum:
	{	char **s;
		s = soap_in_wsa5__RelationshipTypeOpenEnum(soap, NULL, NULL, "wsa5:RelationshipTypeOpenEnum");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLONG64;
			return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:IsReferenceParameter"))
		{	*type = SOAP_TYPE__wsa5__IsReferenceParameter;
			return soap_in__wsa5__IsReferenceParameter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:FaultCodesType"))
		{	*type = SOAP_TYPE_wsa5__FaultCodesType;
			return soap_in_wsa5__FaultCodesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:RelationshipType"))
		{	*type = SOAP_TYPE_wsa5__RelationshipType;
			return soap_in_wsa5__RelationshipType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:wsademo"))
		{	*type = SOAP_TYPE_ns__wsademo;
			return soap_in_ns__wsademo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:wsademoResult"))
		{	*type = SOAP_TYPE_ns__wsademoResult;
			return soap_in_ns__wsademoResult(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ProblemActionType"))
		{	*type = SOAP_TYPE_wsa5__ProblemActionType;
			return soap_in_wsa5__ProblemActionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:RelatesToType"))
		{	*type = SOAP_TYPE_wsa5__RelatesToType;
			return soap_in_wsa5__RelatesToType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:MetadataType"))
		{	*type = SOAP_TYPE_wsa5__MetadataType;
			return soap_in_wsa5__MetadataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ReferenceParametersType"))
		{	*type = SOAP_TYPE_wsa5__ReferenceParametersType;
			return soap_in_wsa5__ReferenceParametersType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsa5__EndpointReferenceType;
			return soap_in_wsa5__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__ProblemHeaderQName;
			s = soap_in__wsa5__ProblemHeaderQName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:FaultCodesOpenEnumType"))
		{	char **s;
			*type = SOAP_TYPE_wsa5__FaultCodesOpenEnumType;
			s = soap_in_wsa5__FaultCodesOpenEnumType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:RelationshipTypeOpenEnum"))
		{	char **s;
			*type = SOAP_TYPE_wsa5__RelationshipTypeOpenEnum;
			s = soap_in_wsa5__RelationshipTypeOpenEnum(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "wsa5:RetryAfter"))
		{	*type = SOAP_TYPE__wsa5__RetryAfter;
			return soap_in__wsa5__RetryAfter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ProblemAction"))
		{	*type = SOAP_TYPE__wsa5__ProblemAction;
			return soap_in__wsa5__ProblemAction(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:FaultTo"))
		{	*type = SOAP_TYPE__wsa5__FaultTo;
			return soap_in__wsa5__FaultTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:From"))
		{	*type = SOAP_TYPE__wsa5__From;
			return soap_in__wsa5__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ReplyTo"))
		{	*type = SOAP_TYPE__wsa5__ReplyTo;
			return soap_in__wsa5__ReplyTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:RelatesTo"))
		{	*type = SOAP_TYPE__wsa5__RelatesTo;
			return soap_in__wsa5__RelatesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:Metadata"))
		{	*type = SOAP_TYPE__wsa5__Metadata;
			return soap_in__wsa5__Metadata(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ReferenceParameters"))
		{	*type = SOAP_TYPE__wsa5__ReferenceParameters;
			return soap_in__wsa5__ReferenceParameters(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:EndpointReference"))
		{	*type = SOAP_TYPE__wsa5__EndpointReference;
			return soap_in__wsa5__EndpointReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa5:ProblemIRI"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__ProblemIRI;
			s = soap_in__wsa5__ProblemIRI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:Action"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__Action;
			s = soap_in__wsa5__Action(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:To"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__To;
			s = soap_in__wsa5__To(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsa5:MessageID"))
		{	char **s;
			*type = SOAP_TYPE__wsa5__MessageID;
			s = soap_in__wsa5__MessageID(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE__wsa5__RetryAfter:
		return soap_out__wsa5__RetryAfter(soap, "wsa5:RetryAfter", id, (const ULONG64 *)ptr, NULL);
	case SOAP_TYPE_unsignedLONG64:
		return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE__wsa5__IsReferenceParameter:
		return soap_out__wsa5__IsReferenceParameter(soap, tag, id, (const enum _wsa5__IsReferenceParameter *)ptr, "wsa5:IsReferenceParameter");
	case SOAP_TYPE_wsa5__FaultCodesType:
		return soap_out_wsa5__FaultCodesType(soap, tag, id, (const enum wsa5__FaultCodesType *)ptr, "wsa5:FaultCodesType");
	case SOAP_TYPE_wsa5__RelationshipType:
		return soap_out_wsa5__RelationshipType(soap, tag, id, (const enum wsa5__RelationshipType *)ptr, "wsa5:RelationshipType");
	case SOAP_TYPE_ns__wsademo:
		return soap_out_ns__wsademo(soap, tag, id, (const struct ns__wsademo *)ptr, "ns:wsademo");
	case SOAP_TYPE_ns__wsademoResult:
		return soap_out_ns__wsademoResult(soap, tag, id, (const struct ns__wsademoResult *)ptr, "ns:wsademoResult");
	case SOAP_TYPE__wsa5__ProblemAction:
		return soap_out__wsa5__ProblemAction(soap, "wsa5:ProblemAction", id, (const struct wsa5__ProblemActionType *)ptr, NULL);
	case SOAP_TYPE__wsa5__FaultTo:
		return soap_out__wsa5__FaultTo(soap, "wsa5:FaultTo", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa5__From:
		return soap_out__wsa5__From(soap, "wsa5:From", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa5__ReplyTo:
		return soap_out__wsa5__ReplyTo(soap, "wsa5:ReplyTo", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa5__RelatesTo:
		return soap_out__wsa5__RelatesTo(soap, "wsa5:RelatesTo", id, (const struct wsa5__RelatesToType *)ptr, NULL);
	case SOAP_TYPE__wsa5__Metadata:
		return soap_out__wsa5__Metadata(soap, "wsa5:Metadata", id, (const struct wsa5__MetadataType *)ptr, NULL);
	case SOAP_TYPE__wsa5__ReferenceParameters:
		return soap_out__wsa5__ReferenceParameters(soap, "wsa5:ReferenceParameters", id, (const struct wsa5__ReferenceParametersType *)ptr, NULL);
	case SOAP_TYPE__wsa5__EndpointReference:
		return soap_out__wsa5__EndpointReference(soap, "wsa5:EndpointReference", id, (const struct wsa5__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE_wsa5__ProblemActionType:
		return soap_out_wsa5__ProblemActionType(soap, tag, id, (const struct wsa5__ProblemActionType *)ptr, "wsa5:ProblemActionType");
	case SOAP_TYPE_wsa5__RelatesToType:
		return soap_out_wsa5__RelatesToType(soap, tag, id, (const struct wsa5__RelatesToType *)ptr, "wsa5:RelatesToType");
	case SOAP_TYPE_wsa5__MetadataType:
		return soap_out_wsa5__MetadataType(soap, tag, id, (const struct wsa5__MetadataType *)ptr, "wsa5:MetadataType");
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		return soap_out_wsa5__ReferenceParametersType(soap, tag, id, (const struct wsa5__ReferenceParametersType *)ptr, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		return soap_out_wsa5__EndpointReferenceType(soap, tag, id, (const struct wsa5__EndpointReferenceType *)ptr, "wsa5:EndpointReferenceType");
	case SOAP_TYPE_PointerTons__wsademoResult:
		return soap_out_PointerTons__wsademoResult(soap, tag, id, (struct ns__wsademoResult *const*)ptr, "ns:wsademoResult");
	case SOAP_TYPE_PointerTo_wsa5__FaultTo:
		return soap_out_PointerTo_wsa5__FaultTo(soap, tag, id, (struct wsa5__EndpointReferenceType *const*)ptr, "wsa5:FaultTo");
	case SOAP_TYPE_PointerTo_wsa5__ReplyTo:
		return soap_out_PointerTo_wsa5__ReplyTo(soap, tag, id, (struct wsa5__EndpointReferenceType *const*)ptr, "wsa5:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa5__From:
		return soap_out_PointerTo_wsa5__From(soap, tag, id, (struct wsa5__EndpointReferenceType *const*)ptr, "wsa5:From");
	case SOAP_TYPE_PointerTo_wsa5__RelatesTo:
		return soap_out_PointerTo_wsa5__RelatesTo(soap, tag, id, (struct wsa5__RelatesToType *const*)ptr, "wsa5:RelatesTo");
	case SOAP_TYPE__wsa5__ProblemIRI:
		return soap_out_string(soap, "wsa5:ProblemIRI", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsa5__ProblemHeaderQName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE__wsa5__Action:
		return soap_out_string(soap, "wsa5:Action", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsa5__To:
		return soap_out_string(soap, "wsa5:To", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__wsa5__MessageID:
		return soap_out_string(soap, "wsa5:MessageID", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_PointerTowsa5__MetadataType:
		return soap_out_PointerTowsa5__MetadataType(soap, tag, id, (struct wsa5__MetadataType *const*)ptr, "wsa5:MetadataType");
	case SOAP_TYPE_PointerTowsa5__ReferenceParametersType:
		return soap_out_PointerTowsa5__ReferenceParametersType(soap, tag, id, (struct wsa5__ReferenceParametersType *const*)ptr, "wsa5:ReferenceParametersType");
	case SOAP_TYPE_wsa5__FaultCodesOpenEnumType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsa5:FaultCodesOpenEnumType");
	case SOAP_TYPE_wsa5__RelationshipTypeOpenEnum:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "wsa5:RelationshipTypeOpenEnum");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ns__wsademo:
		soap_serialize_ns__wsademo(soap, (const struct ns__wsademo *)ptr);
		break;
	case SOAP_TYPE_ns__wsademoResult:
		soap_serialize_ns__wsademoResult(soap, (const struct ns__wsademoResult *)ptr);
		break;
	case SOAP_TYPE__wsa5__ProblemAction:
		soap_serialize__wsa5__ProblemAction(soap, (const struct wsa5__ProblemActionType *)ptr);
		break;
	case SOAP_TYPE__wsa5__FaultTo:
		soap_serialize__wsa5__FaultTo(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa5__From:
		soap_serialize__wsa5__From(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa5__ReplyTo:
		soap_serialize__wsa5__ReplyTo(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa5__RelatesTo:
		soap_serialize__wsa5__RelatesTo(soap, (const struct wsa5__RelatesToType *)ptr);
		break;
	case SOAP_TYPE__wsa5__Metadata:
		soap_serialize__wsa5__Metadata(soap, (const struct wsa5__MetadataType *)ptr);
		break;
	case SOAP_TYPE__wsa5__ReferenceParameters:
		soap_serialize__wsa5__ReferenceParameters(soap, (const struct wsa5__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE__wsa5__EndpointReference:
		soap_serialize__wsa5__EndpointReference(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_wsa5__ProblemActionType:
		soap_serialize_wsa5__ProblemActionType(soap, (const struct wsa5__ProblemActionType *)ptr);
		break;
	case SOAP_TYPE_wsa5__RelatesToType:
		soap_serialize_wsa5__RelatesToType(soap, (const struct wsa5__RelatesToType *)ptr);
		break;
	case SOAP_TYPE_wsa5__MetadataType:
		soap_serialize_wsa5__MetadataType(soap, (const struct wsa5__MetadataType *)ptr);
		break;
	case SOAP_TYPE_wsa5__ReferenceParametersType:
		soap_serialize_wsa5__ReferenceParametersType(soap, (const struct wsa5__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE_wsa5__EndpointReferenceType:
		soap_serialize_wsa5__EndpointReferenceType(soap, (const struct wsa5__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_PointerTons__wsademoResult:
		soap_serialize_PointerTons__wsademoResult(soap, (struct ns__wsademoResult *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__FaultTo:
		soap_serialize_PointerTo_wsa5__FaultTo(soap, (struct wsa5__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__ReplyTo:
		soap_serialize_PointerTo_wsa5__ReplyTo(soap, (struct wsa5__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__From:
		soap_serialize_PointerTo_wsa5__From(soap, (struct wsa5__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa5__RelatesTo:
		soap_serialize_PointerTo_wsa5__RelatesTo(soap, (struct wsa5__RelatesToType *const*)ptr);
		break;
	case SOAP_TYPE__wsa5__ProblemIRI:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__ProblemHeaderQName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__Action:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__To:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__wsa5__MessageID:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTowsa5__MetadataType:
		soap_serialize_PointerTowsa5__MetadataType(soap, (struct wsa5__MetadataType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa5__ReferenceParametersType:
		soap_serialize_PointerTowsa5__ReferenceParametersType(soap, (struct wsa5__ReferenceParametersType *const*)ptr);
		break;
	case SOAP_TYPE_wsa5__FaultCodesOpenEnumType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_wsa5__RelationshipTypeOpenEnum:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
	*a = SOAP_DEFAULT_unsignedLONG64;
#else
	*a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{	ULONG64 *p;
	p = soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
	if (soap_out_unsignedLONG64(soap, tag?tag:"unsignedLong", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsa5__IsReferenceParameter(struct soap *soap, enum _wsa5__IsReferenceParameter *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT__wsa5__IsReferenceParameter
	*a = SOAP_DEFAULT__wsa5__IsReferenceParameter;
#else
	*a = (enum _wsa5__IsReferenceParameter)0;
#endif
}

static const struct soap_code_map soap_codes__wsa5__IsReferenceParameter[] =
{	{ (long)wsa5__false, "wsa5:false" },
	{ (long)wsa5__true, "wsa5:true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap__wsa5__IsReferenceParameter2s(struct soap *soap, enum _wsa5__IsReferenceParameter n)
{	const char *s = soap_code_str(soap_codes__wsa5__IsReferenceParameter, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsa5__IsReferenceParameter(struct soap *soap, const char *tag, int id, const enum _wsa5__IsReferenceParameter *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsa5__IsReferenceParameter), type) || soap_send(soap, soap__wsa5__IsReferenceParameter2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2_wsa5__IsReferenceParameter(struct soap *soap, const char *s, enum _wsa5__IsReferenceParameter *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes__wsa5__IsReferenceParameter, t);
	if (map)
		*a = (enum _wsa5__IsReferenceParameter)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum _wsa5__IsReferenceParameter)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum _wsa5__IsReferenceParameter * SOAP_FMAC4 soap_in__wsa5__IsReferenceParameter(struct soap *soap, const char *tag, enum _wsa5__IsReferenceParameter *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum _wsa5__IsReferenceParameter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsa5__IsReferenceParameter, sizeof(enum _wsa5__IsReferenceParameter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2_wsa5__IsReferenceParameter(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum _wsa5__IsReferenceParameter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsa5__IsReferenceParameter, 0, sizeof(enum _wsa5__IsReferenceParameter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsa5__IsReferenceParameter(struct soap *soap, const enum _wsa5__IsReferenceParameter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsa5__IsReferenceParameter);
	if (soap_out__wsa5__IsReferenceParameter(soap, tag?tag:"wsa5:IsReferenceParameter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum _wsa5__IsReferenceParameter * SOAP_FMAC4 soap_get__wsa5__IsReferenceParameter(struct soap *soap, enum _wsa5__IsReferenceParameter *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsa5__IsReferenceParameter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__FaultCodesType(struct soap *soap, enum wsa5__FaultCodesType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa5__FaultCodesType
	*a = SOAP_DEFAULT_wsa5__FaultCodesType;
#else
	*a = (enum wsa5__FaultCodesType)0;
#endif
}

static const struct soap_code_map soap_codes_wsa5__FaultCodesType[] =
{	{ (long)wsa5__InvalidAddressingHeader, "wsa5:InvalidAddressingHeader" },
	{ (long)wsa5__InvalidAddress, "wsa5:InvalidAddress" },
	{ (long)wsa5__InvalidEPR, "wsa5:InvalidEPR" },
	{ (long)wsa5__InvalidCardinality, "wsa5:InvalidCardinality" },
	{ (long)wsa5__MissingAddressInEPR, "wsa5:MissingAddressInEPR" },
	{ (long)wsa5__DuplicateMessageID, "wsa5:DuplicateMessageID" },
	{ (long)wsa5__ActionMismatch, "wsa5:ActionMismatch" },
	{ (long)wsa5__MessageAddressingHeaderRequired, "wsa5:MessageAddressingHeaderRequired" },
	{ (long)wsa5__DestinationUnreachable, "wsa5:DestinationUnreachable" },
	{ (long)wsa5__ActionNotSupported, "wsa5:ActionNotSupported" },
	{ (long)wsa5__EndpointUnavailable, "wsa5:EndpointUnavailable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa5__FaultCodesType2s(struct soap *soap, enum wsa5__FaultCodesType n)
{	const char *s = soap_code_str(soap_codes_wsa5__FaultCodesType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__FaultCodesType(struct soap *soap, const char *tag, int id, const enum wsa5__FaultCodesType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__FaultCodesType), type) || soap_send(soap, soap_wsa5__FaultCodesType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa5__FaultCodesType(struct soap *soap, const char *s, enum wsa5__FaultCodesType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsa5__FaultCodesType, t);
	if (map)
		*a = (enum wsa5__FaultCodesType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 10)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa5__FaultCodesType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa5__FaultCodesType * SOAP_FMAC4 soap_in_wsa5__FaultCodesType(struct soap *soap, const char *tag, enum wsa5__FaultCodesType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa5__FaultCodesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__FaultCodesType, sizeof(enum wsa5__FaultCodesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa5__FaultCodesType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa5__FaultCodesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__FaultCodesType, 0, sizeof(enum wsa5__FaultCodesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__FaultCodesType(struct soap *soap, const enum wsa5__FaultCodesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__FaultCodesType);
	if (soap_out_wsa5__FaultCodesType(soap, tag?tag:"wsa5:FaultCodesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa5__FaultCodesType * SOAP_FMAC4 soap_get_wsa5__FaultCodesType(struct soap *soap, enum wsa5__FaultCodesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__FaultCodesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__RelationshipType(struct soap *soap, enum wsa5__RelationshipType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa5__RelationshipType
	*a = SOAP_DEFAULT_wsa5__RelationshipType;
#else
	*a = (enum wsa5__RelationshipType)0;
#endif
}

static const struct soap_code_map soap_codes_wsa5__RelationshipType[] =
{	{ (long)http_x003a_x002f_x002fwww_x002ew3_x002eorg_x002f2005_x002f08_x002faddressing_x002freply, "http://www.w3.org/2005/08/addressing/reply" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa5__RelationshipType2s(struct soap *soap, enum wsa5__RelationshipType n)
{	const char *s = soap_code_str(soap_codes_wsa5__RelationshipType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__RelationshipType(struct soap *soap, const char *tag, int id, const enum wsa5__RelationshipType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__RelationshipType), type) || soap_send(soap, soap_wsa5__RelationshipType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa5__RelationshipType(struct soap *soap, const char *s, enum wsa5__RelationshipType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_wsa5__RelationshipType, s);
	if (map)
		*a = (enum wsa5__RelationshipType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa5__RelationshipType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa5__RelationshipType * SOAP_FMAC4 soap_in_wsa5__RelationshipType(struct soap *soap, const char *tag, enum wsa5__RelationshipType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa5__RelationshipType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__RelationshipType, sizeof(enum wsa5__RelationshipType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa5__RelationshipType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa5__RelationshipType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__RelationshipType, 0, sizeof(enum wsa5__RelationshipType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__RelationshipType(struct soap *soap, const enum wsa5__RelationshipType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__RelationshipType);
	if (soap_out_wsa5__RelationshipType(soap, tag?tag:"wsa5:RelationshipType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa5__RelationshipType * SOAP_FMAC4 soap_get_wsa5__RelationshipType(struct soap *soap, enum wsa5__RelationshipType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__RelationshipType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__wsademo(struct soap *soap, struct ns__wsademo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__wsademo(struct soap *soap, const struct ns__wsademo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__wsademo(struct soap *soap, const char *tag, int id, const struct ns__wsademo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__wsademo), type))
		return soap->error;
	if (soap_out_string(soap, "in", -1, &a->in, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__wsademo * SOAP_FMAC4 soap_in_ns__wsademo(struct soap *soap, const char *tag, struct ns__wsademo *a, const char *type)
{
	size_t soap_flag_in = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__wsademo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__wsademo, sizeof(struct ns__wsademo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__wsademo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "in", &a->in, "xsd:string"))
				{	soap_flag_in--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__wsademo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__wsademo, 0, sizeof(struct ns__wsademo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__wsademo(struct soap *soap, const struct ns__wsademo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__wsademo);
	if (soap_out_ns__wsademo(soap, tag?tag:"ns:wsademo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__wsademo * SOAP_FMAC4 soap_get_ns__wsademo(struct soap *soap, struct ns__wsademo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__wsademo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__wsademoResult(struct soap *soap, struct ns__wsademoResult *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__wsademoResult(struct soap *soap, const struct ns__wsademoResult *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__wsademoResult(struct soap *soap, const char *tag, int id, const struct ns__wsademoResult *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__wsademoResult), type))
		return soap->error;
	if (soap_out_string(soap, "out", -1, &a->out, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__wsademoResult * SOAP_FMAC4 soap_in_ns__wsademoResult(struct soap *soap, const char *tag, struct ns__wsademoResult *a, const char *type)
{
	size_t soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__wsademoResult *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__wsademoResult, sizeof(struct ns__wsademoResult), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__wsademoResult(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__wsademoResult *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__wsademoResult, 0, sizeof(struct ns__wsademoResult), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__wsademoResult(struct soap *soap, const struct ns__wsademoResult *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__wsademoResult);
	if (soap_out_ns__wsademoResult(soap, tag?tag:"ns:wsademoResult", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__wsademoResult * SOAP_FMAC4 soap_get_ns__wsademoResult(struct soap *soap, struct ns__wsademoResult *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__wsademoResult(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag_fault = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__wsa5__MessageID(soap, &a->wsa5__MessageID);
	a->wsa5__RelatesTo = NULL;
	a->wsa5__From = NULL;
	a->wsa5__ReplyTo = NULL;
	a->wsa5__FaultTo = NULL;
	soap_default__wsa5__To(soap, &a->wsa5__To);
	soap_default__wsa5__Action(soap, &a->wsa5__Action);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__wsa5__MessageID(soap, &a->wsa5__MessageID);
	soap_serialize_PointerTo_wsa5__RelatesTo(soap, &a->wsa5__RelatesTo);
	soap_serialize_PointerTo_wsa5__From(soap, &a->wsa5__From);
	soap_serialize_PointerTo_wsa5__ReplyTo(soap, &a->wsa5__ReplyTo);
	soap_serialize_PointerTo_wsa5__FaultTo(soap, &a->wsa5__FaultTo);
	soap_serialize__wsa5__To(soap, &a->wsa5__To);
	soap_serialize__wsa5__Action(soap, &a->wsa5__Action);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	if (soap_out__wsa5__MessageID(soap, "wsa5:MessageID", -1, &a->wsa5__MessageID, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa5__RelatesTo(soap, "wsa5:RelatesTo", -1, &a->wsa5__RelatesTo, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa5__From(soap, "wsa5:From", -1, &a->wsa5__From, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa5__ReplyTo(soap, "wsa5:ReplyTo", -1, &a->wsa5__ReplyTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa5__FaultTo(soap, "wsa5:FaultTo", -1, &a->wsa5__FaultTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa5__To(soap, "wsa5:To", -1, &a->wsa5__To, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa5__Action(soap, "wsa5:Action", -1, &a->wsa5__Action, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	size_t soap_flag_wsa5__MessageID = 1;
	size_t soap_flag_wsa5__RelatesTo = 1;
	size_t soap_flag_wsa5__From = 1;
	size_t soap_flag_wsa5__ReplyTo = 1;
	size_t soap_flag_wsa5__FaultTo = 1;
	size_t soap_flag_wsa5__To = 1;
	size_t soap_flag_wsa5__Action = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa5__MessageID && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__wsa5__MessageID(soap, "wsa5:MessageID", &a->wsa5__MessageID, ""))
				{	soap_flag_wsa5__MessageID--;
					continue;
				}
			if (soap_flag_wsa5__RelatesTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__RelatesTo(soap, "wsa5:RelatesTo", &a->wsa5__RelatesTo, ""))
				{	soap_flag_wsa5__RelatesTo--;
					continue;
				}
			if (soap_flag_wsa5__From && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__From(soap, "wsa5:From", &a->wsa5__From, ""))
				{	soap_flag_wsa5__From--;
					continue;
				}
			if (soap_flag_wsa5__ReplyTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__ReplyTo(soap, "wsa5:ReplyTo", &a->wsa5__ReplyTo, ""))
				{	soap_flag_wsa5__ReplyTo--;
					continue;
				}
			if (soap_flag_wsa5__FaultTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa5__FaultTo(soap, "wsa5:FaultTo", &a->wsa5__FaultTo, ""))
				{	soap_flag_wsa5__FaultTo--;
					continue;
				}
			if (soap_flag_wsa5__To && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__wsa5__To(soap, "wsa5:To", &a->wsa5__To, ""))
				{	soap_flag_wsa5__To--;
					continue;
				}
			if (soap_flag_wsa5__Action && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__wsa5__Action(soap, "wsa5:Action", &a->wsa5__Action, ""))
				{	soap_flag_wsa5__Action--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__ProblemActionType(struct soap *soap, struct wsa5__ProblemActionType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Action);
	soap_default_string(soap, &a->SoapAction);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__ProblemActionType(struct soap *soap, const struct wsa5__ProblemActionType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Action);
	soap_serialize_string(soap, &a->SoapAction);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__ProblemActionType(struct soap *soap, const char *tag, int id, const struct wsa5__ProblemActionType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__ProblemActionType), type))
		return soap->error;
	if (soap_out_string(soap, "wsa5:Action", -1, &a->Action, ""))
		return soap->error;
	if (soap_out_string(soap, "wsa5:SoapAction", -1, &a->SoapAction, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__ProblemActionType * SOAP_FMAC4 soap_in_wsa5__ProblemActionType(struct soap *soap, const char *tag, struct wsa5__ProblemActionType *a, const char *type)
{
	size_t soap_flag_Action = 1;
	size_t soap_flag_SoapAction = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__ProblemActionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__ProblemActionType, sizeof(struct wsa5__ProblemActionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__ProblemActionType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Action && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsa5:Action", &a->Action, "xsd:string"))
				{	soap_flag_Action--;
					continue;
				}
			if (soap_flag_SoapAction && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsa5:SoapAction", &a->SoapAction, "xsd:string"))
				{	soap_flag_SoapAction--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__ProblemActionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__ProblemActionType, 0, sizeof(struct wsa5__ProblemActionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__ProblemActionType(struct soap *soap, const struct wsa5__ProblemActionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__ProblemActionType);
	if (soap_out_wsa5__ProblemActionType(soap, tag?tag:"wsa5:ProblemActionType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__ProblemActionType * SOAP_FMAC4 soap_get_wsa5__ProblemActionType(struct soap *soap, struct wsa5__ProblemActionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__ProblemActionType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__RelatesToType(struct soap *soap, struct wsa5__RelatesToType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_wsa5__RelationshipTypeOpenEnum(soap, &a->RelationshipType);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__RelatesToType(struct soap *soap, const struct wsa5__RelatesToType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__RelatesToType(struct soap *soap, const char *tag, int id, const struct wsa5__RelatesToType *a, const char *type)
{
	if (a->RelationshipType)
		soap_set_attr(soap, "RelationshipType", a->RelationshipType);
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa5__RelatesToType * SOAP_FMAC4 soap_in_wsa5__RelatesToType(struct soap *soap, const char *tag, struct wsa5__RelatesToType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa5__RelatesToType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__RelatesToType, sizeof(struct wsa5__RelatesToType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa5__RelatesToType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "RelationshipType", 0), &a->RelationshipType, -1, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, "wsa5:RelatesToType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__RelatesToType(struct soap *soap, const struct wsa5__RelatesToType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__RelatesToType);
	if (soap_out_wsa5__RelatesToType(soap, tag?tag:"wsa5:RelatesToType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__RelatesToType * SOAP_FMAC4 soap_get_wsa5__RelatesToType(struct soap *soap, struct wsa5__RelatesToType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__RelatesToType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__MetadataType(struct soap *soap, const struct wsa5__MetadataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__MetadataType(struct soap *soap, const char *tag, int id, const struct wsa5__MetadataType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__MetadataType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__MetadataType * SOAP_FMAC4 soap_in_wsa5__MetadataType(struct soap *soap, const char *tag, struct wsa5__MetadataType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__MetadataType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__MetadataType, sizeof(struct wsa5__MetadataType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__MetadataType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__MetadataType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__MetadataType, 0, sizeof(struct wsa5__MetadataType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__MetadataType(struct soap *soap, const struct wsa5__MetadataType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__MetadataType);
	if (soap_out_wsa5__MetadataType(soap, tag?tag:"wsa5:MetadataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__MetadataType * SOAP_FMAC4 soap_get_wsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__MetadataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__ReferenceParametersType(struct soap *soap, const struct wsa5__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__ReferenceParametersType(struct soap *soap, const char *tag, int id, const struct wsa5__ReferenceParametersType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__ReferenceParametersType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType * SOAP_FMAC4 soap_in_wsa5__ReferenceParametersType(struct soap *soap, const char *tag, struct wsa5__ReferenceParametersType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__ReferenceParametersType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__ReferenceParametersType, sizeof(struct wsa5__ReferenceParametersType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__ReferenceParametersType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__ReferenceParametersType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__ReferenceParametersType, 0, sizeof(struct wsa5__ReferenceParametersType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__ReferenceParametersType(struct soap *soap, const struct wsa5__ReferenceParametersType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__ReferenceParametersType);
	if (soap_out_wsa5__ReferenceParametersType(soap, tag?tag:"wsa5:ReferenceParametersType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType * SOAP_FMAC4 soap_get_wsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__ReferenceParametersType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa5__EndpointReferenceType(struct soap *soap, struct wsa5__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Address);
	a->ReferenceParameters = NULL;
	a->Metadata = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa5__EndpointReferenceType(struct soap *soap, const struct wsa5__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Address);
	soap_serialize_PointerTowsa5__ReferenceParametersType(soap, &a->ReferenceParameters);
	soap_serialize_PointerTowsa5__MetadataType(soap, &a->Metadata);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__EndpointReferenceType(struct soap *soap, const char *tag, int id, const struct wsa5__EndpointReferenceType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa5__EndpointReferenceType), type))
		return soap->error;
	if (soap_out_string(soap, "wsa5:Address", -1, &a->Address, ""))
		return soap->error;
	if (soap_out_PointerTowsa5__ReferenceParametersType(soap, "wsa5:ReferenceParameters", -1, &a->ReferenceParameters, ""))
		return soap->error;
	if (soap_out_PointerTowsa5__MetadataType(soap, "wsa5:Metadata", -1, &a->Metadata, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType * SOAP_FMAC4 soap_in_wsa5__EndpointReferenceType(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType *a, const char *type)
{
	size_t soap_flag_Address = 1;
	size_t soap_flag_ReferenceParameters = 1;
	size_t soap_flag_Metadata = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa5__EndpointReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa5__EndpointReferenceType, sizeof(struct wsa5__EndpointReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa5__EndpointReferenceType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Address && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsa5:Address", &a->Address, "xsd:string"))
				{	soap_flag_Address--;
					continue;
				}
			if (soap_flag_ReferenceParameters && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa5__ReferenceParametersType(soap, "wsa5:ReferenceParameters", &a->ReferenceParameters, "wsa5:ReferenceParametersType"))
				{	soap_flag_ReferenceParameters--;
					continue;
				}
			if (soap_flag_Metadata && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa5__MetadataType(soap, "wsa5:Metadata", &a->Metadata, "wsa5:MetadataType"))
				{	soap_flag_Metadata--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa5__EndpointReferenceType, 0, sizeof(struct wsa5__EndpointReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Address > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__EndpointReferenceType(struct soap *soap, const struct wsa5__EndpointReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__EndpointReferenceType);
	if (soap_out_wsa5__EndpointReferenceType(soap, tag?tag:"wsa5:EndpointReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType * SOAP_FMAC4 soap_get_wsa5__EndpointReferenceType(struct soap *soap, struct wsa5__EndpointReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__EndpointReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons__wsademoResult(struct soap *soap, struct ns__wsademoResult *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns__wsademoResult))
		soap_serialize_ns__wsademoResult(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons__wsademoResult(struct soap *soap, const char *tag, int id, struct ns__wsademoResult *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns__wsademoResult);
	if (id < 0)
		return soap->error;
	return soap_out_ns__wsademoResult(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns__wsademoResult ** SOAP_FMAC4 soap_in_PointerTons__wsademoResult(struct soap *soap, const char *tag, struct ns__wsademoResult **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns__wsademoResult **)soap_malloc(soap, sizeof(struct ns__wsademoResult *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns__wsademoResult(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns__wsademoResult **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns__wsademoResult, sizeof(struct ns__wsademoResult), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons__wsademoResult(struct soap *soap, struct ns__wsademoResult *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons__wsademoResult);
	if (soap_out_PointerTons__wsademoResult(soap, tag?tag:"ns:wsademoResult", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns__wsademoResult ** SOAP_FMAC4 soap_get_PointerTons__wsademoResult(struct soap *soap, struct ns__wsademoResult **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons__wsademoResult(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__FaultTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__FaultTo))
		soap_serialize__wsa5__FaultTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__FaultTo(struct soap *soap, const char *tag, int id, struct wsa5__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__FaultTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__FaultTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__FaultTo(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa5__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__FaultTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__FaultTo, sizeof(struct wsa5__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__FaultTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__FaultTo);
	if (soap_out_PointerTo_wsa5__FaultTo(soap, tag?tag:"wsa5:FaultTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__FaultTo(struct soap *soap, struct wsa5__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__FaultTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__ReplyTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__ReplyTo))
		soap_serialize__wsa5__ReplyTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__ReplyTo(struct soap *soap, const char *tag, int id, struct wsa5__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__ReplyTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__ReplyTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__ReplyTo(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa5__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__ReplyTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__ReplyTo, sizeof(struct wsa5__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__ReplyTo(struct soap *soap, struct wsa5__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__ReplyTo);
	if (soap_out_PointerTo_wsa5__ReplyTo(soap, tag?tag:"wsa5:ReplyTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__ReplyTo(struct soap *soap, struct wsa5__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__ReplyTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__From(struct soap *soap, struct wsa5__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__From))
		soap_serialize__wsa5__From(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__From(struct soap *soap, const char *tag, int id, struct wsa5__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__From);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__From(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__From(struct soap *soap, const char *tag, struct wsa5__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa5__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__From(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__From, sizeof(struct wsa5__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__From(struct soap *soap, struct wsa5__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__From);
	if (soap_out_PointerTo_wsa5__From(soap, tag?tag:"wsa5:From", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__From(struct soap *soap, struct wsa5__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__From(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa5__RelatesTo(struct soap *soap, struct wsa5__RelatesToType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa5__RelatesTo))
		soap_serialize__wsa5__RelatesTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa5__RelatesTo(struct soap *soap, const char *tag, int id, struct wsa5__RelatesToType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa5__RelatesTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa5__RelatesTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__RelatesToType ** SOAP_FMAC4 soap_in_PointerTo_wsa5__RelatesTo(struct soap *soap, const char *tag, struct wsa5__RelatesToType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__RelatesToType **)soap_malloc(soap, sizeof(struct wsa5__RelatesToType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa5__RelatesTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__RelatesToType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa5__RelatesTo, sizeof(struct wsa5__RelatesToType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa5__RelatesTo(struct soap *soap, struct wsa5__RelatesToType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa5__RelatesTo);
	if (soap_out_PointerTo_wsa5__RelatesTo(soap, tag?tag:"wsa5:RelatesTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__RelatesToType ** SOAP_FMAC4 soap_get_PointerTo_wsa5__RelatesTo(struct soap *soap, struct wsa5__RelatesToType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa5__RelatesTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsa5__ProblemHeaderQName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__wsa5__ProblemHeaderQName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__wsa5__ProblemHeaderQName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__wsa5__ProblemHeaderQName, 2, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsa5__ProblemHeaderQName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsa5__ProblemHeaderQName);
	if (soap_out__wsa5__ProblemHeaderQName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__wsa5__ProblemHeaderQName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__wsa5__ProblemHeaderQName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa5__MetadataType))
		soap_serialize_wsa5__MetadataType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa5__MetadataType(struct soap *soap, const char *tag, int id, struct wsa5__MetadataType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa5__MetadataType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa5__MetadataType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__MetadataType ** SOAP_FMAC4 soap_in_PointerTowsa5__MetadataType(struct soap *soap, const char *tag, struct wsa5__MetadataType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__MetadataType **)soap_malloc(soap, sizeof(struct wsa5__MetadataType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa5__MetadataType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__MetadataType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa5__MetadataType, sizeof(struct wsa5__MetadataType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa5__MetadataType);
	if (soap_out_PointerTowsa5__MetadataType(soap, tag?tag:"wsa5:MetadataType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__MetadataType ** SOAP_FMAC4 soap_get_PointerTowsa5__MetadataType(struct soap *soap, struct wsa5__MetadataType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa5__MetadataType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa5__ReferenceParametersType))
		soap_serialize_wsa5__ReferenceParametersType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa5__ReferenceParametersType(struct soap *soap, const char *tag, int id, struct wsa5__ReferenceParametersType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa5__ReferenceParametersType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa5__ReferenceParametersType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType ** SOAP_FMAC4 soap_in_PointerTowsa5__ReferenceParametersType(struct soap *soap, const char *tag, struct wsa5__ReferenceParametersType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa5__ReferenceParametersType **)soap_malloc(soap, sizeof(struct wsa5__ReferenceParametersType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa5__ReferenceParametersType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa5__ReferenceParametersType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa5__ReferenceParametersType, sizeof(struct wsa5__ReferenceParametersType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa5__ReferenceParametersType);
	if (soap_out_PointerTowsa5__ReferenceParametersType(soap, tag?tag:"wsa5:ReferenceParametersType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa5__ReferenceParametersType ** SOAP_FMAC4 soap_get_PointerTowsa5__ReferenceParametersType(struct soap *soap, struct wsa5__ReferenceParametersType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa5__ReferenceParametersType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__FaultCodesOpenEnumType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wsa5__FaultCodesOpenEnumType);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wsa5__FaultCodesOpenEnumType(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_wsa5__FaultCodesOpenEnumType, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__FaultCodesOpenEnumType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__FaultCodesOpenEnumType);
	if (soap_out_wsa5__FaultCodesOpenEnumType(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wsa5__FaultCodesOpenEnumType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__FaultCodesOpenEnumType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa5__RelationshipTypeOpenEnum(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wsa5__RelationshipTypeOpenEnum);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wsa5__RelationshipTypeOpenEnum(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_wsa5__RelationshipTypeOpenEnum, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa5__RelationshipTypeOpenEnum(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa5__RelationshipTypeOpenEnum);
	if (soap_out_wsa5__RelationshipTypeOpenEnum(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wsa5__RelationshipTypeOpenEnum(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa5__RelationshipTypeOpenEnum(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.c */
