/*
	udpclient.c

	SOAP-over-UDP demo client with zlib compression and WS-Addressing

--------------------------------------------------------------------------------
gSOAP XML Web services tools
Copyright (C) 2001-2008, Robert van Engelen, Genivia, Inc. All Rights Reserved.
This software is released under one of the following two licenses:
GPL or Genivia's license for commercial use.
--------------------------------------------------------------------------------
GPL license.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

Author contact information:
engelen@genivia.com / engelen@acm.org
--------------------------------------------------------------------------------
A commercial use license is available from Genivia, Inc., contact@genivia.com
--------------------------------------------------------------------------------
*/

#include "soapH.h"
#include "d.nsmap"

int main(int argc, char **argv)
{ struct soap soap;
  struct ip_mreq mreq;
  unsigned char ttl = 8;
  int reuse = 1;

  soap_init1(&soap, SOAP_IO_UDP);
  if (!soap_valid_socket(soap_bind(&soap, NULL, 3702, 100)))
  { soap_print_fault(&soap, stderr);
    exit(1);
  }

  mreq.imr_multiaddr.s_addr = inet_addr("239.255.255.250");
  mreq.imr_interface.s_addr = htonl(INADDR_ANY);
  /* Join into a multicast group */
  if(setsockopt(soap.socket, IPPROTO_IP, IP_ADD_MEMBERSHIP, (void *)&mreq, sizeof(mreq)) < 0)
	  perror("IP_ADD_SOURCE_MEMBERSHIP");
  if(setsockopt(soap.socket, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl)) < 0)
	  perror("IP_MULTICAST_TTL");
  if(setsockopt(soap.socket, SOL_SOCKET, SO_REUSEADDR, (char *)&reuse, sizeof(reuse)) < 0)
	  perror("SO_REUSEADDR");
//setsockopt(soap.socket, IPPROTO_IP, IP_MULTICAST_LOOP, &loop, sizeof(loop));

  for (;;)
  { if (soap_serve(&soap))
      soap_print_fault(&soap, stderr); // just report the problem
    soap_destroy(&soap);
    soap_end(&soap);
  }
  soap_done(&soap); // close connection (should not use soap struct after this)
  return 0;
}

int SOAP_FMAC6 __d__Probe(struct soap* soap, struct d__ProbeType *d__Probe, struct d__ProbeMatchesType *d__ProbeResponse)
{
	static struct d__ProbeMatchType	promatch;
	static struct d__ScopesType scopes;
	int counter = 1;
	int id_count = 1;

	if (!soap->header)
	  return soap_sender_fault(soap, "No SOAP header", NULL);
	if (!soap->header->wsa__MessageID.__item)
	  return soap_sender_fault(soap, "No WS-Addressing MessageID", NULL);
	soap->header->wsa__RelatesTo = (struct wsa__Relationship*)soap_malloc(soap, sizeof(struct wsa__Relationship));
	soap_default_wsa__Relationship(soap, soap->header->wsa__RelatesTo);
	soap->header->wsa__RelatesTo->__item = soap->header->wsa__MessageID.__item;
	// must check for duplicate messages
//	if (check_received(soap->header->wsa__MessageID.__item))
//	{ printf("Request message %s already received\n", soap->header->wsa__MessageID.__item);
//	  return SOAP_STOP; // don't return response
//	}
	soap->header->wsa__To.__item = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
	soap->header->wsa__MessageID.__item = soap_strdup(soap, soap_int2s(soap,id_count++)) ;
	soap->header->wsa__Action.__item = "http://schemas.xmlsoap.org/ws/2005/04/discovery/ProbeMatches";

	d__ProbeResponse->__sizeProbeMatch = 1;
	d__ProbeResponse->ProbeMatch = &promatch;
	soap_default_d__ProbeMatchType(soap, &promatch);
	promatch.wsa__EndpointReference = NULL;
	promatch.Scopes = NULL;
	promatch.Types = "dn:NetworkVideoTransmitter";
	promatch.XAddrs = "http://172.16.15.33/onvif/services";
	promatch.MetadataVersion = counter;
	soap_default_d__ScopesType(soap, &scopes);
	return SOAP_OK;
//	soap_print_fault(&soap, stderr);
}
