/* soapC.c
   Generated by gSOAP 2.7.16 from myudp.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.16 2010-07-29 02:57:17 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header))))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_wsa__FaultSubcodeValues:
		return soap_in_wsa__FaultSubcodeValues(soap, NULL, NULL, "wsa:FaultSubcodeValues");
	case SOAP_TYPE_wsa__RelationshipTypeValues:
		return soap_in_wsa__RelationshipTypeValues(soap, NULL, NULL, "wsa:RelationshipTypeValues");
	case SOAP_TYPE_d__FaultCodeType:
		return soap_in_d__FaultCodeType(soap, NULL, NULL, "d:FaultCodeType");
	case SOAP_TYPE_d__RelationshipType:
		return soap_in_d__RelationshipType(soap, NULL, NULL, "d:RelationshipType");
	case SOAP_TYPE_wsa__AttributedURI:
		return soap_in_wsa__AttributedURI(soap, NULL, NULL, "wsa:AttributedURI");
	case SOAP_TYPE_wsa__AttributedQName:
		return soap_in_wsa__AttributedQName(soap, NULL, NULL, "wsa:AttributedQName");
	case SOAP_TYPE_wsa__RetryAfterType:
		return soap_in_wsa__RetryAfterType(soap, NULL, NULL, "wsa:RetryAfterType");
	case SOAP_TYPE_wsa__ReplyAfterType:
		return soap_in_wsa__ReplyAfterType(soap, NULL, NULL, "wsa:ReplyAfterType");
	case SOAP_TYPE_wsa__Relationship:
		return soap_in_wsa__Relationship(soap, NULL, NULL, "wsa:Relationship");
	case SOAP_TYPE_wsa__ServiceNameType:
		return soap_in_wsa__ServiceNameType(soap, NULL, NULL, "wsa:ServiceNameType");
	case SOAP_TYPE_wsa__ReferenceParametersType:
		return soap_in_wsa__ReferenceParametersType(soap, NULL, NULL, "wsa:ReferenceParametersType");
	case SOAP_TYPE_wsa__ReferencePropertiesType:
		return soap_in_wsa__ReferencePropertiesType(soap, NULL, NULL, "wsa:ReferencePropertiesType");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_d__AppSequenceType:
		return soap_in_d__AppSequenceType(soap, NULL, NULL, "d:AppSequenceType");
	case SOAP_TYPE_d__SigType:
		return soap_in_d__SigType(soap, NULL, NULL, "d:SigType");
	case SOAP_TYPE_d__SecurityType:
		return soap_in_d__SecurityType(soap, NULL, NULL, "d:SecurityType");
	case SOAP_TYPE_d__ScopesType:
		return soap_in_d__ScopesType(soap, NULL, NULL, "d:ScopesType");
	case SOAP_TYPE_d__ResolveMatchType:
		return soap_in_d__ResolveMatchType(soap, NULL, NULL, "d:ResolveMatchType");
	case SOAP_TYPE_d__ResolveMatchesType:
		return soap_in_d__ResolveMatchesType(soap, NULL, NULL, "d:ResolveMatchesType");
	case SOAP_TYPE_d__ResolveType:
		return soap_in_d__ResolveType(soap, NULL, NULL, "d:ResolveType");
	case SOAP_TYPE_d__ProbeMatchType:
		return soap_in_d__ProbeMatchType(soap, NULL, NULL, "d:ProbeMatchType");
	case SOAP_TYPE_d__ProbeMatchesType:
		return soap_in_d__ProbeMatchesType(soap, NULL, NULL, "d:ProbeMatchesType");
	case SOAP_TYPE_d__ProbeType:
		return soap_in_d__ProbeType(soap, NULL, NULL, "d:ProbeType");
	case SOAP_TYPE_d__ByeType:
		return soap_in_d__ByeType(soap, NULL, NULL, "d:ByeType");
	case SOAP_TYPE_d__HelloType:
		return soap_in_d__HelloType(soap, NULL, NULL, "d:HelloType");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		return soap_in_PointerTo_wsa__FaultTo(soap, NULL, NULL, "wsa:FaultTo");
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		return soap_in_PointerTo_wsa__ReplyTo(soap, NULL, NULL, "wsa:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa__From:
		return soap_in_PointerTo_wsa__From(soap, NULL, NULL, "wsa:From");
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		return soap_in_PointerTo_wsa__RelatesTo(soap, NULL, NULL, "wsa:RelatesTo");
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		return soap_in_PointerTod__ProbeMatchesType(soap, NULL, NULL, "d:ProbeMatchesType");
	case SOAP_TYPE_PointerTod__ProbeType:
		return soap_in_PointerTod__ProbeType(soap, NULL, NULL, "d:ProbeType");
	case SOAP_TYPE_PointerTod__ByeType:
		return soap_in_PointerTod__ByeType(soap, NULL, NULL, "d:ByeType");
	case SOAP_TYPE_PointerTod__ResolveType:
		return soap_in_PointerTod__ResolveType(soap, NULL, NULL, "d:ResolveType");
	case SOAP_TYPE_PointerTod__HelloType:
		return soap_in_PointerTod__HelloType(soap, NULL, NULL, "d:HelloType");
	case SOAP_TYPE_PointerTowsa__ServiceNameType:
		return soap_in_PointerTowsa__ServiceNameType(soap, NULL, NULL, "wsa:ServiceNameType");
	case SOAP_TYPE_PointerTowsa__AttributedQName:
		return soap_in_PointerTowsa__AttributedQName(soap, NULL, NULL, "wsa:AttributedQName");
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		return soap_in_PointerTowsa__ReferenceParametersType(soap, NULL, NULL, "wsa:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsa__ReferencePropertiesType:
		return soap_in_PointerTowsa__ReferencePropertiesType(soap, NULL, NULL, "wsa:ReferencePropertiesType");
	case SOAP_TYPE_PointerTowsa__AttributedURI:
		return soap_in_PointerTowsa__AttributedURI(soap, NULL, NULL, "wsa:AttributedURI");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_in_PointerToxsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTod__SigType:
		return soap_in_PointerTod__SigType(soap, NULL, NULL, "d:SigType");
	case SOAP_TYPE_PointerTod__ResolveMatchType:
		return soap_in_PointerTod__ResolveMatchType(soap, NULL, NULL, "d:ResolveMatchType");
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		return soap_in_PointerTod__ProbeMatchType(soap, NULL, NULL, "d:ProbeMatchType");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_in_PointerTounsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTod__ScopesType:
		return soap_in_PointerTod__ScopesType(soap, NULL, NULL, "d:ScopesType");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_in_PointerTowsa__EndpointReferenceType(soap, NULL, NULL, "wsa:EndpointReferenceType");
	case SOAP_TYPE_d__FaultCodeOpenType:
	{	char **s;
		s = soap_in_d__FaultCodeOpenType(soap, NULL, NULL, "d:FaultCodeOpenType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_d__UriListType:
	{	char **s;
		s = soap_in_d__UriListType(soap, NULL, NULL, "d:UriListType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_d__QNameListType:
	{	char **s;
		s = soap_in_d__QNameListType(soap, NULL, NULL, "d:QNameListType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_d__OpenRelationshipType:
	{	char **s;
		s = soap_in_d__OpenRelationshipType(soap, NULL, NULL, "d:OpenRelationshipType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__nonNegativeInteger:
	{	char **s;
		s = soap_in_xsd__nonNegativeInteger(soap, NULL, NULL, "xsd:nonNegativeInteger");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__NCName:
	{	char **s;
		s = soap_in_xsd__NCName(soap, NULL, NULL, "xsd:NCName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__IDREFS:
	{	char **s;
		s = soap_in_xsd__IDREFS(soap, NULL, NULL, "xsd:IDREFS");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__ID:
	{	char **s;
		s = soap_in_xsd__ID(soap, NULL, NULL, "xsd:ID");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:FaultSubcodeValues"))
		{	*type = SOAP_TYPE_wsa__FaultSubcodeValues;
			return soap_in_wsa__FaultSubcodeValues(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelationshipTypeValues"))
		{	*type = SOAP_TYPE_wsa__RelationshipTypeValues;
			return soap_in_wsa__RelationshipTypeValues(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:FaultCodeType"))
		{	*type = SOAP_TYPE_d__FaultCodeType;
			return soap_in_d__FaultCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:RelationshipType"))
		{	*type = SOAP_TYPE_d__RelationshipType;
			return soap_in_d__RelationshipType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:AttributedURI"))
		{	*type = SOAP_TYPE_wsa__AttributedURI;
			return soap_in_wsa__AttributedURI(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:AttributedQName"))
		{	*type = SOAP_TYPE_wsa__AttributedQName;
			return soap_in_wsa__AttributedQName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RetryAfterType"))
		{	*type = SOAP_TYPE_wsa__RetryAfterType;
			return soap_in_wsa__RetryAfterType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReplyAfterType"))
		{	*type = SOAP_TYPE_wsa__ReplyAfterType;
			return soap_in_wsa__ReplyAfterType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:Relationship"))
		{	*type = SOAP_TYPE_wsa__Relationship;
			return soap_in_wsa__Relationship(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ServiceNameType"))
		{	*type = SOAP_TYPE_wsa__ServiceNameType;
			return soap_in_wsa__ServiceNameType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReferenceParametersType"))
		{	*type = SOAP_TYPE_wsa__ReferenceParametersType;
			return soap_in_wsa__ReferenceParametersType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReferencePropertiesType"))
		{	*type = SOAP_TYPE_wsa__ReferencePropertiesType;
			return soap_in_wsa__ReferencePropertiesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:EndpointReferenceType"))
		{	*type = SOAP_TYPE_wsa__EndpointReferenceType;
			return soap_in_wsa__EndpointReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AppSequenceType"))
		{	*type = SOAP_TYPE_d__AppSequenceType;
			return soap_in_d__AppSequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SigType"))
		{	*type = SOAP_TYPE_d__SigType;
			return soap_in_d__SigType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:SecurityType"))
		{	*type = SOAP_TYPE_d__SecurityType;
			return soap_in_d__SecurityType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ScopesType"))
		{	*type = SOAP_TYPE_d__ScopesType;
			return soap_in_d__ScopesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ResolveMatchType"))
		{	*type = SOAP_TYPE_d__ResolveMatchType;
			return soap_in_d__ResolveMatchType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ResolveMatchesType"))
		{	*type = SOAP_TYPE_d__ResolveMatchesType;
			return soap_in_d__ResolveMatchesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ResolveType"))
		{	*type = SOAP_TYPE_d__ResolveType;
			return soap_in_d__ResolveType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatchType"))
		{	*type = SOAP_TYPE_d__ProbeMatchType;
			return soap_in_d__ProbeMatchType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatchesType"))
		{	*type = SOAP_TYPE_d__ProbeMatchesType;
			return soap_in_d__ProbeMatchesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeType"))
		{	*type = SOAP_TYPE_d__ProbeType;
			return soap_in_d__ProbeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ByeType"))
		{	*type = SOAP_TYPE_d__ByeType;
			return soap_in_d__ByeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:HelloType"))
		{	*type = SOAP_TYPE_d__HelloType;
			return soap_in_d__HelloType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:FaultCodeOpenType"))
		{	char **s;
			*type = SOAP_TYPE_d__FaultCodeOpenType;
			s = soap_in_d__FaultCodeOpenType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:UriListType"))
		{	char **s;
			*type = SOAP_TYPE_d__UriListType;
			s = soap_in_d__UriListType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:QNameListType"))
		{	char **s;
			*type = SOAP_TYPE_d__QNameListType;
			s = soap_in_d__QNameListType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:OpenRelationshipType"))
		{	char **s;
			*type = SOAP_TYPE_d__OpenRelationshipType;
			s = soap_in_d__OpenRelationshipType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:nonNegativeInteger"))
		{	char **s;
			*type = SOAP_TYPE_xsd__nonNegativeInteger;
			s = soap_in_xsd__nonNegativeInteger(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:NCName"))
		{	char **s;
			*type = SOAP_TYPE_xsd__NCName;
			s = soap_in_xsd__NCName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:IDREFS"))
		{	char **s;
			*type = SOAP_TYPE_xsd__IDREFS;
			s = soap_in_xsd__IDREFS(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:ID"))
		{	char **s;
			*type = SOAP_TYPE_xsd__ID;
			s = soap_in_xsd__ID(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "d:MetadataVersion"))
		{	*type = SOAP_TYPE__d__MetadataVersion;
			return soap_in__d__MetadataVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RetryAfter"))
		{	*type = SOAP_TYPE__wsa__RetryAfter;
			return soap_in__wsa__RetryAfter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReplyAfter"))
		{	*type = SOAP_TYPE__wsa__ReplyAfter;
			return soap_in__wsa__ReplyAfter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:FaultTo"))
		{	*type = SOAP_TYPE__wsa__FaultTo;
			return soap_in__wsa__FaultTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:ReplyTo"))
		{	*type = SOAP_TYPE__wsa__ReplyTo;
			return soap_in__wsa__ReplyTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:From"))
		{	*type = SOAP_TYPE__wsa__From;
			return soap_in__wsa__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:Action"))
		{	*type = SOAP_TYPE__wsa__Action;
			return soap_in__wsa__Action(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:To"))
		{	*type = SOAP_TYPE__wsa__To;
			return soap_in__wsa__To(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:RelatesTo"))
		{	*type = SOAP_TYPE__wsa__RelatesTo;
			return soap_in__wsa__RelatesTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:MessageID"))
		{	*type = SOAP_TYPE__wsa__MessageID;
			return soap_in__wsa__MessageID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsa:EndpointReference"))
		{	*type = SOAP_TYPE__wsa__EndpointReference;
			return soap_in__wsa__EndpointReference(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:AppSequence"))
		{	*type = SOAP_TYPE__d__AppSequence;
			return soap_in__d__AppSequence(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Sig"))
		{	*type = SOAP_TYPE__d__Sig;
			return soap_in__d__Sig(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Security"))
		{	*type = SOAP_TYPE__d__Security;
			return soap_in__d__Security(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Scopes"))
		{	*type = SOAP_TYPE__d__Scopes;
			return soap_in__d__Scopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ResolveMatches"))
		{	*type = SOAP_TYPE__d__ResolveMatches;
			return soap_in__d__ResolveMatches(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Resolve"))
		{	*type = SOAP_TYPE__d__Resolve;
			return soap_in__d__Resolve(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:ProbeMatches"))
		{	*type = SOAP_TYPE__d__ProbeMatches;
			return soap_in__d__ProbeMatches(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Probe"))
		{	*type = SOAP_TYPE__d__Probe;
			return soap_in__d__Probe(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Bye"))
		{	*type = SOAP_TYPE__d__Bye;
			return soap_in__d__Bye(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Hello"))
		{	*type = SOAP_TYPE__d__Hello;
			return soap_in__d__Hello(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "d:Id"))
		{	char **s;
			*type = SOAP_TYPE__d__Id;
			s = soap_in__d__Id(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:SupportedMatchingRules"))
		{	char **s;
			*type = SOAP_TYPE__d__SupportedMatchingRules;
			s = soap_in__d__SupportedMatchingRules(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:XAddrs"))
		{	char **s;
			*type = SOAP_TYPE__d__XAddrs;
			s = soap_in__d__XAddrs(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "d:Types"))
		{	char **s;
			*type = SOAP_TYPE__d__Types;
			s = soap_in__d__Types(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE__d__MetadataVersion:
		return soap_out__d__MetadataVersion(soap, "d:MetadataVersion", id, (const unsigned int *)ptr, NULL);
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_wsa__FaultSubcodeValues:
		return soap_out_wsa__FaultSubcodeValues(soap, tag, id, (const enum wsa__FaultSubcodeValues *)ptr, "wsa:FaultSubcodeValues");
	case SOAP_TYPE_wsa__RelationshipTypeValues:
		return soap_out_wsa__RelationshipTypeValues(soap, tag, id, (const enum wsa__RelationshipTypeValues *)ptr, "wsa:RelationshipTypeValues");
	case SOAP_TYPE_d__FaultCodeType:
		return soap_out_d__FaultCodeType(soap, tag, id, (const enum d__FaultCodeType *)ptr, "d:FaultCodeType");
	case SOAP_TYPE_d__RelationshipType:
		return soap_out_d__RelationshipType(soap, tag, id, (const enum d__RelationshipType *)ptr, "d:RelationshipType");
	case SOAP_TYPE__wsa__RetryAfter:
		return soap_out__wsa__RetryAfter(soap, "wsa:RetryAfter", id, (const struct wsa__RetryAfterType *)ptr, NULL);
	case SOAP_TYPE__wsa__ReplyAfter:
		return soap_out__wsa__ReplyAfter(soap, "wsa:ReplyAfter", id, (const struct wsa__ReplyAfterType *)ptr, NULL);
	case SOAP_TYPE__wsa__FaultTo:
		return soap_out__wsa__FaultTo(soap, "wsa:FaultTo", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__ReplyTo:
		return soap_out__wsa__ReplyTo(soap, "wsa:ReplyTo", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__From:
		return soap_out__wsa__From(soap, "wsa:From", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__wsa__Action:
		return soap_out__wsa__Action(soap, "wsa:Action", id, (const struct wsa__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsa__To:
		return soap_out__wsa__To(soap, "wsa:To", id, (const struct wsa__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsa__RelatesTo:
		return soap_out__wsa__RelatesTo(soap, "wsa:RelatesTo", id, (const struct wsa__Relationship *)ptr, NULL);
	case SOAP_TYPE__wsa__MessageID:
		return soap_out__wsa__MessageID(soap, "wsa:MessageID", id, (const struct wsa__AttributedURI *)ptr, NULL);
	case SOAP_TYPE__wsa__EndpointReference:
		return soap_out__wsa__EndpointReference(soap, "wsa:EndpointReference", id, (const struct wsa__EndpointReferenceType *)ptr, NULL);
	case SOAP_TYPE__d__AppSequence:
		return soap_out__d__AppSequence(soap, "d:AppSequence", id, (const struct d__AppSequenceType *)ptr, NULL);
	case SOAP_TYPE__d__Sig:
		return soap_out__d__Sig(soap, "d:Sig", id, (const struct d__SigType *)ptr, NULL);
	case SOAP_TYPE__d__Security:
		return soap_out__d__Security(soap, "d:Security", id, (const struct d__SecurityType *)ptr, NULL);
	case SOAP_TYPE__d__Scopes:
		return soap_out__d__Scopes(soap, "d:Scopes", id, (const struct d__ScopesType *)ptr, NULL);
	case SOAP_TYPE__d__ResolveMatches:
		return soap_out__d__ResolveMatches(soap, "d:ResolveMatches", id, (const struct d__ResolveMatchesType *)ptr, NULL);
	case SOAP_TYPE__d__Resolve:
		return soap_out__d__Resolve(soap, "d:Resolve", id, (const struct d__ResolveType *)ptr, NULL);
	case SOAP_TYPE__d__ProbeMatches:
		return soap_out__d__ProbeMatches(soap, "d:ProbeMatches", id, (const struct d__ProbeMatchesType *)ptr, NULL);
	case SOAP_TYPE__d__Probe:
		return soap_out__d__Probe(soap, "d:Probe", id, (const struct d__ProbeType *)ptr, NULL);
	case SOAP_TYPE__d__Bye:
		return soap_out__d__Bye(soap, "d:Bye", id, (const struct d__ByeType *)ptr, NULL);
	case SOAP_TYPE__d__Hello:
		return soap_out__d__Hello(soap, "d:Hello", id, (const struct d__HelloType *)ptr, NULL);
	case SOAP_TYPE_wsa__AttributedURI:
		return soap_out_wsa__AttributedURI(soap, tag, id, (const struct wsa__AttributedURI *)ptr, "wsa:AttributedURI");
	case SOAP_TYPE_wsa__AttributedQName:
		return soap_out_wsa__AttributedQName(soap, tag, id, (const struct wsa__AttributedQName *)ptr, "wsa:AttributedQName");
	case SOAP_TYPE_wsa__RetryAfterType:
		return soap_out_wsa__RetryAfterType(soap, tag, id, (const struct wsa__RetryAfterType *)ptr, "wsa:RetryAfterType");
	case SOAP_TYPE_wsa__ReplyAfterType:
		return soap_out_wsa__ReplyAfterType(soap, tag, id, (const struct wsa__ReplyAfterType *)ptr, "wsa:ReplyAfterType");
	case SOAP_TYPE_wsa__Relationship:
		return soap_out_wsa__Relationship(soap, tag, id, (const struct wsa__Relationship *)ptr, "wsa:Relationship");
	case SOAP_TYPE_wsa__ServiceNameType:
		return soap_out_wsa__ServiceNameType(soap, tag, id, (const struct wsa__ServiceNameType *)ptr, "wsa:ServiceNameType");
	case SOAP_TYPE_wsa__ReferenceParametersType:
		return soap_out_wsa__ReferenceParametersType(soap, tag, id, (const struct wsa__ReferenceParametersType *)ptr, "wsa:ReferenceParametersType");
	case SOAP_TYPE_wsa__ReferencePropertiesType:
		return soap_out_wsa__ReferencePropertiesType(soap, tag, id, (const struct wsa__ReferencePropertiesType *)ptr, "wsa:ReferencePropertiesType");
	case SOAP_TYPE_wsa__EndpointReferenceType:
		return soap_out_wsa__EndpointReferenceType(soap, tag, id, (const struct wsa__EndpointReferenceType *)ptr, "wsa:EndpointReferenceType");
	case SOAP_TYPE_d__AppSequenceType:
		return soap_out_d__AppSequenceType(soap, tag, id, (const struct d__AppSequenceType *)ptr, "d:AppSequenceType");
	case SOAP_TYPE_d__SigType:
		return soap_out_d__SigType(soap, tag, id, (const struct d__SigType *)ptr, "d:SigType");
	case SOAP_TYPE_d__SecurityType:
		return soap_out_d__SecurityType(soap, tag, id, (const struct d__SecurityType *)ptr, "d:SecurityType");
	case SOAP_TYPE_d__ScopesType:
		return soap_out_d__ScopesType(soap, tag, id, (const struct d__ScopesType *)ptr, "d:ScopesType");
	case SOAP_TYPE_d__ResolveMatchType:
		return soap_out_d__ResolveMatchType(soap, tag, id, (const struct d__ResolveMatchType *)ptr, "d:ResolveMatchType");
	case SOAP_TYPE_d__ResolveMatchesType:
		return soap_out_d__ResolveMatchesType(soap, tag, id, (const struct d__ResolveMatchesType *)ptr, "d:ResolveMatchesType");
	case SOAP_TYPE_d__ResolveType:
		return soap_out_d__ResolveType(soap, tag, id, (const struct d__ResolveType *)ptr, "d:ResolveType");
	case SOAP_TYPE_d__ProbeMatchType:
		return soap_out_d__ProbeMatchType(soap, tag, id, (const struct d__ProbeMatchType *)ptr, "d:ProbeMatchType");
	case SOAP_TYPE_d__ProbeMatchesType:
		return soap_out_d__ProbeMatchesType(soap, tag, id, (const struct d__ProbeMatchesType *)ptr, "d:ProbeMatchesType");
	case SOAP_TYPE_d__ProbeType:
		return soap_out_d__ProbeType(soap, tag, id, (const struct d__ProbeType *)ptr, "d:ProbeType");
	case SOAP_TYPE_d__ByeType:
		return soap_out_d__ByeType(soap, tag, id, (const struct d__ByeType *)ptr, "d:ByeType");
	case SOAP_TYPE_d__HelloType:
		return soap_out_d__HelloType(soap, tag, id, (const struct d__HelloType *)ptr, "d:HelloType");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_out_xsd__base64Binary(soap, tag, id, (const struct xsd__base64Binary *)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		return soap_out_PointerTo_wsa__FaultTo(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:FaultTo");
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		return soap_out_PointerTo_wsa__ReplyTo(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:ReplyTo");
	case SOAP_TYPE_PointerTo_wsa__From:
		return soap_out_PointerTo_wsa__From(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:From");
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		return soap_out_PointerTo_wsa__RelatesTo(soap, tag, id, (struct wsa__Relationship *const*)ptr, "wsa:RelatesTo");
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		return soap_out_PointerTod__ProbeMatchesType(soap, tag, id, (struct d__ProbeMatchesType *const*)ptr, "d:ProbeMatchesType");
	case SOAP_TYPE_PointerTod__ProbeType:
		return soap_out_PointerTod__ProbeType(soap, tag, id, (struct d__ProbeType *const*)ptr, "d:ProbeType");
	case SOAP_TYPE_PointerTod__ByeType:
		return soap_out_PointerTod__ByeType(soap, tag, id, (struct d__ByeType *const*)ptr, "d:ByeType");
	case SOAP_TYPE_PointerTod__ResolveType:
		return soap_out_PointerTod__ResolveType(soap, tag, id, (struct d__ResolveType *const*)ptr, "d:ResolveType");
	case SOAP_TYPE_PointerTod__HelloType:
		return soap_out_PointerTod__HelloType(soap, tag, id, (struct d__HelloType *const*)ptr, "d:HelloType");
	case SOAP_TYPE__d__Id:
		return soap_out_string(soap, "d:Id", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__d__SupportedMatchingRules:
		return soap_out_string(soap, "d:SupportedMatchingRules", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__d__XAddrs:
		return soap_out_string(soap, "d:XAddrs", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE__d__Types:
		return soap_out_string(soap, "d:Types", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_PointerTowsa__ServiceNameType:
		return soap_out_PointerTowsa__ServiceNameType(soap, tag, id, (struct wsa__ServiceNameType *const*)ptr, "wsa:ServiceNameType");
	case SOAP_TYPE_PointerTowsa__AttributedQName:
		return soap_out_PointerTowsa__AttributedQName(soap, tag, id, (struct wsa__AttributedQName *const*)ptr, "wsa:AttributedQName");
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		return soap_out_PointerTowsa__ReferenceParametersType(soap, tag, id, (struct wsa__ReferenceParametersType *const*)ptr, "wsa:ReferenceParametersType");
	case SOAP_TYPE_PointerTowsa__ReferencePropertiesType:
		return soap_out_PointerTowsa__ReferencePropertiesType(soap, tag, id, (struct wsa__ReferencePropertiesType *const*)ptr, "wsa:ReferencePropertiesType");
	case SOAP_TYPE_PointerTowsa__AttributedURI:
		return soap_out_PointerTowsa__AttributedURI(soap, tag, id, (struct wsa__AttributedURI *const*)ptr, "wsa:AttributedURI");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_out_PointerToxsd__base64Binary(soap, tag, id, (struct xsd__base64Binary *const*)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTod__SigType:
		return soap_out_PointerTod__SigType(soap, tag, id, (struct d__SigType *const*)ptr, "d:SigType");
	case SOAP_TYPE_PointerTod__ResolveMatchType:
		return soap_out_PointerTod__ResolveMatchType(soap, tag, id, (struct d__ResolveMatchType *const*)ptr, "d:ResolveMatchType");
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		return soap_out_PointerTod__ProbeMatchType(soap, tag, id, (struct d__ProbeMatchType *const*)ptr, "d:ProbeMatchType");
	case SOAP_TYPE_PointerTounsignedInt:
		return soap_out_PointerTounsignedInt(soap, tag, id, (unsigned int *const*)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_PointerTod__ScopesType:
		return soap_out_PointerTod__ScopesType(soap, tag, id, (struct d__ScopesType *const*)ptr, "d:ScopesType");
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		return soap_out_PointerTowsa__EndpointReferenceType(soap, tag, id, (struct wsa__EndpointReferenceType *const*)ptr, "wsa:EndpointReferenceType");
	case SOAP_TYPE_d__FaultCodeOpenType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:FaultCodeOpenType");
	case SOAP_TYPE_d__UriListType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:UriListType");
	case SOAP_TYPE_d__QNameListType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:QNameListType");
	case SOAP_TYPE_d__OpenRelationshipType:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "d:OpenRelationshipType");
	case SOAP_TYPE_xsd__nonNegativeInteger:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:nonNegativeInteger");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__NCName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:NCName");
	case SOAP_TYPE_xsd__IDREFS:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:IDREFS");
	case SOAP_TYPE_xsd__ID:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:ID");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE___d__Probe:
		soap_serialize___d__Probe(soap, (const struct __d__Probe *)ptr);
		break;
	case SOAP_TYPE___d__Bye:
		soap_serialize___d__Bye(soap, (const struct __d__Bye *)ptr);
		break;
	case SOAP_TYPE___d__Hello:
		soap_serialize___d__Hello(soap, (const struct __d__Hello *)ptr);
		break;
	case SOAP_TYPE__wsa__RetryAfter:
		soap_serialize__wsa__RetryAfter(soap, (const struct wsa__RetryAfterType *)ptr);
		break;
	case SOAP_TYPE__wsa__ReplyAfter:
		soap_serialize__wsa__ReplyAfter(soap, (const struct wsa__ReplyAfterType *)ptr);
		break;
	case SOAP_TYPE__wsa__FaultTo:
		soap_serialize__wsa__FaultTo(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__ReplyTo:
		soap_serialize__wsa__ReplyTo(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__From:
		soap_serialize__wsa__From(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__wsa__Action:
		soap_serialize__wsa__Action(soap, (const struct wsa__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsa__To:
		soap_serialize__wsa__To(soap, (const struct wsa__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsa__RelatesTo:
		soap_serialize__wsa__RelatesTo(soap, (const struct wsa__Relationship *)ptr);
		break;
	case SOAP_TYPE__wsa__MessageID:
		soap_serialize__wsa__MessageID(soap, (const struct wsa__AttributedURI *)ptr);
		break;
	case SOAP_TYPE__wsa__EndpointReference:
		soap_serialize__wsa__EndpointReference(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE__d__AppSequence:
		soap_serialize__d__AppSequence(soap, (const struct d__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE__d__Sig:
		soap_serialize__d__Sig(soap, (const struct d__SigType *)ptr);
		break;
	case SOAP_TYPE__d__Security:
		soap_serialize__d__Security(soap, (const struct d__SecurityType *)ptr);
		break;
	case SOAP_TYPE__d__Scopes:
		soap_serialize__d__Scopes(soap, (const struct d__ScopesType *)ptr);
		break;
	case SOAP_TYPE__d__ResolveMatches:
		soap_serialize__d__ResolveMatches(soap, (const struct d__ResolveMatchesType *)ptr);
		break;
	case SOAP_TYPE__d__Resolve:
		soap_serialize__d__Resolve(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE__d__ProbeMatches:
		soap_serialize__d__ProbeMatches(soap, (const struct d__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE__d__Probe:
		soap_serialize__d__Probe(soap, (const struct d__ProbeType *)ptr);
		break;
	case SOAP_TYPE__d__Bye:
		soap_serialize__d__Bye(soap, (const struct d__ByeType *)ptr);
		break;
	case SOAP_TYPE__d__Hello:
		soap_serialize__d__Hello(soap, (const struct d__HelloType *)ptr);
		break;
	case SOAP_TYPE_wsa__AttributedURI:
		soap_serialize_wsa__AttributedURI(soap, (const struct wsa__AttributedURI *)ptr);
		break;
	case SOAP_TYPE_wsa__AttributedQName:
		soap_serialize_wsa__AttributedQName(soap, (const struct wsa__AttributedQName *)ptr);
		break;
	case SOAP_TYPE_wsa__RetryAfterType:
		soap_serialize_wsa__RetryAfterType(soap, (const struct wsa__RetryAfterType *)ptr);
		break;
	case SOAP_TYPE_wsa__ReplyAfterType:
		soap_serialize_wsa__ReplyAfterType(soap, (const struct wsa__ReplyAfterType *)ptr);
		break;
	case SOAP_TYPE_wsa__Relationship:
		soap_serialize_wsa__Relationship(soap, (const struct wsa__Relationship *)ptr);
		break;
	case SOAP_TYPE_wsa__ServiceNameType:
		soap_serialize_wsa__ServiceNameType(soap, (const struct wsa__ServiceNameType *)ptr);
		break;
	case SOAP_TYPE_wsa__ReferenceParametersType:
		soap_serialize_wsa__ReferenceParametersType(soap, (const struct wsa__ReferenceParametersType *)ptr);
		break;
	case SOAP_TYPE_wsa__ReferencePropertiesType:
		soap_serialize_wsa__ReferencePropertiesType(soap, (const struct wsa__ReferencePropertiesType *)ptr);
		break;
	case SOAP_TYPE_wsa__EndpointReferenceType:
		soap_serialize_wsa__EndpointReferenceType(soap, (const struct wsa__EndpointReferenceType *)ptr);
		break;
	case SOAP_TYPE_d__AppSequenceType:
		soap_serialize_d__AppSequenceType(soap, (const struct d__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE_d__SigType:
		soap_serialize_d__SigType(soap, (const struct d__SigType *)ptr);
		break;
	case SOAP_TYPE_d__SecurityType:
		soap_serialize_d__SecurityType(soap, (const struct d__SecurityType *)ptr);
		break;
	case SOAP_TYPE_d__ScopesType:
		soap_serialize_d__ScopesType(soap, (const struct d__ScopesType *)ptr);
		break;
	case SOAP_TYPE_d__ResolveMatchType:
		soap_serialize_d__ResolveMatchType(soap, (const struct d__ResolveMatchType *)ptr);
		break;
	case SOAP_TYPE_d__ResolveMatchesType:
		soap_serialize_d__ResolveMatchesType(soap, (const struct d__ResolveMatchesType *)ptr);
		break;
	case SOAP_TYPE_d__ResolveType:
		soap_serialize_d__ResolveType(soap, (const struct d__ResolveType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeMatchType:
		soap_serialize_d__ProbeMatchType(soap, (const struct d__ProbeMatchType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeMatchesType:
		soap_serialize_d__ProbeMatchesType(soap, (const struct d__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE_d__ProbeType:
		soap_serialize_d__ProbeType(soap, (const struct d__ProbeType *)ptr);
		break;
	case SOAP_TYPE_d__ByeType:
		soap_serialize_d__ByeType(soap, (const struct d__ByeType *)ptr);
		break;
	case SOAP_TYPE_d__HelloType:
		soap_serialize_d__HelloType(soap, (const struct d__HelloType *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		soap_serialize_xsd__base64Binary(soap, (const struct xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__FaultTo:
		soap_serialize_PointerTo_wsa__FaultTo(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__ReplyTo:
		soap_serialize_PointerTo_wsa__ReplyTo(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__From:
		soap_serialize_PointerTo_wsa__From(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsa__RelatesTo:
		soap_serialize_PointerTo_wsa__RelatesTo(soap, (struct wsa__Relationship *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeMatchesType:
		soap_serialize_PointerTod__ProbeMatchesType(soap, (struct d__ProbeMatchesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeType:
		soap_serialize_PointerTod__ProbeType(soap, (struct d__ProbeType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ByeType:
		soap_serialize_PointerTod__ByeType(soap, (struct d__ByeType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ResolveType:
		soap_serialize_PointerTod__ResolveType(soap, (struct d__ResolveType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__HelloType:
		soap_serialize_PointerTod__HelloType(soap, (struct d__HelloType *const*)ptr);
		break;
	case SOAP_TYPE__d__Id:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__d__SupportedMatchingRules:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__d__XAddrs:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__d__Types:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTowsa__ServiceNameType:
		soap_serialize_PointerTowsa__ServiceNameType(soap, (struct wsa__ServiceNameType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__AttributedQName:
		soap_serialize_PointerTowsa__AttributedQName(soap, (struct wsa__AttributedQName *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__ReferenceParametersType:
		soap_serialize_PointerTowsa__ReferenceParametersType(soap, (struct wsa__ReferenceParametersType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__ReferencePropertiesType:
		soap_serialize_PointerTowsa__ReferencePropertiesType(soap, (struct wsa__ReferencePropertiesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__AttributedURI:
		soap_serialize_PointerTowsa__AttributedURI(soap, (struct wsa__AttributedURI *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__base64Binary:
		soap_serialize_PointerToxsd__base64Binary(soap, (struct xsd__base64Binary *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__SigType:
		soap_serialize_PointerTod__SigType(soap, (struct d__SigType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ResolveMatchType:
		soap_serialize_PointerTod__ResolveMatchType(soap, (struct d__ResolveMatchType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ProbeMatchType:
		soap_serialize_PointerTod__ProbeMatchType(soap, (struct d__ProbeMatchType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedInt:
		soap_serialize_PointerTounsignedInt(soap, (unsigned int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTod__ScopesType:
		soap_serialize_PointerTod__ScopesType(soap, (struct d__ScopesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsa__EndpointReferenceType:
		soap_serialize_PointerTowsa__EndpointReferenceType(soap, (struct wsa__EndpointReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_d__FaultCodeOpenType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_d__UriListType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_d__QNameListType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_d__OpenRelationshipType:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__nonNegativeInteger:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__NCName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__IDREFS:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__ID:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{	unsigned char *p;
	p = soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag?tag:"unsignedByte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{	unsigned int *p;
	p = soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag?tag:"unsignedInt", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__FaultSubcodeValues(struct soap *soap, enum wsa__FaultSubcodeValues *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa__FaultSubcodeValues
	*a = SOAP_DEFAULT_wsa__FaultSubcodeValues;
#else
	*a = (enum wsa__FaultSubcodeValues)0;
#endif
}

static const struct soap_code_map soap_codes_wsa__FaultSubcodeValues[] =
{	{ (long)wsa__InvalidMessageInformationHeader, "wsa:InvalidMessageInformationHeader" },
	{ (long)wsa__MessageInformationHeaderRequired, "wsa:MessageInformationHeaderRequired" },
	{ (long)wsa__DestinationUnreachable, "wsa:DestinationUnreachable" },
	{ (long)wsa__ActionNotSupported, "wsa:ActionNotSupported" },
	{ (long)wsa__EndpointUnavailable, "wsa:EndpointUnavailable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa__FaultSubcodeValues2s(struct soap *soap, enum wsa__FaultSubcodeValues n)
{	const char *s = soap_code_str(soap_codes_wsa__FaultSubcodeValues, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__FaultSubcodeValues(struct soap *soap, const char *tag, int id, const enum wsa__FaultSubcodeValues *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__FaultSubcodeValues), type) || soap_send(soap, soap_wsa__FaultSubcodeValues2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa__FaultSubcodeValues(struct soap *soap, const char *s, enum wsa__FaultSubcodeValues *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsa__FaultSubcodeValues, t);
	if (map)
		*a = (enum wsa__FaultSubcodeValues)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 4)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa__FaultSubcodeValues)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa__FaultSubcodeValues * SOAP_FMAC4 soap_in_wsa__FaultSubcodeValues(struct soap *soap, const char *tag, enum wsa__FaultSubcodeValues *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa__FaultSubcodeValues *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__FaultSubcodeValues, sizeof(enum wsa__FaultSubcodeValues), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa__FaultSubcodeValues(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa__FaultSubcodeValues *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__FaultSubcodeValues, 0, sizeof(enum wsa__FaultSubcodeValues), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__FaultSubcodeValues(struct soap *soap, const enum wsa__FaultSubcodeValues *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__FaultSubcodeValues);
	if (soap_out_wsa__FaultSubcodeValues(soap, tag?tag:"wsa:FaultSubcodeValues", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa__FaultSubcodeValues * SOAP_FMAC4 soap_get_wsa__FaultSubcodeValues(struct soap *soap, enum wsa__FaultSubcodeValues *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__FaultSubcodeValues(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__RelationshipTypeValues(struct soap *soap, enum wsa__RelationshipTypeValues *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsa__RelationshipTypeValues
	*a = SOAP_DEFAULT_wsa__RelationshipTypeValues;
#else
	*a = (enum wsa__RelationshipTypeValues)0;
#endif
}

static const struct soap_code_map soap_codes_wsa__RelationshipTypeValues[] =
{	{ (long)wsa__Reply, "wsa:Reply" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsa__RelationshipTypeValues2s(struct soap *soap, enum wsa__RelationshipTypeValues n)
{	const char *s = soap_code_str(soap_codes_wsa__RelationshipTypeValues, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__RelationshipTypeValues(struct soap *soap, const char *tag, int id, const enum wsa__RelationshipTypeValues *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__RelationshipTypeValues), type) || soap_send(soap, soap_wsa__RelationshipTypeValues2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsa__RelationshipTypeValues(struct soap *soap, const char *s, enum wsa__RelationshipTypeValues *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsa__RelationshipTypeValues, t);
	if (map)
		*a = (enum wsa__RelationshipTypeValues)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsa__RelationshipTypeValues)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsa__RelationshipTypeValues * SOAP_FMAC4 soap_in_wsa__RelationshipTypeValues(struct soap *soap, const char *tag, enum wsa__RelationshipTypeValues *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsa__RelationshipTypeValues *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__RelationshipTypeValues, sizeof(enum wsa__RelationshipTypeValues), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsa__RelationshipTypeValues(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsa__RelationshipTypeValues *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__RelationshipTypeValues, 0, sizeof(enum wsa__RelationshipTypeValues), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__RelationshipTypeValues(struct soap *soap, const enum wsa__RelationshipTypeValues *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__RelationshipTypeValues);
	if (soap_out_wsa__RelationshipTypeValues(soap, tag?tag:"wsa:RelationshipTypeValues", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsa__RelationshipTypeValues * SOAP_FMAC4 soap_get_wsa__RelationshipTypeValues(struct soap *soap, enum wsa__RelationshipTypeValues *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__RelationshipTypeValues(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__FaultCodeType(struct soap *soap, enum d__FaultCodeType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_d__FaultCodeType
	*a = SOAP_DEFAULT_d__FaultCodeType;
#else
	*a = (enum d__FaultCodeType)0;
#endif
}

static const struct soap_code_map soap_codes_d__FaultCodeType[] =
{	{ (long)d__MatchingRuleNotSupported, "d:MatchingRuleNotSupported" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_d__FaultCodeType2s(struct soap *soap, enum d__FaultCodeType n)
{	const char *s = soap_code_str(soap_codes_d__FaultCodeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__FaultCodeType(struct soap *soap, const char *tag, int id, const enum d__FaultCodeType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__FaultCodeType), type) || soap_send(soap, soap_d__FaultCodeType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2d__FaultCodeType(struct soap *soap, const char *s, enum d__FaultCodeType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_d__FaultCodeType, t);
	if (map)
		*a = (enum d__FaultCodeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum d__FaultCodeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum d__FaultCodeType * SOAP_FMAC4 soap_in_d__FaultCodeType(struct soap *soap, const char *tag, enum d__FaultCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum d__FaultCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__FaultCodeType, sizeof(enum d__FaultCodeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2d__FaultCodeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum d__FaultCodeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__FaultCodeType, 0, sizeof(enum d__FaultCodeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__FaultCodeType(struct soap *soap, const enum d__FaultCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__FaultCodeType);
	if (soap_out_d__FaultCodeType(soap, tag?tag:"d:FaultCodeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum d__FaultCodeType * SOAP_FMAC4 soap_get_d__FaultCodeType(struct soap *soap, enum d__FaultCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__FaultCodeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__RelationshipType(struct soap *soap, enum d__RelationshipType *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_d__RelationshipType
	*a = SOAP_DEFAULT_d__RelationshipType;
#else
	*a = (enum d__RelationshipType)0;
#endif
}

static const struct soap_code_map soap_codes_d__RelationshipType[] =
{	{ (long)d__Suppression, "d:Suppression" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_d__RelationshipType2s(struct soap *soap, enum d__RelationshipType n)
{	const char *s = soap_code_str(soap_codes_d__RelationshipType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__RelationshipType(struct soap *soap, const char *tag, int id, const enum d__RelationshipType *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__RelationshipType), type) || soap_send(soap, soap_d__RelationshipType2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2d__RelationshipType(struct soap *soap, const char *s, enum d__RelationshipType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_d__RelationshipType, t);
	if (map)
		*a = (enum d__RelationshipType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum d__RelationshipType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum d__RelationshipType * SOAP_FMAC4 soap_in_d__RelationshipType(struct soap *soap, const char *tag, enum d__RelationshipType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum d__RelationshipType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__RelationshipType, sizeof(enum d__RelationshipType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2d__RelationshipType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum d__RelationshipType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__RelationshipType, 0, sizeof(enum d__RelationshipType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__RelationshipType(struct soap *soap, const enum d__RelationshipType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__RelationshipType);
	if (soap_out_d__RelationshipType(soap, tag?tag:"d:RelationshipType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum d__RelationshipType * SOAP_FMAC4 soap_get_d__RelationshipType(struct soap *soap, enum d__RelationshipType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__RelationshipType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag_fault = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__wsa__MessageID(soap, &a->wsa__MessageID);
	a->wsa__RelatesTo = NULL;
	a->wsa__From = NULL;
	a->wsa__ReplyTo = NULL;
	a->wsa__FaultTo = NULL;
	soap_default__wsa__To(soap, &a->wsa__To);
	soap_default__wsa__Action(soap, &a->wsa__Action);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__wsa__MessageID(soap, &a->wsa__MessageID);
	soap_serialize_PointerTo_wsa__RelatesTo(soap, &a->wsa__RelatesTo);
	soap_serialize_PointerTo_wsa__From(soap, &a->wsa__From);
	soap_serialize_PointerTo_wsa__ReplyTo(soap, &a->wsa__ReplyTo);
	soap_serialize_PointerTo_wsa__FaultTo(soap, &a->wsa__FaultTo);
	soap_serialize__wsa__To(soap, &a->wsa__To);
	soap_serialize__wsa__Action(soap, &a->wsa__Action);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	if (soap_out__wsa__MessageID(soap, "wsa:MessageID", -1, &a->wsa__MessageID, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa__RelatesTo(soap, "wsa:RelatesTo", -1, &a->wsa__RelatesTo, ""))
		return soap->error;
	if (soap_out_PointerTo_wsa__From(soap, "wsa:From", -1, &a->wsa__From, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa__ReplyTo(soap, "wsa:ReplyTo", -1, &a->wsa__ReplyTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTo_wsa__FaultTo(soap, "wsa:FaultTo", -1, &a->wsa__FaultTo, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa__To(soap, "wsa:To", -1, &a->wsa__To, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out__wsa__Action(soap, "wsa:Action", -1, &a->wsa__Action, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	size_t soap_flag_wsa__MessageID = 1;
	size_t soap_flag_wsa__RelatesTo = 1;
	size_t soap_flag_wsa__From = 1;
	size_t soap_flag_wsa__ReplyTo = 1;
	size_t soap_flag_wsa__FaultTo = 1;
	size_t soap_flag_wsa__To = 1;
	size_t soap_flag_wsa__Action = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__MessageID && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__MessageID(soap, "wsa:MessageID", &a->wsa__MessageID, ""))
				{	soap_flag_wsa__MessageID--;
					continue;
				}
			if (soap_flag_wsa__RelatesTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__RelatesTo(soap, "wsa:RelatesTo", &a->wsa__RelatesTo, ""))
				{	soap_flag_wsa__RelatesTo--;
					continue;
				}
			if (soap_flag_wsa__From && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__From(soap, "wsa:From", &a->wsa__From, ""))
				{	soap_flag_wsa__From--;
					continue;
				}
			if (soap_flag_wsa__ReplyTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__ReplyTo(soap, "wsa:ReplyTo", &a->wsa__ReplyTo, ""))
				{	soap_flag_wsa__ReplyTo--;
					continue;
				}
			if (soap_flag_wsa__FaultTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsa__FaultTo(soap, "wsa:FaultTo", &a->wsa__FaultTo, ""))
				{	soap_flag_wsa__FaultTo--;
					continue;
				}
			if (soap_flag_wsa__To && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__To(soap, "wsa:To", &a->wsa__To, ""))
				{	soap_flag_wsa__To--;
					continue;
				}
			if (soap_flag_wsa__Action && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in__wsa__Action(soap, "wsa:Action", &a->wsa__Action, ""))
				{	soap_flag_wsa__Action--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Probe(struct soap *soap, struct __d__Probe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Probe = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Probe(struct soap *soap, const struct __d__Probe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__ProbeType(soap, &a->d__Probe);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Probe(struct soap *soap, const char *tag, int id, const struct __d__Probe *a, const char *type)
{
	if (soap_out_PointerTod__ProbeType(soap, "d:Probe", -1, &a->d__Probe, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Probe * SOAP_FMAC4 soap_in___d__Probe(struct soap *soap, const char *tag, struct __d__Probe *a, const char *type)
{
	size_t soap_flag_d__Probe = 1;
	short soap_flag;
	a = (struct __d__Probe *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Probe, sizeof(struct __d__Probe), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Probe(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Probe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ProbeType(soap, "d:Probe", &a->d__Probe, "d:ProbeType"))
				{	soap_flag_d__Probe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Probe(struct soap *soap, const struct __d__Probe *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Probe(soap, tag?tag:"-d:Probe", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Probe * SOAP_FMAC4 soap_get___d__Probe(struct soap *soap, struct __d__Probe *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Probe(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Bye(struct soap *soap, struct __d__Bye *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Bye = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Bye(struct soap *soap, const struct __d__Bye *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__ByeType(soap, &a->d__Bye);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Bye(struct soap *soap, const char *tag, int id, const struct __d__Bye *a, const char *type)
{
	if (soap_out_PointerTod__ByeType(soap, "d:Bye", -1, &a->d__Bye, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Bye * SOAP_FMAC4 soap_in___d__Bye(struct soap *soap, const char *tag, struct __d__Bye *a, const char *type)
{
	size_t soap_flag_d__Bye = 1;
	short soap_flag;
	a = (struct __d__Bye *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Bye, sizeof(struct __d__Bye), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Bye(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Bye && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ByeType(soap, "d:Bye", &a->d__Bye, "d:ByeType"))
				{	soap_flag_d__Bye--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Bye(struct soap *soap, const struct __d__Bye *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Bye(soap, tag?tag:"-d:Bye", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Bye * SOAP_FMAC4 soap_get___d__Bye(struct soap *soap, struct __d__Bye *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Bye(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___d__Hello(struct soap *soap, struct __d__Hello *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->d__Hello = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___d__Hello(struct soap *soap, const struct __d__Hello *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__HelloType(soap, &a->d__Hello);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___d__Hello(struct soap *soap, const char *tag, int id, const struct __d__Hello *a, const char *type)
{
	if (soap_out_PointerTod__HelloType(soap, "d:Hello", -1, &a->d__Hello, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Hello * SOAP_FMAC4 soap_in___d__Hello(struct soap *soap, const char *tag, struct __d__Hello *a, const char *type)
{
	size_t soap_flag_d__Hello = 1;
	short soap_flag;
	a = (struct __d__Hello *)soap_id_enter(soap, "", a, SOAP_TYPE___d__Hello, sizeof(struct __d__Hello), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___d__Hello(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_d__Hello && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__HelloType(soap, "d:Hello", &a->d__Hello, "d:HelloType"))
				{	soap_flag_d__Hello--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___d__Hello(struct soap *soap, const struct __d__Hello *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___d__Hello(soap, tag?tag:"-d:Hello", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __d__Hello * SOAP_FMAC4 soap_get___d__Hello(struct soap *soap, struct __d__Hello *p, const char *tag, const char *type)
{
	if ((p = soap_in___d__Hello(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__AttributedURI(struct soap *soap, struct wsa__AttributedURI *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->__item);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__AttributedURI(struct soap *soap, const struct wsa__AttributedURI *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__AttributedURI(struct soap *soap, const char *tag, int id, const struct wsa__AttributedURI *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_xsd__anyURI(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa__AttributedURI * SOAP_FMAC4 soap_in_wsa__AttributedURI(struct soap *soap, const char *tag, struct wsa__AttributedURI *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__AttributedURI *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__AttributedURI, sizeof(struct wsa__AttributedURI), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__AttributedURI(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_xsd__anyURI(soap, tag, &a->__item, "wsa:AttributedURI"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__AttributedURI(struct soap *soap, const struct wsa__AttributedURI *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__AttributedURI);
	if (soap_out_wsa__AttributedURI(soap, tag?tag:"wsa:AttributedURI", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__AttributedURI * SOAP_FMAC4 soap_get_wsa__AttributedURI(struct soap *soap, struct wsa__AttributedURI *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__AttributedURI(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__AttributedQName(struct soap *soap, struct wsa__AttributedQName *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->__item);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__AttributedQName(struct soap *soap, const struct wsa__AttributedQName *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__AttributedQName(struct soap *soap, const char *tag, int id, const struct wsa__AttributedQName *a, const char *type)
{
	const char *soap_tmp___item = soap_QName2s(soap, a->__item);
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out__QName(soap, tag, id, (char*const*)&soap_tmp___item, "");
}

SOAP_FMAC3 struct wsa__AttributedQName * SOAP_FMAC4 soap_in_wsa__AttributedQName(struct soap *soap, const char *tag, struct wsa__AttributedQName *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__AttributedQName *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__AttributedQName, sizeof(struct wsa__AttributedQName), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__AttributedQName(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in__QName(soap, tag, &a->__item, "wsa:AttributedQName"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__AttributedQName(struct soap *soap, const struct wsa__AttributedQName *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__AttributedQName);
	if (soap_out_wsa__AttributedQName(soap, tag?tag:"wsa:AttributedQName", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__AttributedQName * SOAP_FMAC4 soap_get_wsa__AttributedQName(struct soap *soap, struct wsa__AttributedQName *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__AttributedQName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__RetryAfterType(struct soap *soap, struct wsa__RetryAfterType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__nonNegativeInteger(soap, &a->__item);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__RetryAfterType(struct soap *soap, const struct wsa__RetryAfterType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__nonNegativeInteger(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__RetryAfterType(struct soap *soap, const char *tag, int id, const struct wsa__RetryAfterType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_xsd__nonNegativeInteger(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa__RetryAfterType * SOAP_FMAC4 soap_in_wsa__RetryAfterType(struct soap *soap, const char *tag, struct wsa__RetryAfterType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__RetryAfterType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__RetryAfterType, sizeof(struct wsa__RetryAfterType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__RetryAfterType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_xsd__nonNegativeInteger(soap, tag, &a->__item, "wsa:RetryAfterType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__RetryAfterType(struct soap *soap, const struct wsa__RetryAfterType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__RetryAfterType);
	if (soap_out_wsa__RetryAfterType(soap, tag?tag:"wsa:RetryAfterType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__RetryAfterType * SOAP_FMAC4 soap_get_wsa__RetryAfterType(struct soap *soap, struct wsa__RetryAfterType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__RetryAfterType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__ReplyAfterType(struct soap *soap, struct wsa__ReplyAfterType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__nonNegativeInteger(soap, &a->__item);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__ReplyAfterType(struct soap *soap, const struct wsa__ReplyAfterType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__nonNegativeInteger(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__ReplyAfterType(struct soap *soap, const char *tag, int id, const struct wsa__ReplyAfterType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_xsd__nonNegativeInteger(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa__ReplyAfterType * SOAP_FMAC4 soap_in_wsa__ReplyAfterType(struct soap *soap, const char *tag, struct wsa__ReplyAfterType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__ReplyAfterType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__ReplyAfterType, sizeof(struct wsa__ReplyAfterType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__ReplyAfterType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_xsd__nonNegativeInteger(soap, tag, &a->__item, "wsa:ReplyAfterType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__ReplyAfterType(struct soap *soap, const struct wsa__ReplyAfterType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__ReplyAfterType);
	if (soap_out_wsa__ReplyAfterType(soap, tag?tag:"wsa:ReplyAfterType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ReplyAfterType * SOAP_FMAC4 soap_get_wsa__ReplyAfterType(struct soap *soap, struct wsa__ReplyAfterType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__ReplyAfterType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__Relationship(struct soap *soap, struct wsa__Relationship *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->__item);
	soap_default__QName(soap, &a->RelationshipType);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__Relationship(struct soap *soap, const struct wsa__Relationship *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__Relationship(struct soap *soap, const char *tag, int id, const struct wsa__Relationship *a, const char *type)
{
	if (a->RelationshipType)
		soap_set_attr(soap, "RelationshipType", soap_QName2s(soap, a->RelationshipType));
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_xsd__anyURI(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsa__Relationship * SOAP_FMAC4 soap_in_wsa__Relationship(struct soap *soap, const char *tag, struct wsa__Relationship *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__Relationship *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__Relationship, sizeof(struct wsa__Relationship), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__Relationship(soap, a);
	if (soap_s2QName(soap, soap_attr_value(soap, "RelationshipType", 0), &a->RelationshipType, -1, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_xsd__anyURI(soap, tag, &a->__item, "wsa:Relationship"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__Relationship(struct soap *soap, const struct wsa__Relationship *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__Relationship);
	if (soap_out_wsa__Relationship(soap, tag?tag:"wsa:Relationship", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__Relationship * SOAP_FMAC4 soap_get_wsa__Relationship(struct soap *soap, struct wsa__Relationship *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__Relationship(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__ServiceNameType(struct soap *soap, struct wsa__ServiceNameType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->__item);
	soap_default_xsd__NCName(soap, &a->PortName);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__ServiceNameType(struct soap *soap, const struct wsa__ServiceNameType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__ServiceNameType(struct soap *soap, const char *tag, int id, const struct wsa__ServiceNameType *a, const char *type)
{
	const char *soap_tmp___item = soap_QName2s(soap, a->__item);
	if (a->PortName)
		soap_set_attr(soap, "PortName", a->PortName);
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out__QName(soap, tag, id, (char*const*)&soap_tmp___item, "");
}

SOAP_FMAC3 struct wsa__ServiceNameType * SOAP_FMAC4 soap_in_wsa__ServiceNameType(struct soap *soap, const char *tag, struct wsa__ServiceNameType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct wsa__ServiceNameType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__ServiceNameType, sizeof(struct wsa__ServiceNameType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_wsa__ServiceNameType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "PortName", 0), &a->PortName, -1, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in__QName(soap, tag, &a->__item, "wsa:ServiceNameType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__ServiceNameType(struct soap *soap, const struct wsa__ServiceNameType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__ServiceNameType);
	if (soap_out_wsa__ServiceNameType(soap, tag?tag:"wsa:ServiceNameType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ServiceNameType * SOAP_FMAC4 soap_get_wsa__ServiceNameType(struct soap *soap, struct wsa__ServiceNameType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__ServiceNameType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__ReferenceParametersType(struct soap *soap, struct wsa__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__ReferenceParametersType(struct soap *soap, const struct wsa__ReferenceParametersType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__ReferenceParametersType(struct soap *soap, const char *tag, int id, const struct wsa__ReferenceParametersType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__ReferenceParametersType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa__ReferenceParametersType * SOAP_FMAC4 soap_in_wsa__ReferenceParametersType(struct soap *soap, const char *tag, struct wsa__ReferenceParametersType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa__ReferenceParametersType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__ReferenceParametersType, sizeof(struct wsa__ReferenceParametersType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa__ReferenceParametersType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa__ReferenceParametersType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__ReferenceParametersType, 0, sizeof(struct wsa__ReferenceParametersType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__ReferenceParametersType(struct soap *soap, const struct wsa__ReferenceParametersType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__ReferenceParametersType);
	if (soap_out_wsa__ReferenceParametersType(soap, tag?tag:"wsa:ReferenceParametersType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ReferenceParametersType * SOAP_FMAC4 soap_get_wsa__ReferenceParametersType(struct soap *soap, struct wsa__ReferenceParametersType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__ReferenceParametersType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__ReferencePropertiesType(struct soap *soap, struct wsa__ReferencePropertiesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__ReferencePropertiesType(struct soap *soap, const struct wsa__ReferencePropertiesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__ReferencePropertiesType(struct soap *soap, const char *tag, int id, const struct wsa__ReferencePropertiesType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__ReferencePropertiesType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa__ReferencePropertiesType * SOAP_FMAC4 soap_in_wsa__ReferencePropertiesType(struct soap *soap, const char *tag, struct wsa__ReferencePropertiesType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa__ReferencePropertiesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__ReferencePropertiesType, sizeof(struct wsa__ReferencePropertiesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa__ReferencePropertiesType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa__ReferencePropertiesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__ReferencePropertiesType, 0, sizeof(struct wsa__ReferencePropertiesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__ReferencePropertiesType(struct soap *soap, const struct wsa__ReferencePropertiesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__ReferencePropertiesType);
	if (soap_out_wsa__ReferencePropertiesType(soap, tag?tag:"wsa:ReferencePropertiesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ReferencePropertiesType * SOAP_FMAC4 soap_get_wsa__ReferencePropertiesType(struct soap *soap, struct wsa__ReferencePropertiesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__ReferencePropertiesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsa__EndpointReferenceType(struct soap *soap, struct wsa__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Address = NULL;
	a->ReferenceProperties = NULL;
	a->ReferenceParameters = NULL;
	a->PortType = NULL;
	a->ServiceName = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsa__EndpointReferenceType(struct soap *soap, const struct wsa__EndpointReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__AttributedURI(soap, &a->Address);
	soap_serialize_PointerTowsa__ReferencePropertiesType(soap, &a->ReferenceProperties);
	soap_serialize_PointerTowsa__ReferenceParametersType(soap, &a->ReferenceParameters);
	soap_serialize_PointerTowsa__AttributedQName(soap, &a->PortType);
	soap_serialize_PointerTowsa__ServiceNameType(soap, &a->ServiceName);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsa__EndpointReferenceType(struct soap *soap, const char *tag, int id, const struct wsa__EndpointReferenceType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsa__EndpointReferenceType), type))
		return soap->error;
	if (soap_out_PointerTowsa__AttributedURI(soap, "wsa:Address", -1, &a->Address, ""))
		return soap->error;
	if (soap_out_PointerTowsa__ReferencePropertiesType(soap, "wsa:ReferenceProperties", -1, &a->ReferenceProperties, ""))
		return soap->error;
	if (soap_out_PointerTowsa__ReferenceParametersType(soap, "wsa:ReferenceParameters", -1, &a->ReferenceParameters, ""))
		return soap->error;
	if (soap_out_PointerTowsa__AttributedQName(soap, "wsa:PortType", -1, &a->PortType, ""))
		return soap->error;
	if (soap_out_PointerTowsa__ServiceNameType(soap, "wsa:ServiceName", -1, &a->ServiceName, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType * SOAP_FMAC4 soap_in_wsa__EndpointReferenceType(struct soap *soap, const char *tag, struct wsa__EndpointReferenceType *a, const char *type)
{
	size_t soap_flag_Address = 1;
	size_t soap_flag_ReferenceProperties = 1;
	size_t soap_flag_ReferenceParameters = 1;
	size_t soap_flag_PortType = 1;
	size_t soap_flag_ServiceName = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct wsa__EndpointReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsa__EndpointReferenceType, sizeof(struct wsa__EndpointReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsa__EndpointReferenceType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Address && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__AttributedURI(soap, "wsa:Address", &a->Address, "wsa:AttributedURI"))
				{	soap_flag_Address--;
					continue;
				}
			if (soap_flag_ReferenceProperties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__ReferencePropertiesType(soap, "wsa:ReferenceProperties", &a->ReferenceProperties, "wsa:ReferencePropertiesType"))
				{	soap_flag_ReferenceProperties--;
					continue;
				}
			if (soap_flag_ReferenceParameters && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__ReferenceParametersType(soap, "wsa:ReferenceParameters", &a->ReferenceParameters, "wsa:ReferenceParametersType"))
				{	soap_flag_ReferenceParameters--;
					continue;
				}
			if (soap_flag_PortType && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__AttributedQName(soap, "wsa:PortType", &a->PortType, "wsa:AttributedQName"))
				{	soap_flag_PortType--;
					continue;
				}
			if (soap_flag_ServiceName && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__ServiceNameType(soap, "wsa:ServiceName", &a->ServiceName, "wsa:ServiceNameType"))
				{	soap_flag_ServiceName--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsa__EndpointReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsa__EndpointReferenceType, 0, sizeof(struct wsa__EndpointReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Address > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsa__EndpointReferenceType(struct soap *soap, const struct wsa__EndpointReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsa__EndpointReferenceType);
	if (soap_out_wsa__EndpointReferenceType(soap, tag?tag:"wsa:EndpointReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType * SOAP_FMAC4 soap_get_wsa__EndpointReferenceType(struct soap *soap, struct wsa__EndpointReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsa__EndpointReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__AppSequenceType(struct soap *soap, struct d__AppSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_unsignedInt(soap, &a->InstanceId);
	soap_default_xsd__anyURI(soap, &a->SequenceId);
	soap_default_unsignedInt(soap, &a->MessageNumber);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__AppSequenceType(struct soap *soap, const struct d__AppSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__AppSequenceType(struct soap *soap, const char *tag, int id, const struct d__AppSequenceType *a, const char *type)
{
	soap_set_attr(soap, "InstanceId", soap_unsignedInt2s(soap, a->InstanceId));
	if (a->SequenceId)
		soap_set_attr(soap, "SequenceId", a->SequenceId);
	soap_set_attr(soap, "MessageNumber", soap_unsignedInt2s(soap, a->MessageNumber));
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__AppSequenceType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__AppSequenceType * SOAP_FMAC4 soap_in_d__AppSequenceType(struct soap *soap, const char *tag, struct d__AppSequenceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__AppSequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__AppSequenceType, sizeof(struct d__AppSequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__AppSequenceType(soap, a);
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "InstanceId", 1), &a->InstanceId))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "SequenceId", 0), &a->SequenceId, -1, -1))
		return NULL;
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "MessageNumber", 1), &a->MessageNumber))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__AppSequenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__AppSequenceType, 0, sizeof(struct d__AppSequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__AppSequenceType(struct soap *soap, const struct d__AppSequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__AppSequenceType);
	if (soap_out_d__AppSequenceType(soap, tag?tag:"d:AppSequenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__AppSequenceType * SOAP_FMAC4 soap_get_d__AppSequenceType(struct soap *soap, struct d__AppSequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__AppSequenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SigType(struct soap *soap, struct d__SigType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__size = 0;
	a->__any = NULL;
	soap_default_xsd__anyURI(soap, &a->Scheme);
	a->KeyId = NULL;
	soap_default_xsd__IDREFS(soap, &a->Refs);
	soap_default_xsd__base64Binary(soap, &a->Sig);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SigType(struct soap *soap, const struct d__SigType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SigType(struct soap *soap, const char *tag, int id, const struct d__SigType *a, const char *type)
{
	if (a->Scheme)
		soap_set_attr(soap, "Scheme", a->Scheme);
	if (a->KeyId)
		if (a->KeyId->__ptr)
			soap_set_attr(soap, "KeyId", soap_s2base64(soap, a->KeyId->__ptr, NULL, a->KeyId->__size));
	if (a->Refs)
		soap_set_attr(soap, "Refs", a->Refs);
	if (a->Sig.__ptr)
		soap_set_attr(soap, "Sig", soap_s2base64(soap, a->Sig.__ptr, NULL, a->Sig.__size));
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SigType), type))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__SigType * SOAP_FMAC4 soap_in_d__SigType(struct soap *soap, const char *tag, struct d__SigType *a, const char *type)
{
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SigType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SigType, sizeof(struct d__SigType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SigType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Scheme", 1), &a->Scheme, -1, -1))
		return NULL;
	{	const char *t = soap_attr_value(soap, "KeyId", 0);
		if (t)
		{
			if (!(a->KeyId = (struct xsd__base64Binary *)soap_malloc(soap, sizeof(struct xsd__base64Binary))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (!(a->KeyId->__ptr = (unsigned char*)soap_base642s(soap, soap_attr_value(soap, "KeyId", 0), NULL, 0, &a->KeyId->__size)))
				return NULL;
		}
		else if (soap->error)
			return NULL;
	}
	if (soap_s2string(soap, soap_attr_value(soap, "Refs", 1), &a->Refs, -1, -1))
		return NULL;
	if (!(a->Sig.__ptr = (unsigned char*)soap_base642s(soap, soap_attr_value(soap, "Sig", 1), NULL, 0, &a->Sig.__size)))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SigType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SigType, 0, sizeof(struct d__SigType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SigType(struct soap *soap, const struct d__SigType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SigType);
	if (soap_out_d__SigType(soap, tag?tag:"d:SigType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__SigType * SOAP_FMAC4 soap_get_d__SigType(struct soap *soap, struct d__SigType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SigType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__SecurityType(struct soap *soap, struct d__SecurityType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Sig = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__SecurityType(struct soap *soap, const struct d__SecurityType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__SigType(soap, &a->Sig);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__SecurityType(struct soap *soap, const char *tag, int id, const struct d__SecurityType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__SecurityType), type))
		return soap->error;
	if (soap_out_PointerTod__SigType(soap, "d:Sig", -1, &a->Sig, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__SecurityType * SOAP_FMAC4 soap_in_d__SecurityType(struct soap *soap, const char *tag, struct d__SecurityType *a, const char *type)
{
	size_t soap_flag_Sig = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__SecurityType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__SecurityType, sizeof(struct d__SecurityType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__SecurityType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Sig && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__SigType(soap, "d:Sig", &a->Sig, "d:SigType"))
				{	soap_flag_Sig--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__SecurityType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__SecurityType, 0, sizeof(struct d__SecurityType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__SecurityType(struct soap *soap, const struct d__SecurityType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__SecurityType);
	if (soap_out_d__SecurityType(soap, tag?tag:"d:SecurityType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__SecurityType * SOAP_FMAC4 soap_get_d__SecurityType(struct soap *soap, struct d__SecurityType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__SecurityType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ScopesType(struct soap *soap, struct d__ScopesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_d__UriListType(soap, &a->__item);
	soap_default_xsd__anyURI(soap, &a->MatchBy);
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ScopesType(struct soap *soap, const struct d__ScopesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_d__UriListType(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ScopesType(struct soap *soap, const char *tag, int id, const struct d__ScopesType *a, const char *type)
{
	if (a->MatchBy)
		soap_set_attr(soap, "MatchBy", a->MatchBy);
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	return soap_out_d__UriListType(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct d__ScopesType * SOAP_FMAC4 soap_in_d__ScopesType(struct soap *soap, const char *tag, struct d__ScopesType *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct d__ScopesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ScopesType, sizeof(struct d__ScopesType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_d__ScopesType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "MatchBy", 0), &a->MatchBy, -1, -1))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (!soap_in_d__UriListType(soap, tag, &a->__item, "d:ScopesType"))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ScopesType(struct soap *soap, const struct d__ScopesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ScopesType);
	if (soap_out_d__ScopesType(soap, tag?tag:"d:ScopesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ScopesType * SOAP_FMAC4 soap_get_d__ScopesType(struct soap *soap, struct d__ScopesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ScopesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ResolveMatchType(struct soap *soap, struct d__ResolveMatchType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	soap_default_d__UriListType(soap, &a->XAddrs);
	soap_default_unsignedInt(soap, &a->MetadataVersion);
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ResolveMatchType(struct soap *soap, const struct d__ResolveMatchType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
	soap_serialize_d__UriListType(soap, &a->XAddrs);
	soap_embedded(soap, &a->MetadataVersion, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ResolveMatchType(struct soap *soap, const char *tag, int id, const struct d__ResolveMatchType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ResolveMatchType), type))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (soap_out_d__UriListType(soap, "d:XAddrs", -1, &a->XAddrs, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "d:MetadataVersion", -1, &a->MetadataVersion, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ResolveMatchType * SOAP_FMAC4 soap_in_d__ResolveMatchType(struct soap *soap, const char *tag, struct d__ResolveMatchType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	size_t soap_flag_XAddrs = 1;
	size_t soap_flag_MetadataVersion = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ResolveMatchType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ResolveMatchType, sizeof(struct d__ResolveMatchType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ResolveMatchType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__UriListType(soap, "d:XAddrs", &a->XAddrs, "d:UriListType"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "d:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ResolveMatchType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ResolveMatchType, 0, sizeof(struct d__ResolveMatchType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0 || soap_flag_XAddrs > 0 || soap_flag_MetadataVersion > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ResolveMatchType(struct soap *soap, const struct d__ResolveMatchType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ResolveMatchType);
	if (soap_out_d__ResolveMatchType(soap, tag?tag:"d:ResolveMatchType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ResolveMatchType * SOAP_FMAC4 soap_get_d__ResolveMatchType(struct soap *soap, struct d__ResolveMatchType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ResolveMatchType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ResolveMatchesType(struct soap *soap, struct d__ResolveMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ResolveMatch = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ResolveMatchesType(struct soap *soap, const struct d__ResolveMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTod__ResolveMatchType(soap, &a->ResolveMatch);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ResolveMatchesType(struct soap *soap, const char *tag, int id, const struct d__ResolveMatchesType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ResolveMatchesType), type))
		return soap->error;
	if (soap_out_PointerTod__ResolveMatchType(soap, "d:ResolveMatch", -1, &a->ResolveMatch, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ResolveMatchesType * SOAP_FMAC4 soap_in_d__ResolveMatchesType(struct soap *soap, const char *tag, struct d__ResolveMatchesType *a, const char *type)
{
	size_t soap_flag_ResolveMatch = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ResolveMatchesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ResolveMatchesType, sizeof(struct d__ResolveMatchesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ResolveMatchesType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ResolveMatch && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ResolveMatchType(soap, "d:ResolveMatch", &a->ResolveMatch, "d:ResolveMatchType"))
				{	soap_flag_ResolveMatch--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ResolveMatchesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ResolveMatchesType, 0, sizeof(struct d__ResolveMatchesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ResolveMatchesType(struct soap *soap, const struct d__ResolveMatchesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ResolveMatchesType);
	if (soap_out_d__ResolveMatchesType(soap, tag?tag:"d:ResolveMatchesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ResolveMatchesType * SOAP_FMAC4 soap_get_d__ResolveMatchesType(struct soap *soap, struct d__ResolveMatchesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ResolveMatchesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ResolveType(struct soap *soap, struct d__ResolveType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ResolveType(struct soap *soap, const struct d__ResolveType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ResolveType(struct soap *soap, const char *tag, int id, const struct d__ResolveType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ResolveType), type))
		return soap->error;
	if (a->wsa__EndpointReference)
		soap_element_result(soap, "wsa:EndpointReference");
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ResolveType * SOAP_FMAC4 soap_in_d__ResolveType(struct soap *soap, const char *tag, struct d__ResolveType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ResolveType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ResolveType, sizeof(struct d__ResolveType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ResolveType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			soap_check_result(soap, "wsa:EndpointReference");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ResolveType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ResolveType, 0, sizeof(struct d__ResolveType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ResolveType(struct soap *soap, const struct d__ResolveType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ResolveType);
	if (soap_out_d__ResolveType(soap, tag?tag:"d:ResolveType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ResolveType * SOAP_FMAC4 soap_get_d__ResolveType(struct soap *soap, struct d__ResolveType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ResolveType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ProbeMatchType(struct soap *soap, struct d__ProbeMatchType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	soap_default_d__UriListType(soap, &a->XAddrs);
	soap_default_unsignedInt(soap, &a->MetadataVersion);
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ProbeMatchType(struct soap *soap, const struct d__ProbeMatchType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
	soap_serialize_d__UriListType(soap, &a->XAddrs);
	soap_embedded(soap, &a->MetadataVersion, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ProbeMatchType(struct soap *soap, const char *tag, int id, const struct d__ProbeMatchType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ProbeMatchType), type))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (soap_out_d__UriListType(soap, "d:XAddrs", -1, &a->XAddrs, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "d:MetadataVersion", -1, &a->MetadataVersion, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ProbeMatchType * SOAP_FMAC4 soap_in_d__ProbeMatchType(struct soap *soap, const char *tag, struct d__ProbeMatchType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	size_t soap_flag_XAddrs = 1;
	size_t soap_flag_MetadataVersion = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ProbeMatchType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ProbeMatchType, sizeof(struct d__ProbeMatchType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ProbeMatchType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__UriListType(soap, "d:XAddrs", &a->XAddrs, "d:UriListType"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "d:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ProbeMatchType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ProbeMatchType, 0, sizeof(struct d__ProbeMatchType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0 || soap_flag_MetadataVersion > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ProbeMatchType(struct soap *soap, const struct d__ProbeMatchType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ProbeMatchType);
	if (soap_out_d__ProbeMatchType(soap, tag?tag:"d:ProbeMatchType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeMatchType * SOAP_FMAC4 soap_get_d__ProbeMatchType(struct soap *soap, struct d__ProbeMatchType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ProbeMatchType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ProbeMatchesType(struct soap *soap, struct d__ProbeMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeProbeMatch = 0;
	a->ProbeMatch = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ProbeMatchesType(struct soap *soap, const struct d__ProbeMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->ProbeMatch)
	{	int i;
		for (i = 0; i < a->__sizeProbeMatch; i++)
		{
			soap_embedded(soap, a->ProbeMatch + i, SOAP_TYPE_d__ProbeMatchType);
			soap_serialize_d__ProbeMatchType(soap, a->ProbeMatch + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ProbeMatchesType(struct soap *soap, const char *tag, int id, const struct d__ProbeMatchesType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ProbeMatchesType), type))
		return soap->error;
	soap_element_result(soap, "-sizeProbeMatch");
	if (a->ProbeMatch)
	{	int i;
		for (i = 0; i < a->__sizeProbeMatch; i++)
			if (soap_out_d__ProbeMatchType(soap, "d:ProbeMatch", -1, a->ProbeMatch + i, ""))
				return soap->error;
	}
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ProbeMatchesType * SOAP_FMAC4 soap_in_d__ProbeMatchesType(struct soap *soap, const char *tag, struct d__ProbeMatchesType *a, const char *type)
{
	struct soap_blist *soap_blist_ProbeMatch = NULL;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ProbeMatchesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ProbeMatchesType, sizeof(struct d__ProbeMatchesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ProbeMatchesType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "d:ProbeMatch", 1, NULL))
			{	if (a->ProbeMatch == NULL)
				{	if (soap_blist_ProbeMatch == NULL)
						soap_blist_ProbeMatch = soap_new_block(soap);
					a->ProbeMatch = (struct d__ProbeMatchType *)soap_push_block(soap, soap_blist_ProbeMatch, sizeof(struct d__ProbeMatchType));
					if (a->ProbeMatch == NULL)
						return NULL;
					soap_default_d__ProbeMatchType(soap, a->ProbeMatch);
				}soap_revert(soap);
				if (soap_in_d__ProbeMatchType(soap, "d:ProbeMatch", a->ProbeMatch, "d:ProbeMatchType"))
				{	a->__sizeProbeMatch++;
					a->ProbeMatch = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			soap_check_result(soap, "-sizeProbeMatch");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->ProbeMatch)
			soap_pop_block(soap, soap_blist_ProbeMatch);
		if (a->__sizeProbeMatch)
			a->ProbeMatch = (struct d__ProbeMatchType *)soap_save_block(soap, soap_blist_ProbeMatch, NULL, 1);
		else
		{	a->ProbeMatch = NULL;
			if (soap_blist_ProbeMatch)
				soap_end_block(soap, soap_blist_ProbeMatch);
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ProbeMatchesType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ProbeMatchesType, 0, sizeof(struct d__ProbeMatchesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ProbeMatchesType(struct soap *soap, const struct d__ProbeMatchesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ProbeMatchesType);
	if (soap_out_d__ProbeMatchesType(soap, tag?tag:"d:ProbeMatchesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeMatchesType * SOAP_FMAC4 soap_get_d__ProbeMatchesType(struct soap *soap, struct d__ProbeMatchesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ProbeMatchesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ProbeType(struct soap *soap, struct d__ProbeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ProbeType(struct soap *soap, const struct d__ProbeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ProbeType(struct soap *soap, const char *tag, int id, const struct d__ProbeType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ProbeType), type))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ProbeType * SOAP_FMAC4 soap_in_d__ProbeType(struct soap *soap, const char *tag, struct d__ProbeType *a, const char *type)
{
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ProbeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ProbeType, sizeof(struct d__ProbeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ProbeType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ProbeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ProbeType, 0, sizeof(struct d__ProbeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ProbeType(struct soap *soap, const struct d__ProbeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ProbeType);
	if (soap_out_d__ProbeType(soap, tag?tag:"d:ProbeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeType * SOAP_FMAC4 soap_get_d__ProbeType(struct soap *soap, struct d__ProbeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ProbeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__ByeType(struct soap *soap, struct d__ByeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	soap_default_d__UriListType(soap, &a->XAddrs);
	a->MetadataVersion = NULL;
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__ByeType(struct soap *soap, const struct d__ByeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
	soap_serialize_d__UriListType(soap, &a->XAddrs);
	soap_serialize_PointerTounsignedInt(soap, &a->MetadataVersion);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__ByeType(struct soap *soap, const char *tag, int id, const struct d__ByeType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__ByeType), type))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (soap_out_d__UriListType(soap, "d:XAddrs", -1, &a->XAddrs, ""))
		return soap->error;
	if (soap_out_PointerTounsignedInt(soap, "d:MetadataVersion", -1, &a->MetadataVersion, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__ByeType * SOAP_FMAC4 soap_in_d__ByeType(struct soap *soap, const char *tag, struct d__ByeType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	size_t soap_flag_XAddrs = 1;
	size_t soap_flag_MetadataVersion = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__ByeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__ByeType, sizeof(struct d__ByeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__ByeType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__UriListType(soap, "d:XAddrs", &a->XAddrs, "d:UriListType"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedInt(soap, "d:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__ByeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__ByeType, 0, sizeof(struct d__ByeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__ByeType(struct soap *soap, const struct d__ByeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__ByeType);
	if (soap_out_d__ByeType(soap, tag?tag:"d:ByeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ByeType * SOAP_FMAC4 soap_get_d__ByeType(struct soap *soap, struct d__ByeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__ByeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_d__HelloType(struct soap *soap, struct d__HelloType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	soap_default_d__QNameListType(soap, &a->Types);
	a->Scopes = NULL;
	soap_default_d__UriListType(soap, &a->XAddrs);
	soap_default_unsignedInt(soap, &a->MetadataVersion);
	a->__size = 0;
	a->__any = NULL;
	a->__anyAttribute = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_d__HelloType(struct soap *soap, const struct d__HelloType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsa__EndpointReferenceType(soap, &a->wsa__EndpointReference);
	soap_serialize_d__QNameListType(soap, &a->Types);
	soap_serialize_PointerTod__ScopesType(soap, &a->Scopes);
	soap_serialize_d__UriListType(soap, &a->XAddrs);
	soap_embedded(soap, &a->MetadataVersion, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__HelloType(struct soap *soap, const char *tag, int id, const struct d__HelloType *a, const char *type)
{
	if (a->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", a->__anyAttribute);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_d__HelloType), type))
		return soap->error;
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, ""))
		return soap->error;
	if (soap_out_d__QNameListType(soap, "d:Types", -1, &a->Types, ""))
		return soap->error;
	if (soap_out_PointerTod__ScopesType(soap, "d:Scopes", -1, &a->Scopes, ""))
		return soap->error;
	if (soap_out_d__UriListType(soap, "d:XAddrs", -1, &a->XAddrs, ""))
		return soap->error;
	if (soap_out_unsignedInt(soap, "d:MetadataVersion", -1, &a->MetadataVersion, ""))
		return soap->error;
	if (a->__any)
	{	int i;
		for (i = 0; i < a->__size; i++)
			soap_outliteral(soap, "-any", a->__any + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct d__HelloType * SOAP_FMAC4 soap_in_d__HelloType(struct soap *soap, const char *tag, struct d__HelloType *a, const char *type)
{
	size_t soap_flag_wsa__EndpointReference = 1;
	size_t soap_flag_Types = 1;
	size_t soap_flag_Scopes = 1;
	size_t soap_flag_XAddrs = 1;
	size_t soap_flag_MetadataVersion = 1;
	struct soap_blist *soap_blist___any = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct d__HelloType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_d__HelloType, sizeof(struct d__HelloType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_d__HelloType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &a->__anyAttribute, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsa__EndpointReferenceType(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "wsa:EndpointReferenceType"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__QNameListType(soap, "d:Types", &a->Types, "d:QNameListType"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTod__ScopesType(soap, "d:Scopes", &a->Scopes, "d:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_d__UriListType(soap, "d:XAddrs", &a->XAddrs, "d:UriListType"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "d:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH && !soap_peek_element(soap))
			{	if (a->__any == NULL)
				{	if (soap_blist___any == NULL)
						soap_blist___any = soap_new_block(soap);
					a->__any = (char **)soap_push_block(soap, soap_blist___any, sizeof(char *));
					if (a->__any == NULL)
						return NULL;
					*a->__any = NULL;
				}
				if (soap_inliteral(soap, "-any", a->__any))
				{	a->__size++;
					a->__any = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->__any)
			soap_pop_block(soap, soap_blist___any);
		if (a->__size)
			a->__any = (char **)soap_save_block(soap, soap_blist___any, NULL, 1);
		else
		{	a->__any = NULL;
			if (soap_blist___any)
				soap_end_block(soap, soap_blist___any);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct d__HelloType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_d__HelloType, 0, sizeof(struct d__HelloType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0 || soap_flag_MetadataVersion > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__HelloType(struct soap *soap, const struct d__HelloType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__HelloType);
	if (soap_out_d__HelloType(soap, tag?tag:"d:HelloType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__HelloType * SOAP_FMAC4 soap_get_d__HelloType(struct soap *soap, struct d__HelloType *p, const char *tag, const char *type)
{
	if ((p = soap_in_d__HelloType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *a)
{
	(void)soap; /* appease -Wall -Werror */
	a->__size = 0;
	a->__ptr = NULL;
	a->id = NULL;
	a->type = NULL;
	a->options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary const*a)
{
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__base64Binary))
		if (a->id || a->type)
			soap->mode |= SOAP_ENC_DIME;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const struct xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_xsd__base64Binary);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
#endif
	if (id < 0)
		return soap->error;
	if (soap_element_begin_out(soap, tag, id, type))
		return soap->error;
	if (soap_putbase64(soap, a->__ptr, a->__size))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__base64Binary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__base64Binary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (struct xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(struct xsd__base64Binary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__base64Binary(struct soap *soap, const struct xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (soap_out_xsd__base64Binary(soap, tag?tag:"xsd:base64Binary", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa__FaultTo(struct soap *soap, struct wsa__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa__FaultTo))
		soap_serialize__wsa__FaultTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa__FaultTo(struct soap *soap, const char *tag, int id, struct wsa__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa__FaultTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa__FaultTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa__FaultTo(struct soap *soap, const char *tag, struct wsa__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa__FaultTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa__FaultTo, sizeof(struct wsa__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa__FaultTo(struct soap *soap, struct wsa__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa__FaultTo);
	if (soap_out_PointerTo_wsa__FaultTo(soap, tag?tag:"wsa:FaultTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa__FaultTo(struct soap *soap, struct wsa__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa__FaultTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa__ReplyTo(struct soap *soap, struct wsa__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa__ReplyTo))
		soap_serialize__wsa__ReplyTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa__ReplyTo(struct soap *soap, const char *tag, int id, struct wsa__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa__ReplyTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa__ReplyTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa__ReplyTo(struct soap *soap, const char *tag, struct wsa__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa__ReplyTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa__ReplyTo, sizeof(struct wsa__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa__ReplyTo(struct soap *soap, struct wsa__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa__ReplyTo);
	if (soap_out_PointerTo_wsa__ReplyTo(soap, tag?tag:"wsa:ReplyTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa__ReplyTo(struct soap *soap, struct wsa__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa__ReplyTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa__From(struct soap *soap, struct wsa__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa__From))
		soap_serialize__wsa__From(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa__From(struct soap *soap, const char *tag, int id, struct wsa__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa__From);
	if (id < 0)
		return soap->error;
	return soap_out__wsa__From(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTo_wsa__From(struct soap *soap, const char *tag, struct wsa__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa__From(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa__From, sizeof(struct wsa__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa__From(struct soap *soap, struct wsa__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa__From);
	if (soap_out_PointerTo_wsa__From(soap, tag?tag:"wsa:From", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTo_wsa__From(struct soap *soap, struct wsa__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa__From(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsa__RelatesTo(struct soap *soap, struct wsa__Relationship *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsa__RelatesTo))
		soap_serialize__wsa__RelatesTo(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsa__RelatesTo(struct soap *soap, const char *tag, int id, struct wsa__Relationship *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsa__RelatesTo);
	if (id < 0)
		return soap->error;
	return soap_out__wsa__RelatesTo(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__Relationship ** SOAP_FMAC4 soap_in_PointerTo_wsa__RelatesTo(struct soap *soap, const char *tag, struct wsa__Relationship **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__Relationship **)soap_malloc(soap, sizeof(struct wsa__Relationship *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsa__RelatesTo(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__Relationship **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsa__RelatesTo, sizeof(struct wsa__Relationship), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsa__RelatesTo(struct soap *soap, struct wsa__Relationship *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsa__RelatesTo);
	if (soap_out_PointerTo_wsa__RelatesTo(soap, tag?tag:"wsa:RelatesTo", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__Relationship ** SOAP_FMAC4 soap_get_PointerTo_wsa__RelatesTo(struct soap *soap, struct wsa__Relationship **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsa__RelatesTo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ProbeMatchesType(struct soap *soap, struct d__ProbeMatchesType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ProbeMatchesType))
		soap_serialize_d__ProbeMatchesType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ProbeMatchesType(struct soap *soap, const char *tag, int id, struct d__ProbeMatchesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ProbeMatchesType);
	if (id < 0)
		return soap->error;
	return soap_out_d__ProbeMatchesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ProbeMatchesType ** SOAP_FMAC4 soap_in_PointerTod__ProbeMatchesType(struct soap *soap, const char *tag, struct d__ProbeMatchesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ProbeMatchesType **)soap_malloc(soap, sizeof(struct d__ProbeMatchesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ProbeMatchesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ProbeMatchesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ProbeMatchesType, sizeof(struct d__ProbeMatchesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ProbeMatchesType(struct soap *soap, struct d__ProbeMatchesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ProbeMatchesType);
	if (soap_out_PointerTod__ProbeMatchesType(soap, tag?tag:"d:ProbeMatchesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeMatchesType ** SOAP_FMAC4 soap_get_PointerTod__ProbeMatchesType(struct soap *soap, struct d__ProbeMatchesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ProbeMatchesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ProbeType(struct soap *soap, struct d__ProbeType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ProbeType))
		soap_serialize_d__ProbeType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ProbeType(struct soap *soap, const char *tag, int id, struct d__ProbeType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ProbeType);
	if (id < 0)
		return soap->error;
	return soap_out_d__ProbeType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ProbeType ** SOAP_FMAC4 soap_in_PointerTod__ProbeType(struct soap *soap, const char *tag, struct d__ProbeType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ProbeType **)soap_malloc(soap, sizeof(struct d__ProbeType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ProbeType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ProbeType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ProbeType, sizeof(struct d__ProbeType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ProbeType(struct soap *soap, struct d__ProbeType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ProbeType);
	if (soap_out_PointerTod__ProbeType(soap, tag?tag:"d:ProbeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeType ** SOAP_FMAC4 soap_get_PointerTod__ProbeType(struct soap *soap, struct d__ProbeType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ProbeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ByeType(struct soap *soap, struct d__ByeType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ByeType))
		soap_serialize_d__ByeType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ByeType(struct soap *soap, const char *tag, int id, struct d__ByeType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ByeType);
	if (id < 0)
		return soap->error;
	return soap_out_d__ByeType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ByeType ** SOAP_FMAC4 soap_in_PointerTod__ByeType(struct soap *soap, const char *tag, struct d__ByeType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ByeType **)soap_malloc(soap, sizeof(struct d__ByeType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ByeType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ByeType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ByeType, sizeof(struct d__ByeType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ByeType(struct soap *soap, struct d__ByeType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ByeType);
	if (soap_out_PointerTod__ByeType(soap, tag?tag:"d:ByeType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ByeType ** SOAP_FMAC4 soap_get_PointerTod__ByeType(struct soap *soap, struct d__ByeType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ByeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ResolveType(struct soap *soap, struct d__ResolveType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ResolveType))
		soap_serialize_d__ResolveType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ResolveType(struct soap *soap, const char *tag, int id, struct d__ResolveType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ResolveType);
	if (id < 0)
		return soap->error;
	return soap_out_d__ResolveType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ResolveType ** SOAP_FMAC4 soap_in_PointerTod__ResolveType(struct soap *soap, const char *tag, struct d__ResolveType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ResolveType **)soap_malloc(soap, sizeof(struct d__ResolveType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ResolveType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ResolveType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ResolveType, sizeof(struct d__ResolveType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ResolveType(struct soap *soap, struct d__ResolveType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ResolveType);
	if (soap_out_PointerTod__ResolveType(soap, tag?tag:"d:ResolveType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ResolveType ** SOAP_FMAC4 soap_get_PointerTod__ResolveType(struct soap *soap, struct d__ResolveType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ResolveType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__HelloType(struct soap *soap, struct d__HelloType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__HelloType))
		soap_serialize_d__HelloType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__HelloType(struct soap *soap, const char *tag, int id, struct d__HelloType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__HelloType);
	if (id < 0)
		return soap->error;
	return soap_out_d__HelloType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__HelloType ** SOAP_FMAC4 soap_in_PointerTod__HelloType(struct soap *soap, const char *tag, struct d__HelloType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__HelloType **)soap_malloc(soap, sizeof(struct d__HelloType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__HelloType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__HelloType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__HelloType, sizeof(struct d__HelloType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__HelloType(struct soap *soap, struct d__HelloType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__HelloType);
	if (soap_out_PointerTod__HelloType(soap, tag?tag:"d:HelloType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__HelloType ** SOAP_FMAC4 soap_get_PointerTod__HelloType(struct soap *soap, struct d__HelloType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__HelloType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa__ServiceNameType(struct soap *soap, struct wsa__ServiceNameType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa__ServiceNameType))
		soap_serialize_wsa__ServiceNameType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa__ServiceNameType(struct soap *soap, const char *tag, int id, struct wsa__ServiceNameType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa__ServiceNameType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa__ServiceNameType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__ServiceNameType ** SOAP_FMAC4 soap_in_PointerTowsa__ServiceNameType(struct soap *soap, const char *tag, struct wsa__ServiceNameType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__ServiceNameType **)soap_malloc(soap, sizeof(struct wsa__ServiceNameType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa__ServiceNameType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__ServiceNameType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa__ServiceNameType, sizeof(struct wsa__ServiceNameType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa__ServiceNameType(struct soap *soap, struct wsa__ServiceNameType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa__ServiceNameType);
	if (soap_out_PointerTowsa__ServiceNameType(soap, tag?tag:"wsa:ServiceNameType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ServiceNameType ** SOAP_FMAC4 soap_get_PointerTowsa__ServiceNameType(struct soap *soap, struct wsa__ServiceNameType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa__ServiceNameType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa__AttributedQName(struct soap *soap, struct wsa__AttributedQName *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa__AttributedQName))
		soap_serialize_wsa__AttributedQName(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa__AttributedQName(struct soap *soap, const char *tag, int id, struct wsa__AttributedQName *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa__AttributedQName);
	if (id < 0)
		return soap->error;
	return soap_out_wsa__AttributedQName(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__AttributedQName ** SOAP_FMAC4 soap_in_PointerTowsa__AttributedQName(struct soap *soap, const char *tag, struct wsa__AttributedQName **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__AttributedQName **)soap_malloc(soap, sizeof(struct wsa__AttributedQName *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa__AttributedQName(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__AttributedQName **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa__AttributedQName, sizeof(struct wsa__AttributedQName), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa__AttributedQName(struct soap *soap, struct wsa__AttributedQName *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa__AttributedQName);
	if (soap_out_PointerTowsa__AttributedQName(soap, tag?tag:"wsa:AttributedQName", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__AttributedQName ** SOAP_FMAC4 soap_get_PointerTowsa__AttributedQName(struct soap *soap, struct wsa__AttributedQName **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa__AttributedQName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa__ReferenceParametersType(struct soap *soap, struct wsa__ReferenceParametersType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa__ReferenceParametersType))
		soap_serialize_wsa__ReferenceParametersType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa__ReferenceParametersType(struct soap *soap, const char *tag, int id, struct wsa__ReferenceParametersType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa__ReferenceParametersType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa__ReferenceParametersType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__ReferenceParametersType ** SOAP_FMAC4 soap_in_PointerTowsa__ReferenceParametersType(struct soap *soap, const char *tag, struct wsa__ReferenceParametersType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__ReferenceParametersType **)soap_malloc(soap, sizeof(struct wsa__ReferenceParametersType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa__ReferenceParametersType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__ReferenceParametersType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa__ReferenceParametersType, sizeof(struct wsa__ReferenceParametersType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa__ReferenceParametersType(struct soap *soap, struct wsa__ReferenceParametersType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa__ReferenceParametersType);
	if (soap_out_PointerTowsa__ReferenceParametersType(soap, tag?tag:"wsa:ReferenceParametersType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ReferenceParametersType ** SOAP_FMAC4 soap_get_PointerTowsa__ReferenceParametersType(struct soap *soap, struct wsa__ReferenceParametersType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa__ReferenceParametersType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa__ReferencePropertiesType(struct soap *soap, struct wsa__ReferencePropertiesType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa__ReferencePropertiesType))
		soap_serialize_wsa__ReferencePropertiesType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa__ReferencePropertiesType(struct soap *soap, const char *tag, int id, struct wsa__ReferencePropertiesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa__ReferencePropertiesType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa__ReferencePropertiesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__ReferencePropertiesType ** SOAP_FMAC4 soap_in_PointerTowsa__ReferencePropertiesType(struct soap *soap, const char *tag, struct wsa__ReferencePropertiesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__ReferencePropertiesType **)soap_malloc(soap, sizeof(struct wsa__ReferencePropertiesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa__ReferencePropertiesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__ReferencePropertiesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa__ReferencePropertiesType, sizeof(struct wsa__ReferencePropertiesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa__ReferencePropertiesType(struct soap *soap, struct wsa__ReferencePropertiesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa__ReferencePropertiesType);
	if (soap_out_PointerTowsa__ReferencePropertiesType(soap, tag?tag:"wsa:ReferencePropertiesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__ReferencePropertiesType ** SOAP_FMAC4 soap_get_PointerTowsa__ReferencePropertiesType(struct soap *soap, struct wsa__ReferencePropertiesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa__ReferencePropertiesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa__AttributedURI(struct soap *soap, struct wsa__AttributedURI *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa__AttributedURI))
		soap_serialize_wsa__AttributedURI(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa__AttributedURI(struct soap *soap, const char *tag, int id, struct wsa__AttributedURI *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa__AttributedURI);
	if (id < 0)
		return soap->error;
	return soap_out_wsa__AttributedURI(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__AttributedURI ** SOAP_FMAC4 soap_in_PointerTowsa__AttributedURI(struct soap *soap, const char *tag, struct wsa__AttributedURI **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__AttributedURI **)soap_malloc(soap, sizeof(struct wsa__AttributedURI *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa__AttributedURI(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__AttributedURI **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa__AttributedURI, sizeof(struct wsa__AttributedURI), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa__AttributedURI(struct soap *soap, struct wsa__AttributedURI *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa__AttributedURI);
	if (soap_out_PointerTowsa__AttributedURI(soap, tag?tag:"wsa:AttributedURI", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__AttributedURI ** SOAP_FMAC4 soap_get_PointerTowsa__AttributedURI(struct soap *soap, struct wsa__AttributedURI **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa__AttributedURI(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a)
{
	if (*a)
		soap_serialize_xsd__base64Binary(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__base64Binary(struct soap *soap, const char *tag, int id, struct xsd__base64Binary *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__base64Binary(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_in_PointerToxsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xsd__base64Binary **)soap_malloc(soap, sizeof(struct xsd__base64Binary *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__base64Binary(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xsd__base64Binary **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__base64Binary);
	if (soap_out_PointerToxsd__base64Binary(soap, tag?tag:"xsd:base64Binary", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_get_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__SigType(struct soap *soap, struct d__SigType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__SigType))
		soap_serialize_d__SigType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__SigType(struct soap *soap, const char *tag, int id, struct d__SigType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__SigType);
	if (id < 0)
		return soap->error;
	return soap_out_d__SigType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__SigType ** SOAP_FMAC4 soap_in_PointerTod__SigType(struct soap *soap, const char *tag, struct d__SigType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__SigType **)soap_malloc(soap, sizeof(struct d__SigType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__SigType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__SigType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__SigType, sizeof(struct d__SigType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__SigType(struct soap *soap, struct d__SigType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__SigType);
	if (soap_out_PointerTod__SigType(soap, tag?tag:"d:SigType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__SigType ** SOAP_FMAC4 soap_get_PointerTod__SigType(struct soap *soap, struct d__SigType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__SigType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ResolveMatchType(struct soap *soap, struct d__ResolveMatchType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ResolveMatchType))
		soap_serialize_d__ResolveMatchType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ResolveMatchType(struct soap *soap, const char *tag, int id, struct d__ResolveMatchType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ResolveMatchType);
	if (id < 0)
		return soap->error;
	return soap_out_d__ResolveMatchType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ResolveMatchType ** SOAP_FMAC4 soap_in_PointerTod__ResolveMatchType(struct soap *soap, const char *tag, struct d__ResolveMatchType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ResolveMatchType **)soap_malloc(soap, sizeof(struct d__ResolveMatchType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ResolveMatchType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ResolveMatchType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ResolveMatchType, sizeof(struct d__ResolveMatchType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ResolveMatchType(struct soap *soap, struct d__ResolveMatchType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ResolveMatchType);
	if (soap_out_PointerTod__ResolveMatchType(soap, tag?tag:"d:ResolveMatchType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ResolveMatchType ** SOAP_FMAC4 soap_get_PointerTod__ResolveMatchType(struct soap *soap, struct d__ResolveMatchType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ResolveMatchType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ProbeMatchType(struct soap *soap, struct d__ProbeMatchType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ProbeMatchType))
		soap_serialize_d__ProbeMatchType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ProbeMatchType(struct soap *soap, const char *tag, int id, struct d__ProbeMatchType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ProbeMatchType);
	if (id < 0)
		return soap->error;
	return soap_out_d__ProbeMatchType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ProbeMatchType ** SOAP_FMAC4 soap_in_PointerTod__ProbeMatchType(struct soap *soap, const char *tag, struct d__ProbeMatchType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ProbeMatchType **)soap_malloc(soap, sizeof(struct d__ProbeMatchType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ProbeMatchType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ProbeMatchType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ProbeMatchType, sizeof(struct d__ProbeMatchType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ProbeMatchType(struct soap *soap, struct d__ProbeMatchType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ProbeMatchType);
	if (soap_out_PointerTod__ProbeMatchType(soap, tag?tag:"d:ProbeMatchType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ProbeMatchType ** SOAP_FMAC4 soap_get_PointerTod__ProbeMatchType(struct soap *soap, struct d__ProbeMatchType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ProbeMatchType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedInt(struct soap *soap, unsigned int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedInt(struct soap *soap, const char *tag, int id, unsigned int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedInt);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedInt(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_in_PointerTounsignedInt(struct soap *soap, const char *tag, unsigned int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned int **)soap_malloc(soap, sizeof(unsigned int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedInt(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedInt, sizeof(unsigned int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedInt(struct soap *soap, unsigned int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedInt);
	if (soap_out_PointerTounsignedInt(soap, tag?tag:"unsignedInt", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_get_PointerTounsignedInt(struct soap *soap, unsigned int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTod__ScopesType(struct soap *soap, struct d__ScopesType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_d__ScopesType))
		soap_serialize_d__ScopesType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTod__ScopesType(struct soap *soap, const char *tag, int id, struct d__ScopesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_d__ScopesType);
	if (id < 0)
		return soap->error;
	return soap_out_d__ScopesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct d__ScopesType ** SOAP_FMAC4 soap_in_PointerTod__ScopesType(struct soap *soap, const char *tag, struct d__ScopesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct d__ScopesType **)soap_malloc(soap, sizeof(struct d__ScopesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_d__ScopesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct d__ScopesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_d__ScopesType, sizeof(struct d__ScopesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTod__ScopesType(struct soap *soap, struct d__ScopesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTod__ScopesType);
	if (soap_out_PointerTod__ScopesType(soap, tag?tag:"d:ScopesType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct d__ScopesType ** SOAP_FMAC4 soap_get_PointerTod__ScopesType(struct soap *soap, struct d__ScopesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTod__ScopesType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsa__EndpointReferenceType(struct soap *soap, struct wsa__EndpointReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsa__EndpointReferenceType))
		soap_serialize_wsa__EndpointReferenceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsa__EndpointReferenceType(struct soap *soap, const char *tag, int id, struct wsa__EndpointReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsa__EndpointReferenceType);
	if (id < 0)
		return soap->error;
	return soap_out_wsa__EndpointReferenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_in_PointerTowsa__EndpointReferenceType(struct soap *soap, const char *tag, struct wsa__EndpointReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct wsa__EndpointReferenceType **)soap_malloc(soap, sizeof(struct wsa__EndpointReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsa__EndpointReferenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa__EndpointReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsa__EndpointReferenceType, sizeof(struct wsa__EndpointReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsa__EndpointReferenceType(struct soap *soap, struct wsa__EndpointReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsa__EndpointReferenceType);
	if (soap_out_PointerTowsa__EndpointReferenceType(soap, tag?tag:"wsa:EndpointReferenceType", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa__EndpointReferenceType ** SOAP_FMAC4 soap_get_PointerTowsa__EndpointReferenceType(struct soap *soap, struct wsa__EndpointReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsa__EndpointReferenceType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__FaultCodeOpenType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_d__FaultCodeOpenType);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_d__FaultCodeOpenType(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_d__FaultCodeOpenType, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__FaultCodeOpenType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__FaultCodeOpenType);
	if (soap_out_d__FaultCodeOpenType(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_d__FaultCodeOpenType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_d__FaultCodeOpenType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__UriListType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_d__UriListType);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_d__UriListType(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_d__UriListType, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__UriListType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__UriListType);
	if (soap_out_d__UriListType(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_d__UriListType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_d__UriListType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__QNameListType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_d__QNameListType);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_d__QNameListType(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_d__QNameListType, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__QNameListType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__QNameListType);
	if (soap_out_d__QNameListType(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_d__QNameListType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_d__QNameListType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_d__OpenRelationshipType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_d__OpenRelationshipType);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_d__OpenRelationshipType(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_d__OpenRelationshipType, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_d__OpenRelationshipType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_d__OpenRelationshipType);
	if (soap_out_d__OpenRelationshipType(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_d__OpenRelationshipType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_d__OpenRelationshipType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__nonNegativeInteger(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__nonNegativeInteger);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__nonNegativeInteger(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__nonNegativeInteger, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__nonNegativeInteger(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__nonNegativeInteger);
	if (soap_out_xsd__nonNegativeInteger(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__nonNegativeInteger(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__nonNegativeInteger(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag?tag:"unsignedByte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__NCName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__NCName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__NCName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__NCName, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__NCName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__NCName);
	if (soap_out_xsd__NCName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__NCName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__NCName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__IDREFS(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__IDREFS);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__IDREFS(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__IDREFS, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__IDREFS(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__IDREFS);
	if (soap_out_xsd__IDREFS(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__IDREFS(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__IDREFS(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__ID(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__ID);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__ID(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__ID, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__ID(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__ID);
	if (soap_out_xsd__ID(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__ID(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__ID(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifdef __cplusplus
}
#endif

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.c */
