/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#ifndef ACTI_EXTRA_MEMPOOL_H
#define ACTI_EXTRA_MEMPOOL_H


#include <linux/list.h>


struct mem_pool
{
	unsigned int verbose;

	struct {
		unsigned char* top;
		unsigned int   reserve;
	} priv;

	unsigned char* base;
	unsigned int   maximumBytes;
	unsigned int   remainingBytes;

	struct list_head allocated_blocks;
	struct list_head free_blocks;

	int (*new_heap)(struct mem_pool* mp, unsigned int size, void** heap);
	int (*free_heap)(struct mem_pool* mp, void* heap);
};

struct mem_block
{
	struct list_head list;

	unsigned int id;
	unsigned int size;
	void*        heap;

	unsigned int reserved;
};


int  mempool_initialize(struct mem_pool* mp,
						unsigned char* start, unsigned int size,
						unsigned int verbose);
void mempool_destroy(struct mem_pool* mp);


#endif /* ACTI_EXTRA_MEMPOOL_H */
