/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#ifndef ACTI_EXTRA_LOGGY_H
#define ACTI_EXTRA_LOGGY_H


enum
{
	LOGGY_LEVEL_DEBUG   = 0,
	LOGGY_LEVEL_TRACE   = 1,
	LOGGY_LEVEL_INFO    = 2,
	LOGGY_LEVEL_WARNING = 3,
	LOGGY_LEVEL_ERROR   = 4,
};

enum
{
	VERBOSE_LEVEL_NONE    = 0,
	VERBOSE_LEVEL_DEBUG   = 1,
	VERBOSE_LEVEL_TRACE   = 2,
	VERBOSE_LEVEL_INFO    = 3,
	VERBOSE_LEVEL_WARNING = 4,
	VERBOSE_LEVEL_ERROR   = 5,
};


extern int printf(const char *fmt, ...);


#define LOGGY_ERROR(verbose, fmt, args...) \
	do {\
		if (verbose > LOGGY_LEVEL_ERROR) {\
			printf(fmt, ##args);\
		}\
	} while (0)
#define LOGGY_WARNING(verbose, fmt, args...) \
	do {\
		if (verbose > LOGGY_LEVEL_WARNING) {\
			printf(fmt, ##args);\
		}\
	} while (0)
#define LOGGY_INFO(verbose, fmt, args...) \
	do {\
		if (verbose > LOGGY_LEVEL_INFO) {\
			printf(fmt, ##args);\
		}\
	} while (0)
#define LOGGY_TRACE(verbose, fmt, args...) \
	do {\
		if (verbose > LOGGY_LEVEL_TRACE) {\
			printf(fmt, ##args);\
		}\
	} while (0)
#define LOGGY_DEBUG(verbose, fmt, args...) \
	do {\
		if (verbose > LOGGY_LEVEL_DEBUG) {\
			printf(fmt, ##args);\
		}\
	} while (0)


#endif /* ACTI_EXTRA_LOGGY_H */
