/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#ifndef _H264_CODER_CTX_H_
#define _H264_CODER_CTX_H_


#include <ewl.h>
#include <h264encapi.h>


struct h264_coder_opts
{
	//char input[256];
	//char output[256];

	//int lastPic;
	int inputWidth;  // Width of input video
	int inputHeight; // Height of input video
	int outputWidth;  // Width of output video
	int outputHeight; // Height of output video
	int xOffset;
	int yOffset;
	int inputRateNumer;
	int inputRateDenom;
	int level;
	int hrdConformance;
	int cpbSize;
	int intraPicRate;
	int constIntraPred;
	int disableDeblocking;
	int mbPerSlice;
	int qpHdr;
	int qpMin;
	int qpMax;
	int bitPerSecond;
	int picRc;
	int mbRc;
	int picSkip;
	int rotation;
	int inputFormat;
	int chromaQpOffset;
	int trans8x8;
	int enableCabac;
	int cabacInitIdc;
	int quarterPixelMv;
	int sei;
	int byteStream;
	int videoStab;
	int intraQpDelta;
	int fixedIntraQp;
	int mbQpAdjustment;
	int mvOutput;

	unsigned int* intraPrevFavor;
	unsigned int* intra16Favor;
	unsigned int* interFavor;
	unsigned int* skipSadPenalty;
	unsigned int* diffMvPenalty;
	unsigned int* diffMvPenalty4p;

	int attachParameterSet;
};

enum {
	H264_CODER_DEFAULT = -100,
	H264_CODER_MAX_GOP_LEN = 150,
	H264_MOVING_AVG_FRAMES = 30,
};

struct h264_ma {
	i32 frame[H264_MOVING_AVG_FRAMES];
	i32 length;
	i32 count;
	i32 pos;
	i32 frameRateNumer;
	i32 frameRateDenom;
};

struct h264_coder
{
	//void* logger;
	unsigned int logger;
	struct h264_coder_opts* options;

	H264EncInst     encoder;
	H264EncIn       encInput;
	H264EncOut      encOutput;
	H264EncRateCtrl rateCtrl;

	struct h264_ma ma;

	int frameSize;
	EWLLinearMem_t outputMem;
	EWLLinearMem_t pictureMem;
	EWLLinearMem_t pictureStabMem;
};


void h264_coder_opts_copy_default(struct h264_coder_opts* opts);

//void h264_coder_initialize(struct h264_coder* coder,
//						   struct h264_coder_opts* opts);
int h264_coder_open(struct h264_coder* coder, struct h264_coder_opts* opts);
int h264_coder_start(struct h264_coder* coder);
int h264_coder_compress(struct h264_coder* coder, int target, int* actual);
int h264_coder_stop(struct h264_coder* coder);
int h264_coder_close(struct h264_coder* coder);

int  h264_coder_verify_options(struct h264_coder_opts* opts);

//struct h264_coder* h264_coders_create(int count,
//									  struct h264_coder_opts* options);
//void h264_coders_destroy(int count, struct h264_coder* coders);

void h264_ma_add_frame(struct h264_ma* ma, int frameSizeBits);
int  h264_ma_calculate(struct h264_ma* ma);

void h264_coder_swap_linear_mem(EWLLinearMem_t* m1, EWLLinearMem_t* m2);

const char* h264_coder_err_to_str(int val);


#endif /* _H264_CODER_CTX_H_ */
