#include "sys.h"

bool_T sysStrToN(char *szStr, unsigned int *nVal)
{
	/* 
		Convert a string (szStr) to a positive natural number.
		The string might be of hex-decimal or decimal.
	*/

	int nIdx;

	if (szStr[0] == '0' && (szStr[1] == 'X' || szStr[1] == 'x'))
	{
		/* hexdecimal */

		if (szStr[2] == '\0')
			return (FALSE);

		*nVal = 0;
		for (nIdx = 2; szStr[nIdx]; ++nIdx)
		{
			if (szStr[nIdx] == '_')
				continue;

			*nVal <<= 4;

			switch (szStr[nIdx])
			{
			case '0':
				break;

			case '1':
				*nVal += 1;
				break;

			case '2':
				*nVal += 2;
				break;

			case '3':
				*nVal += 3;
				break;

			case '4':
				*nVal += 4;
				break;

			case '5':
				*nVal += 5;
				break;

			case '6':
				*nVal += 6;
				break;

			case '7':
				*nVal += 7;
				break;

			case '8':
				*nVal += 8;
				break;

			case '9':
				*nVal += 9;
				break;

			case 'a':
			case 'A':
				*nVal += 0xA;
				break;

			case 'b':
			case 'B':
				*nVal += 0xB;
				break;

			case 'c':
			case 'C':
				*nVal += 0xC;
				break;

			case 'd':
			case 'D':
				*nVal += 0xD;
				break;

			case 'e':
			case 'E':
				*nVal += 0xE;
				break;

			case 'f':
			case 'F':
				*nVal += 0xF;
				break;

			default:
				return (FALSE);
			}
		}

		return (TRUE);
	}
	else if (szStr[0] >= '0' && szStr[0] <= '9')
	{
		/* decimal */

		*nVal = 0;
		for (nIdx = 0; szStr[nIdx]; ++nIdx)
		{
			if (szStr[nIdx] == '_')
				continue;

			*nVal *= 10;

			switch (szStr[nIdx])
			{
			case '0':
				break;

			case '1':
				*nVal += 1;
				break;

			case '2':
				*nVal += 2;
				break;

			case '3':
				*nVal += 3;
				break;

			case '4':
				*nVal += 4;
				break;

			case '5':
				*nVal += 5;
				break;

			case '6':
				*nVal += 6;
				break;

			case '7':
				*nVal += 7;
				break;

			case '8':
				*nVal += 8;
				break;

			case '9':
				*nVal += 9;
				break;

			default:
				return (FALSE);
			}
		}

		return (TRUE);
	}
	else
	{
		return (FALSE);
	}
}

