#ifndef _sys_h__
#define _sys_h__

/* C/C++ compilier */
#ifdef __cplusplus
#define EXTERN_C_BEGIN	extern "C" {
#define EXTERN_C_END	}
#else
#define EXTERN_C_BEGIN	
#define EXTERN_C_END	
#endif


EXTERN_C_BEGIN

/* target machine */
#if defined (__arm) || defined (__GNUC__)
	#define		PORT_ARM	1
	#define		PORT_WIN	0
#elif defined (_WIN32)
	#define		PORT_ARM	0
	#define		PORT_WIN	1
#else
	#error ERROR: Support WIN32 and ARM target only.
	#define		PORT_ARM	0
	#define		PORT_WIN	0
#endif



/* * * * * * * * * * * * * * *
 * compiler dependent
 * * * * * * * * * * * * * * */

/* INLINE */
#if defined (__arm)
	#define INLINE 
#elif defined (__GNUC__)
	#define INLINE inline
#endif

/* PACKED_STRUCT */
#if defined(__arm) 
	#define PACKED_STRUCT __packed struct
#elif defined(__GNUC__) 
	#define PACKED_STRUCT struct __attribute__ ((packed))
#endif

#ifndef USER_TYPE
typedef unsigned char Byte;
typedef unsigned char bool_T;
#define USER_TYPE
#endif


#ifdef TRUE
#undef TRUE
#endif

#ifdef FALSE
#undef FALSE
#endif

#define TRUE		'\001'
#define FALSE		'\000'

#define NULL_STR ((char *) 0)

#define SYS_MAX_PATH_LEN 256

typedef void * (*sysMallocTrap_FT)(int);
typedef void   (*sysFreeTrap_FT)(void *);
typedef void   (*sysSleepTrap_FT)(unsigned int);


#if defined(MAK_ASSERTION)
	#include "assert.h"
	#define sysDAssert(expression) (assert(expression))
#else
	#define sysDAssert(expression) ((void) 0)
#endif


//modified by TED for Uboot
//bool_T sysInitInMain(void);
bool_T sysInitInMain(sysMallocTrap_FT m_ft, sysFreeTrap_FT f_ft);

bool_T sysIsLittleEndian(void);

void sysCurrentTime(int *year, int *month, int *day,
					int *hour, int *minute, int *second);

void sysSleepms(unsigned int msec);
void sysSleepus(unsigned int usec);
void sysSetSleepCB(sysSleepTrap_FT, sysSleepTrap_FT);

void sysASCIIToUpper(char *szString);
int sysStrCaseCmp(char *szStr1, char *szStr2);
int sysStrNCaseCmp(char *szStr1, char *szStr2, int nLen);

void * sysMalloc(int nSize);
void sysFree(void *memBlock);
void sysSetMMCB(sysMallocTrap_FT, sysFreeTrap_FT);

void * sysMemSet(void *buf, char fill, unsigned int nSize);
void * sysMemCpy(void *target, const void *source, unsigned int nSize);


/* sysUtil.c */
bool_T sysStrToN(char *szStr, unsigned int *nVal);

EXTERN_C_END


#endif

