#ifndef _sdcard_h_
#define _sdcard_h_


#define CUSTCOM_COMMAND_MSK	0x00000fff
#define CUSTOM_BLKSIZE_MSK	0x000ff000
#define CUSTOM_BLKSIZE_SHIFT	12
#define CUSTOM_BLKSIZE(x)	(((x&CUSTOM_BLKSIZE_MSK))>>CUSTOM_BLKSIZE_SHIFT)


/**************************************************/
/* Standard MMC commands (3.1)           type  argument     response */
/* class 1 */
#define CMD0    0   /* MMC_GO_IDLE_STATE        bc                    */
#define CMD1    1   /* MMC_SEND_OP_COND         bcr  [31:0]  OCR  R3  */
#define CMD2    2   /* MMC_ALL_SEND_CID         bcr               R2  */
#define CMD3    3   /* MMC_SET_RELATIVE_ADDR    ac   [31:16] RCA  R1  */
#define CMD4    4   /* MMC_SET_DSR              bc   [31:16] RCA      */
#define CMD5    5   /* SDIO_SEND_OCR            ??   ??               */
#define CMD6    6   /* HSMMC_SWITCH             ac                R1  */
                    /* For ACMD6:SET_BUS_WIDTH  ??   ??               */
#define CMD7    7   /* MMC_SELECT_CARD          ac   [31:16] RCA  R1  */
#define CMD8    8   /* HSMMC_SEND_EXT_CSD       adtc [31:16] RCA  R1  */
#define CMD9    9   /* MMC_SEND_CSD             ac   [31:16] RCA  R2  */
#define CMD10   10  /* MMC_SEND_CID             ac   [31:16] RCA  R2  */
#define CMD11   11  /* MMC_READ_DAT_UNTIL_STOP  adtc [31:0]  dadr R1  */
#define CMD12   12  /* MMC_STOP_TRANSMISSION    ac                R1b */
#define CMD13 	13  /* MMC_SEND_STATUS          ac   [31:16] RCA  R1  */
#define CMD14   14  /* HSMMC_BUS_TESTING        adtc [31:16] stuff R1 */
#define CMD15   15  /* MMC_GO_INACTIVE_STATE    ac   [31:16] RCA  */
#define CMD19   19  /* HSMMC_BUS_TESTING        adtc [31:16] stuff R1 */
/* class 2 */
#define CMD16   16  /* MMC_SET_BLOCKLEN         ac   [31:0] blkln R1  */
#define CMD17   17  /* MMC_READ_SINGLE_BLOCK    adtc [31:0] dtadd R1  */
#define CMD18   18  /* MMC_READ_MULTIPLE_BLOCK  adtc [31:0] dtadd R1  */

/* class 3 */
#define CMD20   20  /* MMC_WRITE_DAT_UNTIL_STOP adtc [31:0] dtadd R1  */

/* class 4 */
#define CMD23   23  /* MMC_SET_BLOCK_COUNT      adtc [31:0] dtadd R1  */
#define CMD24   24  /* MMC_WRITE_BLOCK          adtc [31:0] dtadd R1  */
#define CMD25   25  /* MMC_WRITE_MULTIPLE_BLOCK adtc              R1  */
#define CMD26   26  /* MMC_PROGRAM_CID          adtc              R1  */
#define CMD27   27  /* MMC_PROGRAM_CSD          adtc              R1  */

/* class 6 */
#define CMD28   28  /* MMC_SET_WRITE_PROT       ac   [31:0] dtadd R1b */
#define CMD29   29  /* _CLR_WRITE_PROT          ac   [31:0] dtadd R1b */
#define CMD30   30  /* MMC_SEND_WRITE_PROT      adtc [31:0] wpdtaddr R1  */

/* class 5 */
#define CMD32   32  /* SD_ERASE_GROUP_START    ac   [31:0] dtadd  R1  */
#define CMD33   33  /* SD_ERASE_GROUP_END      ac   [31:0] dtaddr R1  */

#define CMD35   35  /* MMC_ERASE_GROUP_START    ac   [31:0] dtadd  R1  */
#define CMD36   36  /* MMC_ERASE_GROUP_END      ac   [31:0] dtaddr R1  */
#define CMD38   38  /* MMC_ERASE                ac                 R1b */

/* class 9 */
#define CMD39   39  /* MMC_FAST_IO              ac   <Complex>     R4  */
#define CMD40   40  /* MMC_GO_IRQ_STATE         bcr                R5  */

/* class 7 */
#define CMD42   42  /* MMC_LOCK_UNLOCK          adtc               R1b */


#define CMD52   52  /* SDIO_RW_DIRECT           ??                 R5  */
#define CMD53   53  /* SDIO_RW_EXTENDED         ??                 R5  */

/* class 8 */
#define CMD55   55  /* MMC_APP_CMD              ac   [31:16] RCA   R1  */
#define CMD56   56  /* MMC_GEN_CMD              adtc [0] RD/WR     R1b */

// For CE-ATA Drive
#define CMD60	60
#define CMD61	61

#define SDIO_RESET  100  //To differentiate CMD52 for IORESET and other rd/wrs.
#define SDIO_ABORT  101  //To differentiate CMD52 for IO ABORT and other rd/wrs.

// Bob, For geneirc MMC interface
#define CMD41   41  /* MMC_LOCK_UNLOCK          adtc               R1b */
//End of Bob

#define UNADD_OFFSET	200
#define UNADD_CMD7	    207
#define WCMC52		    252
#define WCMD53		    253
#define WCMD60		    260
#define WCMD61		    261
#define SD_CMD8		    208  /*This is added to support SD 2.0 (SDHC) cards*/
#define SD_CMD11     	211  /*This is added to support SDXC Voltage Switching*/

#define APP_CMD_OFFSET			8000
#define ACMD6		   		(6 + APP_CMD_OFFSET)
#define ACMD13 					(13 + APP_CMD_OFFSET) 	/* SD_STATUS                ac   [31:2] Stuff, [1:0]Buswidth  R1*/
#define ACMD23					(23 + APP_CMD_OFFSET)
#define ACMD41  				(41 + APP_CMD_OFFSET) 	/* SD_SEND_OP_COND          ??                 R1  */
#define ACMD51  				(51 + APP_CMD_OFFSET) 	/* SEND_SCR                 adtc               R1  */

/**************************************/
#define CARD_IO			0
#define CARD_IOMEM		1
#define CARD_SD 		2
#define CARD_SDHC		3
#define CARD_MMC 		4
#define CARD_MMC42 		5
#define CARD_NOCARD		0xf


#define SET_RCA(x,y)	        ((x)|=(y<<16))



/* Operation Conditions Register (OCR) Register Definition */
#define OCR_POWER_UP_STATUS	           	0x80000000
#define OCR_ACCESSMODE_SECTOR          		0x40000000	/*This is to indicate the secor addressing for MMC4.2 High capacity MMC cards */
#define OCR_RESERVED_1		           		0x7f000000
#define OCR_27TO36		               		0x00ff8000
#define OCR_20TO26		               		0x00007f00
#define OCR_165TO195		           		0x00000010
#define OCR_RESERVED_2		           		0x0000007f
#define MMC_MOBILE_VOLTAGE	           	OCR_165TO195

#define OCR_CCS			               		0x40000000	/*This is sent by card to indicate it is high capcity SD card*/
#define OCR_HCS			               		OCR_CCS		/*This is sent by host querying whether card is high capacity?*/

#define OCR_FB                         		0x20000000  /* Fast Boot bit reserved for eSD */
#define OCR_XPC                        		0x10000000  /* OCR_XPC used to check on SDXC Power Control. If 0 => Power Saving, If 1 => Maximum Performance */
#define OCR_S18R                       		0x01000000  /* Switching to 1.8V Request 0 => Use current Signal Voltage, 1 => Switch to 1.8V Signal Voltage */

#define R4_RESP_ERROR_BIT	 		          0x00010000
#define CMD39_WRITE_REG		   	     	0x00008000

/* Define Card status bits (R1) */
#define R1CS_ADDRESS_OUT_OF_RANGE       	0x80000000
#define R1CS_ADDRESS_MISALIGN		    		0x40000000
#define R1CS_BLOCK_LEN_ERR       			0x20000000
#define R1CS_ERASE_SEQ_ERR	           	0x10000000
#define R1CS_ERASE_PARAM	            		0x08000000
#define R1CS_WP_VIOLATION		        		0x04000000
#define R1CS_CARD_IS_LOCKED	            	0x02000000
#define R1CS_LCK_UNLCK_FAILED		    		0x01000000
#define R1CS_COM_CRC_ERROR		        	0x00800000
#define R1CS_ILLEGAL_COMMAND		    		0x00400000
#define R1CS_CARD_ECC_FAILED		    		0x00200000
#define R1CS_CC_ERROR		        			0x00100000
#define R1CS_ERROR		            			0x00080000
#define R1CS_UNDERRUN		        			0x00040000
#define R1CS_OVERRUN		        			0x00020000
#define R1CS_CSD_OVERWRITE	        		0x00010000
#define R1CS_WP_ERASE_SKIP	        		0x00008000
#define R1CS_RESERVED_0	        			0x00004000
#define R1CS_ERASE_RESET        				0x00002000
#define R1CS_CURRENT_STATE_MASK    			0x00001e00
#define R1CS_READY_FOR_DATA	        		0x00000100
#define R1CS_SWITCH_ERROR        			0x00000080
#define R1CS_RESERVED_1		        		0x00000040
#define R1CS_APP_CMD		        			0x00000020
#define R1CS_RESERVED_2		        		0x00000010
#define R1CS_APP_SPECIFIC_MASK	    		0x0000000c
#define R1CS_MANUFAC_TEST_MASK    			0x00000003

#define R1CS_ERROR_OCCURED_MAP	    		0xfdffa080

/* current state */
#define R1CS_CURRENT_STATE(x)	    			(((x)&R1CS_CURRENT_STATE_MASK)>>9)
#define SD_IDLE_STATE								0
#define SD_READY_STATE								1
#define SD_IDENT_STATE								2
#define SD_STANDBY_STATE							3
#define SD_TRANSFER_STATE							4
#define SD_DATA_STATE								5
#define SD_RECEIVE_STATE							6
#define SD_PROGRAM_STATE							7
#define SD_DISABLE_STATE							8


/* SDIO */
#define IO_R4_OCR_MSK					0x00ffffff
#define IO_R4_MEM_PRESENT_BIT			0x08000000
#define IO_R4_NUM_FUNCS_MSK			0x70000000
#define IO_R4_READY_BIT				0x80000000



/*************** Begin CSD Register Defines **************************/
#define GET_BITS_BETWEEN(x,y,z)		((((z)[y>>5])>>(x&0x1f))&((1<<(y-x+1))-1))
#define SET_BITS_BETWEEN(v,x,y,z)	((z)[y>>5])|=((v&((1<<(y-x+1))-1))<<(x&0x1f))
#define CLEAR_BITS_BETWEEN(v,x,y,z)	((z)[y>>5])&=(~((v&((1<<(y-x+1))-1))<<(x&0x1f)))



#define CSD_CSD_STRUCTURE(x)		GET_BITS_BETWEEN(126,127,x)
#define CSD_SPEC_VERS(x)			GET_BITS_BETWEEN(122,125,x)
#define CSD_TAAC(x)					GET_BITS_BETWEEN(112,119,x)
#define CSD_NSAC(x)					GET_BITS_BETWEEN(104,111,x)
#define CSD_TRAN_SPEED(x)			GET_BITS_BETWEEN(96,103,x)
#define CSD_CCC(x)					GET_BITS_BETWEEN(84,95,x)
#define CSD_READ_BL_LEN(x)		GET_BITS_BETWEEN(80,83,x)
#define CSD_READ_BL_PARTIAL(x)	GET_BITS_BETWEEN(79,79,x)
#define CSD_WRT_BLK_MISALIGN(x)	GET_BITS_BETWEEN(78,78,x)
#define CSD_RD_BLK_MISALIGN(x)	GET_BITS_BETWEEN(77,77,x)
#define CSD_DSR_IMP(x)				GET_BITS_BETWEEN(76,76,x)
#define CSD_VDD_R_CURR_MIN(x)		GET_BITS_BETWEEN(59,61,x)
#define CSD_VDD_R_CURR_MAX(x)		GET_BITS_BETWEEN(56,58,x)
#define CSD_VDD_W_CURR_MIN(x)		GET_BITS_BETWEEN(53,55,x)
#define CSD_VDD_W_CURR_MAX(x)		GET_BITS_BETWEEN(50,52,x)
#define CSD_C_SIZE_MULT(x)		GET_BITS_BETWEEN(47,49,x)
#define CSD_ERASE_GRP_SZ(x)		GET_BITS_BETWEEN(42,46,x)
#define CSD_ERASE_GRP_MULT(x)		GET_BITS_BETWEEN(37,41,x)
#define CSD_WP_GRP_SIZE(x)		GET_BITS_BETWEEN(32,36,x)
#define CSD_WP_GRP_ENABLE(x)		GET_BITS_BETWEEN(31,31,x)
#define CSD_DEFAULT_ECC(x)		GET_BITS_BETWEEN(29,30,x)
#define CSD_R2W_FACTOR(x)			GET_BITS_BETWEEN(26,28,x)
#define CSD_WRT_BL_LEN(x)			GET_BITS_BETWEEN(22,25,x)
#define CSD_WRT_BL_PARTIAL(x)		GET_BITS_BETWEEN(21,21,x)
#define CSD_CONT_PROT_APP(x)		GET_BITS_BETWEEN(16,16,x)
#define CSD_FILE_FORMAT_GRP(x)	GET_BITS_BETWEEN(15,15,x)
#define CSD_COPY_FLAG(x)			GET_BITS_BETWEEN(15,15,x)
#define CSD_PERM_WRITE_PROT(x)	GET_BITS_BETWEEN(13,13,x)
#define CSD_TEMP_WRITE_PROT(x)	GET_BITS_BETWEEN(12,12,x)
#define CSD_FILE_FORMAT(x)		GET_BITS_BETWEEN(10,11,x)
#define CSD_ECC_CODE(x)			GET_BITS_BETWEEN(8,9,x)
#define CSD_CRC(x)					GET_BITS_BETWEEN(1,7,x)

#define CSD_ERASE_BLK_EN(x)     	GET_BITS_BETWEEN(46,46,x)
#define CSD_SECTOR_SIZE(x)      	GET_BITS_BETWEEN(39,45,x)

#define CSD_C_SIZE(x)           	CSD_C_SIZE_INLINE(x)
#define CSD_C_SIZE_SD_2_0(x)    	CSD_C_SIZE_SD_2_0_INLINE(x)

static inline unsigned int CSD_C_SIZE_INLINE(unsigned int * csd_array)
{
	unsigned int bits_62_to_63, bits_64_to_73;
	bits_62_to_63 = GET_BITS_BETWEEN(62, 63, csd_array);
	bits_64_to_73 = GET_BITS_BETWEEN(64, 73, csd_array);
	return (bits_62_to_63 | (bits_64_to_73 << 2));
}


static inline unsigned int CSD_C_SIZE_SD_2_0_INLINE(unsigned int * csd_array)
{
	unsigned int bits_48_to_63, bits_64_to_69;
	bits_48_to_63 = GET_BITS_BETWEEN(48, 63, csd_array);
	bits_64_to_69 = GET_BITS_BETWEEN(64, 69, csd_array);
	return (bits_48_to_63 | (bits_64_to_69 << 16));
}

#define CSD_SET_CSD_STRUCTURE(v,x)	SET_BITS_BETWEEN(v,126,127,x)
#define CSD_SET_SPEC_VERS(v,x)		SET_BITS_BETWEEN(v,122,125,x)
#define CSD_SET_TAAC(v,x)		SET_BITS_BETWEEN(v,112,119,x)
#define CSD_SET_NSAC(v,x)		SET_BITS_BETWEEN(v,104,111,x)
#define CSD_SET_TRAN_SPEED(v,x)		SET_BITS_BETWEEN(v,103,96,x)
#define CSD_SET_CCC(v,x)		SET_BITS_BETWEEN(v,84,95,x)
#define CSD_SET_READ_BL_LEN(v,x)	SET_BITS_BETWEEN(v,80,83,x)
#define CSD_SET_READ_BL_PARTIAL(v,x)	SET_BITS_BETWEEN(v,79,79,x)
#define CSD_SET_WRT_BLK_MISALIGN(v,x)	SET_BITS_BETWEEN(v,78,78,x)
#define CSD_SET_RD_BLK_MISALIGN(v,x)	SET_BITS_BETWEEN(v,77,77,x)
#define CSD_SET_DSR_IMP(v,x)		SET_BITS_BETWEEN(v,76,76,x)
#define CSD_SET_VDD_R_CURR_MIN(v,x)	SET_BITS_BETWEEN(v,59,61,x)
#define CSD_SET_VDD_R_CURR_MAX(v,x)	SET_BITS_BETWEEN(v,56,58,x)
#define CSD_SET_VDD_W_CURR_MIN(v,x)	SET_BITS_BETWEEN(v,53,55,x)
#define CSD_SET_VDD_W_CURR_MAX(v,x)	SET_BITS_BETWEEN(v,50,52,x)
#define CSD_SET_C_SIZE_MULT(v,x)	SET_BITS_BETWEEN(v,47,49,x)
#define CSD_SET_ERASE_GRP_SZ(v,x)	SET_BITS_BETWEEN(v,42,46,x)
#define CSD_SET_ERASE_GRP_MULT(v,x)	SET_BITS_BETWEEN(v,37,41,x)
#define CSD_SET_WP_GRP_SIZE(v,x)	SET_BITS_BETWEEN(v,32,36,x)
#define CSD_SET_WP_GRP_ENABLE(v,x)	SET_BITS_BETWEEN(v,31,31,x)
#define CSD_SET_DEFAULT_ECC(v,x)	SET_BITS_BETWEEN(v,29,30,x)
#define CSD_SET_R2W_FACTOR(v,x)		SET_BITS_BETWEEN(v,26,28,x)
#define CSD_SET_WRT_BL_LEN(v,x)		SET_BITS_BETWEEN(v,22,25,x)
#define CSD_SET_WRT_BL_PARTIAL(v,x)	SET_BITS_BETWEEN(v,21,21,x)
#define CSD_SET_CONT_PROT_APP(v,x)	SET_BITS_BETWEEN(v,16,16,x)
#define CSD_SET_FILE_FORMAT_GRP(v,x)	SET_BITS_BETWEEN(v,15,15,x)
#define CSD_SET_COPY_FLAG(v,x)		SET_BITS_BETWEEN(v,15,15,x)
#define CSD_SET_PERM_WRITE_PROT(v,x)	SET_BITS_BETWEEN(v,13,13,x)
#define CSD_SET_TEMP_WRITE_PROT(v,x)	SET_BITS_BETWEEN(v,12,12,x)
#define CSD_SET_FILE_FORMAT(v,x)	SET_BITS_BETWEEN(v,10,11,x)
#define CSD_SET_ECC_CODE(v,x)		SET_BITS_BETWEEN(v,8,9,x)
#define CSD_SET_CRC(v,x)		SET_BITS_BETWEEN(v,1,7,x)

#define CSD_CLEAR_CSD_STRUCTURE(v,x)	CLEAR_BITS_BETWEEN(v,126,127,x)
#define CSD_CLEAR_SPEC_VERS(v,x)	CLEAR_BITS_BETWEEN(v,122,125,x)
#define CSD_CLEAR_TAAC(v,x)		CLEAR_BITS_BETWEEN(v,112,119,x)
#define CSD_CLEAR_NSAC(v,x)		CLEAR_BITS_BETWEEN(v,104,111,x)
#define CSD_CLEAR_TRAN_SPEED(v,x)	CLEAR_BITS_BETWEEN(v,103,96,x)
#define CSD_CLEAR_CCC(v,x)		CLEAR_BITS_BETWEEN(v,84,95,x)
#define CSD_CLEAR_READ_BL_LEN(v,x)	CLEAR_BITS_BETWEEN(v,80,83,x)
#define CSD_CLEAR_READ_BL_PARTIAL(v,x)	CLEAR_BITS_BETWEEN(v,79,79,x)
#define CSD_CLEAR_WRT_BLK_MISALIGN(v,x)	CLEAR_BITS_BETWEEN(v,78,78,x)
#define CSD_CLEAR_RD_BLK_MISALIGN(v,x)	CLEAR_BITS_BETWEEN(v,77,77,x)
#define CSD_CLEAR_DSR_IMP(v,x)		CLEAR_BITS_BETWEEN(v,76,76,x)
#define CSD_CLEAR_VDD_R_CURR_MIN(v,x)	CLEAR_BITS_BETWEEN(v,59,61,x)
#define CSD_CLEAR_VDD_R_CURR_MAX(v,x)	CLEAR_BITS_BETWEEN(v,56,58,x)
#define CSD_CLEAR_VDD_W_CURR_MIN(v,x)	CLEAR_BITS_BETWEEN(v,53,55,x)
#define CSD_CLEAR_VDD_W_CURR_MAX(v,x)	CLEAR_BITS_BETWEEN(v,50,52,x)
#define CSD_CLEAR_C_SIZE_MULT(v,x)	CLEAR_BITS_BETWEEN(v,47,49,x)
#define CSD_CLEAR_ERASE_GRP_SZ(v,x)	CLEAR_BITS_BETWEEN(v,42,46,x)
#define CSD_CLEAR_ERASE_GRP_MULT(v,x)	CLEAR_BITS_BETWEEN(v,37,41,x)
#define CSD_CLEAR_WP_GRP_SIZE(v,x)	CLEAR_BITS_BETWEEN(v,32,36,x)
#define CSD_CLEAR_WP_GRP_ENABLE(v,x)	CLEAR_BITS_BETWEEN(v,31,31,x)
#define CSD_CLEAR_DEFAULT_ECC(v,x)	CLEAR_BITS_BETWEEN(v,29,30,x)
#define CSD_CLEAR_R2W_FACTOR(v,x)	CLEAR_BITS_BETWEEN(v,26,28,x)
#define CSD_CLEAR_WRT_BL_LEN(v,x)	CLEAR_BITS_BETWEEN(v,22,25,x)
#define CSD_CLEAR_WRT_BL_PARTIAL(v,x)	CLEAR_BITS_BETWEEN(v,21,21,x)
#define CSD_CLEAR_CONT_PROT_APP(v,x)	CLEAR_BITS_BETWEEN(v,16,16,x)
#define CSD_CLEAR_FILE_FORMAT_GRP(v,x)	CLEAR_BITS_BETWEEN(v,15,15,x)
#define CSD_CLEAR_COPY_FLAG(v,x)	CLEAR_BITS_BETWEEN(v,15,15,x)
#define CSD_CLEAR_PERM_WRITE_PROT(v,x)	CLEAR_BITS_BETWEEN(v,13,13,x)
#define CSD_CLEAR_TEMP_WRITE_PROT(v,x)	CLEAR_BITS_BETWEEN(v,12,12,x)
#define CSD_CLEAR_FILE_FORMAT(v,x)	CLEAR_BITS_BETWEEN(v,10,11,x)
#define CSD_CLEAR_ECC_CODE(v,x)		CLEAR_BITS_BETWEEN(v,8,9,x)
#define CSD_CLEAR_CRC(v,x)		CLEAR_BITS_BETWEEN(v,1,7,x)

#define CSD_SPEC_VER_0      0	/* system specification 1.0 - 1.2 */
#define CSD_SPEC_VER_1      1	/* system specification 1.4 */
#define CSD_SPEC_VER_2      2	/* system specification 2.0 - 2.2 */
#define CSD_SPEC_VER_3      3	/* system specification 3.1 */
#define CSD_SPEC_VER_4      4	/* system specification 4.0 - 4.1 */

/*************** End  CSD Register Defines **************************/

struct card_handle
{
	int sd_ready;
	int card_type;  //sd or mmc type
	int cdetect;
	int CLK_DIV;

	unsigned int TACC;
	unsigned int NSAC;

	unsigned int RCA;
	unsigned int OCR;
	unsigned int CSD[4];
	unsigned int CID[4];
	unsigned int max_TAAC_value;
	unsigned int max_NSAC_value;
	unsigned int card_write_blksize ;
	unsigned int orig_card_read_blksize;
	unsigned int card_read_blksize ;
	unsigned int orig_card_write_blksize;
	unsigned int card_size;
};



#endif
