#include "sys.h"
#include "hal.h"
//#include "hali.h"

#if defined(HAL_INC_WDT)
static void halWDTSelClkSrc_i(halWDTClkSrc_E sourceClk);
static void halWDTTimeOutAction_ii(bool_T bResetOut, bool_T bIntrSys, bool_T bResetSys);

void halWDTInit_i(void)
{
	halWDTDisable();
	halWDTSelClkSrc_i(halcWDTClk_pclk);
	halWDTTimeOutAction_ii(FALSE, FALSE, FALSE);
}

static void halWDTSelClkSrc_i(halWDTClkSrc_E sourceClk)
{
	register unsigned int nRegVal;

	nRegVal = HAL_GETREG32(HAL_REG_WDT_Ctrl);
	if (sourceClk == halcWDTClk_pclk)
	{
		/* reset HAL_REG_WDT_Ctrl[4] as 0 */
		nRegVal &= 0xFFFFFFEF;
	}
	else
	{
		/* set HAL_REG_WDT_Ctrl[4] as 1 */
		nRegVal |= 0x00000010;
	}
	HAL_SETREG32(HAL_REG_WDT_Ctrl, nRegVal);
}

static void halWDTTimeOutAction_ii(bool_T bResetOut, bool_T bIntrSys, bool_T bResetSys)
{
	register unsigned int nRegVal;

	nRegVal = HAL_GETREG32(HAL_REG_WDT_Ctrl);

	if (bResetOut)
	{
		/* set HAL_REG_WDT_Ctrl[3] = 1 */
		nRegVal |= 0x00000008;
	}
	else
	{
		/* reset HAL_REG_WDT_Ctrl[3] = 0 */
		nRegVal &= 0xFFFFFFF7;
	}

	if (bIntrSys)
	{
		/* set HAL_REG_WDT_Ctrl[2] = 1 */
		nRegVal |= 0x00000004;
	}
	else
	{
		/* reset HAL_REG_WDT_Ctrl[2] = 0 */
		nRegVal &= 0xFFFFFFFB;
	}

	if (bResetSys)
	{
		/* set HAL_REG_WDT_Ctrl[1] = 1 */
		nRegVal |= 0x00000002;
	}
	else
	{
		/* reset HAL_REG_WDT_Ctrl[1] = 0 */
		nRegVal &= 0xFFFFFFFD;
	}

	HAL_SETREG32(HAL_REG_WDT_Ctrl, nRegVal);
}

void halWDTEnable(void)
{
	register unsigned int nRegVal;

	/* set HAL_REG_WDT_Ctrl[0] as 1 */
	nRegVal = HAL_GETREG32(HAL_REG_WDT_Ctrl);
	nRegVal |= 1;
	HAL_SETREG32(HAL_REG_WDT_Ctrl, nRegVal);
}

void halWDTDisable(void)
{
	register unsigned int nRegVal;

	/* reset HAL_REG_WDT_Ctrl[0] as 0 */
	nRegVal = HAL_GETREG32(HAL_REG_WDT_Ctrl);
	nRegVal &= 0xFFFFFFFE;
	HAL_SETREG32(HAL_REG_WDT_Ctrl, nRegVal);
}

void halWDTReStartNew(unsigned int nPeriod,
		halWDTClkSrc_E sourceClk,
		bool_T bResetOut, bool_T bIntrSys, bool_T bResetSys)
{
	halWDTDisable();

	HAL_SETREG32(HAL_REG_WDT_Reload, nPeriod);

	halWDTSelClkSrc_i(sourceClk);

	halWDTTimeOutAction_ii(bResetOut, bIntrSys, bResetSys);

	HAL_SETREG16(HAL_REG_WDT_Restart, 0x4755);	/* reload! */

	halWDTEnable();
}

void halWDTReStart(void)
{
	halWDTDisable();
	HAL_SETREG16(HAL_REG_WDT_Restart, 0x4755);	/* reload! */
	halWDTEnable();
}
#endif

