#include "hal.h"

#define HAL_I2C2_CHECK_ACK_BIT	1
#define HAL_I2C_CHECK_ACK_BIT


#define I2C_READ_MODE	1
#define I2C_WRITE_MODE	0

void halI2CDisable(halI2CId_E nId)
{
	switch (nId)
	{
		case halcI2C1:
			HAL_SETREG(HAL_REG_I2C1_Enable, 0);
			break;
		case halcI2C2:
			HAL_SETREG(HAL_REG_I2C2_Enable, 0);
			break;
		case halcI2C0:
			HAL_SETREG(HAL_REG_I2C0_Enable, 0);
			break;
		default:
			break;
	}
}

void halI2CEnable(halI2CId_E nId, unsigned int nPCLK)
{
	unsigned short nScale;

	/*
		The relationship between the PCLK and I2C_clk is shown as
		the following equivalence.

		I2C_clk = nPCLK/(4*(nScale+1))

		In order to meet the I2C's requirement, we need to restrict
		that I2C_clk could not be greater than 400k. Here, restrict
		the I2C_clk not greater than 10k.

		Hence,

		I2C_clk = nPCLK/(4*(nScale+1)) < 10k

		==> nPCLK/10k < 4(nScale+1)

		==> nScale > nPCLK/40k - 1

		we choose: nScale = nPCLK/40k;
	*/

	nScale = (unsigned short) (nPCLK/(400000));
	//nScale = 0xAFC;

	switch (nId)
	{
	case halcI2C1:
		halSysSetMultiFunctionalPin(HAL_MFP_I2C1);
		HAL_SETREG(HAL_REG_I2C1_PreScaleLowByte, (nScale & 0xFF));
		HAL_SETREG(HAL_REG_I2C1_PreScaleHighByte, ((nScale & 0xFF00) >> 8));
		HAL_SETREG(HAL_REG_I2C1_Enable, 1);
		break;
	case halcI2C2:
		halSysSetMultiFunctionalPin(HAL_MFP_I2C2);
		HAL_SETREG(HAL_REG_I2C2_PreScaleLowByte, (nScale & 0xFF));
		HAL_SETREG(HAL_REG_I2C2_PreScaleHighByte, ((nScale & 0xFF00) >> 8));
		HAL_SETREG(HAL_REG_I2C2_Enable, 1);
		break;
	case halcI2C0:
		halSysSetMultiFunctionalPin(HAL_MFP_I2C0);
		HAL_SETREG(HAL_REG_I2C0_PreScaleLowByte, (nScale & 0xFF));
		HAL_SETREG(HAL_REG_I2C0_PreScaleHighByte, ((nScale & 0xFF00) >> 8));
		HAL_SETREG(HAL_REG_I2C0_Enable, 1);
		break;
	default:
		break;
	}
}

int halGenericI2CWrite(i2cPacketFmt_t packet)
{
	unsigned int nRegValue, i;
	
	unsigned int HAL_REG_I2C_Data, HAL_REG_I2C_Ctrl;

	if (packet.nId == halcI2C0)
	{
		HAL_REG_I2C_Data = HAL_REG_I2C0_Data;
 		HAL_REG_I2C_Ctrl = HAL_REG_I2C0_Ctrl;
  	}
	else if (packet.nId == halcI2C1)
	{
  		HAL_REG_I2C_Data = HAL_REG_I2C1_Data;
		HAL_REG_I2C_Ctrl = HAL_REG_I2C1_Ctrl;
	}
	else if (packet.nId == halcI2C2)
	{	
		HAL_REG_I2C_Data = HAL_REG_I2C2_Data;
 		HAL_REG_I2C_Ctrl = HAL_REG_I2C2_Ctrl;
	}
	else
	{
		HAL_REG_I2C_Data = HAL_REG_I2C0_Data;
 		HAL_REG_I2C_Ctrl = HAL_REG_I2C0_Ctrl;
  	}


	/*
	 *	programming sequence :
	 *
	 *	START -> slave address -> slave sub-address (M bytes) ->
	*	data (N bytes) -> STOP
	 *
	 *	Please refer to
	 *		"TECHWELL TW9910",
	 *		data sheets for more details.
	 */

	/*
	 *	While wirting Ctrl as 0, the following actions are done:
	 *		1. clear interrupt
	 *		2. the value in Data register is transmitted.
	 */


	/* START and I2C slave address */
	HAL_SETREG(HAL_REG_I2C_Data, (packet.nSlaveAddr << 1) + I2C_WRITE_MODE);
	HAL_SETREG(HAL_REG_I2C_Ctrl, 0x04); //start
	/*
	 *	While Ctrl[2] is 1, START is transmitted.
	 *	Note that the slave address (in Data register) is sent next implicitly.
	 */

	do
	{
		nRegValue = HAL_GETREG(HAL_REG_I2C_Ctrl);
	}
	while((nRegValue & 0x00000002)==0);

#ifdef HAL_I2C_CHECK_ACK_BIT
	/* check the ACK bit */
	if (nRegValue & 1)
	{
		/* nACK is got; this is incorrect */
		goto LLL_ABNORMALr;
	}
#endif

	/* sub-address of the I2C slave */
	for (i=0; i<packet.subAddrLen; i++)
	{
		HAL_SETREG(HAL_REG_I2C_Data, packet.subAddr[i]); /* sub address */
		HAL_SETREG(HAL_REG_I2C_Ctrl, 0);       /* clear interrupt and send data */
		do
		{
			nRegValue = HAL_GETREG(HAL_REG_I2C_Ctrl);
		}
		while((nRegValue & 0x00000002)==0);
	}


	/* data */
	for (i=0; i<packet.dataLen; i++)
	{
		HAL_SETREG(HAL_REG_I2C_Data, packet.data[i]);
		HAL_SETREG(HAL_REG_I2C_Ctrl, 0); /* clear interrupt and send data */
		do
		{
			nRegValue = HAL_GETREG(HAL_REG_I2C_Ctrl);
		}
		while((nRegValue & 0x00000002)==0);
	}

	/* STOP */
	HAL_SETREG(HAL_REG_I2C_Ctrl, 0x08);
	return 0;

LLL_ABNORMALr:
	return -1;
}

int halGenericI2CRead(i2cPacketFmt_t packet)
{
	unsigned int nRegValue, i;
	
	unsigned int HAL_REG_I2C_Data, HAL_REG_I2C_Ctrl;

	if (packet.nId == halcI2C0)
	{
		HAL_REG_I2C_Data = HAL_REG_I2C0_Data;
 		HAL_REG_I2C_Ctrl = HAL_REG_I2C0_Ctrl;
  	}
	else if (packet.nId == halcI2C1)
	{
  		HAL_REG_I2C_Data = HAL_REG_I2C1_Data;
		HAL_REG_I2C_Ctrl = HAL_REG_I2C1_Ctrl;
	}
	else if (packet.nId == halcI2C2)
	{	
		HAL_REG_I2C_Data = HAL_REG_I2C2_Data;
 		HAL_REG_I2C_Ctrl = HAL_REG_I2C2_Ctrl;
	}
	else
	{
		HAL_REG_I2C_Data = HAL_REG_I2C0_Data;
 		HAL_REG_I2C_Ctrl = HAL_REG_I2C0_Ctrl;
  	}

	/*
	 *	programming sequence :
	 *
	 *	Start -> Slave address (W) -> ACK-s -> 
	*	slave sub-address (M bytes) -> -> ACK-s
	 *	-> repeated Start (Sr) -> SLAVE ADDRESS (R) -> ACK-s
	 *	-> DATA (N Bytes) -> ACK-m -> STOP
	 */

	/* START and I2C slave address */
	HAL_SETREG(HAL_REG_I2C_Data, (packet.nSlaveAddr << 1 ) + I2C_WRITE_MODE); //slave address
	HAL_SETREG(HAL_REG_I2C_Ctrl, 0x04); //start

	do
	{
		nRegValue = HAL_GETREG(HAL_REG_I2C_Ctrl);
	}
	while((nRegValue & 0x00000002)==0);

#ifdef HAL_I2C_CHECK_ACK_BIT
        /* check the ACK bit */
        if (nRegValue & 1)
        {
                /* nACK is got; this is incorrect */
                goto LLL_ABNORMALr;
        }
#endif

	/* sub-address of the I2C slave */
	for (i=0; i<packet.subAddrLen; i++)
	{
		HAL_SETREG(HAL_REG_I2C_Data, packet.subAddr[i]); /* sub address */
		HAL_SETREG(HAL_REG_I2C_Ctrl, 0);       /* clear interrupt and send data */
		do
		{
			nRegValue = HAL_GETREG(HAL_REG_I2C_Ctrl);
		}
		while((nRegValue & 0x00000002)==0);
	}

	HAL_SETREG(HAL_REG_I2C_Data, (packet.nSlaveAddr << 1) + I2C_READ_MODE);
	HAL_SETREG(HAL_REG_I2C_Ctrl, 0x04); //clear interrupt and restart
	do
	{
		nRegValue = HAL_GETREG(HAL_REG_I2C_Ctrl);
	}
	while((nRegValue & 0x00000002)==0);

	for (i=0; i<packet.dataLen; i++)
	{
		HAL_SETREG(HAL_REG_I2C_Ctrl, (i==packet.dataLen-1)? 0x01 /* No ack */  : 0x00 /* ack */ ); 
		do {
			nRegValue = HAL_GETREG(HAL_REG_I2C_Ctrl);	
		} while ((nRegValue & 0x00000002)==0);
		/* retrieve data from data register */
		packet.data[i] = HAL_GETREG(HAL_REG_I2C_Data);
	}
	/* STOP */
	HAL_SETREG(HAL_REG_I2C_Ctrl, 0x08);
	return 0;
LLL_ABNORMALr:
        return -1;
}



//#define SAA7111A_ADDR	0x48
#define TW9910_ADDR		0x88	/* need to check with SIADO value */
//#define AL240_ADDR		0x24	/* need to check with SSEL[0,1] */


void halI2C1WriteSAA7111A(unsigned int subAddr, unsigned int data)
{
}

void halI2C1ReadSAA7111A(unsigned int subAddr, unsigned int *data)
{
}

void halI2C1EnableVideoInViaSAA7111A(unsigned char *pRegValSets, int nNumSet)
{
}

void halI2C1DisableVideoinViaSAA7111A(void)
{

}

void halI2C1WriteTW9910(unsigned int subAddr, unsigned int data)
{
}

void halI2C1ReadTW9910(unsigned int subAddr, unsigned int *data)
{
}

void halI2C1EnableVideoInViaTW9910(unsigned char *pRegValSets, int nNumSet)
{
}

void halI2C1DisableVideoinViaTW9910(void)
{
}

bool_T halI2C2WriteUDA1380(unsigned int regAddr, unsigned int nNumItems, unsigned int *pData)
{
}

bool_T halI2C2ReadUDA1380(unsigned int regAddr, unsigned int nNumItems, unsigned int *pData)
{
}
static void halDAIDelay_ii(int nDelay)
{
}

static void halI2C2PromiseWriteUDA1380_ii(unsigned int subaddr, unsigned int value, int nDelay)
{
}
static unsigned int halI2C2PromiseReadUDA1380_ii(unsigned int subaddr, int nDelay)
{
}

void halI2C2PowerOffUDA1380(void)
{
}

static bool_T halI2C2WriteTLV320_ii(unsigned char regAddr, unsigned short data)
{

}

bool_T halI2C2InitTLV320I2SMode(halTLV320Setting_S *pSetting)
{

}

void halI2C2PowerOffTLV320(void)
{
}

void halI2C3WriteLED(unsigned short nValue)
{

}


