#include "sys.h"
#include "hal.h"

#if defined(HAL_INC_GPIO)

void halGPIOInit_i(void)
{
	return;
}
void halGPIOSetDBEnable(int gpio, halGPIOPin_E nPin, bool_T b)
{
	register unsigned int nRegValue;


	nRegValue = HAL_GETREG32(HAL_REG_GPIO_DBEN + (HAL_REG_GPIO_OFFSET * gpio));

	/* 1: enable. 0: disable */
	if (b)
		nRegValue |= (1 << nPin);
	else
		nRegValue &= ~(1 << nPin);

	HAL_SETREG32(HAL_REG_GPIO_DBEN + (HAL_REG_GPIO_OFFSET * gpio), nRegValue);

}

void halGPIOSetInterrupt(int gpio, halGPIOPin_E nPin, bool_T b)
{
	register unsigned int nRegValue;


	nRegValue = HAL_GETREG32(HAL_REG_GPIO_IntEnable + (HAL_REG_GPIO_OFFSET * gpio));

	/* 1: enable. 0: disable */
	if (b)
		nRegValue |= (1 << nPin);
	else
		nRegValue &= ~(1 << nPin);

	HAL_SETREG32(HAL_REG_GPIO_IntEnable + (HAL_REG_GPIO_OFFSET * gpio), nRegValue);

}

void halGPIOSetPinDir(int gpio, halGPIOPin_E nPin, bool_T b)
{
	register unsigned int nRegValue, nRegMask;


	nRegValue = HAL_GETREG32(HAL_REG_GPIO_Direction + (HAL_REG_GPIO_OFFSET * gpio));

	/* 1: output. 0: input */
	if (b)
		nRegValue |= (1 << nPin);
	else
		nRegValue &= ~(1 << nPin);

	HAL_SETREG32(HAL_REG_GPIO_Direction + (HAL_REG_GPIO_OFFSET * gpio), nRegValue);

}

void halGPIOSetPinData(int gpio, halGPIOPin_E nPin, bool_T b)
{
	register unsigned int nRegValue, nRegMask;

	if (nPin == halcGPIOPinAll)
	{
		HAL_SETREG32(HAL_REG_GPIO_RWMask + (HAL_REG_GPIO_OFFSET * gpio), 0xFFFFFFFF);

		if (b)
			HAL_SETREG32(HAL_REG_GPIO_Data + (HAL_REG_GPIO_OFFSET * gpio), 0xFFFFFFFF);
		else
			HAL_SETREG32(HAL_REG_GPIO_Data + (HAL_REG_GPIO_OFFSET * gpio), 0);

		return;
	}

	if (b)
		nRegValue = (1 << nPin);
	else
		nRegValue = 0;

	nRegMask = (1 << nPin);

	HAL_SETREG32(HAL_REG_GPIO_RWMask + (HAL_REG_GPIO_OFFSET * gpio), nRegMask);
	HAL_SETREG32(HAL_REG_GPIO_Data + (HAL_REG_GPIO_OFFSET * gpio), nRegValue);
}

unsigned int halGPIOGetPinData(int gpio, halGPIOPin_E nPin)
{
	register unsigned int nRegValue, nRegMask;

	if (nPin == halcGPIOPinAll)
	{
		HAL_SETREG32(HAL_REG_GPIO_RWMask + (HAL_REG_GPIO_OFFSET * gpio), 0xFFFFFFFF);

		nRegValue = HAL_GETREG32(HAL_REG_GPIO_Data + (HAL_REG_GPIO_OFFSET * gpio));
		return nRegValue;
	}

	nRegMask = (1 << nPin);

	HAL_SETREG32(HAL_REG_GPIO_RWMask + (HAL_REG_GPIO_OFFSET * gpio), nRegMask);
	nRegValue = HAL_GETREG32(HAL_REG_GPIO_Data + (HAL_REG_GPIO_OFFSET * gpio));
	return nRegValue;
}
#endif

