#include "sys.h"
#include "dosFS.h"
#include "dosFSi.h"


bool_T dosSetFmtInfo_i(dosBS_S *pBS, unsigned int nSize)
{
    unsigned int nNumSecsPreP1;    /* number of sectors before partition-1 */
    unsigned int nNumSecsP1Sys;    /* number of sectors of p1's system info:
                                    partition boot sector +
                                    FAT area +
                                    Root directory area */
    unsigned int nSectorsPerCluster;

    unsigned int nRootDirSectors;
    unsigned int nRootEntCnt = 512;
    unsigned int nResvSecCnt;
    unsigned int nNumFATs = 2;
    unsigned int nFATSz;
    unsigned int nFATSz16;
    unsigned int tmp1, tmp2;


    nSize /= DOS_BYTES_PER_SEC;

	//if ((nSize <= 8400) || (nSize > 1048576))
    if (nSize > 1048576)
	{
		/* the medis size is out of valid range (4.1M ~ 512M) */
        return (FALSE);
    }

	//Dertermine nSectorsPerCluster
    if (nSize <= 32680) // up to 16MB, 1k cluster
        nSectorsPerCluster = 2;
    else if (nSize <= 262144) // up to 128MB, 2k cluster
        nSectorsPerCluster = 4;
    else if (nSize <= 524288) // up to 256MB, 4k cluster
        nSectorsPerCluster = 8;
    else if (nSize <= 1048576) // up to 512MB, 8k cluster
        nSectorsPerCluster = 16;

    nResvSecCnt = nSectorsPerCluster;

    // Dertermine nFATSz16
    nRootDirSectors = ((nRootEntCnt * 32) + (DOS_BYTES_PER_SEC - 1)) / DOS_BYTES_PER_SEC;
    tmp1 = nSize - (nResvSecCnt + nRootDirSectors);
    tmp2 = (256 * nSectorsPerCluster) + nNumFATs;
    nFATSz = (tmp1 + (tmp2 - 1)) / tmp2;
    nFATSz16 = nFATSz & 0x0000ffff;

    // partition-1 information
    pBS->mbs.p1BootId            = (unsigned char) 0x80;
    pBS->mbs.p1StartHeadNum      = (unsigned char) 0x01;
    pBS->mbs.p1StartSectorNum    = (unsigned char) 0x0A;
    pBS->mbs.p1StartCylinderNum  = (unsigned char) 0x00;
    pBS->mbs.p1SystemId          = (unsigned char) 0x01;
    pBS->mbs.p1EndHeadNum        = (unsigned char) 0x03;
    pBS->mbs.p1EndSectorNum      = (unsigned char) 0x10;
    pBS->mbs.p1EndCylinderNum    = (unsigned char) 0xF9;
    pBS->mbs.p1StartLogSectorNum = (unsigned int)  0x00000019;


	////////////////////////////////////////////////////////////////////
    // calculate the size of the partition-1
    nNumSecsPreP1 = pBS->mbs.p1StartLogSectorNum;
	//nNumSecsP1Sys = boot_sector + 2*nFATSz16 + root_directory(nRootEntCnt*32/DOS_BYTES_PER_SEC)=32
    nNumSecsP1Sys = nResvSecCnt + nNumFATs * nFATSz16 + nRootDirSectors;
    pBS->mbs.p1Size    = nSize; // / DOS_BYTES_PER_SEC;
    pBS->mbs.p1Size -= (nNumSecsPreP1 + nNumSecsP1Sys);
    pBS->mbs.p1Size /= nSectorsPerCluster;    // cluster alignment
    pBS->mbs.p1Size *= nSectorsPerCluster;
    pBS->mbs.p1Size += nNumSecsP1Sys;

    // signature
    pBS->mbs.fixedData[0] = 0x55;
    pBS->mbs.fixedData[1] = 0xAA;

    // partition-1 boot sector
    pBS->p1bs.jumpCmd[0] = 0xe8;
    pBS->p1bs.jumpCmd[1] = 0x3c;
    pBS->p1bs.jumpCmd[2] = 0x90;
    pBS->p1bs.manufacture[0] = 'F';
    pBS->p1bs.manufacture[1] = 'L';
    pBS->p1bs.manufacture[2] = 'A';
    pBS->p1bs.manufacture[3] = 'S';
    pBS->p1bs.manufacture[4] = 'H';
    pBS->p1bs.manufacture[5] = 'D';
    pBS->p1bs.manufacture[6] = 'R';
    pBS->p1bs.manufacture[7] = 'V';
    pBS->p1bs.bytesPerSector = DOS_BYTES_PER_SEC;
    pBS->p1bs.sectorsPerCluster = nSectorsPerCluster;
    pBS->p1bs.numReservedSectors = nResvSecCnt;
    pBS->p1bs.numFATs = 2;
    pBS->p1bs.numEntriesInRD = nRootEntCnt;
    pBS->p1bs.numSectorsInVolume = (pBS->mbs.p1Size < 0x10000) ? (unsigned short) pBS->mbs.p1Size : 0;
	// pBS->p1bs.numSectorsInVolume = (unsigned short) pBS->mbs.p1Size;
    pBS->p1bs.mediaDescriptor = 0xF8;
    pBS->p1bs.sectorsPerFAT = nFATSz16;
    pBS->p1bs.sectorsPerTrack = 0x3f;
    pBS->p1bs.numRWHeads = 0xff;
    pBS->p1bs.numHiddenSectors = nNumSecsPreP1;

    // 0x020~0x035 : fill 0's
    pBS->p1bs.nNumPartSecs = (pBS->mbs.p1Size >= 0x10000) ? pBS->mbs.p1Size : 0;
    pBS->p1bs.nPhyDriveNum = 0;
    pBS->p1bs.reserved_1 = 0;
    pBS->p1bs.extBootRecSignature = 0x29;
    pBS->p1bs.volumeId = 0x6a19d191;
    pBS->p1bs.volumeLabel[0] = 'N';
    pBS->p1bs.volumeLabel[1] = 'O';
    pBS->p1bs.volumeLabel[2] = ' ';
    pBS->p1bs.volumeLabel[3] = 'N';
    pBS->p1bs.volumeLabel[4] = 'A';
    pBS->p1bs.volumeLabel[5] = 'M';
    pBS->p1bs.volumeLabel[6] = 'E';
    pBS->p1bs.volumeLabel[7] = ' ';
    pBS->p1bs.volumeLabel[8] = ' ';
    pBS->p1bs.volumeLabel[9] = ' ';
    pBS->p1bs.volumeLabel[10]= ' ';
    
    pBS->p1bs.fileSystemType[0] = 'F';
    pBS->p1bs.fileSystemType[1] = 'A';
    pBS->p1bs.fileSystemType[2] = 'T';
    pBS->p1bs.fileSystemType[3] = '1';
    pBS->p1bs.fileSystemType[4] = '6';
    pBS->p1bs.fileSystemType[5] = ' ';
    pBS->p1bs.fileSystemType[6] = ' ';
    pBS->p1bs.fileSystemType[7] = ' ';

    pBS->p1bs.fixedData[0] = 0x55;
    pBS->p1bs.fixedData[1] = 0xAA;

    // derived info
    pBS->p1bs.fatSystem = DOS_FAT_BITS_16;
    pBS->p1bs.bytesPerCluster = DOS_BYTES_PER_SEC * pBS->p1bs.sectorsPerCluster;
    pBS->p1bs.nFATStartSector = nNumSecsPreP1 + nResvSecCnt;
    pBS->p1bs.nRDStartSector16 = nNumSecsPreP1 + nResvSecCnt + nNumFATs * nFATSz16;
    pBS->p1bs.nDataStartSector = nNumSecsPreP1 + nNumSecsP1Sys;
    pBS->p1bs.numLogEntriesPerFAT = (pBS->p1bs.sectorsPerFAT * DOS_BYTES_PER_SEC * 8)/DOS_FAT_BITS_16;
    pBS->p1bs.numPhyEntriesPerFAT =
        (pBS->mbs.p1Size-nNumSecsP1Sys)/nSectorsPerCluster + 
        (nNumSecsPreP1+nNumSecsP1Sys)/nSectorsPerCluster;

    return (TRUE);
}

void setBootSector(unsigned int *buffer)
{
    buffer[0]   =    0x4d903ceb;
    buffer[1]   =    0x534f4453;
    buffer[2]   =    0x00302e35;//[11:8],
    buffer[3]   =    0x00010202;//[15:12],   [11:12]=0x200 BytesPerSec, [13]=0x02 SecPerClus, [14]=1 fixed RsvdSecCnt
    buffer[4]   =    0x00020002;//[19:16],   [16]=0x02 fixed NutFATs,  [18:17]=0x200 RootEntCnt
    buffer[5]   =    0x007af800;//[23:20],   [20:19]=0 TotSec16,  [21]=0xf8 fixed Media,  [23:22]=0x00f4/2=0x7a FATSz16
    buffer[6]   =    0x00ff003f;//[27:24],   [25:24]=0x003f SecPerTrk,   [27:26]= 0x00ff NumHeads
    buffer[7]   =    0x00000000;//[31:28],   
    buffer[8]   =    0x0000f500;//[35:32],   0x1ea00/2=0xf500 TotSec16/32
    buffer[9]   =    0x78290000;
    buffer[10]  =    0x4edcc10f;
    buffer[11]  =    0x414e204f;
    buffer[12]  =    0x2020454d;
    buffer[13]  =    0x41462020;
    buffer[14]  =    0x20363154;
    buffer[15]  =    0xc9332020;
    buffer[16]  =    0xf0bcd18e;
    buffer[17]  =    0xb8d98e7b;
    buffer[18]  =    0xc08e2000;
    buffer[19]  =    0x7c00bdfc;
    buffer[20]  =    0x7d244e38;
    buffer[21]  =    0x99c18b24;
    buffer[22]  =    0x72013ce8;
    buffer[23]  =    0x3aeb831c;
    buffer[24]  =    0x7c1ca166;
    buffer[25]  =    0x073b6626;
    buffer[26]  =    0xfc578a26;
    buffer[27]  =    0xca800675;
    buffer[28]  =    0x02568802;
    buffer[29]  =    0x7310c380;
    buffer[30]  =    0x8ac933eb;
    buffer[31]  =    0xf7981046;
    buffer[32]  =    0x46031666;
    buffer[33]  =    0x1e56131c;
    buffer[34]  =    0x130e4603;
    buffer[35]  =    0x11768bd1;
    buffer[36]  =    0xfc468960;
    buffer[37]  =    0xb8fe5689;
    buffer[38]  =    0xe6f70020;
    buffer[39]  =    0x030b5e8b;
    buffer[40]  =    0xf3f748c3;
    buffer[41]  =    0x11fc4601;
    buffer[42]  =    0xbf61fe4e;
    buffer[43]  =    0xe6e80000;
    buffer[44]  =    0x26397200;
    buffer[45]  =    0x17742d38;
    buffer[46]  =    0xbe0bb160;
    buffer[47]  =    0xa6f37da1;
    buffer[48]  =    0x4e327461;
    buffer[49]  =    0xc7830974;
    buffer[50]  =    0x72fb3b20;
    buffer[51]  =    0xa0dcebe6;
    buffer[52]  =    0x7db47dfb;
    buffer[53]  =    0x98acf08b;
    buffer[54]  =    0x480c7440;
    buffer[55]  =    0x0eb41374;
    buffer[56]  =    0xcd0007bb;
    buffer[57]  =    0xa0efeb10;
    buffer[58]  =    0xe6eb7dfd;
    buffer[59]  =    0xeb7dfca0;
    buffer[60]  =    0xcd16cde1;
    buffer[61]  =    0x558b2619;
    buffer[62]  =    0x01b0521a;
    buffer[63]  =    0xe80000bb;
    buffer[64]  =    0xe872003b;
    buffer[65]  =    0x24568a5b;
    buffer[66]  =    0x8b7c0bbe;
    buffer[67]  =    0xf046c7fc;
    buffer[68]  =    0x46c77d3d;
    buffer[69]  =    0x8c7d29f4;
    buffer[70]  =    0xf24e89d9;
    buffer[71]  =    0xc6f64e89;
    buffer[72]  =    0xcb7d9606;
    buffer[73]  =    0x000003ea;
    buffer[74]  =    0xc8b60f20;
    buffer[75]  =    0xf8468b66;
    buffer[76]  =    0x1c460366;
    buffer[77]  =    0x66d08b66;
    buffer[78]  =    0xeb10eac1;
    buffer[79]  =    0xc8b60f5e;
    buffer[80]  =    0x468a4a4a;
    buffer[81]  =    0xf7e4320d;
    buffer[82]  =    0xfc4603e2;
    buffer[83]  =    0xebfe5613;
    buffer[84]  =    0x0650524a;
    buffer[85]  =    0x6a016a53;
    buffer[86]  =    0x468b9110;
    buffer[87]  =    0x33929618;
    buffer[88]  =    0x91f6f7d2;
    buffer[89]  =    0x8742f6f7;
    buffer[90]  =    0x1a76f7ca;
    buffer[91]  =    0xe88af28a;
    buffer[92]  =    0x0a02ccc0;
    buffer[93]  =    0x0201b8cc;
    buffer[94]  =    0x0e027e80;
    buffer[95]  =    0x42b40475;
    buffer[96]  =    0x568af48b;
    buffer[97]  =    0x6113cd24;
    buffer[98]  =    0x400b7261;
    buffer[99]  =    0x03420175;
    buffer[100] =    0x75490b5e;
    buffer[101] =    0x41c3f806;
    buffer[102] =    0x600000bb;
    buffer[103] =    0xeb006a66;
    buffer[104] =    0x4c544eb0;
    buffer[105] =    0x20205244;
    buffer[106] =    0x20202020;
    buffer[107] =    0x544e0a0d;
    buffer[108] =    0x2052444c;
    buffer[109] =    0x6d207369;
    buffer[110] =    0x69737369;
    buffer[111] =    0x0dff676e;
    buffer[112] =    0x7369440a;
    buffer[113] =    0x7265206b;
    buffer[114] =    0xff726f72;
    buffer[115] =    0x72500a0d;
    buffer[116] =    0x20737365;
    buffer[117] =    0x20796e61;
    buffer[118] =    0x2079656b;
    buffer[119] =    0x72206f74;
    buffer[120] =    0x61747365;
    buffer[121] =    0x0a0d7472;
    buffer[122] =    0x00000000;
    buffer[123] =    0x00000000;
    buffer[124] =    0x00000000;
    buffer[125] =    0x00000000;
    buffer[126] =    0xac000000;
    buffer[127] =    0xaa55ccbf;
}

