#include <config.h>
#include <common.h>
//#include <command.h>
#include <asm/arch/net.h>
#include <asm/arch/hardware.h>
#include <asm/arch/vic.h>

#define TX_DESC_CNT     (CONFIG_SYS_RX_ETH_BUFFER)	/* Allocated Tx descriptors */
#define RX_DESC_CNT     (CONFIG_SYS_RX_ETH_BUFFER)	/* Allocated Rx descriptors */
#define TX_BUFSIZE		(0x600)	/* Tx buffer data size */
#define RX_BUFSIZE		(0x600)	/* Rx buffer data size */
#define DEFAULT_INT		(ETH_INT_TRCMP|ETH_INT_ABNRML|ETH_INT_TXCMP|ETH_INT_RXCMP|ETH_INT_TXPROCSTP| \
					ETH_INT_RXPROCSTP|ETH_INT_TXUNDERF|ETH_INT_RXOVERF|ETH_INT_TXUNAVAIL|\
					ETH_INT_RXUNAVAIL|ETH_INT_SBE|ETH_INT_LSC)

#define ALIGN4				(0x3)

static volatile pETHERNETCON eth0;
static volatile peth_tx_descript ptxd;
static volatile peth_rx_descript prxd;
static u32 rx_head, rx_tail;	// Index of RX buffer

/*--------------------------------------------------------------
 * Ethernet interrupt service routine.
 */
void eth_isr(void)
{
	u32 rlt = 0, i = 0;

	net_trace();

	//Get interrupt status
	rlt = eth0->ETHECSR5;
	//Clean interrupt status
	eth0->ETHECSR5 = rlt;
	/* Disable all interrupt in CR7 to solve the interrupt edge problem */
	eth0->ETHECSR7 = 0;

	//Scan interrupt status
	for (; i < 12; i++) {
		if (rlt & ETH_INT_TXCMP) {
			//printf("ETH transmit complete \r\n");
			rlt &= ~(ETH_INT_TXCMP);
		} else if (rlt & ETH_INT_RXCMP) {
			//printf("ETH receive complete \r\n");
			rx_tail++;
			rx_tail %= RX_DESC_CNT;
			rlt &= ~(ETH_INT_RXCMP);
			//printf("eth_rx rx_head=%x rx_tail=%x\r\n",rx_head,rx_tail);   
		} else if (rlt & ETH_INT_TXPROCSTP) {
			//printf("ETH transmit process stop \r\n");
			rlt &= ~(ETH_INT_TXPROCSTP);
		} else if (rlt & ETH_INT_RXPROCSTP) {
			//printf("ETH receive process stop \r\n");
			rlt &= ~(ETH_INT_RXPROCSTP);
		} else if (rlt & ETH_INT_TXUNDERF) {
			//printf("ETH transmit underflow \r\n");
			rlt &= ~(ETH_INT_TXUNDERF);
		} else if (rlt & ETH_INT_RXOVERF) {
			//printf("ETH receive overflow \r\n");
			rlt &= ~(ETH_INT_RXOVERF);
		} else if (rlt & ETH_INT_TXUNAVAIL) {
			//printf("ETH transmit descriptor unavailable \r\n");
			rlt &= ~(ETH_INT_TXUNAVAIL);
		} else if (rlt & ETH_INT_RXUNAVAIL) {
			//printf("ETH receive descriptor unavailable \r\n");
			rlt &= ~(ETH_INT_RXUNAVAIL);
		} else if (rlt & ETH_INT_SBE) {
			//printf("ETH system bus error \r\n");
			rlt &= ~(ETH_INT_SBE);
		} else if (rlt & ETH_INT_LSC) {
			//printf("ETH link status change \r\n");
			rlt &= ~(ETH_INT_LSC);
		}
	}

	// Release interrupt mask
	eth0->ETHECSR7 = (DEFAULT_INT);
}

/*--------------------------------------------------
 * Init TX data descriptor , RX data descriptor
 * Step1: Allocate TX RX descriptor.
 * Step2: Allocate TX RX buffer.
 * Step3: Set up TX RX descriptor chain.
 * bd: Include mac address.
 */
static void init_txrx_descriptor(bd_t * bd)
{
	u32 i = 0;
	u32 *l;
	u8 *txb, *rxb;
	peth_tx_descript j;
	peth_rx_descript k;
	/* Bob add */
	char env_enetaddr[6];
	char *tmp, *end;


	net_trace();
	/*
	 * Get the mac address from env
	 */
	tmp = getenv("ethaddr");
	if (tmp) {
		for (i=0; i<6; i++) {
			env_enetaddr[i] = tmp ? simple_strtoul(tmp, &end, 16) : 0;
			if (tmp)
				tmp = (*end) ? end+1 : end;
		}
	}

	//Allocate TX RX descriptor.
	//ptxd = (eth_tx_descript *)malloc(sizeof(eth_tx_descript)*(TX_DESC_CNT+1));
	ptxd = (eth_tx_descript *) (CONFIG_A1_NET_DMABADD);

	i = (u32) ptxd;
	//Align 4 bytes
	i += ALIGN4;
	i &= ~ALIGN4;
	ptxd = (eth_tx_descript *) i;
	eth0->ETHECSR3 = i;

	//prxd = (eth_rx_descript *)malloc(sizeof(eth_rx_descript)*(RX_DESC_CNT+1));    
	prxd =
		(eth_rx_descript *) (CONFIG_A1_NET_DMABADD +
							 sizeof(eth_tx_descript) * (TX_DESC_CNT + 1));
	i = (u32) prxd;
	//Align 4 bytes
	i += ALIGN4;
	i &= ~ALIGN4;
	prxd = (eth_rx_descript *) i;
	eth0->ETHECSR4 = i;

	//Allocate TX RX Buffers
	//txb = (u8  *)malloc(TX_BUFSIZE*(TX_DESC_CNT+1));
	txb = ((u8 *) prxd + sizeof(eth_rx_descript) * (RX_DESC_CNT + 1));
	i = (u32) txb;
	//Align 4 bytes
	i += ALIGN4;
	i &= ~ALIGN4;
	txb = (u8 *) i;

	//rxb = malloc(RX_BUFSIZE*(RX_DESC_CNT+1));
	rxb = ((u8 *) txb + TX_BUFSIZE * (TX_DESC_CNT + 1));
	i = (u32) rxb;
	//Align 4 bytes
	i += ALIGN4;
	i &= ~ALIGN4;
	rxb = (u8 *) i;

//	printf("txb:%x rxb:%x prxd:%x ptxd:%x \r\n", (u32) txb, (u32) rxb,
//		   (u32) prxd, (u32) ptxd);

	//set up descriptors
	i = TX_DESC_CNT;
	j = ptxd;
	k = prxd;

	// Make chain loop
	for (; i != 0; i--) {
		j->_tdes0.stdes0.own = ETH_RX_OWNBY_HOST;
		j->_tdes1.stdes1.fci = 0x1;	//Enable frame completion interrupt.
		j->_tdes1.stdes1.ls = 0x0;	//Last segment.
		j->_tdes1.stdes1.fs = 0x0;	//First segment.
		j->_tdes1.stdes1.ft = ETH_TX_PF;	//Setup perfect filter.
		j->_tdes1.stdes1.sf = 0x0;	//Setup frame.
		j->_tdes1.stdes1.acd = 0x0;	//Append CRC disable.
		j->_tdes1.stdes1.erd = 0x1;	//Descriptor pointer has reached its final descriptor.
		j->_tdes1.stdes1.ce = 0x1;	//Descriptor chain enable.
		j->_tdes1.stdes1.pd = 0x0;	//Auto padding      
		j->_tdes1.stdes1.tbs2_size = 0x0;
		j->_tdes1.stdes1.tbs1_size = 0x0;

		j->ba = (u32) txb;
		if (i != 0x1)
			j->nda = (u32) (j + 1);
		else
			j->nda = (u32) ptxd;

		txb += TX_BUFSIZE;
		j = (peth_tx_descript) j->nda;
	}

	i = RX_DESC_CNT;
	for (; i != 0; i--) {
		k->_rdes0.srdes0.own = ETH_RX_OWNBY_ME;
		k->_rdes1.srdes1.rbs1_size = (RX_BUFSIZE);
		k->_rdes1.srdes1.ce = 1;	//Descriptor chain enable.
		k->ba = (u32) rxb;
		k->nda = (u32) (k + 1);

		if (i != 0x1)
			k->nda = (u32) (k + 1);
		else
			k->nda = (u32) prxd;

		rxb += RX_BUFSIZE;
		k = (peth_rx_descript) k->nda;
	}

	//Init setup frame.
	ptxd[0]._tdes0.stdes0.own = ETH_RX_OWNBY_ME;
	ptxd[0]._tdes1.stdes1.sf = 0x1;
	ptxd[0]._tdes1.stdes1.tbs1_size = 0xc0;
	l = (u32 *) ptxd[0].ba;

	/* 
	 * Following comment out was bad, hard-coded mac address
	 */
//	//Insert unicast address
//	*l = *((u16 *) & bd->bi_enetaddr[0]);
//	l++;
//	*l = *((u16 *) & bd->bi_enetaddr[2]);
//	l++;
//	*l = *((u16 *) & bd->bi_enetaddr[4]);
//	l++;
	
	/* Replace it with value get from env */
	*l = *((u16 *) & env_enetaddr[0]);
	l++;
	*l = *((u16 *) & env_enetaddr[2]);
	l++;
	*l = *((u16 *) & env_enetaddr[4]);
	l++;


	/* broadcast address */
	*l = 0xffff;
	l++;
	*l = 0xffff;
	l++;
	*l = 0xffff;
	l++;

	/* Set Multicast address */
	for (; i < 14; i++) {
		*l = 0x8001;
		l++;
		*l = 0x00c2;
		l++;
		*l = 0x0100;
		l++;
	}

	//Current Transmit descriptor point to next.
	ptxd = (peth_tx_descript) ptxd->nda;

}

/*------------------------------------------------------
 *	Read one bit phy data from PHY controller
 */

static u16 phy_read_1bit(void)
{
	u32 i = 0;
	u16 phy_data;

	eth0->ETHECSR9 = ETH_CSR9_MRWS | ETH_CSR9_MDC;

	//Delay
	i = 0x1000;
	for (; i != 0;)
		i--;

	phy_data = (eth0->ETHECSR9 >> 7) & 0x1;
	eth0->ETHECSR9 = ETH_CSR9_MRWS;

	//Delay
	i = 0x1000;
	for (; i != 0;)
		i--;

	return phy_data;
}

/* -------------------------------------------------
 *	Write one bit data to Phy Controller
 */
static void phy_write_1bit(phy_data data)
{
	u32 j = 0;

	//MII Clock Low 
	eth0->ETHECSR9 = (data == phy_bit1) ? ETH_CSR9_MDO : 0;

	//Delay
	j = 0x100;
	for (; j != 0;)
		j--;

	//MII Clock High
	eth0->ETHECSR9 =
		(data == phy_bit1) ? (ETH_CSR9_MDO | ETH_CSR9_MDC) : ETH_CSR9_MDC;

	//Delay
	j = 0x100;
	for (; j != 0;)
		j--;

	//MII Clock Low
	eth0->ETHECSR9 = (data == phy_bit1) ? ETH_CSR9_MDO : 0;

	//Delay
	j = 0x100;
	for (; j != 0;)
		j--;
}

/*-------------------------------------------------------------------------------
 *	Write a word to Phy register by serial interface(1'bit interface)
 */
#if 0
static void phy_write(u8 regadd, u16 phy_data)
{
	u16 i = 0;

	/* Send 33 synchronization clock to Phy controller */
	for (i = 0; i < 32; i++)
		phy_write_1bit(phy_bit1);

	/* Send start command(01) to Phy */
	phy_write_1bit(phy_bit0);
	phy_write_1bit(phy_bit1);

	/* Send write command(01) to Phy */
	phy_write_1bit(phy_bit0);
	phy_write_1bit(phy_bit1);

	/* Send Phy addres */
	for (i = 0x10; i > 0; i = i >> 1)
		phy_write_1bit(A1_ETH_PHYADD & i ? phy_bit1 : phy_bit0);

	/* Send register addres */
	for (i = 0x10; i > 0; i = i >> 1)
		phy_write_1bit(regadd & i ? phy_bit1 : phy_bit0);

	/* written trasnition */
	phy_write_1bit(phy_bit1);
	phy_write_1bit(phy_bit0);

	/* Write a word data to PHY controller */
	for (i = 0x8000; i > 0; i >>= 1)
		phy_write_1bit((phy_data & i) ? phy_bit1 : phy_bit0);

}
#endif

/*------------------------------------------------------------------------------
 *	Read a word data from phy register
 */

static u16 phy_read(u8 regadd)
{
	int i;
	u16 phy_data;

	/* Send 33 synchronization clock to Phy controller */
	for (i = 0; i < 32; i++)
		phy_write_1bit(phy_bit1);

	/* Send start command(01) to Phy */
	phy_write_1bit(phy_bit0);
	phy_write_1bit(phy_bit1);

	/* Send read command(10) to Phy */
	phy_write_1bit(phy_bit1);
	phy_write_1bit(phy_bit0);

	/* Send Phy addres */
	for (i = 0x10; i > 0; i = i >> 1)
		phy_write_1bit(A1_ETH_PHYADD & i ? phy_bit1 : phy_bit0);

	/* Send register addres */
	for (i = 0x10; i > 0; i = i >> 1)
		phy_write_1bit(regadd & i ? phy_bit1 : phy_bit0);

	/* Skip transition state */
	phy_read_1bit();

	/* read 16bit data */
	for (phy_data = 0, i = 0; i < 16; i++) {
		phy_data <<= 1;
		phy_data |= phy_read_1bit();
	}

	return phy_data;
}

int eth_init(bd_t * bd)
{
	u32 i = 0x1000;
	u16 lsts = 0;

	net_trace();
	eth0 = (ETHERNETCON *) (A1_ETH_BASE);

	//Reset etnernet.
	eth0->ETHECSR0 = ETH_CSR0_0;
	for (; i != 0;)
		i--;
	eth0->ETHECSR0 &= ~ETH_CSR0_0;

	//Init rx index
	rx_head = 0;
	rx_tail = 0;

	//Init required descriptors.
	init_txrx_descriptor(bd);

	//Init networking operation mode
	eth0->ETHECSR6 = (ETH_CSR6_OPMFD | ETH_CSR6_SFE);

	lsts = phy_read(1);

	printf("eth_init get eth port status:%s \r\n",
		   (lsts & A1_ETH_PHY_LS) ? "Ethernet connected" :
		   "Ethernet not connected");

	//Init interrupt.
	reg_interrupt(USE_IRQ, int_eth110, eth_isr);
	vic_enirq(int_eth110);
	eth0->ETHECSR7 = DEFAULT_INT;

	//Start to transfer and receive
	eth0->ETHECSR6 |= (ETH_CSR6_TXCNTL | ETH_CSR6_RXCNTL);

	return 0;
}

/*--------------------------------------
 * Get a data block via Ethernet 
 */
int eth_rx(void)
{
	u32 rxlen;

	net_trace();
	if (rx_head == rx_tail) {
		rxlen = 0;
		goto err;
	}

	rxlen = prxd[rx_head]._rdes0.srdes0.fl;
	//Transfer control handler to Mercury
	prxd[rx_head]._rdes0.srdes0.own = ETH_RX_OWNBY_ME;

	memcpy((void *) NetRxPackets[0], (void *) prxd[rx_head].ba,
		   (int) rxlen);
	rx_head++;
	rx_head %= RX_DESC_CNT;

	/* Pass the packet up to the protocol layers. */
	NetReceive(NetRxPackets[0], rxlen);

  err:
	return rxlen;
}

/*-------------------------------------
 * Send a data block via Ethernet. 
 */
int eth_send(volatile void *packet, int length)
{

	net_trace();
	memcpy((void *) ptxd->ba, (void *) packet, length);

	ptxd->_tdes1.stdes1.tbs1_size = (length & 0x7ff);	//Only valid of 11 bits
	ptxd->_tdes0.stdes0.own = ETH_RX_OWNBY_ME;
	ptxd->_tdes1.stdes1.sf = 0x0;	//Disable Start frame
	ptxd->_tdes1.stdes1.fci = 0x1;	//Enable
	ptxd->_tdes1.stdes1.ls = 0x1;	//Enable
	ptxd->_tdes1.stdes1.fs = 0x1;	//Enable

	//Current Transmit descriptor point to next.
	ptxd = (peth_tx_descript) ptxd->nda;
	ptxd->_tdes0.stdes0.own = ETH_RX_OWNBY_HOST;	//Next control handle was on Host

	eth0->ETHECSR1 = ETH_CSR1_TXPOLL;	// TX poll demand.

	return 0;
}

/*-------------------------------------
 * Stop ethernet. 
 */
void eth_halt(void)
{
	printf("eth_halt \r\n");
	eth0->ETHECSR6 &= ~(ETH_CSR6_TXCNTL | ETH_CSR6_RXCNTL);

}
