/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <h264encapi.h>

#include "encasiccontroller.h"
#include "H264Instance.h"


extern void printf(const char *fmt, ...);


void H264DumpMirrorRegs(H264EncInst inst)
{
	unsigned int i;
	h264Instance_s* pEncInst = (h264Instance_s*)inst;
	regValues_s* val = &pEncInst->asic.regs;

	printf("Registers of Mirrored H.264 registers:\n");
	for (i = 1; i <= 62; ++i) {
		printf("Reg#%02u: 0x%08x\n", i, val->regMirror[i]);
	}
}

void H264CompareReg(H264EncInst inst, unsigned int index)
{
	u32 v;
	h264Instance_s* pEncInst = (h264Instance_s*)inst;
	regValues_s* val = &pEncInst->asic.regs;

	v = EWLReadReg(pEncInst->asic.ewl, index * 4);
	if (val->regMirror[index] != v) {
		printf("\nH264CompareReg: "
			   "Register#%02d is different. 0x%08x/0x%08x\n",
			   index, v, val->regMirror[index]);
	}
}
