/*------------------------------------------------------------------------------
--                                                                            --
--       This software is confidential and proprietary and may be used        --
--        only as expressly authorized by a licensing agreement from          --
--                                                                            --
--                            Hantro Products Oy.                             --
--                                                                            --
--                   (C) COPYRIGHT 2006 HANTRO PRODUCTS OY                    --
--                            ALL RIGHTS RESERVED                             --
--                                                                            --
--                 The entire notice above must be reproduced                 --
--                  on all copies and should not be removed.                  --
--                                                                            --
--------------------------------------------------------------------------------
--
--  Abstract : Encoder Wrapper Layer for 6280/7280/8270/8290 without interrupts
--
------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
    1. Include headers
------------------------------------------------------------------------------*/

#include "basetype.h"
#include "ewl.h"
#include "ewl_x280_common.h"

//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

//#include <assert.h>
#define assert(...)  /* no assertion */

#ifndef EWL_NO_HW_TIMEOUT
#define EWL_WAIT_HW_TIMEOUT 2   /* HW IRQ timeout in seconds */
#endif

extern volatile u32 asic_status;


/*******************************************************************************
 Function name   : EWLReserveHw
 Description     : Reserve HW resource for currently running codec
*******************************************************************************/
i32 EWLReserveHw(const void *inst)
{
	hx280ewl_t *enc = (hx280ewl_t *) inst;

	assert(enc != NULL);

	PTRACE("EWLReserveHw: HW locked\r\n");

	EWLWriteReg(inst, 0x38, 0);

	return EWL_OK;
}

/*******************************************************************************
 Function name   : EWLWaitHwRdy
 Description     : Wait for the encoder semaphore
 Return type     : i32
 Argument        : void
*******************************************************************************/
i32 EWLWaitHwRdy(const void *inst)
{
	unsigned int i;
	volatile u32 irq_stats;
	hx280ewl_t* enc = (hx280ewl_t *) inst;

	i32 ret = EWL_HW_WAIT_TIMEOUT;
	//u32 timeout = 1000;

    assert(enc != NULL);

	PTRACE("EWLWaitHwRdy\r\n");

	irq_stats = EWLReadReg(inst, 0x04);
	PTRACE("IRQ stat %08x\r\n", irq_stats);

	if ((irq_stats & ASIC_STATUS_ALL)) {
        irq_stats &= (~(ASIC_IRQ_LINE));

		EWLWriteReg(inst, 0x04, irq_stats); /* clear IRQ */
        ret = EWL_OK;
    //} else if(timeout) {
	} else {
		int loop = 1;

		do {
			// Have CPU Spin here
			for (i = 0; i < 50; i++) ;

/*
			if (EWLReadReg(inst, 0x08) != 0xd00f) {
				extern void printf(const char *fmt, ...);
				printf("\EWLWaitHwRdy: Register#2 != 0xd00f\n");
			}
*/

            irq_stats = EWLReadReg(inst, 0x04);
			PTRACE("IRQ stat %08x\r\n", irq_stats);

			if ((irq_stats & ASIC_STATUS_ALL)) {
				ret = EWL_HW_WAIT_OK;
				loop = 0;                           // end the polling loop

				irq_stats &= (~ASIC_IRQ_LINE);
				EWLWriteReg(inst, 0x04, irq_stats); // clear IRQ
			}/* else {
				if (EWLReadReg(inst, 0x60) != 0x5eec0) {
					extern void printf(const char *fmt, ...);
					printf("\EWLWaitHwRdy: Register#24 != 0x5eec0\n");
				}
			}*/
		} while (loop);
	}

	asic_status = irq_stats;

	return ret;
}
