/*------------------------------------------------------------------------------
--                                                                            --
--       This software is confidential and proprietary and may be used        --
--        only as expressly authorized by a licensing agreement from          --
--                                                                            --
--                            Hantro Products Oy.                             --
--                                                                            --
--                   (C) COPYRIGHT 2006 HANTRO PRODUCTS OY                    --
--                            ALL RIGHTS RESERVED                             --
--                                                                            --
--                 The entire notice above must be reproduced                 --
--                  on all copies and should not be removed.                  --
--                                                                            --
--------------------------------------------------------------------------------
--
--  Description :  Encoder SW/HW interface register definitions
--
------------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------

    Table of contents

    1. Include headers
    2. External compiler flags
    3. Module defines

------------------------------------------------------------------------------*/
#ifndef ENC_SWHWREGISTERS_H
#define ENC_SWHWREGISTERS_H

/*------------------------------------------------------------------------------
    1. Include headers
------------------------------------------------------------------------------*/

#include "basetype.h"

/*------------------------------------------------------------------------------
    2. External compiler flags
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
    3. Module defines
------------------------------------------------------------------------------*/

#define ASIC_SWREG_AMOUNT               96

#define ASIC_INPUT_YUV420PLANAR         0x00
#define ASIC_INPUT_YUV420SEMIPLANAR     0x01
#define ASIC_INPUT_YUYV422INTERLEAVED   0x02
#define ASIC_INPUT_UYVY422INTERLEAVED   0x03
#define ASIC_INPUT_RGB565               0x04
#define ASIC_INPUT_RGB555               0x05
#define ASIC_INPUT_RGB444               0x06
#define ASIC_INPUT_RGB888               0x07
#define ASIC_INPUT_RGB101010            0x08

/* HW Register field names */
typedef enum {
    HEncProductID,
    HEncProductMajor,
    HEncProductMinor,
    HEncProductBuild,

    HEncAXIWriteID,
    HEncAXIReadID,
    HEncIRQInt,
    HEncIRQTest1,
    HEncIRQTest2,
    HEncIRQBuffer,
    HEncIRQReset,
    HEncIRQBusError,
    HEncIRQFrameReady,
    HEncIRQDisable,
    HEncIRQ,

    HEncOutputSwap16,
    HEncInputSwap16,
    HEncBurstLength,
    HEncBurstDisable,
    HEncBurstIncr,
    HEncDataDiscard,
    HEncClockGating,
    HEncOutputSwap32,
    HEncInputSwap32,
    HEncOutputSwap8,
    HEncInputSwap8,

    HEncTestCounter,
    HEncTestLength,
    HEncTestMem,
    HEncTestReg,
    HEncTestIrq,

    HEncBaseStream,
    HEncBaseControl,
    HEncBaseRefLum,
    HEncBaseRefChr,
    HEncBaseRecLum,
    HEncBaseRecChr,
    HEncBaseInLum,
    HEncBaseInCb,
    HEncBaseInCr,

    HEncIntTimeout,
    HEncMvWrite,
    HEncNalMode,
    HEncWidth,
    HEncHeight,
    HEncStartOffset,
    HEncPictureType,
    HEncEncodingMode,
    HEncEnable,

    HEncChrOffset,
    HEncLumOffset,
    HEncRowLength,
    HEncXFill,
    HEncYFill,
    HEncInputFormat,
    HEncInputRot,

    HEncPicInitQp,
    HEncSliceAlpha,
    HEncSliceBeta,
    HEncChromaQp,
    HEncSliceSize,
    HEncDeblocking,
    HEncIdrPicId,
    HEncConstrIP,

    HEncPPSID,
    HEncIPPrevModeFavor,
    HEncIPIntra16Favor,

    HEncDisableQPMV,
    HEncTransform8x8,
    HEncCabacInitIdc,
    HEncCabacEnable,
    HEncInter4Restrict,
    HEncStreamMode,
    HEncFrameNum,

    HEncJpegMode,
    HEncJpegSlice,
    HEncJpegRSTInt,
    HEncJpegRST,

    HEncSkipPenalty,
    HEncInterFavor,

    HEncDMVPenalty,
    HEncDMVPenalty4p,

    HEncStrmHdrRem1,
    HEncStrmHdrRem2,

    HEncStrmBufLimit,

    HEncMadQpDelta,
    HEncMadThreshold,
    HEncQpSum,

    HEncQp,
    HEncMaxQp,
    HEncMinQp,
    HEncCPDist,

    HEncCP1WordTarget,
    HEncCP2WordTarget,
    HEncCP3WordTarget,
    HEncCP4WordTarget,
    HEncCP5WordTarget,
    HEncCP6WordTarget,
    HEncCP7WordTarget,
    HEncCP8WordTarget,
    HEncCP9WordTarget,
    HEncCP10WordTarget,

    HEncCPWordError1,
    HEncCPWordError2,
    HEncCPWordError3,
    HEncCPWordError4,
    HEncCPWordError5,
    HEncCPWordError6,

    HEncCPDeltaQp1,
    HEncCPDeltaQp2,
    HEncCPDeltaQp3,
    HEncCPDeltaQp4,
    HEncCPDeltaQp5,
    HEncCPDeltaQp6,
    HEncCPDeltaQp7,

    HEncRlcSum,
    HEncMadCount,
    HEncMbCount,

    HEncBaseNextLum,

    HEncStabMode,
    HEncStabMotionSum,

    HEncStabMinimum,
    HEncStabGmvX,
    HEncStabGmvY,

    HEncStabMatrix1,
    HEncStabMatrix2,
    HEncStabMatrix3,
    HEncStabMatrix4,
    HEncStabMatrix5,
    HEncStabMatrix6,
    HEncStabMatrix7,
    HEncStabMatrix8,
    HEncStabMatrix9,

    HEncBaseCabacCtx,
    HEncBaseMvWrite,

    HEncRGBCoeffA,
    HEncRGBCoeffB,
    HEncRGBCoeffC,
    HEncRGBCoeffE,
    HEncRGBCoeffF,

    HEncRMaskMSB,
    HEncGMaskMSB,
    HEncBMaskMSB,

    HEncIntraAreaLeft,
    HEncIntraAreaRight,
    HEncIntraAreaTop,
    HEncIntraAreaBottom,

    HEncCirStart,
    HEncCirInterval,

    HEncIntraSliceMap1,
    HEncIntraSliceMap2,

    HEncRoi1Left,
    HEncRoi1Right,
    HEncRoi1Top,
    HEncRoi1Bottom,

    HEncRoi2Left,
    HEncRoi2Right,
    HEncRoi2Top,
    HEncRoi2Bottom,

    HEncRoi1DeltaQp,
    HEncRoi2DeltaQp,

    HEncHWSearchArea,
    HEncHWRgbSupport,
    HEncHWH264Support,
    HEncHWMpeg4Support,
    HEncHWJpegSupport,
    HEncHWStabSupport,
    HEncHWBus,
    HEncHWSynthesisLan,
    HEncHWBusWidth,
    HEncHWMaxVideoWidth,

    HEncJpegQuantLuma1,
    HEncJpegQuantLuma2,
    HEncJpegQuantLuma3,
    HEncJpegQuantLuma4,
    HEncJpegQuantLuma5,
    HEncJpegQuantLuma6,
    HEncJpegQuantLuma7,
    HEncJpegQuantLuma8,
    HEncJpegQuantLuma9,
    HEncJpegQuantLuma10,
    HEncJpegQuantLuma11,
    HEncJpegQuantLuma12,
    HEncJpegQuantLuma13,
    HEncJpegQuantLuma14,
    HEncJpegQuantLuma15,
    HEncJpegQuantLuma16,

    HEncJpegQuantChroma1,
    HEncJpegQuantChroma2,
    HEncJpegQuantChroma3,
    HEncJpegQuantChroma4,
    HEncJpegQuantChroma5,
    HEncJpegQuantChroma6,
    HEncJpegQuantChroma7,
    HEncJpegQuantChroma8,
    HEncJpegQuantChroma9,
    HEncJpegQuantChroma10,
    HEncJpegQuantChroma11,
    HEncJpegQuantChroma12,
    HEncJpegQuantChroma13,
    HEncJpegQuantChroma14,
    HEncJpegQuantChroma15,
    HEncJpegQuantChroma16

} regName;

/* HW Register field descriptions */
typedef struct {
    i32 base;               /* Register base address  */
    i32 msb;                /* MSB for this field [31..0] */
    i32 lsb;                /* LSB for this field [31..0] */
    regName name;           /* Enumerated field name */
    i32 trace;              /* Enable/disable writing in swreg_params.trc */
    char *description;      /* Field description */
} regField_s;

/* NOTE: Don't use ',' in descriptions, because it is used as separator in csv
 * parsing. */
static const regField_s asicRegisterDesc[] = {
/* HW ID register, read-only */
    {0x00, 31, 16, HEncProductID,       0, "Product ID"},
    {0x00, 15, 12, HEncProductMajor,    0, "Major number"},
    {0x00, 11,  4, HEncProductMinor,    0, "Minor number"},
    {0x00,  3,  0, HEncProductBuild,    0, "Build number defined in synthesis."},

/* Encoder interrupt register */
    {0x04,  7,  7, HEncIRQTest1,        0, "IRQ test 2 status bit. Memory coherency test."},
    {0x04,  6,  6, HEncIRQTest2,        0, "IRQ test 1 status bit. Interrupt test."},
    {0x04,  5,  5, HEncIRQBuffer,       0, "IRQ buffer full status bit. HW waiting for new buffer."},
    {0x04,  4,  4, HEncIRQReset,        0, "IRQ SW reset status bit."},
    {0x04,  3,  3, HEncIRQBusError,     0, "IRQ bus error or timeout status bit."},
    {0x04,  2,  2, HEncIRQFrameReady,   0, "IRQ frame ready status bit. Encoder has finished a frame."},
    {0x04,  1,  1, HEncIRQDisable,      0, "IRQ disable. No interrupts from HW. SW must use polling."},
    {0x04,  0,  0, HEncIRQ,             0, "HINTenc Interrupt from HW. SW resets at IRQ handler."},

/* Encoder configuration register */
    {0x08, 31, 24, HEncAXIWriteID,      0, "AXI Write ID"},
    {0x08, 23, 16, HEncAXIReadID,       0, "AXI Read ID"},
    {0x08, 15, 15, HEncOutputSwap16,    0, "Enable output swap 16-bits"},
    {0x08, 14, 14, HEncInputSwap16,     0, "Enable input swap 16-bits"},
    {0x08, 13,  8, HEncBurstLength,     0, "Burst length. 0=incremental. 4=max BURST4.8=max BURST8. 16=max BURST16"},
    {0x08,  7,  7, HEncBurstDisable,    0, "Disable burst mode for AXI"},
    {0x08,  6,  6, HEncBurstIncr,       0, "Burst incremental. 1=INCR burst allowed. 0=use SINGLE burst"},
    {0x08,  5,  5, HEncDataDiscard,     0, "Enable burst data discard. 2 or 3 long reads are using BURST4"},
    {0x08,  4,  4, HEncClockGating,     0, "Enable clock gating"},
    {0x08,  3,  3, HEncOutputSwap32,    0, "Enable output swap 32-bits"},
    {0x08,  2,  2, HEncInputSwap32,     0, "Enable input swap 32-bits"},
    {0x08,  1,  1, HEncOutputSwap8,     0, "Enable output swap 8-bits"},
    {0x08,  0,  0, HEncInputSwap8,      0, "Enable input swap 8-bits"},

    {0x0C, 31, 28, HEncTestCounter,     0, "Test counter"},
    {0x0C, 20,  3, HEncTestLength,      0, "Test data length for memory test"},
    {0x0C,  2,  2, HEncTestMem,         0, "Enable memory coherency test. Reads BaseStream. Writes BaseControl"},
    {0x0C,  1,  1, HEncTestReg,         0, "Enable register coherency test. Increments test counter"},
    {0x0C,  0,  0, HEncTestIrq,         0, "Enable IRQ test. HW gives interrupt"},

/* External memory base addresses for encoder input/output */
    {0x14, 31,  0, HEncBaseStream,      0, "Base address for output stream data"},
    {0x18, 31,  0, HEncBaseControl,     0, "Base address for output control data"},
    {0x1C, 31,  0, HEncBaseRefLum,      0, "Base address for reference luma"},
    {0x20, 31,  0, HEncBaseRefChr,      0, "Base address for reference chroma"},
    {0x24, 31,  0, HEncBaseRecLum,      0, "Base address for reconstructed luma"},
    {0x28, 31,  0, HEncBaseRecChr,      0, "Base address for reconstructed chroma"},
    {0x2C, 31,  0, HEncBaseInLum,       0, "Base address for input picture luma"},
    {0x30, 31,  0, HEncBaseInCb,        0, "Base address for input picture cb"},
    {0x34, 31,  0, HEncBaseInCr,        0, "Base address for input picture cr"},

/* Common encoder control parameters */
    {0x38, 31, 31, HEncIntTimeout,      0, "Enable interrupt for timeout"},
    {0x38, 30, 30, HEncMvWrite,         1, "Enable writing MV and SAD of each MB to BaseMvWrite"},
    {0x38, 29, 29, HEncNalMode,         1, "Enable writing size of each NAL unit to BaseControl, nalSizeWriteOut"},
    {0x38, 27, 19, HEncWidth,           1, "Encoded width. lumWidth (macroblocks) H264:[6..255] JPEG:[6..511]"},
    {0x38, 18, 10, HEncHeight,          1, "Encoded height. lumHeight (macroblocks) H264:[6..255] JPEG:[2..511]"},
    {0x38,  3,  3, HEncPictureType,     1, "Encoded picture type. frameType. 0=INTER, 1=INTRA(IDR)"},
    {0x38,  2,  1, HEncEncodingMode,    1, "Encoding mode. streamType. 2=JPEG. 3=H264"},
    {0x38,  0,  0, HEncEnable,          0, "Encoder enable"},

    {0x3C, 31, 29, HEncChrOffset,       0, "Input chrominance offset (bytes) [0..7]"},
    {0x3C, 28, 26, HEncLumOffset,       0, "Input luminance offset (bytes) [0..7]"},
    {0x3C, 25, 12, HEncRowLength,       1, "Input luminance row length. lumWidthSrc (bytes) [96..8192]"},
    {0x3C, 11, 10, HEncXFill,           0, "Overfill pixels on right edge of image div4 [0..3]"},
    {0x3C,  9,  6, HEncYFill,           1, "Overfill pixels on bottom edge of image. YFill. [0..15]"},
    {0x3C,  5,  2, HEncInputFormat,     1, "Input image format. inputFormat. YUV420P/YUV420SP/YUYV422/UYVY422/RGB565/RGB555/RGB444/RGB888/RGB101010"},
    {0x3C,  1,  0, HEncInputRot,        1, "Input image rotation. 0=disabled. 1=90degrees right. 2=90 degrees left"},

/* H.264 control parameters */
    {0x40, 31, 26, HEncPicInitQp,       0, "H.264 Pic init qp in PPS [0..51]"},
    {0x40, 25, 22, HEncSliceAlpha,      0, "H.264 Slice filter alpha c0 offset div2 [-6..6]"},
    {0x40, 21, 18, HEncSliceBeta,       0, "H.264 Slice filter beta offset div2 [-6..6]"},
    {0x40, 17, 13, HEncChromaQp,        0, "H.264 Chroma qp index offset [-12..12]"},
    {0x40,  6,  5, HEncDeblocking,      0, "H.264 Deblocking filter mode. 0=enabled. 1=disabled. 2=disabled on slice borders"},
    {0x40,  4,  1, HEncIdrPicId,        0, "H.264 IDR picture ID"},
    {0x40,  0,  0, HEncConstrIP,        1, "H.264 Constrained intra prediction enable. constIntraPred"},

    {0x44, 31, 24, HEncPPSID,           0, "H.264 pic_parameter_set_id"},
    {0x44, 23, 16, HEncIPPrevModeFavor, 0, "H.264 Intra prediction previous 4x4 mode favor"},
    {0x44, 15,  0, HEncIPIntra16Favor,  0, "H.264 Intra prediction intra 16x16 mode favor"},

    {0x48, 29, 23, HEncSliceSize,       1, "H.264 Slice size. mbRowPerSlice (mb rows) [0..127] 0=one slice per picture"},
    {0x48, 22, 22, HEncDisableQPMV,     1, "H.264 Disable quarter pixel MVs. disableQuarterPixelMv"},
    {0x48, 21, 21, HEncTransform8x8,    1, "H.264 Transform 8x8 enable. High Profile H.264, transform8x8Mode"},
    {0x48, 20, 19, HEncCabacInitIdc,    0, "H.264 CABAC initial IDC. [0..2]"},
    {0x48, 18, 18, HEncCabacEnable,     1, "H.264 CABAC enable. entropyCodingMode. 0=CAVLC (Baseline Profile H.264). 1=CABAC (Main Profile H.264)"},
    {0x48, 17, 17, HEncInter4Restrict,  1, "H.264 Inter 4x4 mode restriction. restricted4x4Mode"},
    {0x48, 16, 16, HEncStreamMode,      1, "H.264 Stream mode. byteStream. 0=NAL unit stream. 1=Byte stream"},
    {0x48, 15,  0, HEncFrameNum,        0, "H.264 Frame num"},

    {0x4C, 19, 10, HEncDMVPenalty4p,    1, "H.264 Differential MV penalty for 4p ME. DMVPenalty4p"},
    {0x4C,  9,  0, HEncDMVPenalty,      1, "H.264 Differential MV penalty for 1p/qp ME. DMVPenalty1p"},

/* JPEG control parameters */
    {0x50, 25, 25, HEncJpegMode,        0, "JPEG mode. 0=4:2:0 (4lum+2chr blocks/MCU). 1=4:2:2 (2lum+2chr blocks/MCU)"},
    {0x50, 24, 24, HEncJpegSlice,       0, "JPEG slice enable. 0=picture ends with EOI. 1=slice ends with RST"},
    {0x50, 23, 16, HEncJpegRSTInt,      0, "JPEG restart marker interval when slices are disabled (mb rows) [0..255]"},
    {0x50, 15,  0, HEncJpegRST,         0, "JPEG restart marker for first RST. incremented by HW for next RST"},

    {0x54, 31, 24, HEncSkipPenalty,     0, "H.264 SKIP macroblock mode penalty"},
    {0x54, 15,  0, HEncInterFavor,      0, "H.264 Inter MB mode favor in intra/inter selection"},

    {0x58, 31,  0, HEncStrmHdrRem1,     0, "Stream header remainder bits MSB (MSB aligned)"},
    {0x5C, 31,  0, HEncStrmHdrRem2,     0, "Stream header remainder bits LSB (MSB aligned)"},

    {0x60, 31,  0, HEncStrmBufLimit,    1, "Stream buffer limit (64bit addresses) / output stream size (bits), HWStreamDataCount. If limit is reached buffer full IRQ is given."},

    {0x64, 31, 28, HEncMadQpDelta,      1, "MAD based QP adjustment, madQpChange [-8..7]"},
    {0x64, 27, 22, HEncMadThreshold,    0, "MAD threshold div256"},
    {0x64, 20,  0, HEncQpSum,           0, "QP Sum div2 output"},

    {0x6C, 31, 26, HEncQp,              1, "Initial QP. qpLum [0..51]"},
    {0x6C, 25, 20, HEncMaxQp,           1, "Maximum QP. qpMax [0..51]"},
    {0x6C, 19, 14, HEncMinQp,           1, "Minimum QP. qpMin [0..51]"},
    {0x6C, 12,  0, HEncCPDist,          0, "Checkpoint distance (mb) 0=disabled [0..8191]"},

/* H.264 Macroblock rate control checkpoints */
    {0x70, 31, 16, HEncCP1WordTarget,   0, "Checkpoint 1 word target/usage div32 [0..65535]"},
    {0x70, 15,  0, HEncCP2WordTarget,   0, "Checkpoint 2 word target/usage div32 [0..65535]"},

    {0x74, 31, 16, HEncCP3WordTarget,   0, "Checkpoint 3 word target/usage div32 [0..65535]"},
    {0x74, 15,  0, HEncCP4WordTarget,   0, "Checkpoint 4 word target/usage div32 [0..65535]"},

    {0x78, 31, 16, HEncCP5WordTarget,   0, "Checkpoint 5 word target/usage div32 [0..65535]"},
    {0x78, 15,  0, HEncCP6WordTarget,   0, "Checkpoint 6 word target/usage div32 [0..65535]"},

    {0x7C, 31, 16, HEncCP7WordTarget,   0, "Checkpoint 7 word target/usage div32 [0..65535]"},
    {0x7C, 15,  0, HEncCP8WordTarget,   0, "Checkpoint 8 word target/usage div32 [0..65535]"},

    {0x80, 31, 16, HEncCP9WordTarget,   0, "Checkpoint 9 word target/usage div32 [0..65535]"},
    {0x80, 15,  0, HEncCP10WordTarget,  0, "Checkpoint 10 word target/usage div32 [0..65535]"},

    {0x84, 31, 16, HEncCPWordError1,    0, "Checkpoint word error 1 div4 [-32768..32767]"},
    {0x84, 15,  0, HEncCPWordError2,    0, "Checkpoint word error 2 div4 [-32768..32767]"},

    {0x88, 31, 16, HEncCPWordError3,    0, "Checkpoint word error 3 div4 [-32768..32767]"},
    {0x88, 15,  0, HEncCPWordError4,    0, "Checkpoint word error 4 div4 [-32768..32767]"},

    {0x8C, 31, 16, HEncCPWordError5,    0, "Checkpoint word error 5 div4 [-32768..32767]"},
    {0x8C, 15,  0, HEncCPWordError6,    0, "Checkpoint word error 6 div4 [-32768..32767]"},

    {0x90, 27, 24, HEncCPDeltaQp1,      0, "Checkpoint delta QP 1 [-8..7]"},
    {0x90, 23, 20, HEncCPDeltaQp2,      0, "Checkpoint delta QP 2 [-8..7]"},
    {0x90, 19, 16, HEncCPDeltaQp3,      0, "Checkpoint delta QP 3 [-8..7]"},
    {0x90, 15, 12, HEncCPDeltaQp4,      0, "Checkpoint delta QP 4 [-8..7]"},
    {0x90, 11,  8, HEncCPDeltaQp5,      0, "Checkpoint delta QP 5 [-8..7]"},
    {0x90,  7,  4, HEncCPDeltaQp6,      0, "Checkpoint delta QP 6 [-8..7]"},
    {0x90,  3,  0, HEncCPDeltaQp7,      0, "Checkpoint delta QP 7 [-8..7]"},

    {0x94, 28, 23, HEncStartOffset,     0, "Stream start offset = amount of StrmHdrRem (bits) [0..63]"},
    {0x94, 22,  0, HEncRlcSum,          0, "RLC codeword count div4 output. max 255*255*384/4"},

    {0x98, 31, 16, HEncMadCount,        0, "Macroblock count with MAD value under threshold output"},
    {0x98, 15,  0, HEncMbCount,         0, "MB count output. max 255*255"},

/* Stabilization parameters and outputs */
    {0x9C, 31,  0, HEncBaseNextLum,     0, "Base address for next pic luminance"},

    {0xA0, 31, 30, HEncStabMode,        1, "Stabilization mode. 0=disabled. 1=stab only. 2=stab+encode"},
    {0xA0, 23,  0, HEncStabMinimum,     0, "Stabilization minimum value output. max 253*253*255"},

    {0xA4, 31,  0, HEncStabMotionSum,   0, "Stabilization motion sum div8 output. max 253*253*255*1089/8"},

    {0xA8, 31, 26, HEncStabGmvX,        0, "Stabilization GMV horizontal output [-16..16]"},
    {0xA8, 23,  0, HEncStabMatrix1,     0, "Stabilization matrix 1 (up-left position) output"},
    {0xAC, 31, 26, HEncStabGmvY,        0, "Stabilization GMV vertical output [-16..16]"},
    {0xAC, 23,  0, HEncStabMatrix2,     0, "Stabilization matrix 2 (up position) output"},
    {0xB0, 23,  0, HEncStabMatrix3,     0, "Stabilization matrix 3 (up-right position) output"},
    {0xB4, 23,  0, HEncStabMatrix4,     0, "Stabilization matrix 4 (left position) output"},
    {0xB8, 23,  0, HEncStabMatrix5,     0, "Stabilization matrix 5 (GMV position) output"},
    {0xBC, 23,  0, HEncStabMatrix6,     0, "Stabilization matrix 6 (right position) output"},
    {0xC0, 23,  0, HEncStabMatrix7,     0, "Stabilization matrix 7 (down-left position) output"},
    {0xC4, 23,  0, HEncStabMatrix8,     0, "Stabilization matrix 8 (down position) output"},
    {0xC8, 23,  0, HEncStabMatrix9,     0, "Stabilization matrix 9 (down-right position) output"},

    {0xCC, 31,  0, HEncBaseCabacCtx,    0, "Base address for cabac context tables"},

    {0xD0, 31,  0, HEncBaseMvWrite,     0, "Base address for MV output writing"},

/* Pre-processor color conversion parameters */
    {0xD4, 31, 16, HEncRGBCoeffB,       0, "RGB to YUV conversion coefficient B"},
    {0xD4, 15,  0, HEncRGBCoeffA,       0, "RGB to YUV conversion coefficient A"},

    {0xD8, 31, 16, HEncRGBCoeffE,       0, "RGB to YUV conversion coefficient E"},
    {0xD8, 15,  0, HEncRGBCoeffC,       0, "RGB to YUV conversion coefficient C"},

    {0xDC, 30, 26, HEncBMaskMSB,        0, "RGB B-component mask MSB bit position [0..31]"},
    {0xDC, 25, 21, HEncGMaskMSB,        0, "RGB G-component mask MSB bit position [0..31]"},
    {0xDC, 20, 16, HEncRMaskMSB,        0, "RGB R-component mask MSB bit position [0..31]"},
    {0xDC, 15,  0, HEncRGBCoeffF,       0, "RGB to YUV conversion coefficient F"},

/* Macroblock intra-mode forcing parameters */
    {0xE0, 31, 24, HEncIntraAreaLeft,   0, "Intra area left mb column (inside area) [0..255]"},
    {0xE0, 23, 16, HEncIntraAreaRight,  0, "Intra area right mb column (outside area) [0..255]"},
    {0xE0, 15,  8, HEncIntraAreaTop,    0, "Intra area top mb row (inside area) [0..255]"},
    {0xE0,  7,  0, HEncIntraAreaBottom, 0, "Intra area bottom mb row (outside area) [0..255]"},

    {0xE4, 31, 16, HEncCirStart,        0, "CIR first intra mb. 0=disabled [0..65535]"},
    {0xE4, 15,  0, HEncCirInterval,     0, "CIR intra mb interval. 0=disabled [0..65535]"},

    {0xE8, 31,  0, HEncIntraSliceMap1,  0, "Intra slice bit map for slices 0..31. MSB=slice0. LSB=slice31"},
    {0xEC, 31,  0, HEncIntraSliceMap2,  0, "Intra slice bit map for slices 32..63. MSB=slice32. LSB=slice63"},

/* Region-of-interest parameters */
    {0xF0, 31, 24, HEncRoi1Left,        0, "1st ROI area left mb column (inside area) qp+=Roi1DeltaQp"},
    {0xF0, 23, 16, HEncRoi1Right,       0, "1st ROI area right mb column (outside area) qp-=Roi1DeltaQp"},
    {0xF0, 15,  8, HEncRoi1Top,         0, "1st ROI area top mb row (inside area) qp+=Roi1DeltaQp"},
    {0xF0,  7,  0, HEncRoi1Bottom,      0, "1st ROI area bottom mb row (outside area) qp-=Roi1DeltaQp"},

    {0xF4, 31, 24, HEncRoi2Left,        0, "2nd ROI area left mb column (inside area) qp+=Roi2DeltaQp"},
    {0xF4, 23, 16, HEncRoi2Right,       0, "2nd ROI area right mb column (outside area) qp-=Roi2DeltaQp"},
    {0xF4, 15,  8, HEncRoi2Top,         0, "2nd ROI area top mb row (inside area) qp+=Roi2DeltaQp"},
    {0xF4,  7,  0, HEncRoi2Bottom,      0, "2nd ROI area bottom mb row (outside area) qp-=Roi2DeltaQp"},

    {0xF8,  7,  4, HEncRoi1DeltaQp,     0, "1st ROI area delta QP [-15..0]"},
    {0xF8,  3,  0, HEncRoi2DeltaQp,     0, "2nd ROI area delta QP [-15..0]"},

/* HW synthesis config register, read-only */
    {0xFC, 29, 29, HEncHWSearchArea,    0, "HW search area height. 0=5 MB rows. 1=3 MB rows"},
    {0xFC, 28, 28, HEncHWRgbSupport,    0, "RGB to YUV conversion supported by HW. 0=not supported. 1=supported"},
    {0xFC, 27, 27, HEncHWH264Support,   0, "H.264 encoding supported by HW. 0=not supported. 1=supported"},
    {0xFC, 26, 26, HEncHWMpeg4Support,  0, "MPEG-4 encoding supported by HW. 0=not supported. 1=supported"},
    {0xFC, 25, 25, HEncHWJpegSupport,   0, "JPEG encoding supported by HW. 0=not supported. 1=supported"},
    {0xFC, 24, 24, HEncHWStabSupport,   0, "Stabilization supported by HW. 0=not supported. 1=supported"},
    {0xFC, 23, 20, HEncHWBus,           0, "Bus connection of HW. 1=AHB. 2=OCP. 3=AXI. 4=PCI"},
    {0xFC, 19, 16, HEncHWSynthesisLan,  0, "Synthesis language. 1=vhdl. 2=verilog"},
    {0xFC, 15, 12, HEncHWBusWidth,      0, "Bus width of HW. 0=32b. 1=64b. 2=128b"},
    {0xFC, 11,  0, HEncHWMaxVideoWidth, 0, "Maximum video width supported by HW (pixels)"},

    {0x100, 31, 0, HEncJpegQuantLuma1,   0, "JPEG luma quantization 1"},
    {0x104, 31, 0, HEncJpegQuantLuma2,   0, "JPEG luma quantization 2"},
    {0x108, 31, 0, HEncJpegQuantLuma3,   0, "JPEG luma quantization 3"},
    {0x10C, 31, 0, HEncJpegQuantLuma4,   0, "JPEG luma quantization 4"},
    {0x110, 31, 0, HEncJpegQuantLuma5,   0, "JPEG luma quantization 5"},
    {0x114, 31, 0, HEncJpegQuantLuma6,   0, "JPEG luma quantization 6"},
    {0x118, 31, 0, HEncJpegQuantLuma7,   0, "JPEG luma quantization 7"},
    {0x11C, 31, 0, HEncJpegQuantLuma8,   0, "JPEG luma quantization 8"},
    {0x120, 31, 0, HEncJpegQuantLuma9,   0, "JPEG luma quantization 9"},
    {0x124, 31, 0, HEncJpegQuantLuma10,  0, "JPEG luma quantization 10"},
    {0x128, 31, 0, HEncJpegQuantLuma11,  0, "JPEG luma quantization 11"},
    {0x12C, 31, 0, HEncJpegQuantLuma12,  0, "JPEG luma quantization 12"},
    {0x130, 31, 0, HEncJpegQuantLuma13,  0, "JPEG luma quantization 13"},
    {0x134, 31, 0, HEncJpegQuantLuma14,  0, "JPEG luma quantization 14"},
    {0x138, 31, 0, HEncJpegQuantLuma15,  0, "JPEG luma quantization 15"},
    {0x13C, 31, 0, HEncJpegQuantLuma16,  0, "JPEG luma quantization 16"},

    {0x140, 31, 0, HEncJpegQuantChroma1,  0, "JPEG chroma quantization 1"},
    {0x144, 31, 0, HEncJpegQuantChroma2,  0, "JPEG chroma quantization 2"},
    {0x148, 31, 0, HEncJpegQuantChroma3,  0, "JPEG chroma quantization 3"},
    {0x14C, 31, 0, HEncJpegQuantChroma4,  0, "JPEG chroma quantization 4"},
    {0x150, 31, 0, HEncJpegQuantChroma5,  0, "JPEG chroma quantization 5"},
    {0x154, 31, 0, HEncJpegQuantChroma6,  0, "JPEG chroma quantization 6"},
    {0x158, 31, 0, HEncJpegQuantChroma7,  0, "JPEG chroma quantization 7"},
    {0x15C, 31, 0, HEncJpegQuantChroma8,  0, "JPEG chroma quantization 8"},
    {0x160, 31, 0, HEncJpegQuantChroma9,  0, "JPEG chroma quantization 9"},
    {0x164, 31, 0, HEncJpegQuantChroma10, 0, "JPEG chroma quantization 10"},
    {0x168, 31, 0, HEncJpegQuantChroma11, 0, "JPEG chroma quantization 11"},
    {0x16C, 31, 0, HEncJpegQuantChroma12, 0, "JPEG chroma quantization 12"},
    {0x170, 31, 0, HEncJpegQuantChroma13, 0, "JPEG chroma quantization 13"},
    {0x174, 31, 0, HEncJpegQuantChroma14, 0, "JPEG chroma quantization 14"},
    {0x178, 31, 0, HEncJpegQuantChroma15, 0, "JPEG chroma quantization 15"},
    {0x17C, 31, 0, HEncJpegQuantChroma16, 0, "JPEG chroma quantization 16"},
};

#endif
