/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>


#include <codec/hx8290/include/h264encapi.h>
#include <codec/hx8290/include/jpegencapi.h>

#include "dosFS.h"
#include "hal.h"
#include "halVcap.h"
#include "10x16font.h"

#define sdbvPrintf_g printf

char sdbvszWorkDir_gi[128];
char sdbvszMdHandle_gi[8];

extern void  dma_memorypool_reset(void);
extern void* dma_memory_alloc(unsigned int size);
extern void  dma_memory_free(void* ptr);

dosBS_Id sdbvnCurMediaHandle_g = (dosBS_Id) 0;

extern void store_osdfont2fontRAM(void);
extern long file_read(const char *filename, void *buffer, unsigned long maxsize);

extern bool_T halSDCardExist(void);
extern bool_T halSDUninstall(void);

extern unsigned int halSDGetCapacity(void);
extern bool_T halSDReadNSector(unsigned int nStartSect, unsigned int nSectNum, void *pBuf);
extern bool_T halSDWriteNSector(unsigned int nStartSect, unsigned int nSectNum, void *pBuf);

static int env_init_flag = FALSE;
static int env_init()
{
	if(env_init_flag == FALSE)
	{
		dma_memorypool_reset();

		sysInitInMain((sysMallocTrap_FT) dma_memory_alloc, (sysFreeTrap_FT) dma_memory_free);

		dosFSInitInMain();
	}
	env_init_flag = TRUE;
}

int do_sdinit(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{

	env_init();

	dosMediaIORoutine_S ioRoutine;

	ioRoutine.getCapacity = halSDGetCapacity;
	ioRoutine.readNSector = halSDReadNSector;
	ioRoutine.writeNSector= halSDWriteNSector;
	ioRoutine.uninstall = halSDUninstall;

	if (sdbvnCurMediaHandle_g)
	{
		dosUninstallMedia(sdbvnCurMediaHandle_g);
		sdbvnCurMediaHandle_g = (dosBS_Id) 0;

		sdbvszMdHandle_gi[0] = '?';
		sdbvszMdHandle_gi[1] = '\0';

		sdbvszWorkDir_gi[0] = '\\';
		sdbvszWorkDir_gi[1] = '\0';
	}

	if (!halSDCardExist())
	{
		sdbvPrintf_g("sd isn't inserted");
		return (FALSE);
	}

	sdbvPrintf_g("SD card exists. Init SD\n\r");
	if (!halSDInstall(halSysGetDeviceClockSrc(CONFIG_SYS_INPUT_CLOCK, HAL_MFP_SDC, NULL)))
	{
		sdbvPrintf_g("fail to install sd driver");
		return (FALSE);
	}
	sdbvPrintf_g("SD card init OK. Init SD file system\n\r");
	if(!(sdbvnCurMediaHandle_g = dosInstallMedia(ioRoutine)))
	{
		sdbvPrintf_g("fail to install sd driver");
		return (FALSE);
	}

	sdbvPrintf_g("file system = %s\r\n", dosGetMediaFS(sdbvnCurMediaHandle_g));
	sdbvPrintf_g("card capacity = %dK\r\n", dosGetMediaCapacity(sdbvnCurMediaHandle_g)/1000);
	sdbvPrintf_g("DATA storage size = %dK\r\n", dosGetMediaDataStorage(sdbvnCurMediaHandle_g)/1000);
	sdbvPrintf_g("free DATA storage size = %dK\r\n", dosGetMediaFreeDataStorage(sdbvnCurMediaHandle_g)/1000);

	sdbvszMdHandle_gi[0] = 's';
	sdbvszMdHandle_gi[1] = 'd';
	sdbvszMdHandle_gi[2] = '\0';

	sdbvszWorkDir_gi[0] = '\\';
	sdbvszWorkDir_gi[1] = '\0';

	return 0;
}

#define sdbIsRootDir_ii(s) (strcmp(s, "\\") ? FALSE : TRUE)

int do_dir(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	dosIter_Id iterFileId;
	dosIterInfo_S *pIterInfo;
	char szPathName[256];			/* iterated directory or file name */
	int nMode;
	int nNumFiles, nNumDirs, nTotalFileSize;

	if (strcmp(argv[0], "ls") == 0)
		nMode = 0;	/* show in wide mode; don't change this magic number 0 */
	else
		nMode = 1;	/* show with file size */

	if (argc > 2)
	{
		printf("Usage:\n\t%s%s", cmdtp->usage, cmdtp->help);
		return FALSE;
	}

	if (argc == 1 ||
		(argc == 2 && (strcmp(".", argv[1]) == 0 || strcmp(".\\", argv[1]) == 0)))
	{
		/* default is the current working directory */
		strcpy(szPathName, sdbvszWorkDir_gi);
	}
	else
	{
		char *szTempName;

		szTempName = dosBeautyFileName(sdbvszWorkDir_gi, argv[1]);
		strcpy(szPathName, szTempName);

		if (sdbIsRootDir_ii(szPathName))
		{
			//nothing to do here; traversing in the following
		}
		else
		{
			bool_T b1, b2;

			b1 = dosFileExist(sdbvnCurMediaHandle_g, szPathName, FALSE);
			b2 = dosFileExist(sdbvnCurMediaHandle_g, szPathName, TRUE);

			if (b1)
			{
				/* dir file_name */

				sdbvPrintf_g("%-16s %d", argv[1],
						dosFileSize(sdbvnCurMediaHandle_g, szPathName));
				return (TRUE);
			}
			else if (b2)
			{
				//nothing to do here; traversing in the following
			}
			else
			{
				sdbvPrintf_g("\"%s\": not found", argv[1]);
				return (FALSE);
			}
		}
	}


	nNumFiles = 0;
	nNumDirs = 0;
	nTotalFileSize = 0;
	iterFileId = dosStartToIterFile(sdbvnCurMediaHandle_g, szPathName, doscIterBoth);
	while ((pIterInfo = dosIterOneFile(iterFileId)) != NULL)
	{
		if (strcmp(pIterInfo->szName, ".") == 0 || strcmp(pIterInfo->szName, "..") == 0)
		{
			continue;
		}

		if (pIterInfo->isDir)
		{
			char kkk[20];

			if (nMode % 4 == 0)
			{
				if (nMode % 16 == 0)
					sdbvPrintf_g("\r\n");

				sprintf(kkk, "[%s]", pIterInfo->szName);
				sdbvPrintf_g("%-16s", kkk);
				nMode += 4;
			}
			else
				sdbvPrintf_g("[%s]\r\n", pIterInfo->szName);

			++nNumDirs;
		}
		else
		{
			if (nMode % 4 == 0)
			{
				if (nMode % 16 == 0)
					sdbvPrintf_g("\r\n");

				sdbvPrintf_g("%-16s", pIterInfo->szName);
				nMode += 4;
			}
			else
				sdbvPrintf_g("%-16s %d\r\n", pIterInfo->szName, pIterInfo->nSize);

			nTotalFileSize += pIterInfo->nSize;
			++nNumFiles;
		}
	}
	dosStopIterFile(iterFileId);

	if (nMode % 4 == 0)
		sdbvPrintf_g("\r\n");

	sdbvPrintf_g("\t%d files\t %d bytes", nNumFiles, nTotalFileSize);
	sdbvPrintf_g("\r\n\t%d directories", nNumDirs);
	sdbvPrintf_g("\r\n");

	return (TRUE);
}

extern void  dma_memorypool_reset(void);
extern void* dma_memory_alloc(unsigned int size);
extern void dma_memory_free(void *ptr);

static void VcapCloseCobra1(int ch_num);
static void VcapEnableFrame(int ch);
static void VcapFreeFrame(int ch, int fb);
static int VcapGetFrame(int ch, char **ybuf, char **uvbuf);
static void VcapInit(char *ch_buf, a1_sdb_vcap_options options, int ch_num);
static int start_jpegenc(unsigned int width, unsigned int height, unsigned char* rawdata_y, unsigned char* rawdata_uv, unsigned char* output);

//------------------------------------------------------------------
// R:20120601 - for PCBA test  --BN--
static int do_vcap_pcba_test(void)
{
	a1_sdb_vcap_options    vcap_options;
	unsigned  int index,   jfifSize;
	unsigned char *ch_buf, *output;
	         char *ybuf,   *uvbuf;
			 int timeout = 500;		//get fail retry times
	
	vcap_options.src_w     = 1288; vcap_options.src_h   = 720;
	vcap_options.ch_w[0]   = 1280; vcap_options.ch_h[0] = 720;
	printf("size = 1288 X 720 \n");

	vcap_options.scaler[0] 		 = 1;
	vcap_options.fps[0]  		 = 30;
	vcap_options.bitPerSecond[0] = 2000000;

	ch_buf = (unsigned char *)dma_memory_alloc(vcap_options.ch_w[0] * vcap_options.ch_h[0] * 1.5 * 4 + 0x800);
	output = (unsigned char *)dma_memory_alloc(vcap_options.ch_w[0] * vcap_options.ch_h[0] * 1.5);

	VcapInit((char *)ch_buf, vcap_options, 0+1);
	
	/* enable capture description */
	VcapEnableFrame(0);
	
	printf("start PCBA test capture 1 video frame to 0x%08x & encode to JPEG file...\n", (unsigned int)ch_buf);
	while(1)
	{
		if(serial_tstc() == 1)	break;// if get key pressed
		
		index = VcapGetFrame(0, (char **)(&ybuf), (char **)(&uvbuf));
		//printf("index =  0x%8.8x \n", index);
		if(index != 0xffffffff)	{
			printf("?\n");
			jfifSize = start_jpegenc(vcap_options.ch_w[0], vcap_options.ch_h[0], ybuf, uvbuf, output);
			printf("JPEG file size(%d Bytes)", jfifSize);
			printf(" done.\n");			
			VcapFreeFrame(0, index);
			break;
		}
		
		//-- get frame fail to do retry --
		if (timeout < 0)  break;
		timeout--;
	
		printf(".");
   		udelay(1000);
	}

	VcapCloseCobra1(0);
	if(ch_buf) dma_memory_free(ch_buf);
	if(output) dma_memory_free(output);

	printf("----------------------------------------------\n");			
	if (timeout < 0)
		return (FALSE);
	else		
		return (TRUE);	
}
//------------------------------------------------------------------

#if 1
int do_vcap(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	a1_sdb_vcap_options vcap_options;
	unsigned int index, jfifSize;
	char *ybuf, *uvbuf;
	unsigned char *ch_buf, *output;
	char *szDstFileName = "test0.jpg";
	dosFile_Id fDstId;
	
    // R:20120606-01 @PCBA_TEST
	if ((argc > 1)&&(strcmp(argv[1], "PCBATEST")==0)) {
		return (do_vcap_pcba_test());
	}
	//
	
	if (!dosCreateFile(sdbvnCurMediaHandle_g, szDstFileName, FALSE))
	{
		sdbvPrintf_g("can't create %s\r\n", szDstFileName);
		return FALSE;
	}
	if(!(fDstId = dosOpenFile(sdbvnCurMediaHandle_g, szDstFileName)))
	{
		sdbvPrintf_g("can't open %s\r\n", szDstFileName);
		return FALSE;
	}

	vcap_options.src_w     = 1288; vcap_options.src_h   = 720;  // must set 1288 X 720
	vcap_options.ch_w[0]   = 1280; vcap_options.ch_h[0] = 720;
	printf("size = 1288 X 720 \n");
//
	vcap_options.scaler[0] = 1;    vcap_options.fps[0]  = 30;
	vcap_options.bitPerSecond[0] = 2000000;

//	dma_memorypool_reset();

	ch_buf = (unsigned char *)dma_memory_alloc(vcap_options.ch_w[0] * vcap_options.ch_h[0] * 1.5 * 4 + 0x800);
	output = (unsigned char *)dma_memory_alloc(vcap_options.ch_w[0] * vcap_options.ch_h[0] * 1.5);

#if 1
	VcapInit((char *)ch_buf, vcap_options, 0+1);

	// enable capture description
	VcapEnableFrame(0);

	printf("start capture 1 video frame to 0x%08x & encode to JPEG file...\n\r", (unsigned int)ch_buf);
	while(1)
	{
		index = VcapGetFrame(0, (char **)(&ybuf), (char **)(&uvbuf));
		if(index != 0xffffffff)
		{
			jfifSize = start_jpegenc(vcap_options.ch_w[0], vcap_options.ch_h[0], ybuf, uvbuf, output);

			printf("Write JPEG file(%d Bytes) to SD Card...", jfifSize);
			if(jfifSize > 0) dosWriteFile(fDstId, output, jfifSize);
			printf("done\n\r");
						
			VcapFreeFrame(0, index);
			break;
		}
		
	}
	
   dosCloseFile(fDstId);
	
	VcapCloseCobra1(0);
#endif
	dma_memory_free(ch_buf);
	dma_memory_free(output);

	return (TRUE);
}

/*********************************/
/* capture control functions */
/*********************************/

static int ch_fb_index[4] = {0,0,0,0};
static void VcapCloseCobra1(int ch_num)
{
	cap_ctrl(0);
}

static void VcapEnableFrame(int ch)
{
	ch_fb_index[ch] = 0;
	HAL_SETREG(HAL_REG_VCAP_CHm_DEST_OWN(ch), 0xF);
}

static void VcapFreeFrame(int ch, int fb)
{
	set_buf_own(ch, fb);
}

static int VcapGetFrame(int ch, char **ybuf, char **uvbuf)
{
	int value, index;
	value = get_buf_own_value(ch, ch_fb_index[ch]);
	if(value == 0)
	{
		index = ch_fb_index[ch];
		*ybuf = (char *)HAL_GETREG(HAL_REG_VCAP_CHm_FBn_DESTY(ch, index));
		*uvbuf = (char *)HAL_GETREG(HAL_REG_VCAP_CHm_FBn_DESTC(ch, index));
		ch_fb_index[ch]++;
		ch_fb_index[ch] %= 4;

		return index;
	}
	return 0xffffffff;
}

static void VcapInit(char *ch_buf, a1_sdb_vcap_options options, int ch_num)
{
	int fb, flag_add_len = 0, ch, buf_size = 0, ch_buf_ptr;
	unsigned int value;
	src_if_t src_if;
	src_size_t src_size;
	src_start_t src_start;
	clip_start_t clip_start;
	clip_size_t clip_size;
	crop_size_t crop_size;
	crop_offset_t crop_offset;

	scaler_t scaler;
	src_blank_t src_blank;
	chn_dma_t chn_dma;
	reg_up_t reg_up;
	lb_ctrl_t lb_ctrl;

	unsigned int y_buf_size;
	unsigned int uv_buf_size;
	unsigned int bufaddr;

	if (vcap_reset()) sdbvPrintf_g("\tVCAP reset failed\n\r");

	halSysInternalISPEnable(1);

	*((int *)&(src_if)) = 0;
	/*Configure bus parameters*/
	src_if.vif_mode = HV_ACTIVE_MODE; /* H/V active mode (progressive only) */
	src_if.vif_link_paral = PARAL;

	src_if.vif_link_swap = 0;
	src_if.vif_blank_chk = 0;
	src_if.vif_ccir_ec = 0;
	src_if.vif_vref_pol = 1;
	src_if.vif_href_pol = 1;
	src_if.vif_isp_gated = 1;
	src_if.vif_ccir_chid = 0; /* It only has effect on TV decoder */
	src_if.vif_pxl_swap = 0x00; /* Y0,Cb0->Y1,Cr0 */
	src_if.vif_ccir_skip = 0; /* (00: no skip, 10: skip even field, 11: skip odd field) */
	src_if.vif_en = 0; 		/* do'nt use it */
	src_if.vif_spare0 = 1;
	src_if.vif_disglitch = 1;

	/*Set source size*/
	src_size.src_w = options.src_w - 1;
	src_size.src_h = options.src_h - 1;
	set_src_size(src_size);

	value = HAL_GETREG(HAL_REG_VCAP_SRC_SIZE);
	//sdbvPrintf_g("\tsrc_reg = 0x%08X\n\r", value);

	/*Set Source H/V start*/
	//ted useless in active mode	src_start.src_hstart = 2;
	//ted useless in active mode	src_start.src_vstart	= 1;

	set_src_start(src_start);
	/* Set Clip start */
	clip_start.swc_x = 0; clip_start.swc_y = 0; set_clip_start(clip_start);
	/* Set Clip size */
	clip_size.swc_w = src_size.src_w; clip_size.swc_h = src_size.src_h; set_clip_size(clip_size);
	/* Enable Clip */
	HAL_SETREG(0x90b00300, 0x00000001);

	/* SRC Blank */
	src_blank.hblank = 0;
	src_blank.vblank = 0;
	set_src_blank(src_blank);

	ch_buf_ptr = (( ((unsigned int)(ch_buf) ) / 0x100) + 1) * 0x100;
	for(ch = 0; ch < ch_num; ch++)
	{
		if(options.scaler[ch] == 1)
		{
			scaler.en =1;
			scaler.src_w = options.src_w; scaler.src_h = options.src_h;
			scaler.out_w = options.ch_w[ch]; scaler.out_h = options.ch_h[ch];
			set_scaler(ch, scaler);
		}
		/* Set Crop offset */
		crop_offset.crop_x = 0; crop_offset.crop_y = 0; set_crop_offset(ch, crop_offset);
		/* Set Crop size */
		crop_size.crop_w = options.ch_w[ch] - 1; crop_size.crop_h = options.ch_h[ch] -1; set_crop_size(ch, crop_size);

		y_buf_size = (options.ch_w[ch] * options.ch_h[ch]/0x100 + 1)*0x100;
		uv_buf_size = (options.ch_w[ch] * options.ch_h[ch]/2/0x100 + 1)*0x100;;

		for(fb = 0; fb < 4; fb++)
		{
			set_ybuf_addr(ch, fb, ch_buf_ptr);
			ch_buf_ptr += y_buf_size;
			set_uvbuf_addr(ch, fb, ch_buf_ptr);
			ch_buf_ptr += uv_buf_size;
		}

		unmask_int(FM_START_INT(ch));
		unmask_int(FM_END_INT(ch));
		unmask_int(FD_INT(ch));

		HAL_SETREG(HAL_REG_VCAP_INT_MASK_SET, 0x00000FFF);

		write_int_sts_clr(FM_START_INT(ch));
		write_int_sts_clr(FM_END_INT(ch));
		write_int_sts_clr(FD_INT(ch));

		//set frame rate control
		cfg_frc_ctl(ch, options.fps[ch]);

		/**Configure DMA buffer */
		*(int *)&(chn_dma) = 0;
		chn_dma.wlen = chn_dma.rlen = 16 -1;
		chn_dma.dmaw_en = chn_dma.dmar_en = 1;
		chn_dma.dmar_wm = 0;
		chn_dma.fb0_en = chn_dma.fb1_en = chn_dma.fb2_en = chn_dma.fb3_en = 1;
		set_channel_dma(ch, chn_dma);
	}

	/* line buffer controll,  bit 0, 0x1 => 1 ch; 0xf=> 4ch */
	//HAL_SETREG(0x90b00520, 0x00002081);
	*((int *)&(lb_ctrl)) = 0;
	lb_ctrl.lb_en = 1;
	lb_ctrl.vif_err_en = 1;
	lb_ctrl.lb_mode = 2;
	set_lb_ctrl(lb_ctrl);

	set_src_if(src_if);
	set_vif_enable(0xf); // enable 4 ch

	reg_update();
	HAL_SETREG(0x90b0000c, 1); // update register immediately
	cap_ctrl(1);
}
#endif



static void _init_encoder_config(JpegEncCfg* pCfg, unsigned int width, unsigned int height);
static int  _open_jpeg_encoder(JpegEncCfg* pCfg, JpegEncInst * pEnc);
static int  _allocate_resources(JpegEncInst* pEnc, JpegEncCfg* pCfg, JpegEncIn* pEncIn, JpegEncOut* pEncOut, unsigned char* rawdata_y, unsigned char* rawdata_uv, unsigned char* output);
static int  _start_jpeg_encode(JpegEncInst * pEnc, JpegEncIn* pEncIn, JpegEncOut* pEncOut);


static int start_jpegenc(unsigned int width, unsigned int height, unsigned char* rawdata_y, unsigned char* rawdata_uv, unsigned char* output)
{
	int rc;
	JpegEncInst encoder;
	JpegEncCfg config;
	JpegEncIn encIn;
	JpegEncOut encOut;
	unsigned int jfifSize;

	printf("Encoding JPEG frame(%ux%u) from: y=0x%08x uv=0x%08x to 0x%08x\n", width, height, (unsigned int)rawdata_y, (unsigned int)rawdata_uv, (unsigned int)output);

	memset(&encoder, 0, sizeof(encoder));
	memset(&config,  0, sizeof(config));
	memset(&encIn,   0, sizeof(encIn));
	memset(&encOut,  0, sizeof(encOut));

	//
	// Test case: JPEG encoding
	//

	// Step 1: Initial encoder
	_init_encoder_config(&config, width, height);
	rc = _open_jpeg_encoder(&config, &encoder);
	if (rc != 0) {
		printf("Failed to open JPEG encoder\n");
		goto error;
	}

	// Step 2: Allocate resource
	rc = _allocate_resources(&encoder, &config, &encIn, &encOut, rawdata_y, rawdata_uv, output);
	if (rc != 0) {
		printf("Failed to open allocate resources for JPEG encoder\n");
		goto error;
	}

	// Step 3: Encode a frame
	rc = _start_jpeg_encode(&encoder, &encIn, &encOut);
	if (rc != 0) goto error;

	printf("JPEG encoded at 0x%08x(%u bytes)\n", (unsigned int)encIn.pOutBuf, encOut.jfifSize);
	jfifSize = encOut.jfifSize;

	JpegEncRelease(encoder);

	return jfifSize;

error:
	printf("Failed to encode a JPEG frame\n");

	return 0;
}


static void _init_encoder_config(JpegEncCfg* pCfg,
								 unsigned int width, unsigned int height)
{
	pCfg->qLevel = 8;
	pCfg->frameType = JPEGENC_YUV420_PLANAR;
	pCfg->markerType = JPEGENC_SINGLE_MARKER;
	pCfg->unitsType = JPEGENC_DOTS_PER_INCH;
	pCfg->xDensity = 72;
	pCfg->yDensity = 72;
	pCfg->inputWidth = width;
	pCfg->inputHeight = height;
	pCfg->codingWidth = width;
	pCfg->codingHeight = height;
	pCfg->xOffset = 0;
	pCfg->yOffset = 0;
	pCfg->rotation = JPEGENC_ROTATE_0;
	pCfg->codingType = JPEGENC_WHOLE_FRAME;
	pCfg->restartInterval = 0;
}

static int  _open_jpeg_encoder(JpegEncCfg* pCfg, JpegEncInst * pEnc)
{
	JpegEncRet ret;

	if ((ret = JpegEncInit(pCfg, pEnc)) != JPEGENC_OK) {
		return -1;
	}

	return 0;
}

static int  _allocate_resources(JpegEncInst* pEnc, JpegEncCfg* pCfg,
								JpegEncIn* pEncIn, JpegEncOut* pEncOut,
								unsigned char* rawdata_y, unsigned char*rawdata_uv, unsigned char* output)
{

	size_t outbufSize = pCfg->inputWidth * pCfg->inputHeight;
	unsigned int lumaSize = pCfg->inputWidth * pCfg->inputHeight;
	unsigned int chromaSize = pCfg->inputWidth * pCfg->inputHeight / 4;

	memset(output, 0, outbufSize);

	/* Setup encoder input */
	pEncIn->pOutBuf = (u8*)output;
	pEncIn->busOutBuf = (u32)output;
	pEncIn->outBufSize = outbufSize;
	pEncIn->frameHeader = 1;

	/* Set Full Resolution mode */
	if (JpegEncSetPictureSize(*pEnc, pCfg) != JPEGENC_OK) return 1;

	/* Bus addresses of input picture, used by hardware encoder */
	pEncIn->busLum = (u32)rawdata_y;
	pEncIn->busCb  = (u32)(rawdata_uv);
	pEncIn->busCr  = (u32)(rawdata_uv + chromaSize);

	/* Virtual addresses of input picture, used by software encoder */
	pEncIn->pLum   = rawdata_y;
	pEncIn->pCb    = rawdata_uv;
	pEncIn->pCr    = rawdata_uv + chromaSize;

	return 0;
}

static int  _start_jpeg_encode(JpegEncInst * pEnc,
								JpegEncIn* pEncIn, JpegEncOut* pEncOut)
{
	int ret;

	ret = JpegEncEncode(*pEnc, pEncIn, pEncOut);

	return (ret == JPEGENC_FRAME_READY) ? 0 : 1;
}


#if 1
U_BOOT_CMD(
	vcap,	CONFIG_SYS_MAXARGS,	0,	do_vcap,
	"capture frame and encode YUV420 frames into JPEG",
	"\n"

);
#endif
U_BOOT_CMD(
	sdinit,	CONFIG_SYS_MAXARGS,	0,	do_sdinit,
	"init sd file system",
	"\n"

);

U_BOOT_CMD(
	dir,	CONFIG_SYS_MAXARGS,	0,	do_dir,
	"display directory or filename",
	"[directory or filename]\n"
);
