/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>

#include <json.h>


static char* _pattern =
"{\n"
"	'encoders': [\n"
"		{\n"
"			'input':          '../sd/hx8290_testdata/vga-test.yuv',\n"
"			'output':         'vga-test-01.h264',\n"
"			'lastPic':        30,\n"
"			'inputWidth':     640,\n"
"			'inputHeight':    480,\n"
"			'outputWidth':    640,\n"
"			'outputHeight':   480,\n"
"			'xOffset':        0,\n"
"			'yOffset':        0,\n"
"			'inputRateNumer': 30,\n"
"			'inputRateDenom': 1,\n"
"			'level':          40,\n"
"			'hrdConformance': 0,\n"
"			'intraPicRate':   30,\n"
"			'qpHdr':          26,\n"
"			'qpMin':          10,\n"
"			'qpMax':          51,\n"
"			'bitPerSecond':   1000000,\n"
"			'picRc':          1,\n"
"			'mbRc':           1,\n"
"			'picSkip':        0,\n"
"			'rotation':       0,\n"
"			'inputFormat':    0,\n"
"			'chromaQpOffset': 2,\n"
"			'trans8x8':       0,\n"
"			'enableCabac':    0,\n"
"			'quarterPixelMv': 1,\n"
"			'byteStream':     1,\n"
"			'intraQpDelta':   -3,\n"
"			'fixedIntraQp':   0,\n"
"			'mbQpAdjustment': 0,\n"
"			'mvOutput':       0\n"
"		}\n"
"	]\n"
"}";


static void _read_int_property(struct json_object* obj, char* field, int* val)
{
	struct json_object* property;

	property = json_object_object_get(obj, field);
	if (property != NULL &&
		json_object_get_type(property) == json_type_int)
	{
		*val = json_object_get_int(property);
		//printf("Property: %s = %d\n", field, *val);
	} else {
		*val = -999;
	}
}

static void _read_str_property(struct json_object* obj, char* field, char** val)
{
	struct json_object* property;

	property = json_object_object_get(obj, field);
	if (property != NULL &&
		json_object_get_type(property) == json_type_string)
	{
		*val = json_object_get_string(property);
	} else {
		*val = "invalid";
	}
}

int do_json_test4(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	int value;
	char* string;
	struct json_object* object;
	struct json_object* property;

	printf("Input pattern: %s\n\n", _pattern);

	object = json_tokener_parse(_pattern);

	property = json_object_object_get(object, "encoders");
	if (property == NULL ||
		json_object_get_type(property) != json_type_array)
	{
		printf("Type of 'encoders' is not array\n");
		goto house_keeping;
	}
	printf("  Count of encoders: %d\n", json_object_array_length(property));

	property = json_object_array_get_idx(property, 0);

	#define READ_STR_PROPERTY(prop) \
	_read_str_property(property, prop, &string); \
	printf("    %s: %s\n", prop, string);

	#define READ_INT_PROPERTY(prop) \
	_read_int_property(property, prop, &value); \
	printf("    %s: %d\n", prop, value);

	READ_STR_PROPERTY("input");
	READ_STR_PROPERTY("output");
	READ_INT_PROPERTY("lastPic");
	READ_INT_PROPERTY("inputWidth");
	READ_INT_PROPERTY("inputHeight");
	READ_INT_PROPERTY("outputWidth");
	READ_INT_PROPERTY("outputHeight");
	READ_INT_PROPERTY("xOffset");
	READ_INT_PROPERTY("yOffset");
	READ_INT_PROPERTY("inputRateNumer");
	READ_INT_PROPERTY("inputRateDenom");
	READ_INT_PROPERTY("level");
	READ_INT_PROPERTY("hrdConformance");
	READ_INT_PROPERTY("intraPicRate");
	READ_INT_PROPERTY("qpHdr");
	READ_INT_PROPERTY("qpMin");
	READ_INT_PROPERTY("qpMax");
	READ_INT_PROPERTY("bitPerSecond");
	READ_INT_PROPERTY("picRc");
	READ_INT_PROPERTY("mbRc");
	READ_INT_PROPERTY("picSkip");
	READ_INT_PROPERTY("rotation");
	READ_INT_PROPERTY("inputFormat");
	READ_INT_PROPERTY("chromaQpOffset");
	READ_INT_PROPERTY("trans8x8");
	READ_INT_PROPERTY("enableCabac");
	READ_INT_PROPERTY("quarterPixelMv");
	READ_INT_PROPERTY("byteStream");
	READ_INT_PROPERTY("intraQpDelta");
	READ_INT_PROPERTY("fixedIntraQp");
	READ_INT_PROPERTY("mbQpAdjustment");
	READ_INT_PROPERTY("mvOutput");

house_keeping:
	json_object_put(object);

	extern void dma_pool_info(void);
	//dma_pool_info();

	return 0;
}


U_BOOT_CMD (
	json_test4, CONFIG_SYS_MAXARGS, 0, do_json_test4,
	"json_test4 - Selftest for json-c\n",
	"\n"
	"	- json_test4"
);
