/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>


#ifdef HAL_GETREG32
	#undefine HAL_GETREG32
#endif
#ifdef HAL_SETREG32
	#undefine HAL_SETREG32
#endif


#define HAL_GETREG32(r)	  (*((volatile unsigned int*)(r)))
#define HAL_SETREG32(r,v) (*((volatile unsigned int*)(r)) = ((unsigned int)(v)))


static char* _progress      = "|/-\\";
static unsigned int _mirror[] =
{
	0x00000000, 0x0000D00F, 0x00000000, 0x00000000,
	0x57607100, 0x575FB100, 0x572FDF00, 0x574FC000,
	0x57000D00, 0x571FEE00, 0x5A000000, 0x5A1FA400,
	0x5A278D00, 0xA3C1100E, 0x00780200, 0x68004000,
	0x001B009A, 0x00660000, 0x0000701D, 0x00000000,
	0x28000098, 0x00000000, 0x00000000, 0x0005EEC0,
	0x01800000, 0x00000000, 0x5F3282E5, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x575FB300, 0x00000000,
	0x962B4C85, 0x90901D50, 0x0000B694, 0x78784444,
	0x00000000, 0x00000000, 0x00000000, 0x78784444,
	0x78784444, 0x00000000,
};

enum {
	REG_MIRROR_BASE = 0x99200004,
	REG_MIRROR_SIZE = sizeof(_mirror) / sizeof(unsigned int),
};

int do_hx8290_regtest(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int i, j;
	unsigned int value;

	unsigned int p = 0;

	while (1) {
		for (i = 0; i < REG_MIRROR_SIZE; ++i) {
			HAL_SETREG32(REG_MIRROR_BASE + i * 4, _mirror[i]);

			for (j = 0; j < i; ++j) {
				value = HAL_GETREG32(REG_MIRROR_BASE + j * 4);
				if (value != _mirror[j]) {
					printf("\nRegister#%02u is altered at #%02u\n", j, i);
				}
			}
		}

		printf("%u %c\r", p, _progress[p & 0x3]); ++p;
	}

	return 0;
}


U_BOOT_CMD (
	hx8290_regtest,	CONFIG_SYS_MAXARGS,	0,	do_hx8290_regtest,
	"hx8290_regtest - Access test for HX8290\n",
	"hx8290_regtest\n"
);
