/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>


#ifdef HAL_GETREG32
	#undefine HAL_GETREG32
#endif
#ifdef HAL_SETREG32
	#undefine HAL_SETREG32
#endif


#define HAL_GETREG32(r)	  (*((volatile unsigned int*)(r)))
#define HAL_SETREG32(r,v) (*((volatile unsigned int*)(r)) = ((unsigned int)(v)))


int do_hx8290_idle(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int j = 0;
	unsigned int i = 0;
	unsigned int v = 0;
	char progress[4] = "|/-\\";

	HAL_SETREG32(0x99200000 + 0x4 * 2,  0x0000d00f);
	HAL_SETREG32(0x99200000 + 0x4 * 24, 0x0005eec0);

	while (1) {
		v = HAL_GETREG32(0x99200000 + 0x4 * 2);
		if (v != 0x0000d00f) {
			printf("Register#)2 != 0x0000d00f. Actual: %u\n", v);
		}

		v = HAL_GETREG32(0x99200000 + 0x4 * 24);
		if (v != 0x0005eec0) {
			printf("Register#24 != 0x0005eec0. Actual: %u\n", v);
		}

		printf("%c\r", progress[i & 0x3]);

		// Have CPU spin a while.
		for (j = 0; j < 100000; ++j) ;

		++i;
	}

	return 0;
}


U_BOOT_CMD (
	hx8290_idle,	CONFIG_SYS_MAXARGS,	0,	do_hx8290_idle,
	"hx8290_idle - Make hx8290 idel\n",
	"hx8290_idle\n"
);
