/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>

#include <codec/hx8290/access.h>
#include <codec/hx8290/source/common/enccfg.h>


#define HX8290_REG_BASE 0x99200000

enum
{
	HX8290_REG_ID           = (HX8290_REG_BASE + 0x00),
	HX8290_REG_IRQ          = (HX8290_REG_BASE + 0x04),
	HX8290_REG_DEV_CFG      = (HX8290_REG_BASE + 0x08),
	HX8290_REG_TEST         = (HX8290_REG_BASE + 0x0C),
	HX8290_REG_INT_INTERVAL = (HX8290_REG_BASE + 0x10),
	HX8290_REG_OUTPUT_DATA  = (HX8290_REG_BASE + 0x14),
	HX8290_REG_OUTPUT_CTRL  = (HX8290_REG_BASE + 0x18),
	HX8290_REG_REF_PIC_LUM  = (HX8290_REG_BASE + 0x1C),
	HX8290_REG_REF_PIC_CHR  = (HX8290_REG_BASE + 0x20),
	HX8290_REG_NEW_PIC_LUM  = (HX8290_REG_BASE + 0x24)
};

enum
{
	HX8290_IRQ_REG_INTERVAL    = (0x1 << 8),
	HX8290_IRQ_REG_MEM_TEST    = (0x1 << 7),
	HX8290_IRQ_REG_IRQ_TEST    = (0x1 << 6),
	HX8290_IRQ_REG_STREAM_FULL = (0x1 << 5),
	HX8290_IRQ_REG_REST        = (0x1 << 4),
	HX8290_IRQ_REG_ERROR       = (0x1 << 3),
	HX8290_IRQ_REG_FRAME_OK    = (0x1 << 2),
	HX8290_IRQ_REG_INT_DISABLE = (0x1 << 1),
	HX8290_IRQ_REG_HINT        = 0x1
};

enum
{
	HX8290_TEST_REG_COUNTER  = 0xF0000000,
	HX8290_TEST_REG_DATA_LEN = 0x001FFFF8,
	HX8290_TEST_REG_TEST_MEM = (0x1 << 2),
	HX8290_TEST_REG_TEST_REG = (0x1 << 1),
	HX8290_TEST_REG_TEST_IRQ = 0x1
};


static void EncAsicControllerInit()
{
	HAL_SETREG32(HX8290_REG_DEV_CFG,
				 ((ENC8290_AXI_WRITE_ID & (255)) << 24) |
				 ((ENC8290_AXI_READ_ID & (255)) << 16) |
				 ((ENC8290_OUTPUT_SWAP_16 & (1)) << 15) |
				 ((ENC8290_BURST_LENGTH & (63)) << 8) |
				 ((ENC8290_BURST_INCR_TYPE_ENABLED & (1)) << 6) |
				 ((ENC8290_BURST_DATA_DISCARD_ENABLED & (1)) << 5) |
				 ((ENC8290_ASIC_CLOCK_GATING_ENABLED & (1)) << 4) |
				 ((ENC8290_OUTPUT_SWAP_32 & (0)) << 3) |
				 ((ENC8290_OUTPUT_SWAP_8 & (0)) << 1));
}

static char* ROLLER = "|/-\\";

int do_hx8290_dmatest(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	unsigned int i              = 0;
	unsigned int irq_status     = 0x0;
	unsigned int bytes_left     = 1024 * 1024 * 32;
	unsigned int bytes_moved    = 0;
	unsigned int start_address  = 0x50000000;
	unsigned int output_address = 0x59000000;
	unsigned int data_length    = 1024;

	EncAsicControllerInit();

	if (argc == 5) {
		start_address  = (unsigned char*)simple_strtoul(argv[1], NULL, 16);
		output_address = (unsigned char*)simple_strtoul(argv[2], NULL, 16);
		bytes_left     = simple_strtoul(argv[3], NULL, 10) * 1024 * 1024;
		data_length    = simple_strtoul(argv[4], NULL, 10) * 1024 / 8;
	}

	while (bytes_left > 0) {
		printf("%8u bytes moved. %8u bytes left. %c\r",
			   bytes_moved, bytes_left, ROLLER[i & 0x3]);
		++i;

		HAL_SETREG32(HX8290_REG_IRQ, 0x0);
		HAL_SETREG32(HX8290_REG_TEST, 0x0);

		HAL_SETREG32(HX8290_REG_OUTPUT_DATA, start_address + bytes_moved);
		HAL_SETREG32(HX8290_REG_OUTPUT_CTRL, output_address + bytes_moved);
		HAL_SETREG32(HX8290_REG_TEST,
					 HX8290_TEST_REG_TEST_MEM | (data_length/* 8K bytes */ << 3));

		//while ((irq_status = HAL_GETREG32(HX8290_REG_IRQ)) == 0x0) {
		while (((irq_status = HAL_GETREG32(HX8290_REG_IRQ)) & HX8290_IRQ_REG_HINT) == 0) {
			// Waiting for the interrupt
		}

		//if (irq_status != (HX8290_IRQ_REG_MEM_TEST | HX8290_IRQ_REG_HINT)) {
		if ((irq_status & (HX8290_IRQ_REG_MEM_TEST | HX8290_IRQ_REG_HINT)) !=
			(HX8290_IRQ_REG_MEM_TEST | HX8290_IRQ_REG_HINT))
		{
			printf("\nDMA test for HX8290 is failed(0x%08x).\n", irq_status);
			printf("%8u bytes moved. %8u bytes left.\n", bytes_moved, bytes_left);
			break;
		} else {
			//printf("\nDMA test for HX8290 is successed(0x%08x).\n", irq_status);
			bytes_left -= data_length * 8;
			bytes_moved += data_length * 8;
		}
	}
	if (bytes_left == 0) printf("\nTotoal %u Bytes moved at this DMA test.\n", bytes_moved);

	return 0;
}


U_BOOT_CMD(
	hx8290_dmatest,	CONFIG_SYS_MAXARGS,	0,	do_hx8290_dmatest,
	"hx8290_dmatest - Performing DMA test of HX8290\n",
	"hx8290_dmatest [from] [to] [length(MBytes)] [blockSize(KBytes)]\n"
);
