/*******************************************************************************
 (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

 All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
 Redistribution and use in source and binary forms, with or
 without modification, are strictly prohibited.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#include <common.h>
#include <command.h>


#ifdef HAL_GETREG32
	#undefine HAL_GETREG32
#endif
#ifdef HAL_SETREG32
	#undefine HAL_SETREG32
#endif


#define HAL_GETREG32(r)	  (*((volatile unsigned int*)(r)))
#define HAL_SETREG32(r,v) (*((volatile unsigned int*)(r)) = ((unsigned int)(v)))


#define ASIC_STATUS_IRQ_INTERVAL        0x100
#define ASIC_STATUS_TEST_COPY_RDY       0x80
#define ASIC_STATUS_TEST_IRQ            0x40
#define ASIC_STATUS_BUFF_FULL           0x20
#define ASIC_STATUS_RESET               0x10
#define ASIC_STATUS_ERROR               0x08
#define ASIC_STATUS_FRAME_READY         0x04
#define ASIC_IRQ_LINE                   0x01

#define ASIC_STATUS_ALL     (ASIC_STATUS_IRQ_INTERVAL |\
                             ASIC_STATUS_TEST_IRQ |\
                             ASIC_STATUS_TEST_COPY_RDY |\
                             ASIC_STATUS_FRAME_READY | \
                             ASIC_STATUS_BUFF_FULL | \
                             ASIC_STATUS_RESET | \
                             ASIC_STATUS_ERROR)


int do_h264enc_hardcore(cmd_tbl_t *cmdtp, int flag, int argc, char** argv)
{
	char progress[4] = "|/-\\";

	unsigned int p = 0;
	unsigned int i = 0;
	unsigned int value = 0;

	while (1) {
		HAL_SETREG32(0x99200004, 0x00000000);
		HAL_SETREG32(0x99200008, 0x0000D00F);
		HAL_SETREG32(0x9920000c, 0x00000000);
		HAL_SETREG32(0x99200010, 0x00000000);
		HAL_SETREG32(0x99200014, 0x57607100);
		HAL_SETREG32(0x99200018, 0x575FB100);
		HAL_SETREG32(0x9920001c, 0x572FDF00);
		HAL_SETREG32(0x99200020, 0x574FC000);
		HAL_SETREG32(0x99200024, 0x57000D00);
		HAL_SETREG32(0x99200028, 0x571FEE00);
		HAL_SETREG32(0x9920002c, 0x5A000000);
		HAL_SETREG32(0x99200030, 0x5A1FA400);
		HAL_SETREG32(0x99200034, 0x5A278D00);
		HAL_SETREG32(0x99200038, 0xA3C1100E);
		HAL_SETREG32(0x9920003c, 0x00780200);
		HAL_SETREG32(0x99200040, 0x68004000);
		HAL_SETREG32(0x99200044, 0x001B009A);
		HAL_SETREG32(0x99200048, 0x00660000);
		HAL_SETREG32(0x9920004c, 0x0000701D);
		HAL_SETREG32(0x99200050, 0x00000000);
		HAL_SETREG32(0x99200054, 0x28000098);
		HAL_SETREG32(0x99200058, 0x00000000);
		HAL_SETREG32(0x9920005c, 0x00000000);
		HAL_SETREG32(0x99200060, 0x0005EEC0);
		HAL_SETREG32(0x99200064, 0x01800000);
		HAL_SETREG32(0x99200068, 0x00000000);
		HAL_SETREG32(0x9920006c, 0x5F3282E5);
		HAL_SETREG32(0x99200070, 0x00000000);
		HAL_SETREG32(0x99200074, 0x00000000);
		HAL_SETREG32(0x99200078, 0x00000000);
		HAL_SETREG32(0x9920007c, 0x00000000);
		HAL_SETREG32(0x99200080, 0x00000000);
		HAL_SETREG32(0x99200084, 0x00000000);
		HAL_SETREG32(0x99200088, 0x00000000);
		HAL_SETREG32(0x9920008c, 0x00000000);
		HAL_SETREG32(0x99200090, 0x00000000);
		HAL_SETREG32(0x99200094, 0x00000000);
		HAL_SETREG32(0x99200098, 0x00000000);
		HAL_SETREG32(0x9920009c, 0x00000000);
		HAL_SETREG32(0x992000a0, 0x00000000);
		HAL_SETREG32(0x992000a4, 0x00000000);
		HAL_SETREG32(0x992000a8, 0x00000000);
		HAL_SETREG32(0x992000ac, 0x00000000);
		HAL_SETREG32(0x992000b0, 0x00000000);
		HAL_SETREG32(0x992000b4, 0x00000000);
		HAL_SETREG32(0x992000b8, 0x00000000);
		HAL_SETREG32(0x992000bc, 0x00000000);
		HAL_SETREG32(0x992000c0, 0x00000000);
		HAL_SETREG32(0x992000c4, 0x00000000);
		HAL_SETREG32(0x992000c8, 0x00000000);
		HAL_SETREG32(0x992000cc, 0x575FB300);
		HAL_SETREG32(0x992000d0, 0x00000000);
		HAL_SETREG32(0x992000d4, 0x962B4C85);
		HAL_SETREG32(0x992000d8, 0x90901D50);
		HAL_SETREG32(0x992000dc, 0x0000B694);
		HAL_SETREG32(0x992000e0, 0x78784444);
		HAL_SETREG32(0x992000e4, 0x00000000);
		HAL_SETREG32(0x992000e8, 0x00000000);
		HAL_SETREG32(0x992000ec, 0x00000000);
		HAL_SETREG32(0x992000f0, 0x78784444);
		HAL_SETREG32(0x992000f4, 0x78784444);
		HAL_SETREG32(0x992000f8, 0x00000000);

		value = HAL_GETREG32(0x99200060);
		if (value != 0x0005EEC0) {
			printf("\nBuffer size is altered\n");
			HAL_SETREG32(0x99200060, 0x0005EEC0);
		}

		value = HAL_GETREG32(0x99200008);
		if (value != 0x0000D00F) {
			printf("\nBus configuration is altered\n");
			HAL_SETREG32(0x99200008, 0x0000D00F);
		}

		HAL_SETREG32(0x99200038, 0xA3C1100F);

spin:
		for (i = 0; i < 1000; ++i) ;

		value = HAL_GETREG32(0x99200004);
		if ((value & ASIC_STATUS_ALL) == 0) goto spin;

		printf("%u %c\r", p, progress[p & 0x3]); ++p;

		value &= ~ASIC_IRQ_LINE;
		HAL_SETREG32(0x99200004, value);

		if (value != ASIC_STATUS_FRAME_READY) {
			printf("\nUnexpected INT value. Actual: 0x%08x\n", value);
			break;
		}

		HAL_SETREG32(0x99200038, 0xA3C1100E);
	}
}


U_BOOT_CMD (
	h264enc_hardcore,	CONFIG_SYS_MAXARGS,	0,	do_h264enc_hardcore,
	"H.264 gardcore",
	"\n"
	"	- h264enc_hardcore"
);
