/*
 * functions in this file are HardWare Independent (hwIndep)
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "sys.h"
#include "sysi.h"

#if 0
bool_T sysInitInMain(void)
{
	bool_T bResult;


	bResult = TRUE;
	bResult &= sysInitGlobalVars_i();

	/* TODO : do other things if there is any */

	return (bResult);
}
#else // modified by Ted for Uboot
bool_T sysInitInMain(sysMallocTrap_FT m_ft, sysFreeTrap_FT f_ft)
{
	bool_T bResult;


	bResult = TRUE;
	bResult &= sysInitGlobalVars_i(m_ft, f_ft);

	/* TODO : do other things if there is any */

	return (bResult);
}
#endif

bool_T sysIsLittleEndian(void)
{
	return (sysvLittleEndian_g);
}

void sysASCIIToUpper(char *szString)
{
#if 1
	char cDiff;

	cDiff = 'a' - 'A';

	while (*szString)
	{
		if (*szString >= 'a' && *szString <= 'z')
			*szString = *szString - cDiff;

		++szString;
	}
#else
	while (*szString)
	{
		*szString = toupper(*szString);
		++szString;
	}
#endif
}

int sysStrCaseCmp(char *szStr1, char *szStr2)
{
	char s1[64], s2[64];

	strcpy(s1, szStr1);
	strcpy(s2, szStr2);

	sysASCIIToUpper(s1);
	sysASCIIToUpper(s2);

	return (strcmp(s1, s2));
}

int sysStrNCaseCmp(char *szStr1, char *szStr2, int nLen)
{
	char s1[64], s2[64];

	strcpy(s1, szStr1);
	strcpy(s2, szStr2);

	sysASCIIToUpper(s1);
	sysASCIIToUpper(s2);

	return (strncmp(s1, s2, nLen));
}

void sysSleepms(unsigned int msec)
{
	register unsigned int i, j;

	if (sysvSleepmsTrap_g)
	{
		sysvSleepmsTrap_g(msec);
	}
	else
	{
		for (i = 0; i < msec; ++i)
		{
			/* TODO : revise this  */

			for (j = 0; j < 0x100; ++j)
			{
				;
			}
		}
	}
}

void sysSleepus(unsigned int usec)
{
	register unsigned int i, j;

	if (sysvSleepusTrap_g)
	{
		sysvSleepusTrap_g(usec);
	}
	else
	{
		/* TODO : revise this */
		for (i = 0; i < usec; ++i)
		{
			for (j = 0; j < 0x10; ++j)
			{
				;
			}
		}
	}
}

void sysSetSleepCB(sysSleepTrap_FT fms, sysSleepTrap_FT fus)
{
	sysvSleepmsTrap_g = fms;
	sysvSleepusTrap_g = fus;
}

void * sysMalloc(int nSize)
{
	if (sysvInitFlag_g != FW_INIT_FLAG || !sysvMallocTrap_g)
		return (malloc(nSize));
	else
		return (sysvMallocTrap_g(nSize));
}

void sysFree(void *memBlock)
{
	if (sysvInitFlag_g != FW_INIT_FLAG || !sysvFreeTrap_g)
		free(memBlock);
	else
		sysvFreeTrap_g(memBlock);
}

void sysSetMMCB(sysMallocTrap_FT fm, sysFreeTrap_FT ff)
{
	sysvMallocTrap_g = fm;
	sysvFreeTrap_g = ff;
}

void * sysMemSet(void *buf, char fill, unsigned int nSize)
{
#if 1
	return (memset(buf, fill, nSize));
#else
	unsigned int i;
	char *pcBuf;

	pcBuf = (char *) buf;
	for (i = 0; i < nSize; ++i)
		pcBuf[i] = fill;

	return buf;
#endif
}

void * sysMemCpy(void *target, const void *source, unsigned int nSize)
{
#if 1
	return (memcpy(target, source, nSize));
#else
	unsigned int i;
	char *pT, *pS;

	pT = (char *) target;
	pS = (char *) source;

	for (i = 0; i < nSize; ++i)
		*(pT+i) = *(pS+i);

	return (target);
#endif
}

