#ifndef _hal_h_
#define _hal_h_

#include "hal_mmp2.h"

/***********************************************************
 * Define the tic resolution. Not opened for modifying now.
 ***********************************************************/
#define HAL_TICKS_PER_SEC		10

/* HW does not support this register in ACTi A1 */
#define HAL_IPENB_SMCC		((unsigned int) (1 << 0))
#define HAL_IPENB_SDC		((unsigned int) (1 << 1))
#define HAL_IPENB_I2S		((unsigned int) (1 << 2))
#define HAL_IPENB_AC97		((unsigned int) (1 << 3))
#define HAL_IPENB_UART1		((unsigned int) (1 << 6))
#define HAL_IPENB_SSI1		((unsigned int) (1 << 8))
#define HAL_IPENB_I2C3		((unsigned int) (1 << 9))	/* LED, SAA1064 */
#define HAL_IPENB_I2C2		((unsigned int) (1 << 10))	/* I2S, UDA1380 */
#define HAL_IPENB_I2C1		((unsigned int) (1 << 11))	/* VFE, SAA7111A */
#define HAL_IPENB_PWM		((unsigned int) (1 << 12))
#define HAL_IPENB_WDT		((unsigned int) (1 << 13))
#define HAL_IPENB_TIMER2	((unsigned int) (1 << 14))
#define HAL_IPENB_TIMER1	((unsigned int) (1 << 15))
#define HAL_IPENB_GPIO		((unsigned int) (1 << 16))
#define HAL_IPENB_JPEG		((unsigned int) (1 << 18))
#define HAL_IPENB_DMAM		((unsigned int) (1 << 20))	/* DMA, memory */
#define HAL_IPENB_TV		((unsigned int) (1 << 21))
#define HAL_IPENB_LCD		((unsigned int) (1 << 23))
#define HAL_IPENB_CPTR		((unsigned int) (1 << 24))	/* i.e. VFE */
#define HAL_IPENB_EBDSRAM	((unsigned int) (1 << 25))	/* i.e. internal SRAM */
#define HAL_IPENB_RTC		((unsigned int) (1 << 26))
#define HAL_IPENB_DMAP		((unsigned int) (1 << 27))	/* DMA, peripheral */
#define HAL_IPENB_USB20	((unsigned int) (1 << 28))
#define HAL_IPENB_ETH110	((unsigned int) (1 << 30))

/* for multiple functional pins */
#define HAL_MFP_SMC				0
#define HAL_MFP_NAND			1
#define HAL_MFP_SDC				2
#define HAL_MFP_LCD				3
#define HAL_MFP_USB				4

#define HAL_MFP_I2C0			10
#define HAL_MFP_I2C1			11
#define HAL_MFP_I2C2			12

#define HAL_MFP_I2S				15
#define HAL_MFP_SSI				16
#define HAL_MFP_SSI_ISP			161
#define HAL_MFP_TMR				17
#define HAL_MFP_WDT				18

#define HAL_MFP_UART0			20
#define HAL_MFP_UART1			21
#define HAL_MFP_UART2			22
#define HAL_MFP_UART3			23
#define HAL_MFP_UART4			24

#define HAL_MFP_H8290			25
#define HAL_MFP_H9170			26
#define HAL_MFP_ISP				30
#define HAL_MFP_ISP_DEBUG		301
#define HAL_MFP_EXTERNAL_ISP  	31
#define HAL_MFP_VCAP			32
#define HAL_MFP_SENSOR			33
#define HAL_MFP_SENSOR_DIV		34

#define HAL_MFP_GPIO_AP			35
#define HAL_MFP_GPIO_AP_POWER	351


/* SYS */
#define HAL_REG_SYS_OSCCtrl				(HAL_REG_SYS_BASE+0x00)
#define HAL_REG_SYS_CPUMode				(HAL_REG_SYS_BASE+0x04)
#define HAL_REG_SYS_PMUSts				(HAL_REG_SYS_BASE+0x08)

#define HAL_REG_SYS_MSF0					(HAL_REG_SYS_BASE+0x0C)
#define HAL_REG_SYS_MSF1					(HAL_REG_SYS_BASE+0x10)
#define HAL_REG_SYS_MSF2					(HAL_REG_SYS_BASE+0x14)
#define HAL_REG_SYS_MSF3					(HAL_REG_SYS_BASE+0x18)
#define HAL_REG_SYS_MSF4					(HAL_REG_SYS_BASE+0x1C)
#define HAL_REG_SYS_MSF5					(HAL_REG_SYS_BASE+0x20)

#define HAL_REG_SYS_AHBGateCtrl			(HAL_REG_SYS_BASE+0x24)
#define HAL_REG_SYS_APBGateCtrl			(HAL_REG_SYS_BASE+0x28)

#define HAL_REG_SYS_JumpSts				(HAL_REG_SYS_BASE+0x2C)
#define HAL_REG_SYS_SRCSel				(HAL_REG_SYS_BASE+0x30)
#define HAL_REG_SYS_CLKDivCnt0			(HAL_REG_SYS_BASE+0x34)
#define HAL_REG_SYS_CLKDivCnt1			(HAL_REG_SYS_BASE+0x38)
#define HAL_REG_SYS_CLKDivCnt2			(HAL_REG_SYS_BASE+0x3c)
#define HAL_REG_SYS_CLKDivCnt3			(HAL_REG_SYS_BASE+0x40)
#define HAL_REG_SYS_CLKDivCnt4			(HAL_REG_SYS_BASE+0x44)
#define HAL_REG_SYS_CLKDivCnt5			(HAL_REG_SYS_BASE+0x48)

#define HAL_REG_SYS_NANDBootCtrl0		(HAL_REG_SYS_BASE+0x60)
#define HAL_REG_SYS_NANDBootCtrl1		(HAL_REG_SYS_BASE+0x64)
#define HAL_REG_SYS_NANDBootCtrl2		(HAL_REG_SYS_BASE+0x68)
#define HAL_REG_SYS_NANDBootCtrl3		(HAL_REG_SYS_BASE+0x6C)
#define HAL_REG_SYS_NANDBootCtrl4		(HAL_REG_SYS_BASE+0x70)
#define HAL_REG_SYS_NANDBootCtrl5		(HAL_REG_SYS_BASE+0x74)
#define HAL_REG_SYS_NANDBootCtrl6		(HAL_REG_SYS_BASE+0x78)
#define HAL_REG_SYS_NANDBootCtrl7		(HAL_REG_SYS_BASE+0x7C)

#define HAL_REG_SYS_DDR2PhyCtrl			(HAL_REG_SYS_BASE+0x80)
#define HAL_REG_SYS_VerNum				(HAL_REG_SYS_BASE+0xF000)
#define HAL_REG_SYS_DDR2_INIT_STS		(HAL_REG_SYS_BASE+0xF004)

#define DDR2_INIT_STS_BUSY					0x00000001
#define CPU_TURBO_BIT						0x00000001

#define PMU_PLL0_MAX_DIVIDER			74		//225MHz
#define PMU_PLL0_MIN_DIVIDER			32		//99MHz
//#define PMU_PLL1_MAX_DIVIDER			62		//378Mhz
#define PMU_PLL1_MAX_DIVIDER			70		//428Mhz
#define PMU_PLL1_MIN_DIVIDER			21		//132MHz

//#define ISP_MAX_CLK					(94500*1000)	// 94.5MHZ
#define ISP_MAX_CLK						(100500*1000)	// 100.5MHZ
#define ISP_MIN_CLK						(40000*1000)	// 40 MHZ


#if 1
typedef struct
{
	unsigned int x0:9;
	unsigned int nand_boot:1;
	unsigned int x10:8;
	unsigned int reserved0:14;
}sys_jumper_t;
#else
typedef struct
{
	unsigned int x0:1;
	unsigned int x1:1;
	unsigned int x2:1;
	unsigned int x3:1;
	unsigned int x4:1;
	unsigned int x5:1;
	unsigned int x6:1;
	unsigned int x7:1;
	unsigned int x8:1;
	unsigned int nand_boot:1;
	unsigned int x10:1;
	unsigned int x11:1;
	unsigned int x12:1;
	unsigned int x13:1;
	unsigned int x14:1;
	unsigned int x15:1;
	unsigned int x16:1;
	unsigned int x17:1;
	unsigned int reserved0:14;
}sys_jumper_t;
#endif
typedef struct
{
	unsigned int nand_cntx:5;
	unsigned int reserved0:3;
	unsigned int usb_cntx:5;
	unsigned int reserved1:3;
	unsigned int sdc_cntx:5;
	unsigned int reserved2:11;
}sys_div_cnt0_t;
typedef struct
{
	unsigned int vcap_cntx:5;
	unsigned int reserved0:11;
	unsigned int isp_cntx:5;
	unsigned int reserved1:11;
}sys_div_cnt1_t;
typedef struct
{
	unsigned int h8290_cntx:5;
	unsigned int reserved0:11;
	unsigned int h9170_cntx:5;
	unsigned int reserved1:11;
}sys_div_cnt2_t;
typedef struct
{
	unsigned int lcd_cntx:8;
	unsigned int sensor_cntx_div:8;
	unsigned int uart4_cntx:8;
	unsigned int sensor_cntx:8;
}sys_div_cnt3_t;
typedef struct
{
	unsigned int uar0_cntx:8;
	unsigned int uar1_cntx:8;
	unsigned int uar2_cntx:8;
	unsigned int uar3_cntx:8;
}sys_div_cnt4_t;
typedef struct
{
	unsigned int i2s_cntx:8;
	unsigned int ssi_cntx:8;
	unsigned int tmr_cntx:8;
	unsigned int wdt_cntx:8;
}sys_div_cnt5_t;

enum halDeviceGateBit_E
{
	halcGateAPBBrg	= 0,
	halcGateAHBC	= 1,
	halcGateNANDHCLK	= 3,
	halcGateNANDCLK	= 4,
	halcGateISPMCLK	= 5,
	halcGateVCAPMCLK	= 6,
	halcGateUSBUCLK	= 7,
	halcGateVIC	= 8,
	halcGateEMAC	= 10,
	halcGateDMAC	= 11,
	halcGateSDCHCLK	= 12,
	halcGateLMC	= 13,
	halcGateLCDHCLK	= 14,
	halcGateUSBHCLK	= 15,
	halcGateSMC	= 16,
	halcGateH8290ACLK	= 19,
	halcGateH9170ACLK	= 20,
	halcGateDDR2X	= 21,
	halcGateLCDCLK	= 22,
	halcGateCMOS	= 23,
	halcGateSDCCLK	= 25,
	halcGateVCAP0ACLK	= 27,
	halcGateVCAP1ACLK	= 28,
	halcGateVCAP2ACLK	= 29,
	halcGateVCAP3ACLK	= 30,
	halcGateSensorCLK	= 31,

	halcGateWDT	= 32,
	halcGateUART0PCLK	= 33,
	halcGateUART1PCLK	= 34,
	halcGateUART2PCLK	= 35,
	halcGateUART3PCLK	= 36,
	halcGateUART4PCLK	= 37,
	halcGateTMRPCLK	= 38,
	halcGateI2C0	= 39,
	halcGateI2C1	= 40,
	halcGateI2C2	= 41,
	halcGateGPIO0	= 42,
	halcGateGPIO1	= 43,
	halcGateGPIO2	= 44,
	halcGateGPIO3	= 45,
	halcGateGPIO4	= 46,
	halcGateI2SPCLK	= 47,
	halcGateI2SEXTBYPASS	= 48,
	halcGateSSIPCLK	= 49,
	halcGateH8290PCLK	= 50,
	halcGateH9170ACLK	= 51,
	halcGateUART0CLK	= 52,
	halcGateUART1CLK	= 53,
	halcGateUART2CLK	= 54,
	halcGateUART3CLK	= 55,
	halcGateUART4CLK	= 56,
	halcGateI2SCLK	= 57,
	halcGateTMRECLK	= 58,
	halcGateSSICLK = 59,
	halcGatePLL0Out = 60,
	halcGatePLL1Out = 61,
	halcGateISPPCLK = 63,
};


/* POM */
#define HAL_REG_PLL0_CTRL					(0x00 + HAL_REG_POM_BASE)
#define HAL_REG_PLL1_CTRL					(0x04 + HAL_REG_POM_BASE)
#define HAL_REG_RST_CNT						(0x08 + HAL_REG_POM_BASE)
#define HAL_REG_POM_CTRL 					(0x0C + HAL_REG_POM_BASE)

#define POM_CTRl_CPU_HOLD_CNT				0x0000007F
#define POM_CTRL_CPU_TURBO_ECO				0x00000080
#define POM_CTRL_NOP_CNT					0x00000700
#define POM_CTRL_CPU_FIRQ_EN				0x00000800
#define POM_CTRL_FCS_START					0x00001000
#define POM_CTRL_DDR_OK						0x00002000
#define POM_CTRL_IN_SRF_MODE				0x00004000
#define POM_CTRL_DO_DATA_TRAIN				0x00008000
#define POM_CTRL_SW_RESET					0x00010000

#define PLL_CTRL_BYPASS						0x00000001
#define PLL_CTRL_PD							0x00000002
#define PLL_CTRL_NO							0x0000000C
#define PLL_NO_SHIFT						2
#define PLL_CTRL_BS							0x00000030
#define PLL_BS_SHIFT						4
#define PLL_CTRL_LOCK_DET					0x00000040
#define PLL_CTRL_NR							0x00001F00
#define PLL_NR_SHIFT						8
#define PLL_CTRL_NF							0x7F000000
#define PLL_NF_SHIFT						24
#define PLL_CTRL_UPDATE						0x80000000

/* POM state machine status register */
#define PMU_STATUS_PLL1_STATE_BITS			0x00000F00
#define PMU_STATUS_PLL0_STATE_BITS			0x00007000
#define PLL1_WAIT_UPDATE_STATE				0x00000300
#define PLL0_WAIT_UPDATE_STATE				0x00001000

typedef struct pll_ctrl_s
{
	unsigned int by_pass:1;
	unsigned int pd:1;
	unsigned int op_div:2;
	unsigned int bs:2;
	unsigned int lock_det:1;
	unsigned int reserved0:1;
	unsigned int nr:5;
	unsigned int reserved1:11;
	unsigned int nf:7;
	unsigned int update:1;
}pll_ctrl_t;


/* DDR2 */
#define HAL_REG_DDR2C_CtrlConfig			(HAL_REG_DDR2C_BASE + 0x000)		//CCR
#define HAL_REG_DDR2C_DRAMConfig			(HAL_REG_DDR2C_BASE + 0x004)		//DCR
#define HAL_REG_DDR2C_DRAMRefresh			(HAL_REG_DDR2C_BASE + 0x010)
#define HAL_REG_DDR2C_DLLContol				(HAL_REG_DDR2C_BASE + 0x048)
#define HAL_REG_DDR2C_TimingReg3			(HAL_REG_DDR2C_BASE + 0x0b8)
#define HAL_REG_DDR2C_ModeReg				(HAL_REG_DDR2C_BASE + 0x1F0)

#define DDR2_DO_DATA_TRAIN			0x40000000
#define DDR2_CMD_BITS				0x78000000
#define DDR2_IN_SRF_CMD				0x10000000
#define DDR2_EXIT_SRF_CMD			0x38000000
#define DDR2_SDR_NOP_CMD			0x78000000
#define	DDR2_EXECUTE_CMD_BIT		0x80000000
#define DDR2_RESET_SDRAM_DLL_BIT	0x00000100

// this structure is used to store the DDR parameters used for PLL1 FCS
typedef struct DDRSetting_T
{
	unsigned int count;
	unsigned int addr[0x20];
	unsigned int value[0x20];
}DDRSetting_T;

#define HAL_REG_DDR2C_CCR		(HAL_REG_DDR2C_BASE + (0x00 << 2))
#define HAL_REG_DDR2C_DCR		(HAL_REG_DDR2C_BASE + (0x01 << 2))
#define HAL_REG_DDR2C_IOCR		(HAL_REG_DDR2C_BASE + (0x02 << 2))
#define HAL_REG_DDR2C_CSR		(HAL_REG_DDR2C_BASE + (0x03 << 2))
#define HAL_REG_DDR2C_DRR		(HAL_REG_DDR2C_BASE + (0x04 << 2))

#define HAL_REG_DDR2C_TPR0		(HAL_REG_DDR2C_BASE + (0x05 << 2))
#define HAL_REG_DDR2C_TPR1		(HAL_REG_DDR2C_BASE + (0x06 << 2))
#define HAL_REG_DDR2C_TPR2		(HAL_REG_DDR2C_BASE + (0x07 << 2))

#define HAL_REG_DDR2C_DLLCR		(HAL_REG_DDR2C_BASE + (0x08 << 2))

#define HAL_REG_DDR2C_DLLCR0		(HAL_REG_DDR2C_BASE + (0x09 << 2))
#define HAL_REG_DDR2C_DLLCR1		(HAL_REG_DDR2C_BASE + (0x0A << 2))
#define HAL_REG_DDR2C_DLLCR2		(HAL_REG_DDR2C_BASE + (0x0B << 2))
#define HAL_REG_DDR2C_DLLCR3		(HAL_REG_DDR2C_BASE + (0x0C << 2))
#define HAL_REG_DDR2C_DLLCR4		(HAL_REG_DDR2C_BASE + (0x0D << 2))
#define HAL_REG_DDR2C_DLLCR5		(HAL_REG_DDR2C_BASE + (0x0E << 2))
#define HAL_REG_DDR2C_DLLCR6		(HAL_REG_DDR2C_BASE + (0x0F << 2))
#define HAL_REG_DDR2C_DLLCR7		(HAL_REG_DDR2C_BASE + (0x10 << 2))
#define HAL_HAL_REG_DDR2C_R8		(HAL_REG_DDR2C_BASE + (0x11 << 2))
#define HAL_REG_DDR2C_DLLCR9		(HAL_REG_DDR2C_BASE + (0x12 << 2))

#define HAL_REG_DDR2C_RSLR0		(HAL_REG_DDR2C_BASE + (0x13 << 2))
#define HAL_REG_DDR2C_RSLR1		(HAL_REG_DDR2C_BASE + (0x14 << 2))
#define HAL_REG_DDR2C_RSLR2		(HAL_REG_DDR2C_BASE + (0x15 << 2))
#define HAL_REG_DDR2C_RSLR3		(HAL_REG_DDR2C_BASE + (0x16 << 2))

#define HAL_REG_DDR2C_RDGR0		(HAL_REG_DDR2C_BASE + (0x17 << 2))
#define HAL_REG_DDR2C_RDGR1		(HAL_REG_DDR2C_BASE + (0x18 << 2))
#define HAL_REG_DDR2C_RDGR2		(HAL_REG_DDR2C_BASE + (0x19 << 2))
#define HAL_REG_DDR2C_RDGR3		(HAL_REG_DDR2C_BASE + (0x1A << 2))

#define HAL_REG_DDR2C_DQTR0		(HAL_REG_DDR2C_BASE + (0x1B << 2))
#define HAL_REG_DDR2C_DQTR1		(HAL_REG_DDR2C_BASE + (0x1C << 2))
#define HAL_REG_DDR2C_DQTR2		(HAL_REG_DDR2C_BASE + (0x1D << 2))
#define HAL_REG_DDR2C_DQTR3		(HAL_REG_DDR2C_BASE + (0x1E << 2))
#define HAL_REG_DDR2C_DQTR4		(HAL_REG_DDR2C_BASE + (0x1F << 2))
#define HAL_REG_DDR2C_DQTR5		(HAL_REG_DDR2C_BASE + (0x20 << 2))
#define HAL_REG_DDR2C_DQTR6		(HAL_REG_DDR2C_BASE + (0x21 << 2))
#define HAL_REG_DDR2C_DQTR7		(HAL_REG_DDR2C_BASE + (0x22 << 2))
#define HAL_REG_DDR2C_DQTR8		(HAL_REG_DDR2C_BASE + (0x23 << 2))

#define HAL_REG_DDR2C_DQSTR		(HAL_REG_DDR2C_BASE + (0x24 << 2))
#define HAL_REG_DDR2C_DQSBTR		(HAL_REG_DDR2C_BASE + (0x25 << 2))
#define HAL_REG_DDR2C_ODTCR		(HAL_REG_DDR2C_BASE + (0x26 << 2))

#define HAL_REG_DDR2C_DTR0		(HAL_REG_DDR2C_BASE + (0x27 << 2))
#define HAL_REG_DDR2C_DTR1		(HAL_REG_DDR2C_BASE + (0x28 << 2))

#define HAL_REG_DDR2C_DTAR		(HAL_REG_DDR2C_BASE + (0x29 << 2))

#define HAL_REG_DDR2C_ZQCR0		(HAL_REG_DDR2C_BASE + (0x2A << 2))
#define HAL_REG_DDR2C_ZQCR1		(HAL_REG_DDR2C_BASE + (0x2B << 2))
#define HAL_REG_DDR2C_ZQCR2		(HAL_REG_DDR2C_BASE + (0x2C << 2))

#define HAL_REG_DDR2C_ZQSR		(HAL_REG_DDR2C_BASE + (0x2D << 2))
#define HAL_REG_DDR2C_TPR3		(HAL_REG_DDR2C_BASE + (0x2E << 2))
#define HAL_REG_DDR2C_ALPMR		(HAL_REG_DDR2C_BASE + (0x2F << 2))

#define HAL_REG_DDR2C_MR			(HAL_REG_DDR2C_BASE + (0x7C << 2))
#define HAL_REG_DDR2C_EMR		(HAL_REG_DDR2C_BASE + (0x7D << 2))
#define HAL_REG_DDR2C_EMR2		(HAL_REG_DDR2C_BASE + (0x7E << 2))
#define HAL_REG_DDR2C_EMR3		(HAL_REG_DDR2C_BASE + (0x7F << 2))

#define HAL_REG_DDR2C_HPCR0		(HAL_REG_DDR2C_BASE + (0x80 << 2))
#define HAL_REG_DDR2C_HPCR1		(HAL_REG_DDR2C_BASE + (0x81 << 2))
#define HAL_REG_DDR2C_HPCR2		(HAL_REG_DDR2C_BASE + (0x82 << 2))
#define HAL_REG_DDR2C_HPCR3		(HAL_REG_DDR2C_BASE + (0x83 << 2))
#define HAL_REG_DDR2C_HPCR4		(HAL_REG_DDR2C_BASE + (0x84 << 2))
#define HAL_REG_DDR2C_HPCR5		(HAL_REG_DDR2C_BASE + (0x85 << 2))
#define HAL_REG_DDR2C_HPCR6		(HAL_REG_DDR2C_BASE + (0x86 << 2))
#define HAL_REG_DDR2C_HPCR7		(HAL_REG_DDR2C_BASE + (0x87 << 2))

#define HAL_REG_DDR2C_PQCR0		(HAL_REG_DDR2C_BASE + (0xA0 << 2))
#define HAL_REG_DDR2C_PQCR1		(HAL_REG_DDR2C_BASE + (0xA1 << 2))
#define HAL_REG_DDR2C_PQCR2		(HAL_REG_DDR2C_BASE + (0xA2 << 2))
#define HAL_REG_DDR2C_PQCR3		(HAL_REG_DDR2C_BASE + (0xA3 << 2))

/* DMAM */
#if defined(HAL_INC_DMAM)
#define HAL_REG_DMAM_SrcAddr				(HAL_REG_DMAM_BASE+0x0)
#define HAL_REG_DMAM_DestAddr				(HAL_REG_DMAM_BASE+0x4)
#define HAL_REG_DMAM_Ctrl					(HAL_REG_DMAM_BASE+0x8)
#define HAL_REG_DMAM_Enable				(HAL_REG_DMAM_BASE+0xC)
#endif

/*LM DMAM*/
#define HAL_REG_LM_DMAM_SrcAddr			(HAL_REG_LM_DMAM_BASE+0x0)
#define HAL_REG_LM_DMAM_DestAddr			(HAL_REG_LM_DMAM_BASE+0x4)
#define HAL_REG_LM_DMAM_Ctrl				(HAL_REG_LM_DMAM_BASE+0x8)
#define HAL_REG_LM_DMAM_Enable			(HAL_REG_LM_DMAM_BASE+0xC)

/* DMAM AXI */
#define __ARM9__
//#undef	__ARM9__
//#define __ARM11__
#undef	__ARM11__

#if defined(HAL_INC_DMAM)
#define HAL_REG_DMAM_AXI_SrcAddr			(HAL_REG_DMAM_AXI_BASE+0x0)
#define HAL_REG_DMAM_AXI_DestAddr		(HAL_REG_DMAM_AXI_BASE+0x8)
#if defined(__ARM9__)
#define HAL_REG_DMAM_AXI_CtrlL			(HAL_REG_DMAM_AXI_BASE+0x10)
#define HAL_REG_DMAM_AXI_CtrlH			(HAL_REG_DMAM_AXI_BASE+0x14)
#elif defined(__ARM11__)
#define HAL_REG_DMAM_AXI_Ctrl				(HAL_REG_DMAM_AXI_BASE+0x10)
#endif
#define HAL_REG_DMAM_AXI_Enable			(HAL_REG_DMAM_AXI_BASE+0x18)
#endif

/* DMAP */
#if defined(HAL_INC_DMAP)
#define HAL_REG_DMAP_IntStat			(HAL_REG_DMAP_BASE+0x000)
#define HAL_REG_DMAP_IntTCStat		(HAL_REG_DMAP_BASE+0x004)
#define HAL_REG_DMAP_IntTCClr			(HAL_REG_DMAP_BASE+0x008)
#define HAL_REG_DMAP_IntErrStat		(HAL_REG_DMAP_BASE+0x00C)
#define HAL_REG_DMAP_IntErrClr		(HAL_REG_DMAP_BASE+0x010)
#define HAL_REG_DMAP_RawIntTCStat	(HAL_REG_DMAP_BASE+0x014)
#define HAL_REG_DMAP_RawIntErrStat	(HAL_REG_DMAP_BASE+0x018)
#define HAL_REG_DMAP_EnbldChns		(HAL_REG_DMAP_BASE+0x01C)
#define HAL_REG_DMAP_Sync				(HAL_REG_DMAP_BASE+0x024)

	/* each channel's base address */
#define HAL_REG_DMAP_C0_BASE		(HAL_REG_DMAP_BASE+0x100)
#define HAL_REG_DMAP_C1_BASE		(HAL_REG_DMAP_BASE+0x110)
#define HAL_REG_DMAP_C2_BASE		(HAL_REG_DMAP_BASE+0x120)
#define HAL_REG_DMAP_C3_BASE		(HAL_REG_DMAP_BASE+0x130)
#define HAL_REG_DMAP_C4_BASE		(HAL_REG_DMAP_BASE+0x140)
#define HAL_REG_DMAP_C5_BASE		(HAL_REG_DMAP_BASE+0x150)
#define HAL_REG_DMAP_C6_BASE		(HAL_REG_DMAP_BASE+0x160)
#define HAL_REG_DMAP_C7_BASE		(HAL_REG_DMAP_BASE+0x170)

	/* offsets of each channel's registers (w.r.t. HAL_REG_DMAP_Cn_BASE) */
	/*                                                           |       */
	/*                                                           |       */
	/*                                    7,6,5,4,3,2,1,0 -------+       */
#define HAL_DMAP_Cn_SrcAddr_Offset	0x0
#define HAL_DMAP_Cn_DestAddr_Offset	0x4
#define HAL_DMAP_Cn_Ctrl_Offset		0x8
#define HAL_DMAP_Cn_Config			0xC
#endif

/* watchdog timer (WDT) */
#if defined(HAL_INC_WDT)
#define HAL_REG_WDT_CntSts				(HAL_REG_WDT_BASE+0x00)
#define HAL_REG_WDT_Reload				(HAL_REG_WDT_BASE+0x04)
#define HAL_REG_WDT_Restart				(HAL_REG_WDT_BASE+0x08)
#define HAL_REG_WDT_Ctrl				(HAL_REG_WDT_BASE+0x0C)
#define HAL_REG_WDT_TimeOut				(HAL_REG_WDT_BASE+0x10)
#define HAL_REG_WDT_Clr					(HAL_REG_WDT_BASE+0x14)
#define HAL_REG_WDT_RstWd				(HAL_REG_WDT_BASE+0x18)
#endif

/* RTC */
#define HAL_REG_RTC_CounterStatus		(HAL_REG_RTC_BASE+0x00)
#define HAL_REG_RTC_Alarm				(HAL_REG_RTC_BASE+0x04)
#define HAL_REG_RTC_Reload				(HAL_REG_RTC_BASE+0x08)
#define HAL_REG_RTC_Control				(HAL_REG_RTC_BASE+0x0C)
#define HAL_REG_RTC_Restart				(HAL_REG_RTC_BASE+0x10)
#define HAL_REG_RTC_Reset				(HAL_REG_RTC_BASE+0x14)

/* VIC */
#define HAL_REG_VIC1_IRQStatus			(HAL_REG_VIC1_BASE+0x00)
#define HAL_REG_VIC1_FIQStatus			(HAL_REG_VIC1_BASE+0x04)
#define HAL_REG_VIC1_RawIntStatus		(HAL_REG_VIC1_BASE+0x08)
#define HAL_REG_VIC1_IntSelect			(HAL_REG_VIC1_BASE+0x0C)
#define HAL_REG_VIC1_IntEnable			(HAL_REG_VIC1_BASE+0x10)
#define HAL_REG_VIC1_IntEnableClear		(HAL_REG_VIC1_BASE+0x14)
#define HAL_REG_VIC1_SoftInt				(HAL_REG_VIC1_BASE+0x18)
#define HAL_REG_VIC1_SoftIntClear		(HAL_REG_VIC1_BASE+0x1C)
#define HAL_REG_VIC1_ProtectionEnable	(HAL_REG_VIC1_BASE+0x20)
#define HAL_REG_VIC1_Sense				(HAL_REG_VIC1_BASE+0x24)
#define HAL_REG_VIC1_BothEdge				(HAL_REG_VIC1_BASE+0x28)
#define HAL_REG_VIC1_Event				(HAL_REG_VIC1_BASE+0x2C)
#define HAL_REG_VIC1_EdgeTriClear		(HAL_REG_VIC1_BASE+0x38)

#if HAL_VIC_NUM == 2
#define HAL_REG_VIC2_IRQStatus			(HAL_REG_VIC2_BASE+0x00)
#define HAL_REG_VIC2_FIQStatus			(HAL_REG_VIC2_BASE+0x04)
#define HAL_REG_VIC2_RawIntStatus		(HAL_REG_VIC2_BASE+0x08)
#define HAL_REG_VIC2_IntSelect			(HAL_REG_VIC2_BASE+0x0C)
#define HAL_REG_VIC2_IntEnable			(HAL_REG_VIC2_BASE+0x10)
#define HAL_REG_VIC2_IntEnableClear		(HAL_REG_VIC2_BASE+0x14)
#define HAL_REG_VIC2_SoftInt			(HAL_REG_VIC2_BASE+0x18)
#define HAL_REG_VIC2_SoftIntClear		(HAL_REG_VIC2_BASE+0x1C)
#define HAL_REG_VIC2_ProtectionEnable	(HAL_REG_VIC2_BASE+0x20)
#define HAL_REG_VIC2_Sense				(HAL_REG_VIC2_BASE+0x24)
#define HAL_REG_VIC2_BothEdge			(HAL_REG_VIC2_BASE+0x28)
#define HAL_REG_VIC2_Event				(HAL_REG_VIC2_BASE+0x2C)
#define HAL_REG_VIC2_EdgeTriClear		(HAL_REG_VIC2_BASE+0x38)
#endif


/* LCD */
#if defined(HAL_INC_LCD)
/*
#define HAL_REG_LCD_HCtrlR				(HAL_REG_LCD_BASE+0x00)
#define HAL_REG_LCD_VCtrlR				(HAL_REG_LCD_BASE+0x04)
#define HAL_REG_LCD_IFormR				(HAL_REG_LCD_BASE+0x08)
#define HAL_REG_LCD_DOutR				(HAL_REG_LCD_BASE+0x0C)
#define HAL_REG_LCD_TCtrlR				(HAL_REG_LCD_BASE+0x10)
#define HAL_REG_LCD_BaseR				(HAL_REG_LCD_BASE+0x18)
#define HAL_REG_LCD_IntCtrlR			(HAL_REG_LCD_BASE+0x24)
#define HAL_REG_LCD_IntStsR				(HAL_REG_LCD_BASE+0x28)
#define HAL_REG_LCD_DCtrlR				(HAL_REG_LCD_BASE+0x2C)
#define HAL_REG_LCD_GPIOFR				(HAL_REG_LCD_BASE+0x30)
#define HAL_REG_LCD_GPIOVR				(HAL_REG_LCD_BASE+0x34)
#define HAL_REG_LCD_TModeR				(HAL_REG_LCD_BASE+0x38)
#define HAL_REG_LCD_HALIGNR				(HAL_REG_LCD_BASE+0x3C)
#define HAL_REG_LCD_VALIGNR				(HAL_REG_LCD_BASE+0x40)
#define	HAL_REG_LCD_BCOLORR				(HAL_REG_LCD_BASE+0x44)
#define HAL_REG_LCD_PIXARRR				(HAL_REG_LCD_BASE+0x48)
#define HAL_REG_LCD_PALER				(HAL_REG_LCD_BASE+0x100)
*/
#endif

/* TV (master) */
#if defined(HAL_INC_TV)
#define HAL_REG_TV_ContractCoef			(HAL_REG_TV_BASE+0x0)
#define HAL_REG_TV_SaturationCoef		(HAL_REG_TV_BASE+0x8)
#define HAL_REG_TV_Test1				(HAL_REG_TV_BASE+0xC)
#define HAL_REG_TV_Ctrl1				(HAL_REG_TV_BASE+0x10)
#define HAL_REG_TV_Ctrl2				(HAL_REG_TV_BASE+0x14)
#define HAL_REG_TV_ReConfigCSCCoef		(HAL_REG_TV_BASE+0x18)
#define HAL_REG_TV_CbCoef				(HAL_REG_TV_BASE+0x1C)
#define HAL_REG_TV_YCoef				(HAL_REG_TV_BASE+0x20)
#define HAL_REG_TV_CrCoef				(HAL_REG_TV_BASE+0x24)
#define HAL_REG_TV_Test2				(HAL_REG_TV_BASE+0x28)
#define HAL_REG_TV_BurstParam1H			(HAL_REG_TV_BASE+0x2C)
#define HAL_REG_TV_BurstParam1L			(HAL_REG_TV_BASE+0x30)
#define HAL_REG_TV_BurstParam2H			(HAL_REG_TV_BASE+0x34)
#define HAL_REG_TV_BurstParam2L			(HAL_REG_TV_BASE+0x38)
#define HAL_REG_TV_BurstParam3H			(HAL_REG_TV_BASE+0x3C)
#define HAL_REG_TV_BurstParam3L			(HAL_REG_TV_BASE+0x40)
#define HAL_REG_TV_Field0StartAddr		(HAL_REG_TV_BASE+0x100)
#define HAL_REG_TV_Field1StartAddr		(HAL_REG_TV_BASE+0x104)
#define HAL_REG_TV_ImageWidth			(HAL_REG_TV_BASE+0x108)
#define HAL_REG_TV_ImageHeight			(HAL_REG_TV_BASE+0x10C)
#define HAL_REG_TV_HorizontalOffset		(HAL_REG_TV_BASE+0x110)
#define HAL_REG_TV_VerticalOffset		(HAL_REG_TV_BASE+0x114)
#define HAL_REG_TV_Reset				(HAL_REG_TV_BASE+0x118)
#define HAL_REG_TV_Enable				(HAL_REG_TV_BASE+0x11C)

#define HAL_REG_TV_BGColor				(HAL_REG_TV_BASE+0x124)
#define HAL_REG_TV_CtrlReg10			(HAL_REG_TV_BASE+0x128)
#define HAL_REG_TV_CropWidth			(HAL_REG_TV_BASE+0x12C)
#define HAL_REG_TV_CropHeight			(HAL_REG_TV_BASE+0x130)
#define HAL_REG_TV_CropHorizontalOffset	(HAL_REG_TV_BASE+0x134)
#define HAL_REG_TV_CropVerticalOffset	(HAL_REG_TV_BASE+0x138)
#define HAL_REG_TV_FIFO_LO_THD			(HAL_REG_TV_BASE+0x170)
#define HAL_REG_TV_FIFO_HI_THD			(HAL_REG_TV_BASE+0x174)
#endif

/* USB2.0 */
#if defined(HAL_INC_USB20)
	/* register definition is seen in "halusbmass.c" file */
#endif

/* Timer */
#if defined(HAL_INC_TIMER1)
#define HAL_REG_TIMER1CNT1_Status		(HAL_REG_TIMER1_BASE+0x00)
#define HAL_REG_TIMER1CNT1_Reload		(HAL_REG_TIMER1_BASE+0x04)
#define HAL_REG_TIMER1CNT1_Match1		(HAL_REG_TIMER1_BASE+0x08)
#define HAL_REG_TIMER1CNT1_Match2		(HAL_REG_TIMER1_BASE+0x0C)

#define HAL_REG_TIMER1CNT2_Status		(HAL_REG_TIMER1_BASE+0x10)
#define HAL_REG_TIMER1CNT2_Reload		(HAL_REG_TIMER1_BASE+0x14)
#define HAL_REG_TIMER1CNT2_Match1		(HAL_REG_TIMER1_BASE+0x18)
#define HAL_REG_TIMER1CNT2_Match2		(HAL_REG_TIMER1_BASE+0x1C)

#define HAL_REG_TIMER1CNT3_Status		(HAL_REG_TIMER1_BASE+0x20)
#define HAL_REG_TIMER1CNT3_Reload		(HAL_REG_TIMER1_BASE+0x24)
#define HAL_REG_TIMER1CNT3_Match1		(HAL_REG_TIMER1_BASE+0x28)
#define HAL_REG_TIMER1CNT3_Match2		(HAL_REG_TIMER1_BASE+0x2C)

#define HAL_REG_TIMER1_Control			(HAL_REG_TIMER1_BASE+0x30)
#endif

#if defined(HAL_INC_TIMER2)
#define HAL_REG_TIMER2CNT1_Status		(HAL_REG_TIMER2_BASE+0x00)
#define HAL_REG_TIMER2CNT1_Reload		(HAL_REG_TIMER2_BASE+0x04)
#define HAL_REG_TIMER2CNT1_Match1		(HAL_REG_TIMER2_BASE+0x08)
#define HAL_REG_TIMER2CNT1_Match2		(HAL_REG_TIMER2_BASE+0x0C)

#define HAL_REG_TIMER2CNT2_Status		(HAL_REG_TIMER2_BASE+0x10)
#define HAL_REG_TIMER2CNT2_Reload		(HAL_REG_TIMER2_BASE+0x14)
#define HAL_REG_TIMER2CNT2_Match1		(HAL_REG_TIMER2_BASE+0x18)
#define HAL_REG_TIMER2CNT2_Match2		(HAL_REG_TIMER2_BASE+0x1C)

#define HAL_REG_TIMER2CNT3_Status		(HAL_REG_TIMER2_BASE+0x20)
#define HAL_REG_TIMER2CNT3_Reload		(HAL_REG_TIMER2_BASE+0x24)
#define HAL_REG_TIMER2CNT3_Match1		(HAL_REG_TIMER2_BASE+0x28)
#define HAL_REG_TIMER2CNT3_Match2		(HAL_REG_TIMER2_BASE+0x2C)

#define HAL_REG_TIMER2_Control			(HAL_REG_TIMER2_BASE+0x30)
#endif


/* AHBC */
#define HAL_REG_AHBC_PriorityCtrl		(HAL_REG_AHBC_BASE+0x80)
#define HAL_REG_AHBC_IntCtrl				(HAL_REG_AHBC_BASE+0x88)
#define HAL_REG_AHBC_Remap				(HAL_REG_AHBC_BASE+0x8C)

/* remap */
#define HAL_REG_AHBC_Remap_bits			0x00000FFF
#define HAL_REMAP_SRAM						0x00000000					// Internal SRAM for NAND flash
#define HAL_REMAP_SMC						0x00000100					// NOR FLASH
#define HAL_REMAP_DDR2						0x00000300					// DDR2

/* GPIO */
#if defined(HAL_INC_GPIO)
#define HAL_REG_GPIO_Data				(HAL_REG_GPIO_BASE+0x0)
#define HAL_REG_GPIO_Direction			(HAL_REG_GPIO_BASE+0x4)
#define HAL_REG_GPIO_IntSensCtrl		(HAL_REG_GPIO_BASE+0x8)
#define HAL_REG_GPIO_BothEdgeIntCtrl	(HAL_REG_GPIO_BASE+0xC)
#define HAL_REG_GPIO_IntEventCtrl		(HAL_REG_GPIO_BASE+0x10)
#define HAL_REG_GPIO_IntEnable			(HAL_REG_GPIO_BASE+0x14)
#define HAL_REG_GPIO_RawIntStatus		(HAL_REG_GPIO_BASE+0x1C)
#define HAL_REG_GPIO_MaskedIntStatus	(HAL_REG_GPIO_BASE+0x20)
#define HAL_REG_GPIO_IntClear			(HAL_REG_GPIO_BASE+0x24)
#define HAL_REG_GPIO_RWMask				(HAL_REG_GPIO_BASE+0x28)
#endif

/* I2C1, for VFE (capture) */
#if defined(HAL_INC_I2C1)
#define HAL_REG_I2C1_Enable				(HAL_REG_I2C1_BASE+0x0)
#define HAL_REG_I2C1_Ctrl				(HAL_REG_I2C1_BASE+0x10)
#define HAL_REG_I2C1_Data				(HAL_REG_I2C1_BASE+0x20)
#define HAL_REG_I2C1_Status				(HAL_REG_I2C1_BASE+0x24)
#define HAL_REG_I2C1_PreScaleLowByte	(HAL_REG_I2C1_BASE+0x30)
#define HAL_REG_I2C1_PreScaleHighByte	(HAL_REG_I2C1_BASE+0x34)
#endif

/* I2C2, for I2S */
#if defined(HAL_INC_I2C2)
#define HAL_REG_I2C2_Enable				(HAL_REG_I2C2_BASE+0x0)
#define HAL_REG_I2C2_Ctrl				(HAL_REG_I2C2_BASE+0x10)
#define HAL_REG_I2C2_Data				(HAL_REG_I2C2_BASE+0x20)
#define HAL_REG_I2C2_Status				(HAL_REG_I2C2_BASE+0x24)
#define HAL_REG_I2C2_PreScaleLowByte	(HAL_REG_I2C2_BASE+0x30)
#define HAL_REG_I2C2_PreScaleHighByte	(HAL_REG_I2C2_BASE+0x34)
#endif

#if 1
/* I2C0 */
#if defined(HAL_INC_I2C0)
#define HAL_REG_I2C0_Enable				(HAL_REG_I2C0_BASE+0x0)
#define HAL_REG_I2C0_Ctrl				(HAL_REG_I2C0_BASE+0x10)
#define HAL_REG_I2C0_Data				(HAL_REG_I2C0_BASE+0x20)
#define HAL_REG_I2C0_Status				(HAL_REG_I2C0_BASE+0x24)
#define HAL_REG_I2C0_PreScaleLowByte	(HAL_REG_I2C0_BASE+0x30)
#define HAL_REG_I2C0_PreScaleHighByte	(HAL_REG_I2C0_BASE+0x34)
#endif
#endif

/* SSI */
#if defined(HAL_INC_SSI)
#define HAL_REG_SSI_CTRLR0				(HAL_REG_SSI_BASE+0x00)
#define HAL_REG_SSI_CTRLR1				(HAL_REG_SSI_BASE+0x04)
#define HAL_REG_SSI_SSIENR				(HAL_REG_SSI_BASE+0x08)
#define HAL_REG_SSI_MWCR				(HAL_REG_SSI_BASE+0x0C)
#define HAL_REG_SSI_SER					(HAL_REG_SSI_BASE+0x10)
#define HAL_REG_SSI_BAUDR				(HAL_REG_SSI_BASE+0x14)
#define HAL_REG_SSI_TXFTLR				(HAL_REG_SSI_BASE+0x18)
#define HAL_REG_SSI_RXFTLR				(HAL_REG_SSI_BASE+0x1C)
#define HAL_REG_SSI_TXFLR				(HAL_REG_SSI_BASE+0x20)
#define HAL_REG_SSI_RXFLR				(HAL_REG_SSI_BASE+0x24)
#define HAL_REG_SSI_SR					(HAL_REG_SSI_BASE+0x28)
#define HAL_REG_SSI_IMR					(HAL_REG_SSI_BASE+0x2C)
#define HAL_REG_SSI_ISR					(HAL_REG_SSI_BASE+0x30)
#define HAL_REG_SSI_RISR				(HAL_REG_SSI_BASE+0x34)
#define HAL_REG_SSI_TXOICR				(HAL_REG_SSI_BASE+0x38)
#define HAL_REG_SSI_RXOICR				(HAL_REG_SSI_BASE+0x3C)
#define HAL_REG_SSI_RXUICR				(HAL_REG_SSI_BASE+0x40)
#define HAL_REG_SSI_MSTICR				(HAL_REG_SSI_BASE+0x44)
#define HAL_REG_SSI_ICR					(HAL_REG_SSI_BASE+0x48)
#define HAL_REG_SSI_IDR					(HAL_REG_SSI_BASE+0x58)
#define HAL_REG_SSI_SSI_VERSION_ID		(HAL_REG_SSI_BASE+0x5C)
#define HAL_REG_SSI_DR					(HAL_REG_SSI_BASE+0x60)
#endif

/* I2S */
#define HAL_REG_I2S_mode				(HAL_REG_I2S_BASE+0x00)
#define HAL_REG_I2S_rx_ctrl			(HAL_REG_I2S_BASE+0x04)
#define HAL_REG_I2S_tx_ctrl			(HAL_REG_I2S_BASE+0x08)
#define HAL_REG_I2S_wlen				(HAL_REG_I2S_BASE+0x0C)
#define HAL_REG_I2S_wpos				(HAL_REG_I2S_BASE+0x10)
#define HAL_REG_I2S_slot				(HAL_REG_I2S_BASE+0x14)
#define HAL_REG_I2S_tx_fifo_lth		(HAL_REG_I2S_BASE+0x18)
#define HAL_REG_I2S_rx_fifo_gth		(HAL_REG_I2S_BASE+0x1C)
#define HAL_REG_I2S_clock				(HAL_REG_I2S_BASE+0x20)
#define HAL_REG_I2S_init				(HAL_REG_I2S_BASE+0x24)
#define HAL_REG_I2S_tx_fifo_flag		(HAL_REG_I2S_BASE+0x28)
#define HAL_REG_I2S_tx_left_data		(HAL_REG_I2S_BASE+0x2C)
#define HAL_REG_I2S_tx_right_data		(HAL_REG_I2S_BASE+0x30)
#define HAL_REG_I2S_rx_fifo_flag		(HAL_REG_I2S_BASE+0x34)
#define HAL_REG_I2S_rx_data			(HAL_REG_I2S_BASE+0x38)
#define HAL_REG_I2S_tx_fifo_cntr		(HAL_REG_I2S_BASE+0x3C)
#define HAL_REG_I2S_rx_fifo_cntr		(HAL_REG_I2S_BASE+0x40)
#define HAL_REG_I2S_tx_int_enable		(HAL_REG_I2S_BASE+0x44)
#define HAL_REG_I2S_rx_int_enable		(HAL_REG_I2S_BASE+0x48)
#define HAL_REG_I2S_CODEC_clk_ctrl		(HAL_REG_I2S_BASE+0x4C)
#define HAL_REG_I2S_CODEC_clk_div 		(HAL_REG_I2S_BASE+0x50)

#if 0
/* KBMS0 */
#if defined(HAL_INC_KBMS0)
#define HAL_REG_KBMS0_ACK				(HAL_REG_KBMS0_BASE+0x00)
#define HAL_REG_KBMS0_STS				(HAL_REG_KBMS0_BASE+0x04)
#define HAL_REG_KBMS0_DATA				(HAL_REG_KBMS0_BASE+0x08)
#define HAL_REG_KBMS0_IR				(HAL_REG_KBMS0_BASE+0x10)
#define HAL_REG_KBMS0_INHB				(HAL_REG_KBMS0_BASE+0x14)
#endif

/* KBMS1 */
#if defined(HAL_INC_KBMS1)
#define HAL_REG_KBMS1_ACK				(HAL_REG_KBMS1_BASE+0x00)
#define HAL_REG_KBMS1_STS				(HAL_REG_KBMS1_BASE+0x04)
#define HAL_REG_KBMS1_DATA				(HAL_REG_KBMS1_BASE+0x08)
#define HAL_REG_KBMS1_IR				(HAL_REG_KBMS1_BASE+0x10)
#define HAL_REG_KBMS1_INHB				(HAL_REG_KBMS1_BASE+0x14)
#endif
#endif



#define HAL_GETMEM32(m)		(*((volatile unsigned int   *) (m)))
#define HAL_GETMEM16(m)		(*((volatile unsigned short *) (m)))
#define HAL_GETMEM8(m)		(*((volatile unsigned char  *) (m)))

#define HAL_SETMEM32(m,v)	(*((volatile unsigned int   *) (m)) = ((unsigned int) (v)))
#define HAL_SETMEM16(m,v)	(*((volatile unsigned short *) (m)) = ((unsigned short) (v)))
#define HAL_SETMEM8(m,v)	(*((volatile unsigned char  *) (m)) = ((unsigned char) (v)))


#define HAL_GETREG32(r)		(*((volatile unsigned int   *) (r)))
#define HAL_GETREG(r)		(*((volatile unsigned int   *) (r)))
#define HAL_GETREG16(r)		(*((volatile unsigned short *) (r)))
#define HAL_GETREG8(r)		(*((volatile unsigned char  *) (r)))

#define HAL_SETREG32(r,v)	(*((volatile unsigned int   *) (r)) = ((unsigned int)   (v)))
#define HAL_SETREG(r,v)		(*((volatile unsigned int   *) (r)) = ((unsigned int)   (v)))
#define HAL_SETREG16(r,v)	(*((volatile unsigned short *) (r)) = ((unsigned short) (v)))
#define HAL_SETREG8(r,v)	(*((volatile unsigned char  *) (r)) = ((unsigned char)  (v)))


enum halWDTClkSrc_E
{
	halcWDTClk_pclk		= 0,
	halcWDTClk_extclk	= 1
};

enum halI2CId_E
{
	halcI2C0	= 0,
	halcI2C1	= 1,
	halcI2C2	= 2,
//	halcI2C3	= 3
};

enum halGPIOPin_E
{
	halcGPIOPin0	= 0,
	halcGPIOPin1	= 1,
	halcGPIOPin2	= 2,
	halcGPIOPin3	= 3,
	halcGPIOPin4	= 4,
	halcGPIOPin5	= 5,
	halcGPIOPin6	= 6,
	halcGPIOPin7	= 7,
	halcGPIOPin8	= 8,
	halcGPIOPin9	= 9,
	halcGPIOPin10	= 10,
	halcGPIOPin11	= 11,
	halcGPIOPin12	= 12,
	halcGPIOPin13	= 13,
	halcGPIOPin14	= 14,
	halcGPIOPin15	= 15,
	halcGPIOPin16	= 16,
	halcGPIOPin17	= 17,
	halcGPIOPin18	= 18,
	halcGPIOPin19	= 19,
	halcGPIOPin20	= 20,
	halcGPIOPin21	= 21,
	halcGPIOPin22	= 22,
	halcGPIOPin23	= 23,
	halcGPIOPin24	= 24,
	halcGPIOPin25	= 25,
	halcGPIOPin26	= 26,
	halcGPIOPin27	= 27,
	halcGPIOPin28	= 28,
	halcGPIOPin29	= 29,
	halcGPIOPin30	= 30,
	halcGPIOPin31	= 31,

	halcGPIOPinAll	= 88
};

enum halGPIOPushBtn_E
{
	halcPushBtn0	= 0,
	halcPushBtn1	= 1,
	halcPushBtn2	= 2,
	halcPushBtn3	= 3,
	halcPushBtn4	= 4,
	halcPushBtn5	= 5,
	halcPushBtn6	= 6,
	halcPushBtn7	= 7,

	halcPushBtnAll	= 99
};

enum halGPIOIntrTrigMode_E
{
	halcGPIOIntr_edge_positive = 1,
	halcGPIOIntr_edge_negative = 2,
	halcGPIOIntr_edge_both = 3,
	halcGPIOIntr_level_activeHigh = 4,
	halcGPIOIntr_level_activeLow = 5,
};

enum halAHBMaster_E
{
	halcAHBMaster_CPU		= 1,
	halcAHBMaster_DMA_A		= 2,
	halcAHBMaster_JPEGIn	= 17,
	halcAHBMaster_JPEGOut	= 18,
	halcAHBMaster_DMA_B		= 19
};

enum halTVInputFormat_E
{
	halcTVInputFormat_CbYCrY = 0,	// normal //
	halcTVInputFormat_CrYCbY = 1,	// swap Cb/Cr //
	halcTVInputFormat_YCbYCr = 2,	// swap Y/Cb,Cr //
	halcTVInputFormat_YCrYCb = 3	// swap Y/Cb,Cr; swap Cb/Cr //

	/*
	NOTE: 

		YCbYCr422 names that the order of Y1, Cb, Y2, and Cr
		from "lsb" to "msb".

        M                       L
        S                       S
        B                       B
        +-----------------------+
        |  Cr |  Y2 |  Cb |  Y1 |
        +-----------------------+

		LSB is the low address byte and MSB is the high address byte.
	*/
};

enum halTVLCDEncoder_E
{
	halcTVLCD_TV = 1,
	halcTVLCD_LCD= 2
};

enum halLCDInputFormat_E
{
	halcLCDInputFormat_YCbYCr422	= 0,
	halcLCDInputFormat_YCrYCb422,
	halcLCDInputFormat_CbYCrY422,
	halcLCDInputFormat_CrYCbY422,

	halcLCDInputFormat_RGB1bpp,		/* need to provide a color pallet */
	halcLCDInputFormat_RGB2bpp,
	halcLCDInputFormat_RGB4bpp,
	halcLCDInputFormat_RGB8bpp,

	halcLCDInputFormat_RGB16bpp,	/* (R,G,B) = (5b,6b,5b) */
	halcLCDInputFormat_BGR16bpp,	/* (B,G,R) = (5b,6b,5b) */

	halcLCDInputFormat_RGB24bpp,	/* (R,G,B) = (8b,8b,8b) */
	halcLCDInputFormat_BGR24bpp		/* (B,G,R) = (8b,8b,8b) */

	/*
		NOTE:

		YCbYCr422 names that the order of Y1, Cb, Y2, and Cr
		from "lsb" to "msb".

        M                       L
        S                       S
        B                       B
        +-----------------------+
        |  Cr |  Y2 |  Cb |  Y1 |   YCbYCr format
        +-----------------------+

        +-----------------------+
        |  Cb |  Y2 |  Cr |  Y1 |   YCrYCb format
        +-----------------------+



		RGB names that the order of R, G, and B are from
		"msb" to "lsb".
		
        M                       L
        S                       S
        B                       B
        +-----------------------+
        |  X  |  R  |  G  |  B  |   RGB
        +-----------------------+

        +-----------------------+
        |  X  |  B  |  G  |  R  |   BGR
        +-----------------------+
	*/
};

enum halTVSys_E
{
	halcTVSys_NTSC = 1,
	halcTVSys_PAL_M	= 2,
	halcTVSys_PAL_BDGHI	= 3,
	halcTVSys_PAL_Nc	= 4
};

enum halDisplay_E
{
	halcTV	= 1,
	halcLCD	= 2,
	halcVGA	= 3
};

enum halHSDelay_E
{
	halcHSNoDelay		= 0,
	halcHSDelay1Cycle	= 1,
	halcHSDelay2Cycle	= 2,
	halcHSDelay3Cycle	= 3
};

enum halCptrCntl_E
{
	halcCptrCntl_captureEnable	= 1,
	halcCptrCntl_captureDisable,

	halcCptrCntl_skipFrame,
	halcCptrCntl_noSkipFrame,

	halcCptrCntl_VSyncActiveHigh,
	halcCptrCntl_VSyncActiveLow,

	halcCptrCntl_HSyncActiveHigh,
	halcCptrCntl_HSyncActiveLow,

	halcCptrCntl_InterleaveMode,
	halcCptrCntl_BlockMode,

	halcCptrCntl_422Format,
	halcCptrCntl_420Format,

	halcCptrCntl_YCbYCr,
	halcCptrCntl_CbYCrY,
	halcCptrCntl_YCrYCb,
	halcCptrCntl_CrYCbY,

	halcCptrCntl_littleEndian,
	halcCptrCntl_bigEndian,

	halcCptrCntl_captureOnce,
	halcCptrCntl_captureAlways,

	halcCptrCntl_conventional,
	halcCptrCntl_advanced,

	halcCptrCntl_HSNoDelay,
	halcCptrCntl_HSDelay1Cycle,
	halcCptrCntl_HSDelay2Cycle,
	halcCptrCntl_HSDelay3Cycle
};

enum halJIFormat_E			/* input format of the jpeg codec */
{
	halcJIUnknown	= 0,
	halcJIYCbCr422	= 1,
	halcJIYCbCr420	= 2,
	halcJIYCbCr444	= 3,
	halcJIGrayLevel	= 4
};

enum halRawImgFmt_E
{
	halcRawImgFmt_Unknown	= 0,
	halcRawImgFmt_YCbCr444	= 1,
	halcRawImgFmt_YCbCr422	= 2,	/* 422H */
	halcRawImgFmt_YCbCr420	= 3,
	halcRawImgFmt_GrayLevel	= 4,
	halcRawImgFmt_YCbCr422V	= 5		/* 422V, added on 08/10/2006 */
};

enum halVICIntrTrigMode_E
{
	halc_edge_activeFalling	= 0,
	halc_edge_activeRaising	= 1,
	halc_edge_activeBoth	= 2,
	halc_level_activeHigh	= 3,
	halc_level_activeLow	= 4
};

enum halTimerId_E
{
	halcTimer1Cnt1	= 1,
	halcTimer1Cnt2	= 2,
	halcTimer1Cnt3	= 3,
	halcTimer2Cnt1	= 4,
	halcTimer2Cnt2	= 5,
	halcTimer2Cnt3	= 6
};

enum halUDSP24Mem_E
{
	halcUDSP24_PM		= 0,
	halcUDSP24_DM		= 1,
	halcUDSP24_CM		= 2
};

enum halDMAPId_E
{
	halcDMAPIdC0	=	0,	/* channel 0 */
	halcDMAPIdC1	=	1,	/* channel 1 */
	halcDMAPIdC2	=	2,
	halcDMAPIdC3	=	3,
	halcDMAPIdC4	=	4,
	halcDMAPIdC5	=	5,
	halcDMAPIdC6	=	6,
	halcDMAPIdC7	=	7	/* channel 7 */
};

#if 0
enum halCFIRQId_E
{
	halcCFIRQ0	= 0,
	halcCFIRQ1	= 1
};

enum halCFFlag_E
{
	halcCFFlag_NoCF			= 0,
	halcCFFlag_CardInsert	= 1,
	halcCFFlag_PwrRstComplete= 2,
//	halcCFFlag_DataOutCmd	= 3,
	halcCFFlag_Ready		= 4,
	halcCFFlag_StatusRdy	= 5,
	halcCFFlag_StatusDrq	= 6,
	halcCFFlag_StatusErr	= 7,
	halcCFFlag_FIFODrain	= 8,
	halcCFFlag_FIFOFill		= 9,
	halcCFFlag_FIFOEmpty	= 10,
	halcCFFlag_FIFOFull		= 11,
	halcCFFlag_FIFOUnderrun	= 12,
	halcCFFlag_FIFOOverrun	= 13,
	halcCFFlag_SecCntWrAct	= 14,
	halcCFFlag_SecCntRdAct	= 15,
	halcCFFlag_StatusAct	= 16,
	halcCFFlag_CmdAct		= 17,
	halcCFFlag_ErrorAct		= 18,
	halcCFFlag_FeatureAct	= 19,
	halcCFFlag_DataWrAct	= 20,
	halcCFFlag_DataRdAct	= 21,
	halcCFFlag_EccWrAct		= 22,
	halcCFFlag_EccRdAct		= 23,
	halcCFFlag_DrvHeadWrAct	= 24,
	halcCFFlag_DrvHeadRdAct	= 25,
	halcCFFlag_CylHighWrAct	= 26,
	halcCFFlag_CylHighRdAct	= 27,
	halcCFFlag_CylLowWrAct	= 28,
	halcCFFlag_CylLowRdAct	= 29,
	halcCFFlag_SecNumWrAct	= 30,
	halcCFFlag_SecNumRdAct	= 31,

	halcCFFlag_All			= 99
};

enum halCFFlag_E
{
	halcCFFlag_NoCF			= 0,
	halcCFFlag_CardInsert	= 1,
	halcCFFlag_DataInCmd	= 2,
	halcCFFlag_DataOutCmd	= 3,
	halcCFFlag_NonDataCmd	= 4,
	halcCFFlag_Ready		= 5,
	halcCFFlag_StatusDrq	= 6,
	halcCFFlag_StatusRdy	= 7,
	halcCFFlag_StatusErr	= 8,
	halcCFFlag_FIFOOverrun	= 9,
	halcCFFlag_FIFOUnderrun	= 10,
	halcCFFlag_FIFOEmpty	= 11,
	halcCFFlag_FIFOFull		= 12,
	halcCFFlag_FIFOEccRdy	= 13,
	halcCFFlag_SecCntWrAct	= 14,
	halcCFFlag_SecCntRdAct	= 15,
	halcCFFlag_StatusAct	= 16,
	halcCFFlag_CmdAct		= 17,
	halcCFFlag_ErrorAct		= 18,
	halcCFFlag_FeatureAct	= 19,
	halcCFFlag_DataWrAct	= 20,
	halcCFFlag_DataRdAct	= 21,
	halcCFFlag_EccWrAct		= 22,
	halcCFFlag_EccRdAct		= 23,
	halcCFFlag_DrvHeadWrAct	= 24,
	halcCFFlag_DrvHeadRdAct	= 25,
	halcCFFlag_CylHighWrAct	= 26,
	halcCFFlag_CylHighRdAct	= 27,
	halcCFFlag_CylLowWrAct	= 28,
	halcCFFlag_CylLowRdAct	= 29,
	halcCFFlag_SecNumWrAct	= 30,
	halcCFFlag_SecNumRdAct	= 31,

	halcCFFlag_All			= 99
};
#endif

enum halISRMode_E
{
	halcIRQMode	= 1,
	halcFIQMode	= 2
};

#if 0
enum halUSBEvent_E
{
	USB_NO_EVT          = 0,
	USB_CTRL_EVT        = 1,
	USB_BUKIN_EVT       = 2,
	USB_BUKOUT_EVT      = 3,
	USB_OTH_EVT         = 4,
	USB_CONN_EVT		= 5,
	USB_DISCONN_EVT		= 6,
	USB_RESET_EVT       = 7
};

enum halKBMSId_E
{
	halcKBMS0_Id		= 0,
	halcKBMS1_Id		= 1
};
#endif

enum halDAIId_E
{
	halcDAITX	= 1,
	halcDAIRX	= 2,
	halcDAITXRX	= 3
};

enum halDAIDataProtocol_E
{
	halcDAII2SMode			= 4,
	halcDAILJustMode		= 0,
	halcDAIRJustMode		= 1,
	halcDAIMSBExtMode		= 2,
	halcDAIDSPMode			= 6
};

enum halUARTParity_E
{
	halcUARTParity_none		= 1,
	halcUARTParity_even		= 2,
	halcUARTParity_odd		= 3,
	halcUARTParity_stick0	= 4,
	halcUARTParity_stick1	= 5
};

enum halUARTRXFIFOThr_E
{
	halcUARTRXFIFO_1Char	= 0,
	halcUARTRXFIFO_1_4		= 1,
	halcUARTRXFIFO_1_2		= 2,
	halcUARTRXFIFO_less2	= 3
};

enum halUARTTXFIFOThr_E
{
	halcUARTTXFIFO_empty	= 0,
	halcUARTTXFIFO_2Chars	= 1,
	halcUARTTXFIFO_1_4		= 2,
	halcUARTTXFIFO_1_2		= 3
};

typedef enum halWDTClkSrc_E			halWDTClkSrc_E;
typedef enum halI2CId_E				halI2CId_E;
typedef enum halGPIOPushBtn_E		halGPIOPushBtn_E;
typedef enum halGPIOPin_E			halGPIOPin_E;
typedef enum halGPIOIntrTrigMode_E	halGPIOIntrTrigMode_E;
typedef enum halAHBMaster_E			halAHBMaster_E;
typedef enum halIntrVector_E		halIntrVector_E;
typedef enum halLCDInputFormat_E	halLCDInputFormat_E;
typedef enum halTVInputFormat_E		halTVInputFormat_E;
typedef enum halTVLCDEncoder_E		halTVLCDEncoder_E;
typedef enum halTVSys_E				halTVSys_E;
typedef enum halDisplay_E			halDisplay_E;
typedef enum halHSDelay_E			halHSDelay_E;
typedef enum halCptrCntl_E			halCptrCntl_E;
typedef enum halJIFormat_E			halJIFormat_E;
typedef enum halRawImgFmt_E			halRawImgFmt_E;
typedef enum halVICIntrTrigMode_E	halVICIntrTrigMode_E;
typedef enum halTimerId_E			halTimerId_E;
//typedef enum halUDSP24Mem_E			halUDSP24Mem_E;
typedef enum halDMAPId_E			halDMAPId_E;
//typedef enum halCFIRQId_E			halCFIRQId_E;
//typedef enum halCFFlag_E			halCFFlag_E;
typedef enum halISRMode_E			halISRMode_E;
//typedef enum halUSBEvent_E			halUSBEvent_E;
//typedef enum halKBMSId_E			halKBMSId_E;
typedef enum halDAIId_E				halDAIId_E;
typedef enum halDAIDataProtocol_E	halDAIDataProtocol_E;
typedef enum halUARTParity_E		halUARTParity_E;
typedef enum halUARTRXFIFOThr_E		halUARTRXFIFOThr_E;
typedef enum halUARTTXFIFOThr_E		halUARTTXFIFOThr_E;



typedef void (*halISR_FT)(void);
	/*
	The prototype of "interrupt service routines".
	*/




/* hal.c */
void halInitInMain(unsigned int Fin, unsigned int nHCLK, unsigned int nPCLK);
void halInitInMain2(unsigned int Fin, unsigned int nHCLK, unsigned int nPCLK);
void halDelay(int nTicks);
void halDelayMiliSec(int nMiliSecs);
int halGetTicks(void);
bool_T halRegisterISR(halISRMode_E isrMode,
				halIntrVector_E interrupt,
				halISR_FT serviceRoutine);

bool_T halUnregisterISR(halISRMode_E isrMode, halIntrVector_E interrupt);

void halIRQISR(void);
void halFIQISR(void);

#define halEnableInterrupt(interrupt)		halVICEnableIntr(interrupt)
#define halDisableInterrupt(interrupt)		halVICDisableIntr(interrupt)


/* halSys.c */
void halSysSelDisplay(halDisplay_E nDisplay);
unsigned int halSysGetHWVersion(void);
unsigned int halSysGetDIPSwitchValue(void);
void halSysShowSysInfo(void);
void halSysInternalISPEnable(int enable);
void halSysSetMultiFunctionalPin(int Device);
unsigned int halSysGetDeviceClockSrc(unsigned int Fin, int DeviceID, unsigned int *divider);
unsigned int halSysSetDeviceClockDivider(unsigned int Fin, int DeviceID, unsigned int DividerValue);
unsigned int halSysGetTimerClockSrc(unsigned int Fin);
unsigned int halSysGetWDTTimerClockSrc(unsigned int Fin);

int POM_SWReset();
int PLL_GetFCS(int pll_no, unsigned int *NR, unsigned int *NF, unsigned int *NO);
int PLL_SetFCS(int pll_no, unsigned int Fin, unsigned int NR, unsigned int NF, unsigned int NO);
unsigned int PLL_GetAHBClock(unsigned int Fin);
unsigned int PLL_GetAPBClock(unsigned int Fin);
unsigned int PLL_GetFout(int pll_no, unsigned int Fin);
int CPU_GetTurbo(void);
unsigned int CPU_PerformaceTest(int count);
int PLL1_FCS(unsigned int Fin, unsigned int NR, unsigned int NF, unsigned int NO);
int PLL0_FCS(unsigned int Fin, unsigned int NR, unsigned int NF, unsigned int NO);
int CPU_SetTurbo(int turbo);


/* halDDR2.c */
void halInitDDR2(void);

/* halAHBC.c */
void halAHBCRemapToSDRAM(void);
void halAHBCRemapToSRAM(void);
void halAHBCRemapToASRAM(void);
void halAHBCSetMasterHighPri(halAHBMaster_E);
void halAHBCSetMasterLowPri(halAHBMaster_E);


/* halGPIO.c */
#if defined(HAL_INC_GPIO)
#define halGPIOSetData(nData) (HAL_SETREG32(HAL_REG_GPIO_Data, nData))
void halGPIOSetPinDir(int gpio, halGPIOPin_E nPin, bool_T b);
void halGPIOSetPinData(int gpio, halGPIOPin_E nPin, bool_T b);
unsigned int halGPIOGetPinData(int gpio, halGPIOPin_E nPin);
#else
#define halGPIOUnmaskPushBtnIntr(pushBtn)
#define halGPIOMaskPushBtnIntr(pushBtn)
#define halGPIOSetPushBtnIntrMode(pushBtn, nIntrTrigMode)
#define halGPIOUnmaskIntr(nPin)
#define halGPIOMaskIntr(nPin)
#define halGPIOSetIntrMode(nPin, nIntrTrigMode)
#define halGPIOSetData(nData) 
#define halGPIOSetPinData(nPin, b)
#define halGPIOTogglePinData(nPin)
#define halGPIOClearPinIntr(nPin)
#endif


/* halCapture.c */
#if defined(HAL_INC_CAPTURE)
bool_T halCaptureSetControl(halCptrCntl_E);
//void halCaptureHSPolarityActiveHigh(void);
//void halCaptureHSPolarityActiveLow(void);
//void halCaptureVSPolarityActiveHigh(void);
//void halCaptureVSPolarityActiveLow(void);
//void halCaptureEnable(void);
//void halCaptureDisable(void);
//void halCaptureSetHSDelay(halHSDelay_E nDelay);
bool_T halCaptureSetCropping(unsigned short nStartWidthPix, unsigned short nWidth,
							 unsigned short nStartHeightPix,unsigned short nHeight,
							 unsigned short nWDScale, unsigned short nHDScale);
void halCaptureSetCaptureStartAddr(unsigned int n);
void halCaptureSetBlockCaptureStartAddr(unsigned int Y, unsigned int Cb, unsigned int Cr);
#else
#define halCaptureHSPolarityActiveHigh()
#define halCaptureHSPolarityActiveLow()
#define halCaptureVSPolarityActiveHigh()
#define halCaptureVSPolarityActiveLow()
#define halCaptureEnable()
#define halCaptureDisable()
#define halCaptureSetHSDelay(nDelay)
#define halCaptureSetCropping(a, b, c, d, e, f) (FALSE)
#define halCaptureSetCaptureStartAddr(n)
#endif


/* halI2C.c */
#if defined(HAL_INC_I2C1) || defined(HAL_INC_I2C2) || defined(HAL_INC_I2C0)
typedef struct i2cPacketFmt_s
{
        halI2CId_E nId;
        unsigned char nSlaveAddr;
        unsigned char *subAddr;
        unsigned short subAddrLen;
        unsigned char *data;
        unsigned short dataLen;
} i2cPacketFmt_t;

void halI2CDisable(halI2CId_E nId);
void halI2CEnable(halI2CId_E nId, unsigned int nPCLK);
int halGenericI2CWrite(i2cPacketFmt_t packet);
int halGenericI2CRead(i2cPacketFmt_t packet);
#else
#define halI2CDisable(nId)
#define halI2CEnable(nId, nPCLK)
#endif

#if defined(HAL_INC_I2C1)
#if 0
void halI2C1WriteSAA7111A(unsigned int subAddr, unsigned int data);
void halI2C1ReadSAA7111A(unsigned int subAddr, unsigned int *data);
void halI2C1EnableVideoInViaSAA7111A(unsigned char *pRegValSets, int nNumSet);
void halI2C1DisableVideoinViaSAA7111A(void);
#endif

void halI2C1WriteTW9910(unsigned int subAddr, unsigned int data);
void halI2C1ReadTW9910(unsigned int subAddr, unsigned int *data);
void halI2C1EnableVideoInViaTW9910(unsigned char *pRegValSets, int nNumSet);
void halI2C1DisableVideoinViaTW9910(void);

#if 0
void halI2C1WriteAL240(unsigned int subAddr, unsigned int data);
void halI2C1ReadAL240(unsigned int subAddr, unsigned int *data);
void halI2C1EnableVideoInViaAL240(unsigned char *pRegValSets, int nNumSet);
void halI2C1DisableVideoinViaAL240(void);
#endif
#else
#if 0
#define halI2C1WriteSAA7111A(subAddr, data)
#define halI2C1ReadSAA7111A(subAddr, data)
#define halI2C1EnableVideoInViaSAA7111A(a, b)
#define halI2C1DisableVideoinViaSAA7111A()
#endif

#define halI2C1WriteTW9910(subAddr, data)
#define halI2C1ReadTW9910(subAddr, data)
#define halI2C1EnableVideoInViaTW9910(a, b)
#define halI2C1DisableVideoinViaTW9910()

#if 0
#define halI2C1WriteAL240(subAddr, data)
#define halI2C1ReadAL240(subAddr, data)
#define halI2C1EnableVideoInViaAL240(a, b)
#define halI2C1DisableVideoinViaAL240()
#endif
#endif

#if defined(HAL_INC_I2C2)
#if 0
typedef struct halUDA1380Setting_S
{
	unsigned int nPCLK;			//AMBA clock (APB clock); used by the DAI IP
	unsigned int nSYSCLK;		//input frequency of the UDA1380's SYSCLK pin
	unsigned int nSamplingRate; //the audio/speech sampling rate; I2S protocol needs this

	bool_T bEnableMicVGA;
	unsigned char nMicVGAGain;	//Microphone input VGA gain (4-bit long)

	unsigned short nDecVolCtrl;	//Decimator volume control (16-bit long, left and right)

	bool_T bEnableAnaIn;		//enable "analog input"
	bool_T bAnaInFromMic;		//the "analog input" is from microphone or from line-in
} halUDA1380Setting_S;
#endif

typedef struct halTLV320Setting_S
{
	unsigned int nPCLK;
	unsigned int nMCLK;			//input frequency of the TLV320's MCLK pin
	unsigned int nSamplingRate;

	bool_T bEnableDAC;

	bool_T bEnableADC;

	bool_T bAnaInFromMic;	//TRUE:ADC is from microphone; FALSE:ADC is from linein

	bool_T bSitoneAdded;	//add microphonein to headphone

	bool_T bBypassLineInToHeadphone; //bypass linein to headphone
} halTLV320Setting_S;

#if 0
bool_T halI2C2WriteUDA1380(unsigned int regAddr,
		unsigned int nNumItems, unsigned int *pData);
bool_T halI2C2ReadUDA1380(unsigned int regAddr,
		unsigned int nNumItems, unsigned int *pData);
bool_T halI2C2InitUDA1380I2SMode(halUDA1380Setting_S *pSetting);
void halI2C2PowerOffUDA1380(void);
#endif

void halI2C2ResetTLV320(void);
bool_T halI2C2InitTLV320I2SMode(halTLV320Setting_S *pSetting);
void halI2C2PowerOffTLV320(void);
#else
#if 0
#define halI2C2WriteUDA1380(regAddr, nNumItems, pData) (FALSE)
#define halI2C2ReadUDA1380(regAddr, nNumItems, pData) (FALSE)
#define halI2C2InitUDA1380I2SMode(pSetting)
#define halI2C2PowerOffUDA1380()
#endif
#endif

#if 0
#if defined(HAL_INC_I2C3)
void halI2C3WriteLED(unsigned short nValue);
#else
#define halI2C3WriteLED(nValue);
#endif
#endif


/* halVIC.c */
void halVICReset(void);
void halVICSetIRQMode(halIntrVector_E);
void halVICSetFIQMode(halIntrVector_E);
void halVICSetIntrTrigMode(halIntrVector_E, halVICIntrTrigMode_E);
void halVICEnableIntr(halIntrVector_E);
void halVICDisableIntr(halIntrVector_E);
void halVICClearIntr(halIntrVector_E);
void halVICGenSWIntr(halIntrVector_E);
void halVICClearSWIntr(halIntrVector_E);
#define halVIC1ProtRegs(b) 								\
	(b ?												\
		(HAL_SETREG(HAL_REG_VIC1_ProtectionEnable, 1))	\
			:											\
		(HAL_SETREG(HAL_REG_VIC1_ProtectionEnable, 0))	\
	)


/* halTimer.c */
#if defined(HAL_INC_TIMER1)
bool_T halTimerEnable(halTimerId_E timerId,
					unsigned int nMatch1,
					unsigned int nMatch2,
					unsigned int nNumPClks);
void halTimerDisable(halTimerId_E timerId);
unsigned int halTimerGetStatus(halTimerId_E timerId);
#else
#define halTimerEnable(timerId, n1, n2, nClk) FALSE
#define halTimerDisable(timerId)
#define halTimerGetStatus(timerId) 0
#endif


/* halLCD.c */
#if defined(HAL_INC_LCD)
	#include "hal_lcd.h"
/*
	#define halLCDEnable(void)				(HAL_SETREG(HAL_REG_LCD_DOutR, 1))
	#define halLCDDisable(void)				(HAL_SETREG(HAL_REG_LCD_DOutR, 0))
	#define halLCDSetFrameDataStartAddr(x)	(HAL_SETREG(HAL_REG_LCD_BaseR, x))
	void halLCDSetInputFormat(bool_T bSysLittleEndian, halLCDInputFormat_E nFmt);
	void halLCDSetPaletteTblEntry(unsigned char nR, unsigned char nG, unsigned char nB,
								unsigned char nIdx);
	void halLCDSetBoder(unsigned int nBW, unsigned nBH, unsigned char nR,
						unsigned char nG, unsigned char nB);
*/
#else
/*
	#define halLCDEnable()
	#define halLCDDisable()
	#define halLCDSetFrameDataStartAddr(x)
	#define halLCDSetInputFormat(bSysLittleEndian, nFmt)
	#define halLCDSetPaletteTblEntry(nR, nG, nB, nIdx)
	#define halLCDSetBoder(nBW, nBH, nR, nG, nB)
*/
#endif


/* halUART.c */
#if defined(HAL_INC_UART)

typedef void (*halUARTRXCB_FT)(char);

void halUARTChangeDevice(unsigned uart_number);
bool_T halUARTInitInMain(unsigned int uart_number, unsigned int nPClk, unsigned int nBaudRate);
bool_T halUARTSetLineControl(unsigned char nNumDataBit, unsigned char nNumStopBit, halUARTParity_E);
void halUARTLoopbackTestMode(bool_T b);
void halUARTSet16550RXFIFOThr(halUARTRXFIFOThr_E threshold);
unsigned int halUARTGetChar(void);
void halUARTPutChar(char c);
int halUARTPutString(char *szString);
int halUARTPrintf(const char *szFormat, ...);
void halUARTRegisterRXCB(halUARTRXCB_FT function);
#endif


#if 0
/* halSSI.c */
#if 1

	/* API 1 */

#if defined(HAL_INC_SSI)
void halSSI_SPISetup(unsigned int nPCLK);
unsigned char halAT250x0AReadStatus(void);
void halAT250x0AWriteStatus(unsigned char nSts);
bool_T halAT250x0AReadData(unsigned short nAddr, unsigned char *pData);
void halAT250x0AWriteData(unsigned short nAddr, unsigned char nData);
void halAT250x0A_Cmd_WREN_ii(void);
#else
#define halSSI_SPISetup(nPCLK)
#define halAT250x0AReadStatus() (0)
#define halAT250x0AWriteStatus(nSts)
#define halAT250x0AReadData(nAddr, pData) (FALSE)
#define halAT250x0AWriteData(nAddr, nData)
#endif

#else

	/* API 2 */

#if defined(HAL_INC_SSI)
bool_T halSSI_SPISetup(unsigned short nSCKDV, unsigned short nDFS);
bool_T halSSI_SPIWriteRead(unsigned short *pWriteBuffer,
							unsigned short *pReadBuffer,
							unsigned int nWriteSize,
							unsigned int nReadSize);
bool_T halSSI_SPIWrite(unsigned short *pBuffer, unsigned int nSize);
#else
#define halSSI_SPISetup(nSCKDV, nDFS) (FALSE)
#define halSSI_SPIWriteRead(pWriteBuffer, pReadBuffer, nWriteSize, nReadSize) (FALSE)
#define halSSI_SPIWrite(pBuffer, nSize) (FALSE)
#endif

#endif

#endif

/* halDAI.c */
typedef struct halDAISetting_S
{
	bool_T bStereo;
	int nSamplingRate;
	halDAIDataProtocol_E nDataProtocol;
	int nTXFIFOThreshold;
	int nRXFIFOThreshold;
	bool_T bMaster;
} halDAISetting_S;

#if defined(HAL_INC_I2S)
INLINE bool_T halDAIIsBusy(void);
INLINE void halDAIResetFIFO(void);
INLINE void halDAIEnable(halDAIId_E);
INLINE void halDAIDisable(halDAIId_E);
#define halDAIConfig(a, b, c) (FALSE)
bool_T halDAIConfig_master(halDAISetting_S *pSetting, unsigned int Fin, unsigned int *pCodecCLK);
bool_T halDAIConfig_slave(halDAISetting_S *pSetting, unsigned int Fin, unsigned int *pCodecCLK);
#define halDAIGetAudioOSCCLK() (HAL_AUDIO_OSC_CLK)
#else
#define halDAIIsBusy() (TRUE)
#define halDAIResetFIFO() 
#define halDAIEnable(a)
#define halDAIDisable(a)
#define halDAIConfig_master(a, b, c) (FALSE)
#define halDAIConfig_slave(a, b, c) (FALSE)
#define halDAIGetAudioOSCCLK() 0
#endif


#if 0
/* halusbmass.c */
#if defined(HAL_INC_USB20)

#define HAL_USB20_INIT_BUF_SIZE	8600

/*
 * prototypes of USB's mass-storage IO routines
 */
typedef unsigned int (*halUSBMSGetCapacity_FT) (void);

typedef bool_T (*halUSBMSReadNSector_FT) (unsigned int /* start sector */,
										unsigned int /* sector number*/,
										void * /* buffer address */);

typedef bool_T (*halUSBMSWriteNSector_FT) (unsigned int /* start sector */,
										unsigned int /* sector number*/,
										void * /* buffer address */);

typedef PACKED_STRUCT halUSBMSIORoutine_S
{
	halUSBMSGetCapacity_FT getCapacity;
	halUSBMSReadNSector_FT readNSector;
	halUSBMSWriteNSector_FT writeNSector;
} halUSBMSIORoutine_S;


unsigned int usbInitInMain(halUSBMSIORoutine_S *ioRoutine, unsigned int *pUSBBuf);
	/*
	 * the buffer size pointed by pUSBBuf could not be smaller than
	 * HAL_USB20_INIT_BUF_SIZE
	 */

halUSBEvent_E usbIRQHandler(void);
void usbMassStorageEventHandler(void);
#else
#define usbInitInMain(ioRoutine)
#define usbIRQHandler() (USB_NO_EVT)
#define usbMassStorageEventHandler()
#endif
#endif

/* halFlash.c */
int halFlashReset(void);
unsigned int halFlashGetSectorCount(void);
int halFlashGetID(unsigned short *flash_id);
bool_T halFlashEraseAll(void);

bool_T halFlashIsValidSector(unsigned int nSectorNum);
bool_T halFlashEraseSector(unsigned int nSectorNum);
bool_T halFlashProgramSector(unsigned int nSectorNum,
				unsigned char *pBuf, unsigned int nSize);
bool_T halFlashGetSectorSize(unsigned int nSectorNum, unsigned int *pnSize);
bool_T halFlashGetSectorOffsetAddr(unsigned int nSectorNum, unsigned int *pnStartAddr);
bool_T halFlashGetSectorNum(unsigned int nPhyAddr, unsigned int *pnSectorNum);

bool_T halFlashProgramSeg(unsigned int nSegStartAddr,
				unsigned char *pBuf, unsigned int nSize);
bool_T halFlashProgram8(unsigned int nAddr, unsigned char nData);

#define halFlashRead32(nAddr)				HAL_GETMEM32(HAL_REG_SMC + (nAddr & 0xFFFFFFFC))
#define halFlashRead16(nAddr)				HAL_GETMEM16(HAL_REG_SMC + (nAddr & 0xFFFFFFFE))
#define halFlashRead8(nAddr)				HAL_GETMEM8(HAL_REG_SMC + nAddr)

#define halFlashWrite32(nAddr, value)	HAL_SETMEM32(HAL_REG_SMC + (nAddr & 0xFFFFFFFC), value)
#define halFlashWrite16(nAddr, value)	HAL_SETMEM16(HAL_REG_SMC + (nAddr & 0xFFFFFFFE), value)
#define halFlashWrite8(nAddr, value)	HAL_SETMEM8(HAL_REG_SMC + nAddr, value)

/* halNAND.c */
int halNandReset(void);
int halNandGetID(unsigned int *id);
bool_T halNandEraseAll(void);

unsigned int halNandGetBlockCount(void);

bool_T halNandIsValidBlock(unsigned int nSectorNum);
bool_T halNandEraseBlock(unsigned int nSectorNum);

bool_T halNandGetBlockSize(unsigned int nSectorNum, unsigned int *pnSize);
bool_T halNandGetBlockOffsetAddr(unsigned int nSectorNum, unsigned int *pnStartAddr);
bool_T halNandGetBlockNum(unsigned int nPhyAddr, unsigned int *pnSectorNum);

bool_T halNandGetPageSize(unsigned int nPageNum, unsigned int *pnSize);
bool_T halNandGetSpareSize(unsigned int nPageNum, unsigned int *pnSize);
bool_T halNandEraseBlock(unsigned int nBlockNum);
bool_T halNandProgramBlock(unsigned int nBlockNum, unsigned char *pBuf, unsigned int nSize, int WithSpare);
bool_T halNandProgramPage(unsigned int nPageNum,unsigned char *pBuf, unsigned int nSize, int WithSpare);
bool_T halNandProgramSpare(unsigned int nPageNum,unsigned char *pBuf, unsigned int nSize);
bool_T halNandReadBlock(unsigned int nBlockNum, unsigned char *pBuf, unsigned int nSize, int WithSpare);
bool_T halNandReadPage(unsigned int nPageNum, unsigned char *pBuf, unsigned int nSize, int WithSpare);
bool_T halNandReadSpare(unsigned int nPageNum, unsigned char *pBuf, unsigned int nSize);

/* halWDT.c */
#if defined(HAL_INC_WDT)
void halWDTEnable(void);
void halWDTDisable(void);
void halWDTReStartNew(unsigned int nPeriod, halWDTClkSrc_E sourceClk,
		bool_T bResetOut, bool_T bIntrSys, bool_T bResetSys);
void halWDTReStart(void);
#define halWDTClearTimeOut() (HAL_SETREG(HAL_REG_WDT_Clr, 1))
#else
#define halWDTEnable()
#define halWDTDisable()
#define halWDTReStartNew(nPeriod, sourceClk, bResetOut, bIntrSys, bResetSys)
#define halWDTReStart()
#define halWDTClearTimeOut() 
#endif


/* halSD.c   : for GUC SD_MMC IP, use the same interface for sd and mmc cards
   halSD2.c  : for GUC SD_MMC IP, only sd card access function
   halDWSD.c : for design_ware SD_MMC IP, only for sd card access

   1. to compile halSD.c, one need to define HAL_INC_SD and not define HAL_INC_SD2
   2. to compile halSD2.c, one need to define HAL_INC_SD and HAL_INC_SD2
   3. to compile halDWSD.c, one need to define HAL_INC_DWSD
   
   stan's opinion : either open HAL_INC_SD or HAL_INC_DWSD
*/
void SdEnableInt(unsigned int mask);
unsigned int SdClearInt();

bool_T halSDCardExist(void);
bool_T halSDInstall(int sd_pclk);
bool_T halSDIsInstall(void);
bool_T halSDUninstall(void);
unsigned int halSDGetCapacity(void);
bool_T halSDWriteProtect(void);
bool_T halSDReadNSector( unsigned int nStartSect, unsigned int nSectNum, void *pBuf);
bool_T halSDWriteNSector( unsigned int nStartSect, unsigned int nSectNum, void *pBuf);


/* halDMAP.c */
#if defined(HAL_INC_DMAP)
int halDMAPGetChannelNum(void);
bool_T halDMAPIsChannelBusy(halDMAPId_E nCnId);
#else
#define halDMAPGetChannelNum() (0)
#define halDMAPIsChannelBusy(nCnId) (TRUE)
#endif


void init_flash(void);
void read_ID(void);
void erase_block(int _chipID, int nBlockNum);
void read_phy_sector(unsigned int _start_sector,
					unsigned int _data_length,
					unsigned int *pBuf,
					int _chipID);
void write_multi_phy_page(unsigned int _write_start_sector,
						unsigned int _data_length,
						unsigned int *pBuf,
						int _chipID);




EXTERN_C_END

#endif /* _hal_h_ */

