#ifndef __ASM_ARCH_HARDWARE_H__
#define __ASM_ARCH_HARDWARE_H__

#define A1_TIMER_BASE	0x9a500000
#define A1_UART0_BASE	0x99d00000
#define A1_VIC_BASE		0x90800000
#define A1_SYS_BASE		0x99000000
#define A1_WDT_BASE		0x99400000	
#define A1_NAND_BASE	0x90500000

/* Bob Create following definition for global reference */
#ifndef __A1_writel
	#define  __A1_writel	writel
#endif

#ifndef __A1_readl
	#define  __A1_readl		readl
#endif

#ifndef HAL_REG_SYS_BASE
	#define HAL_REG_SYS_BASE           0x99000000
#endif

#define HAL_GETREG32(r)     (*((volatile unsigned int   *) (r)))
#define HAL_SETREG32(r,v)   (*((volatile unsigned int   *) (r)) = ((unsigned int)   (v)))

#include <asm/arch/pin_mux.h>
#include <asm/arch/debug.h>

#define mdelay(n)	udelay((n)*1000)

#define WDT_StsR 		0x00
#define WDT_ReloadR 	0x04
#define WDT_RestartR 	0x08
#define WDT_ClrR 		0x0C
#define WDT_TimeoutR 	0x10
#define WDT_RELOAD_MAGIC	0x4755

/*
 * For debug purpose
 */
#ifdef CONFIG_A1_EARLY_SERIAL_INIT
	#define FTrace(str)	\
	{\
	char buf[128];\
	sprintf(buf, str"-[%s]\r\n", __FUNCTION__);\
	__A1_WriteSerial(buf);\
	}
#else
	#define FTrace(str)	
#endif

#endif /* __ASM_ARCH_HARDWARE_H__ */
