/*
 * ASoC driver for UMVP platform
 *
 * Author:      Betta Lin, <Betta.Lin@acti.com>
 * Copyright:   (C) 2010 ACTI, Inc., 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/timer.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/soc.h>
#include <sound/soc-dapm.h>

#include <asm/dma.h>
#include <mach/hardware.h>
#include <mach/platform2500.h>


#include "../codecs/tw2865.h"
#include "umvp-pcm.h"
#include "umvp-i2s.h"


/*
SND_SOC_DAIFMT_NB_NF :           
normal bit clock + frame 
*/

/*  codec clk & frame master */
#define AUDIO_FORMAT SND_SOC_DAIFMT_I2S | SND_SOC_DAIFMT_NB_NF | SND_SOC_DAIFMT_CBM_CFM



static int umvp_hw_params(struct snd_pcm_substream *substream,
	struct snd_pcm_hw_params *params)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *codec_dai = rtd->dai->codec_dai;
	struct snd_soc_dai *cpu_dai = rtd->dai->cpu_dai;
	int ret = 0;


#if 0
	unsigned int clk = 0;
/* The followings are sampling rate supported by TW2865 */
	switch (params_rate(params)) {
	case 8000:
	case 16000:
	case 48000:
	case 96000:
	/* clk = 48000 x 256 fs */
		clk = 12288000; 
		break;
	case 11025:
	case 22050:
	case 44100:
	/* clk = 44100 x 256 fs */
		clk = 11289600;
		break;
	}

	
#endif	

	/* set codec DAI configuration */
		
	ret = snd_soc_dai_set_fmt(codec_dai, AUDIO_FORMAT);
	if (ret < 0)
		return ret;


	/* set cpu DAI configuration */
	ret = snd_soc_dai_set_fmt(cpu_dai, AUDIO_FORMAT);
	if (ret < 0)
		return ret;


/* => call tw2865_set_dai_sysclk */ 
	if (ret < 0)
		return ret;
		
#if 0		
/* 12M/clk */
	if ( (UMVP2500_APBCLOCK / clk ) > 1 )
	{
		int div = UMVP2500_APBCLOCK/clk;
		snd_soc_dai_set_clkdiv(cpu_dai, UMVP_CODEC_CLK_DIV_ON, div);
			
			
	}
	else 
	{
		snd_soc_dai_set_clkdiv(cpu_dai, UMVP_CODEC_CLK_DIV_OFF, 0);
	}
	if (ret < 0)
		return ret;
#endif
		
/*
int snd_soc_dai_set_clkdiv(struct snd_soc_dai *dai,
        int div_id, int div);



*/

	return 0;
}
		

static struct snd_soc_ops umvp_ops = {
	.hw_params = umvp_hw_params,
};

/* umvp digital audio interface glue - connects codec <--> CPU */
static struct snd_soc_dai_link umvp_dai = {
	.name = "TW2865",
	.stream_name = "TW2865",
	.cpu_dai = &umvp_i2s_dai,  /* defined in umvp-i2s.c */
	.codec_dai = &tw2865_dai, /*  defined in tw2865.c */
/* unconnected codec pins can be set and 
	 machine specific audio mixer controls can be added 
	 in the DAI init function
*/	
	//.init = tw2865_pins_init,
	.ops = &umvp_ops, 
};

/* umvp audio machine driver */
static struct snd_soc_card snd_soc_card_umvp = {
	.name = "UMVP TW2865",
	.platform = &umvp_soc_platform, /* defined in umvp-pcm.c */
	.dai_link = &umvp_dai,
	.num_links = 1,
};

/* umvp audio private data */

#if 1
static struct tw2865_setup_data umvp_tw2865_setup = {
	.i2c_bus = 1,
	.i2c_address = 0x28,
};
#endif

/* umvp audio subsystem */
static struct snd_soc_device umvp_snd_devdata = {
	.card = &snd_soc_card_umvp,
	.codec_dev = &soc_codec_device_tw2865,
	.codec_data = &umvp_tw2865_setup,
};

static struct resource umvp_snd_resources[] = {
	{
		.start = UMVP_DAI_BASE,
		.end = UMVP_DAI_BASE + SZ_4K - 1,
		.flags = IORESOURCE_MEM,
	},
};




static struct platform_device *umvp_snd_device;

static int __init umvp_tw2865_init(void)
{
	int ret;

	/* Note : Don't change the string "soc-audio" */
	umvp_snd_device = platform_device_alloc("soc-audio", 0);
	
	if (!umvp_snd_device)
		return -ENOMEM;

	platform_set_drvdata(umvp_snd_device, &umvp_snd_devdata);
	umvp_snd_devdata.dev = &umvp_snd_device->dev;
	//umvp_snd_device->dev.platform_data = &umvp_snd_data;

	ret = platform_device_add_resources(umvp_snd_device, umvp_snd_resources,
					    ARRAY_SIZE(umvp_snd_resources));
	if (ret) {
		platform_device_put(umvp_snd_device);
		return ret;
	}

	ret = platform_device_add(umvp_snd_device);
	if (ret)
		platform_device_put(umvp_snd_device);

	return ret;
}

static void __exit umvp_tw2865_exit(void)
{
	platform_device_unregister(umvp_snd_device);
}

module_init(umvp_tw2865_init);
module_exit(umvp_tw2865_exit);

MODULE_AUTHOR("Betta Lin");
MODULE_DESCRIPTION("UMVP-TW2865 machine ASoC driver");
MODULE_LICENSE("GPL");
