#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/stat.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <mach/hardware.h>
#include <mach/lcm.h>
#include <asm/io.h>
#include <asm/ioctl.h>
#include <asm/uaccess.h>

struct lcm_dev_T {
	unsigned char row;
	unsigned char col;
	char	buf[16];
};

struct lcm_dev_T *plcm;

int __lcm_init(void) {

	unsigned char i;
	int ret=0;

	plcm = kmalloc(sizeof(struct lcm_dev_T), GFP_KERNEL);
	if (!plcm) {
		ret = -ENOMEM;
		goto fail;
	}

	printk(KERN_INFO "lcm initialize \n");
	UMVP_LCM_WRITE_REG(LCM_CTRL1, 0x05014015);
	UMVP_LCM_WRITE_REG(LCM_CTRL2, 0x0C006000);
	UMVP_LCM_WRITE_REG(LCM_CTRL_START, 0x00000000);
	for (i=0; i<8; i++) {
		UMVP_LCM_WRITE_REG(LCM_DATA1+i*4, 0x20202020);
	}
	UMVP_LCM_WRITE_REG(LCM_DATA_START, 1);
	return 0;
fail:
	printk("Failed to allocate MEMORY for LCM Driver! \n");
	return ret;
}

void write_one_data(unsigned char nRow, unsigned char nCol, char cData) {

	unsigned char   nRegOffset,nDataOffset;
	unsigned int    nData;
	
	nRow &= 1;
	nCol &= 0xf;
	nRegOffset = nCol/4;
	nDataOffset= nCol%4;

	if(nRow) {
		nData = UMVP_LCM_READ_REG(LCM_DATA1+nRegOffset*4 + 0x10);
	}
	else {
		nData = UMVP_LCM_READ_REG(LCM_DATA1+nRegOffset*4);
	}
	switch(nDataOffset)
        {
		case 0:
			nData &= 0x00ffffff;
			nData |= (cData<<24);
			break;
		case 1:
			nData &= 0xff00ffff;
			nData |= (cData<<16);
			break;
		case 2:
			nData &= 0xffff00ff;
			nData |= (cData<<8);
			break;
		case 3:
			nData &= 0xffffff00;
			nData |= cData;
			break;
	}
	if(nRow) {
		UMVP_LCM_WRITE_REG(LCM_DATA1+nRegOffset*4 + 0x10, nData);
	}
	else {
		UMVP_LCM_WRITE_REG(LCM_DATA1+nRegOffset*4, nData);
	}
}

ssize_t __lcm_write(size_t count, char *buf) {
	
	unsigned int 	i;
	unsigned char   nCol = plcm->col;

	while((count + nCol) > 16) {
		if(--count == 0)
			break;
	}
//	printk(KERN_INFO "LCM_WRITE_DATA... \n");
	for(i=0; i<count; i++) {
		write_one_data(plcm->row, nCol++, buf[i]);
	}
	UMVP_LCM_WRITE_REG(LCM_DATA_START, 1);

	return 0;
}

#if 0	/* We don't need to read from LCM */
char read_one_data(unsigned char nRow, unsigned char nCol) {

	unsigned char   nRegOffset, nDataOffset;
	unsigned int    nData;

	nRow &= 1;
	nCol &= 0xf;
	nRegOffset = nCol/4;
	nDataOffset= nCol%4;

	if(nRow)
		nData = UMVP_LCM_READ_REG(LCM_DATA1+nRegOffset*4 + 0x10);
	else
		nData = UMVP_LCM_READ_REG(LCM_DATA1+nRegOffset*4);
	switch(nDataOffset)
	{
		case 0:
			nData = ((nData>>24) & 0xff);
			break;
		case 1:
			nData = ((nData>>16) & 0xff);
			break;
		case 2:
			nData = ((nData>>8) & 0xff);
			break;
		case 3:
			nData = ((nData>>0) & 0xff);
			break;
	}
	return nData;
}

void __lcm_read(size_t count) {
	
	unsigned int i;
	unsigned char nCol=0;
	while((count + nCol) > 16) {
		if(--count == 0)
			break;
	}
	for(i=0; i<count; i++) {
		plcm->buf[i] = read_one_data(plcm->row, nCol++);
	}
}
#endif

void __lcm_row_clean(unsigned char nRow) {

	unsigned int i;
	char whitespace[] = "                ";

	for(i=0; i<sizeof(whitespace)-1; i++) {
		write_one_data(nRow, i, whitespace[i]);
	}
	UMVP_LCM_WRITE_REG(LCM_DATA_START, 1);
}

void __lcm_ioctl(u32 cmd, u32 arg, char *buf, size_t size) {

	switch(cmd)
	{
		case LCM_ROW_CMD:
			plcm->row = ((unsigned char)arg & 1);
			break;
		case LCM_COL_CMD:
			plcm->col = (unsigned char)arg;
			break;
#if 0
		case LCM_READ_CMD:
			__lcm_read(size);
			break;
#endif
		case LCM_WRITE_CMD:
			__lcm_write(size, buf);
			break;
		default:
			break;
	}
}

void __lcm_display(u32 row, u32 col, char *buf) {
	__lcm_ioctl(LCM_ROW_CMD, row, NULL, 0);
	__lcm_ioctl(LCM_COL_CMD, col, NULL, 0);
	__lcm_ioctl(LCM_WRITE_CMD, 0, buf, strlen(buf));
}
