/*
 * arch/arm/mach-umvp2501/include/mach/uncompress.h
 *
 * Author:	Rudolph Lu
 * Copyright:	(C) 2009 Global Unichip Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef  __UMVP2501_UNCOMPRESS_H
#define  __UMVP2501_UNCOMPRESS_H
#include <mach/platform2500.h>

#define UMVP2500_UART			UMVP_UART0_BASE
#define UART_THRE				(0x1<<5)

typedef  volatile u32   reg32;
typedef  volatile const u32 ro_reg32;

typedef struct _UARTCON{
  reg32	UARTRTDR;		/*UARTRBR : Receive Buffer Register*/
   						/*UARTTHR : Transmit Holding Register*/
  						/*UARTDLLR: Divisor Latch (Low), when DLAB bit is 1*/
  reg32	UARTTITDR;		/*UARTIER : Interrupt Enable Register*/
						/*UARTDLHR: Divisor Latch (High), when DLAB bit is 1*/
  reg32	UARTTITFR;		/*UARTIIR : Interrupt Identity Register*/
						/*UARTFCR : FIFO Control Register*/
  reg32	UARTLCR;		/*Line Control Register*/
  reg32	UARTMCR;		/*Modem Control Register*/
  ro_reg32	UARTLSR;	/*Line Status Register*/
  ro_reg32	UARTMSR;	/*Modem Status Register*/
  reg32	UARTSCR;		/*Scratch Register*/ 
}UARTCON,*pUARTCON;

/*-----------------------------------------------------------------------
 * Call by misc.c
 */
static inline void putc(char c)
{
	pUARTCON uart = (pUARTCON)(UMVP2500_UART);
	
	do{
		//Wait until FIFO was free.		
		__asm__ volatile ("NOP"::);
		__asm__ volatile ("" : : : "memory");
	}while(!(uart->UARTLSR&UART_THRE));

	uart->UARTRTDR = (u32)(c&0xff);
}

/*
 * This does not append a newline
 */
static inline void flush(void)
{
}

/* ----------------------------------------------------
 * UART default setting should be done by Bootloader.
 */
static inline void arch_decomp_setup(void)
{
}

/*
 * nothing to do
 */
#define arch_decomp_wdog()

#endif
