/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __asm_arch_platform3000_h__
#define __asm_arch_platform3000_h__

#define Reserve(a,b)		PAD##a[b]
#define BYTEMASK			(0xff)
#define ALIGN4				(0x3)

#define A1_SYS_CLOCK_SRC		(12*1000*1000)//12 MHz
#define UMVP2500_SYS_CLK_FREQ	225000000	// 225MHz

#define UMVP2500_SYS_CLK_DIV	2
#define UMVP2500_APBCLOCK		( UMVP2500_SYS_CLK_FREQ / UMVP2500_SYS_CLK_DIV )
//#define TICKS_PER_uSEC			( UMVP2500_APBCLOCK / 1000000 )
#define CONFIG_SYS_CLK_DIV		UMVP2500_SYS_CLK_DIV

/*
 *-------------------------------------------------------
 * Static memory Layout
 *-------------------------------------------------------
 */
#define UMVP2500_ROMBASE                (0x20000000)
#define UMVP2500_INTERNAL_SRAM_BASE     (0x20000000)
#define UMVP2500_FLASHBASE              (0x40000000)

#define UMVP2500_IO_VIRT_BASE           (0xe0000000)

//Physical Address  to Virtual Address transformer.
#define UMVP2500_P2V(x)                 ((x-UMVP2500_ROMBASE)+UMVP2500_IO_VIRT_BASE)
#define UMVP2500_FLASHSIZE              (0x800000)

#define MAXIRQNUM				31
#define UMVP_IO_START			0x90000000
#define UMVP_IO_SIZE			0x0C000000

#define INT_USB             	2	
#define INT_ETHERNET            3	
#define INT_DMAP                4	
#define INT_SDC                 5	
#define INT_NAND				6
#define INT_VCAP 				7
#define INT_HX8290              8
#define INT_HX9170              9
#define INT_ISP_C1              10
#define INT_UARTINT0            12	
#define INT_UARTINT1            13	
#define INT_UARTINT2            14	
#define INT_UARTINT3            15	
#define INT_UARTINT4            16	
#define INT_GPIO0               17	
#define INT_GPIO1               18	
#define INT_GPIO2               19	
#define INT_GPIO3               20	
#define INT_GPIO4               21	
#define INT_TIMERINT0           27	
#define INT_TIMERINT1           28	
#define INT_TIMERINT2           29	
#define INT_WDT                 30	

#define INTMASK_GPIO0           (1 << INT_GPIO0)
#define INTMASK_GPIO1           (1 << INT_GPIO1)
#define INTMASK_GPIO2           (1 << INT_GPIO2)
#define INTMASK_GPIO3           (1 << INT_GPIO3)
#define INTMASK_GPIO4           (1 << INT_GPIO4)
#define INTMASK_SDC             (1 << INT_SDC)
#define INTMASK_NAND			(1 << INT_NAND)
#define INTMASK_TIMERINT0       (1 << INT_TIMERINT0)
#define INTMASK_TIMERINT1       (1 << INT_TIMERINT1)
#define INTMASK_TIMERINT2       (1 << INT_TIMERINT2)
#define INTMASK_DMAP            (1 << INT_DMAP)
#define INTMASK_ETHERNET        (1 << INT_ETHERNET)
#define INTMASK_UARTINT0        (1 << INT_UARTINT0)
#define INTMASK_UARTINT1        (1 << INT_UARTINT1)
#define INTMASK_UARTINT4        (1 << INT_UARTINT4)
#define INTMASK_WDT             (1 << INT_WDT)
#define INTMASK_USB				(1 << INT_USB)
#define INTMASK_HX8290			(1 << INT_HX8290)
#define INTMASK_HX9170			(1 << INT_HX9170)
#define INTMASK_NAND			(1 << INT_NAND)
#define INTMASK_VCAP			(1 << INT_VCAP)
#define INTMASK_ISP_C1			(1 << INT_ISP_C1)

#define UMVP_VIC_VALID_INTMASK      (INTMASK_GPIO0|          \
									INTMASK_GPIO1|      \
									INTMASK_GPIO2|      \
									INTMASK_GPIO3|      \
									INTMASK_GPIO4|      \
									INTMASK_ISP_C1|		\
									INTMASK_TIMERINT0|      \
									INTMASK_TIMERINT1|      \
									INTMASK_TIMERINT2|      \
									INTMASK_USB|			\
									INTMASK_ETHERNET|       \
									INTMASK_DMAP|           \
									INTMASK_UARTINT0|       \
									INTMASK_UARTINT4|       \
									INTMASK_HX8290|			\
									INTMASK_HX9170|			\
									INTMASK_NAND|			\
									INTMASK_SDC|            \
									INTMASK_VCAP|           \
                                    INTMASK_WDT)

#define UMVP_ETHERNET_BASE		0x90400000	// FIXME
#define UMVP_DMAP_BASE			0x90600000  // FIXME	/* DMA - Peripheral */
#define UMVP_SDMMC_BASE     	0x90700000  // FIXME	/* SD/MMC */
#define UMVP_VIC_BASE			0x90800000  // FIXME
#define UMVP_LCD_BASE			0x90900000  // FIXME 	/* LCD controller   */
#define UMVP_VCAP_BASE         	0x90B00000 	// VCAP
#define UMVP_SYSTEM_BASE		0x99000000  // FIXME

#define UMVP_POM_BASE			0x99100000  // FIXME
#define UMVP_WDT_BASE			0x99400000  
#define UMVP_I2C0_BASE			0x99500000  
#define UMVP_I2C1_BASE			0x99600000  
#define UMVP_I2C2_BASE			0x99700000  
#define UMVP_GPIO0_BASE			0x99800000	
#define UMVP_GPIO1_BASE			0x99900000	
#define UMVP_GPIO2_BASE			0x99a00000	
#define UMVP_GPIO3_BASE			0x99b00000	
#define UMVP_GPIO4_BASE			0x99c00000	

#define UMVP_UART0_BASE			0x99d00000
#define UMVP_UART1_BASE			0x99e00000
#define UMVP_UART2_BASE			0x99f00000
#define UMVP_UART3_BASE			0x9a000000
#define UMVP_UART4_BASE			0x9a100000

#define UMVP_DAI_BASE			0x9a400000  /* DAI 		*/
#define UMVP_TIMER_BASE			0x9a500000

#define UHC_BASE_ADDR			0x90C00000  /* UHCI CONTROLLER  */
#define MEDUSA_BASE_ADDR		0x90C04000  /* MEDUSA DEVICE    */
#define OTG_BASE_ADDR			0x90C08000  /* OTG CONTROLLER   */
#define EHC_AHB_BASE_ADDR		0x90C0C000  /* EHCI CONTROLLER  */


#define UMVP_VIC_STATUS_OFFSET          0x00
#define UMVP_VIC_RAW_STATUS_OFFSET      0X08
#define UMVP_VIC_INT_SEL_OFFSET         0x0C
#define UMVP_VIC_ENABLE_SET_OFFSET      0x10
#define UMVP_VIC_ENABLE_CLEAR_OFFSET    0x14
#define UMVP_VIC_SENSE_OFFSET           0x24
#define UMVP_VIC_BOTH_EDGE_OFFSET       0x28
#define UMVP_VIC_EVENT_OFFSET           0x2C
#define UMVP_VIC_EDGE_CLEAR_OFFSET      0x38

#define UMVP_TIMER0_OFFSET              0x00
#define UMVP_TIMER1_OFFSET              0x10
#define UMVP_TIMER2_OFFSET              0x20
#define UMVP_TIMER_CTRL_OFFSET          0x30

/////////////////////////////////////////////////////////////////////////////////////////////
/* for multiple functional pins */
#define HAL_MFP_SMC				0
#define HAL_MFP_NAND			1
#define HAL_MFP_SDC				2
#define HAL_MFP_LCD				3
#define HAL_MFP_USB				4

#define HAL_MFP_I2C0			10
#define HAL_MFP_I2C1			11
#define HAL_MFP_I2C2			12

#define HAL_MFP_I2S				15
#define HAL_MFP_SSI				16
#define HAL_MFP_SSI_ISP			161
#define HAL_MFP_TMR				17
#define HAL_MFP_WDT				18

#define HAL_MFP_UART0			20
#define HAL_MFP_UART1			21
#define HAL_MFP_UART2			22
#define HAL_MFP_UART3			23
#define HAL_MFP_UART4			24

#define HAL_MFP_H8290			25
#define HAL_MFP_H9170			26
#define HAL_MFP_ISP				30
#define HAL_MFP_ISP_DEBUG		301
#define HAL_MFP_ISP_DEBUG_OFF	302
#define HAL_MFP_EXTERNAL_ISP  	31
#define HAL_MFP_VCAP			32
#define HAL_MFP_SENSOR			33
#define HAL_MFP_SENSOR_DIV		34

#define HAL_MFP_GPIO_AP			35
#define HAL_MFP_GPIO_AP_POWER	351

/* SYS */
#define HAL_REG_SYS_OSCCtrl				(HAL_REG_SYS_BASE+0x00)
#define HAL_REG_SYS_CPUMode				(HAL_REG_SYS_BASE+0x04)
#define HAL_REG_SYS_PMUSts				(HAL_REG_SYS_BASE+0x08)

#define HAL_REG_SYS_MSF0					(HAL_REG_SYS_BASE+0x0C)
#define HAL_REG_SYS_MSF1					(HAL_REG_SYS_BASE+0x10)
#define HAL_REG_SYS_MSF2					(HAL_REG_SYS_BASE+0x14)
#define HAL_REG_SYS_MSF3					(HAL_REG_SYS_BASE+0x18)
#define HAL_REG_SYS_MSF4					(HAL_REG_SYS_BASE+0x1C)
#define HAL_REG_SYS_MSF5					(HAL_REG_SYS_BASE+0x20)

#define HAL_REG_SYS_AHBGateCtrl			(HAL_REG_SYS_BASE+0x24)
#define HAL_REG_SYS_APBGateCtrl			(HAL_REG_SYS_BASE+0x28)

#define HAL_REG_SYS_JumpSts				(HAL_REG_SYS_BASE+0x2C)
#define HAL_REG_SYS_SRCSel				(HAL_REG_SYS_BASE+0x30)
#define HAL_REG_SYS_CLKDivCnt0			(HAL_REG_SYS_BASE+0x34)
#define HAL_REG_SYS_CLKDivCnt1			(HAL_REG_SYS_BASE+0x38)
#define HAL_REG_SYS_CLKDivCnt2			(HAL_REG_SYS_BASE+0x3c)
#define HAL_REG_SYS_CLKDivCnt3			(HAL_REG_SYS_BASE+0x40)
#define HAL_REG_SYS_CLKDivCnt4			(HAL_REG_SYS_BASE+0x44)
#define HAL_REG_SYS_CLKDivCnt5			(HAL_REG_SYS_BASE+0x48)

#define HAL_REG_SYS_NANDBootCtrl0		(HAL_REG_SYS_BASE+0x60)
#define HAL_REG_SYS_NANDBootCtrl1		(HAL_REG_SYS_BASE+0x64)
#define HAL_REG_SYS_NANDBootCtrl2		(HAL_REG_SYS_BASE+0x68)
#define HAL_REG_SYS_NANDBootCtrl3		(HAL_REG_SYS_BASE+0x6C)
#define HAL_REG_SYS_NANDBootCtrl4		(HAL_REG_SYS_BASE+0x70)
#define HAL_REG_SYS_NANDBootCtrl5		(HAL_REG_SYS_BASE+0x74)
#define HAL_REG_SYS_NANDBootCtrl6		(HAL_REG_SYS_BASE+0x78)
#define HAL_REG_SYS_NANDBootCtrl7		(HAL_REG_SYS_BASE+0x7C)

#define HAL_REG_SYS_DDR2PhyCtrl			(HAL_REG_SYS_BASE+0x80)

#define HAL_REG_SYS_VerNum				(HAL_REG_SYS_BASE+0xF000)
#endif
