/*
 * arch/arm/mach-umvp/include/mach/entry-macro.S
 *
 * Low-level IRQ helper macros for UMVP-based platforms
 *
 * This file is licensed under  the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
*/

/* We have a problem that the INTOFFSET register does not always
 * show one interrupt. Occasionally we get two interrupts through
 * the prioritiser, and this causes the INTOFFSET register to show
 * what looks like the logical-or of the two interrupt numbers.
 *
 * Thanks to Klaus, Shannon, et al for helping to debug this problem
*/
#include <mach/hardware.h>

#define INTPND		(0x10)
#define INTOFFSET	(0x14)

	.macro  get_irqnr_preamble, base, tmp
	.endm

	.macro  arch_ret_to_user, tmp1, tmp2
	.endm

	.macro	get_irqnr_and_base, irqnr, irqstat, base, tmp
		ldr \base, =IO_ADDRESS(UMVP_VIC_BASE)
        ldr \irqstat, [\base, #UMVP_VIC_STATUS_OFFSET]     @ get masked status

        mov \irqnr, #0
1000:   tst \irqstat, #1        // Check irqstat[irqnr] is 1 or not.
        bne 1300f               // If irqstat[irqnr] is 1, service

        // check next bit
        add \irqnr, \irqnr, #1
        mov \irqstat, \irqstat, lsr #1
        cmp \irqnr, #32     /* If irqnr is number 32, all bits on VIC1 */
        beq 1300f           /* have been checked and leave this macro. */
        bne 1000b

1300:   /* EQ will be set if we reach 31 */
	.endm

	/* currently don't need an disable_fiq macro */
	.macro	disable_fiq
	.endm
