# (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED
#
# All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
# Redistribution and use in source and binary forms, with or without modification,
# are strictly prohibited.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


include usr/workspace/Makefile.config


list-workspace:
	@printf "Available workspace:\n"
	@printf "\t%s\n" $(WORKSPACE_COMPS)

$(WORKSPACE_COMPS:%=workspace-%):
	@printf "Building workspace compent: %s\n" $(subst workspace-,,$@)
	@make -C usr/workspace CROSS_COMPILE=$(CROSS_COMPILE) $(subst workspace-,,$@)

$(WORKSPACE_COMPS:%=workspace-%-install):
	@printf "Installing workspace compent: %s\n" $(subst -install,,$(subst workspace-,,$@))
	@make -C usr/workspace CROSS_COMPILE=$(CROSS_COMPILE) $(subst workspace-,,$@)

$(WORKSPACE_COMPS:%=workspace-%-clean):
	@printf "Cleaning workspace compent: %s\n" $(subst -clean,,$(subst workspace-,,$@))
	@make -C usr/workspace CROSS_COMPILE=$(CROSS_COMPILE) $(subst workspace-,,$@)

workspace-build: packages-install runtime-install
	@make -C usr/workspace CROSS_COMPILE=$(CROSS_COMPILE) all

#workspace-install: workspace-build root-fs-staging
workspace-install: output workspace-build
	@make -C usr/workspace install

workspace-only:
	@make -C usr/workspace CROSS_COMPILE=$(CROSS_COMPILE) all

workspace-only-install: workspace-only
	@make -C usr/workspace install

workspace-clean:
	@make -C usr/workspace clean

.PHONY: workspace-build workspace-install workspace-clean workspace-only \
		$(WORKSPACE_COMPS:%=workspace-%) $(WORKSPACE_COMPS:%=workspace-%-install) $(WORKSPACE_COMPS:%=workspace-%-clean)
