/*********************************************************************************
(c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED

All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
Redistribution and use in source and binary forms, with or without modification,
are strictly prohibited.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*********************************************************************************/
#include <hardware.h>
#include <auto_version.h>

.extern WriteSerial
.extern __a1_console_init
.extern __a1_boot_from_nand
.extern bLoader_main
/*
 *******************************
 *
 * Exception Vectors.
 *
 *******************************
 */
.globl _start
_start:	
	B __a1_reset_handler 	/* Reset vector*/
 	B __a1_undef_handler 	/* Undefined vector*/
 	B __a1_swi_handler 		/* Software Interrupt vector*/
 	B __a1_prefetch_handler /* Prefetch vector*/
 	B __a1_abort_handler 	/* Abort vector*/
 	NOP 					/* -- Reserved vector --*/
 	B __a1_irq_handler 		/* Interrupt ReQuest vector*/
 	B __a1_fiq_handler 		/* Fast Interrupt ReQuest vector*/

_TEXT_BASE:     .word 0x0
.globl _armboot_start
_armboot_start: .word 0x800000

.align 4
//Str_NOR_BOOT:	.ascii "\r\n"BLOADER_VERSION" NOR boot ..\r\n\0"
Str_NAND_BOOT:	.ascii "\r\n"BLOADER_VERSION" NAND boot ..\r\n\0"

.align 4

/*
 * These are defined in the board-specific linker script.
 */
.globl _bss_start
_bss_start:
	.word __bss_start

.globl _bss_end
_bss_end:
	.word _end


.macro DPrint, mesg
	LDR		r0, =\mesg
	BL		WriteSerial
.endm

/*************************************************************************                               
 *                                                                                                                                                                                                                 
 * Reset Handler
 * 
 ***********************************************************************/
__a1_reset_handler:
	/*
	 * set the cpu to SVC32 mode
	 */
	MRS		r0, cpsr
	BIC		r0, r0, #0x1f
	ORR		r0,	r0, #0xd3
	MSR		cpsr, r0
	/* Early console init for debugging */
	BL		__a1_console_init

	/* DDR initialze process */
	BL		__a1_setup_ddr

	/* Try to work around early termination issue */
__A1_V0_BUG_TRY:
	LDR	r1, =0x90000080
	MOV	r2, #0x6
	STR r2, [r1]
	
STACK_SETUP:
	/* Set up the stack						    */
	BL 		__a1_stack_setup

	/* Get to know where we boot up */
	BL		__a1_boot_from_nand
	CMP		r0, #0		/* r0 = 0, nor boot */
	BNE		NAND_BOOT

NOR_BOOT:
//	DPrint 	Str_NOR_BOOT

	/* Turn on NAND CLK gate, when NOR boot */
	LDR		r1, =0x99000024
	LDR		r2, =NAND_CLK_GATE_VALUE
	STR		r2, [r1]

	/* For the buggy chip at the 1st tape out
	 * Copy boot code from NOR to internal SRAM
	 *  Remap SRAM to address 0
	 */
RELOCATE:
	/* Relocate to SRAM, 0x20000000 */
	MOV		r0, #0
	LDR		r1, =0x20000000
	LDR		r2, _bss_start

COPY_LOOP:
	LDMIA	r0!, {r3-r10}
	STMIA	r1!, {r3-r10}
	CMP		r0, r2
	BLE		COPY_LOOP

REMAP_SRAM:
	MOV		r0, #0x000
	LDR		r1, =0x9000008c
	STR		r0, [r1]

//DDR_REMAP:
//	MOV		r0, #0x300
//	LDR		r1, =0x9000008c
//	STR		r0, [r1]

	/* Pinmux setting to enable NANDC */
NAND_EN:
	LDR		r1, =0x99000010
	MOV		r2, #0
	STR		r2, [r1]

	LDR		r1, =0x99000014
	MOV		r2, #0
	STR		r2, [r1]
	B		bLoader

NAND_BOOT:
	DPrint 	Str_NAND_BOOT

bLoader:
	/* Enter C code in SVC mode */
	LDR		PC,	_bLoader_main

_bLoader_main:
.word	bLoader_main

/*************************************************************************
 *
 * Setup Stacks for each ARM Mode
 *
 * Now, just setup supervisor mode sp
 * Other modes will be set up when necessary, pending 
 *
 ***********************************************************************/
.align 4

__a1_stack_setup:
/* Currently we are in Supervisor mode.Setup the stackpointer.*/
	LDR		a1, =__a1_supervisor_stack_base
	LDR		a1, [a1]
	MOV		SP, a1

/* Go to FIQ mode. */
    MRS     a1, cpsr
    AND     a1, a1, #~0x001F
    ORR     a1, a1, #0x0011 
    MSR     cpsr_c, a1

/* Setup stack in FIQ mode. */
    LDR     a1, =__a1_fiq_stack_base 
    LDR     a1, [a1]
    MOV     SP, a1

/* Go to IRQ mode. */
    MRS     a1, cpsr 
    AND     a1, a1, #~0x001F
    ORR     a1, a1, #0x0012
    MSR     cpsr_c, a1

/* Setup stack in IRQ mode. */
    LDR     a1, =__a1_irq_stack_base
    LDR     a1, [a1]
    MOV     SP, a1

/* Go back to SVC mode. */
    MRS     a1, cpsr 
    AND     a1, a1, #~0x001F
    ORR     a1, a1, #0x0013
    MSR     cpsr_c, a1

	MOV		PC, LR
/*************************************************************************
 *
 * We don't need these exception handler
 * Just loop itself
 *
 ***********************************************************************/
.align 4
__a1_undef_handler:
	B	__a1_undef_handler

.align 4
__a1_swi_handler:
	B	__a1_swi_handler

.align 4
__a1_prefetch_handler:
	B	__a1_prefetch_handler

.align 4
__a1_abort_handler:
	B	__a1_abort_handler

.align 4
__a1_irq_handler:
	B	__a1_irq_handler

.align 4
__a1_fiq_handler:
	B	__a1_fiq_handler

.align 4
__user_undef_handler:
    B	__user_undef_handler

.align 4
/* Stack Base Addresses */
__a1_supervisor_stack_base:	.word	0x50800000
__a1_fiq_stack_base:        .word	0x50900000
__a1_irq_stack_base:        .word	0x50a00000

