/*
 * Generic virtual read/write.  Note that we don't support half-word
 * read/writes.  We define __arch_*[bl] here, and leave __arch_*w
 * to the architecture specific code.
 */
#ifndef __ASM_ARM_IO_H
#define __ASM_ARM_IO_H

#define __a1_getb(a)		(*(volatile unsigned char *)(a))
#define __a1_getw(a)		(*(volatile unsigned short *)(a))
#define __a1_getl(a)		(*(volatile unsigned int *)(a))

#define __a1_putb(v,a)		(*(volatile unsigned char *)(a) = (v))
#define __a1_putw(v,a)		(*(volatile unsigned short *)(a) = (v))
#define __a1_putl(v,a)		(*(volatile unsigned int *)(a) = (v))



#define writeb(v,a)			__a1_putb(v,a)
#define writew(v,a)			__a1_putw(v,a)
#define writel(v,a)			__a1_putl(v,a)

#define readb(a)			__a1_getb(a)
#define readw(a)			__a1_getw(a)
#define readl(a)			__a1_getl(a)

#endif	/* __ASM_ARM_IO_H */
