#!/bin/sh
PATH=/bin/:/sbin/:/usr/bin/:/usr/sbin:/usr/local/sbin:/usr/local/bin
export PATH

. /etc/default/firmware_version.conf
OUTPUT_FILE=/mnt/nfs/"$FIRMWARE_VERSION".img
case "$1" in
	s) #start
#		mkdir -p /etc/config
		#mount jffs2 FS 
#		mount -t jffs2 /dev/mtdblock2 /etc/config
#		sed -ie "s/NET_TYPE=.*/NET_TYPE='2'/" /etc/default/default.conf
#		sed -ie "s/NET_IP=.*/NET_IP='172.16.15.233'/" /etc/default/default.conf
#		sed -ie "s/NET_GATEWAY=.*/NET_GATEWAY='172.16.15.253'/" /etc/default/default.conf
		#setup sensor's resolution: 1920 x 1080
		#isp-ctrl sensor view 3 
		#start service
		/etc/init.d/service
		;;
	a) #accept input connection
		iptables -P INPUT ACCEPT
		;;
	k) #stop service
		kill `pidof aistreamer`
		kill `pidof aistreamer_monitor.sh`
		;;
	nfs)
		#mount nfs
		if [ ! -d /mnt/nfs ]; then
			mkdir -p /mnt/nfs
		fi
		mount -t nfs -o nolock,proto=tcp,nfsvers=3 172.16.15.38:/nfs /mnt/nfs
		;;
	ted)
		insmod /lib/modules/jif_get.ko
		echo verbose=0 > /proc/a1_shamm
		aistreamer &
		;;
	nanddump)
#		tftp -gr bootpImage.ub 172.16.15.38
#		BOOTNUM=`fw_printenv |grep bootnum |cut -d= -f2`
#		BOOTNUM=`expr $BOOTNUM % 2 + 1`
#		nandwrite -p /dev/mtd_bootp$BOOTNUM bootpImage.ub
		if [ ! -d /mnt/nfs ]; then
            mkdir -p /mnt/nfs
        fi
		mount -t nfs -o nolock,proto=tcp,nfsvers=3 172.16.15.38:/nfs /mnt/nfs
		if [ "" != "$2" ]; then
			OUTPUT_FILE=$2
		fi
		fw_setenv ethaddr 00:a1:a1:a1:a1:a1
		rm -rf /etc/config/*
		umount /etc/config
		flash_eraseall /dev/mtd_config
		acti_nanddump -b -u -r -f "$OUTPUT_FILE"
#		acti_nanddump -b -u -r -o -f "$OUTPUT_FILE".main
#		acti_nanddump -b -u -r -m -f "$OUTPUT_FILE".oob
		;;
	hqa)
		if [ "" != "$2" ]; then
			rm -f /etc/config/DbgCtrl.conf
		else
			echo "ispdbg=1" > /etc/config/DbgCtrl.conf
		fi
		;;	
    *)
        echo "Usage: "$0" [s(start aistreamer)|a(skip firewall rules)|k(stop aistreamer)]"
        exit 1
        ;;
esac
exit 0

