#!/bin/sh

. /etc/default/default.conf
[ -f /etc/config/update.conf ] && . /etc/config/update.conf
[ -f /etc/config/preserve_net.conf ] && . /etc/config/preserve_net.conf

DBG_PATH=/tmp/dbg
NET_CONF=/etc/default/net.conf

prepare_net_conf () {
	/etc/init.d/check_updatefile.sh
	[ -f /etc/config/update.conf ] && . /etc/config/update.conf
	echo "NET_TYPE='$NET_TYPE'" > $NET_CONF
	echo "NET_SPEED='$NET_SPEED'" >> $NET_CONF
	echo "NET_IP='$NET_IP'" >> $NET_CONF
	echo "NET_NETMASK='$NET_NETMASK'" >> $NET_CONF
	echo "NET_GATEWAY='$NET_GATEWAY'" >> $NET_CONF
	echo "PPPOE_LOGIN='$PPPOE_LOGIN'" >> $NET_CONF
	echo "DHCP_BY_HOSTNAME='$DHCP_BY_HOSTNAME'" >> $NET_CONF
	echo "SYS_HOSTNAME='$SYS_HOSTNAME'" >> $NET_CONF
	echo "DNS_PRIMARY='$DNS_PRIMARY'" >> $NET_CONF
	echo "DNS_SECONDARY='$DNS_SECONDARY'" >> $NET_CONF
	echo "DDNS_TYPE='$DDNS_TYPE'" >> $NET_CONF
	echo "DDNS_SERVICE='$DDNS_SERVICE'" >> $NET_CONF
	echo "DDNS_HOSTNAME='$DDNS_HOSTNAME'" >> $NET_CONF
	echo "DDNS_LOGIN='$DDNS_LOGIN'" >> $NET_CONF
	echo "DDNS_SERVER='$DDNS_SERVER'" >> $NET_CONF
	echo "PORT_HTTP='$PORT_HTTP'" >> $NET_CONF
	echo "PORT_HTTPS='$PORT_HTTPS'" >> $NET_CONF
	echo "UPNP='$UPNP'" >> $NET_CONF
	echo "UPNP_FRIENDLY_NAME='$UPNP_FRIENDLY_NAME'" >> $NET_CONF
	echo "STATE_8021X='$STATE_8021X'" >> $NET_CONF
	echo "EAP_VER_8021X='$EAP_VER_8021X'" >> $NET_CONF
	echo "IEEE8021X_LOGIN='$IEEE8021X_LOGIN'" >> $NET_CONF
	echo "ONVIF_STATE='$ONVIF_STATE'" >> $NET_CONF
}

find_core () {
	ls -l /core
	if [ $? -ne 0 ]; then
		acti_logger "core file not found!"
		return
	fi
	bsize=`ls -l /core |awk '{print $5}'`
	if [ $bsize -gt 30000000 ]; then
    	acti_logger "core size > 30MB"
	else
    	cp /core $DBG_PATH
	fi

}

start_safemode () {
	mkdir -p $DBG_PATH/log
	#CoreDump
	find_core	
	#Blackbox, configure files
	cp /etc/config $DBG_PATH -r
	#aistreamer_mmap, server_report, acti_log, etc...
	cp /var/log/* $DBG_PATH/log
	ps > $DBG_PATH/ps.txt
	dmesg > $DBG_PATH/dmesg.txt
	cd /tmp
	tar zcvf /var/www/images/tmp/dbg.tgz dbg
	cd /
	mv /var/www/login_err_mode.html /var/www/login.html
	prepare_net_conf
	TROUBLE_SHOOTING_CONTROL='0'
	. /etc/config/update.conf
	/usr/sbin/aistreamer ERROR_LOOP $TROUBLE_SHOOTING_CONTROL &
}

#main start
if [ -z $PORT_HTTP ]; then
	PORT_HTTP=80
fi

sleep 40

USER0=`echo $ACCOUNT_USER0 | cut -d, -f1`
PWD0=`echo $ACCOUNT_USER0 | cut -d, -f2`

wget "http://127.0.0.1:$PORT_HTTP/cgi-bin/system?USER=$USER0&PWD=$PWD0&SERVER_REPORT" -O /var/log/server_report.txt

echo "0" > /var/run/alive_check_fail_counter
cnt=0

while [ 1 ]; do
 	# the alive_check blocks until failed to get aistreamer http service
	/usr/sbin/alive_check $PORT_HTTP 5 10 $cnt
	# fail to get aistreamer http service
	cnt=`cat /var/run/alive_check_fail_counter`
	cnt=`expr $cnt + 1`
	echo "cnt=$cnt"
	if [ $cnt -gt 6 ]; then
		acti_logger "No http response from aistreamer"
		kill -9 `pidof aistreamer`
		start_safemode
		# reset the fail counter
		echo "0" > /var/run/alive_check_fail_counter
		cnt=0
	else
		# record this counter
		echo $cnt > /var/run/alive_check_fail_counter
		# alive_check will clear this counter in this file as it gets http service successfully
    fi
done

