
//#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/version.h>
#include <linux/wait.h>
#include <linux/sched.h>
#include <linux/timer.h>


#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/smp_lock.h>
#include <linux/errno.h>
#include <linux/unistd.h>
#include <linux/interrupt.h>
#include <linux/spinlock.h>
//#include <linux/proc_fs.h>
#include <linux/ioctl.h>
#include <asm/irq.h>

#include <linux/device.h>
#ifdef CONFIG_USB_DEBUG
#define DEBUG
#else
#undef DEBUG
#endif


//#include "otg_ioctl.h"
#include "otg_drv.h"
//#include "uhci.h"
//#include "ahb_hcd.h"
//#include "medusa.h"
//#include "vdisk.h"

#define OTG_DRIVER_VERSION "v0.1"
#define OTG_DRIVER_DESC "GUC OTG Driver"

#ifdef CONFIG_DEVFS_FS
#include <linux/devfs_fs_kernel.h>
#endif

#define A1_HOST_ONLY

int host = HOST_EHCI; // default is 1: UHCI, 2: EHCI.
//int host = HOST_UHCI; // default is 1: UHCI, 2: EHCI.


// ioctl
//static devfs_handle_t   devfs_handle=0;
//static int        devfs_major=IOCTL_OTG_MAJOR;


// OTG
int reqHNPA = 0;   // HNP request command from keyobard
int reqHNPB = 0;
int reqSRPB = 0;



#define THREAD_INITIAL    1
#define THREAD_START    2
#define THREAD_STOP    3
#define THREAD_DEAD    4

static int thread_state = 0;
struct timer_list otg_timer;

// otg thread wait queue
DECLARE_WAIT_QUEUE_HEAD(otg_queue);
#define sleep_thread()    interruptible_sleep_on(&otg_queue)
#define wakeup_thread()    wake_up_interruptible(&otg_queue)

DECLARE_WAIT_QUEUE_HEAD(timer_queue);

#ifdef SEPARATE_HC_AND_DC
int isSeperateHCDCOnce = 0;
#endif

unsigned long *otg_base;
struct otg_device *otg;

int _disconnectA = 0;  // 0: connected, bit1 set: port1 disconnect, bit2 set: port2 disconnect.
int _lowPower = 0;  // 0:power on,   bit1 set: port1 off,     bit2 set: port2 off.
int _connectB = 0;
int _hnpIsBEnable = 0;  // Is B-Device receive SetFeature(b_hnp_en) from HC?
int _hnpStartB = 0;
int _hnpEndB = 0;  // Is B-Device ending HNP process?
int _hnpA = 0;  // Is A-Device is in HNP, and now in PERI state?
int _isVBusOn1 = 0;  // Is A-Device's VBus is on or off?
int _isVBusManualOff = 0;
int _isSRPEngage = 1;
BHNP_STATE sBHNP = BHNP_IDLE; 
unsigned int _enableEHCI; //BCWR1[30] = 1, enable EHCI
unsigned int _uhci_suspend_flag = 0; // 0: no request, bit 0(1): don't spsend, bit 1(2): host already suspend

static unsigned int _globalSuspend = 0; // 1: would like, 2: into suspend


int isHost = 0;
static int initMedusaIndex = 0;
int mode = 0;   // decide if it is A-Device, or B-Device
int isEHCI = 1;  // default is 1: EHCI, 0: UHCI.
int isConnected = 0;  // decide if A-Device is connect
int isAHNP = 0;

int Disconnect =0;


extern unsigned long *medusa_base;
extern unsigned long *ehci_base1;
extern unsigned int bHighSpeed;
extern unsigned int bSuspendAckLater;

//extern int vdisk_mounted; // In vdisk.c


int SetFeature_BHNPEnable(void);

extern void hcd_irq1 (int irq, void *__hcd, struct pt_regs *r);
extern void uhci_interrupt(int irq, void *__uhci, struct pt_regs *regs);
//extern int uhci_ahb_probe(void);
extern int uhci_hcd_init(void);

extern void medusa_interrupt(struct pt_regs *regs);

extern void suspend_ehci(struct usb_hcd *hcd1);
extern void suspend_ehci_hnp(struct usb_hcd *hcd1);
extern void suspend_ehci1(struct usb_hcd *hcd1);
extern void wakeup_ehci(struct usb_hcd *hcd1);
extern void fast_wakeup_ehci(struct usb_hcd *hcd1);
extern void fast_wakeup_hc(struct uhci_hcd *uhci);

extern void ahb_ehci_module_cleanup (void);
extern int ahb_ehci_module_init (void);

void adevice_loop(void);
void bdevice_loop(void);
void otg_loop(void);


HOST_CONTROLLER currentHostState; // default is 1: UHCI, 2: EHCI.

//MODULE_PARM(host, "i");

//#define printk(msg...)
//#define printk printk

void (* loopfunc )(void);

void GlobalSuspendSet(void)
{

	if (!reqHNPA && !reqHNPB)	// HNP is on going?  
   		_globalSuspend = 1;
	else
		_globalSuspend = 0;
	//printk("GSuspend = %d\n", _globalSuspend);
}

int GlobalSuspendSetCheck(void)
{

  return _globalSuspend;
}
void GlobalSuspendClear(void)
{
   _globalSuspend = 0;      
}

extern void medusa_suspendACK(void);
int GlobalSuspendCheck(void)
{
  //lcc0221, bSuspendAckLater should be clear here to let Medusa handle suspend event again
  if (bSuspendAckLater)
  	bSuspendAckLater = 0;
  	
  if(_globalSuspend==1)
  {       
    medusa_suspendACK();    
    _globalSuspend = 2;
   //}
   return 1;
  }
  else if(_globalSuspend==2)
   return 1;
   
  return 0;
}

int GlobalLoopEnter(void)
{
  if(GlobalSuspendCheck())
     return 0;  
  else
     return 1;    
}
#if 0
static void AHNP_OTG(void) {
    reqHNPA = 1;
}
#endif
void BHNP_OTG(int cmd) {
    if (cmd == 0) {
        reqHNPB = 0;
        HNP_BDeviceReturnToB();
    }
    else if (cmd == 1) {
        reqHNPB = 1;
        HNP_BDevice();
    }

}

#if 0
static  void ASRP_OTG(int cmd) {
    if (cmd == 0) {
        SRP_AdeviceVBUS(0);
    }
    else if (cmd == 1) {
        SRP_AdeviceVBUS(1);
    }
}

static void BSRP_OTG(int cmd) {
    if (cmd == 0) {
        reqSRPB = BSRP_VBUS;
    }
    else if (cmd == 1) {
        reqSRPB = BSRP_DPLUS;
    }
    else if (cmd == 2) {
        reqSRPB = BSRP_BOTH;
    }
    else if (cmd == 3) {
        reqSRPB = BSRP_DISCHARGE_VBUS;
    }
    BDeviceSRP();
}
#endif


// 1. Set BCWR1[8] = 1, for at least 50ms, and then reset it to 0. (Discharging Vbus)
// 2. Set BCWR1[9] = 1, for at least 10ms, and then reset it to 0. (Data-line Pulsing)
// 3. Set BCWR1[10] = 1, for at least 30ms, and then reset it to 0. (Vbus Pulsing)
void BDeviceSRP(void) {
    unsigned int mReg;

    if (!reqSRPB) 
        return;

    if (reqSRPB == BSRP_BOTH)
        printk("B-Device SRP is in process...\n");

    if ((reqSRPB == BSRP_DISCHARGE_VBUS) || (reqSRPB == BSRP_BOTH)) {
        if (reqSRPB == BSRP_DISCHARGE_VBUS)
            printk("BSRP_DISCHARGE_VBUS is in process.\n");

        // *OTGBCWR1 |= (unsigned int) 0x00000100;  // OTGBCWR1[8] = 1
           //mReg = readl(otg_base+BCWR0); 
           mReg = readl(otg_base+OTG_BCWR1); 
        mReg |= 0x00000100; // OTGBCWR1[8] = 1
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);

	    interruptible_sleep_on_timeout(&timer_queue, HZ/20);

        // *OTGBCWR1 &= (unsigned int) ~(0x00000100);
        //mReg = readl(otg_base+BCWR0);  
        mReg = readl(otg_base+OTG_BCWR1);  
        mReg &= ~((unsigned int) 0x00000100);
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);

        if (reqSRPB == BSRP_DISCHARGE_VBUS)
            printk("BSRP_DISCHARGE_VBUS has finished.\n");
    }

    if (reqSRPB == BSRP_DISCHARGE_VBUS) {
        reqSRPB = 0;
        return;
    }

    if ((reqSRPB == BSRP_DPLUS) || (reqSRPB == BSRP_BOTH)) {
        if (reqSRPB == BSRP_DPLUS)
            printk("BSRP_DPLUS is in process.\n");
        // *OTGBCWR1 |= (unsigned int) 0x00000200;  // OTGBCWR1[9] = 1
           //mReg = readl(otg_base+BCWR0); 
           mReg = readl(otg_base+OTG_BCWR1); 
        mReg |= 0x00000200; // OTGBCWR1[9] = 1
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);

    	interruptible_sleep_on_timeout(&timer_queue, HZ/100);

        // *OTGBCWR1 &= (unsigned int) ~(0x00000200);
        //mReg = readl(otg_base+BCWR0);  
        mReg = readl(otg_base+OTG_BCWR1);  
        mReg &= ~((unsigned int) 0x00000200);
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);

        if (reqSRPB == BSRP_DPLUS)
            printk("BSRP_DPLUS has finished.\n");
    }

    if ((reqSRPB == BSRP_VBUS) || (reqSRPB == BSRP_BOTH)) {
        if (reqSRPB == BSRP_VBUS)
            printk("BSRP_VBUS is in process.\n");
        // *OTGBCWR1 |= (unsigned int) 0x00000400;  // OTGBCWR1[10] = 1
           //mReg = readl(otg_base+BCWR0); 
           mReg = readl(otg_base+OTG_BCWR1); 
        mReg |= 0x00000400;  // OTGBCWR1[10] = 1
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);

	    interruptible_sleep_on_timeout(&timer_queue, HZ/33);

        // *OTGBCWR1 &= (unsigned int) ~(0x00000400);
        //mReg = readl(otg_base+BCWR0);  
        mReg = readl(otg_base+OTG_BCWR1);  
        mReg &= ~((unsigned int) 0x00000400);
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);

        if (reqSRPB == BSRP_VBUS)
            printk("BSRP_VBUS has finished.\n");
    }

    if (reqSRPB == BSRP_BOTH)
        printk("B-Device SRP has finished!\n");

    reqSRPB = 0;
}


#ifndef A1_HOST_ONLY
void SRP_AdeviceVBUS(int isOn) {
    unsigned int mReg;

    if (isOn) {
        // *OTGBCWR1 |= (unsigned int) 0x02;  // VBus On: BCWR1[1] == 1
           //mReg = readl(otg_base+BCWR0); 
           mReg = readl(otg_base+OTG_BCWR1); 
        mReg |= 0x02; // VBus On: BCWR1[1] == 1
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);
        _isVBusOn1 = 1;
        _isSRPEngage = 1;
        _isVBusManualOff = 0;
        isConnected = 0; // By Macleod 2006.02.09 

        printk("VBus has turned on port1 successfully!\n");
    }
    else {
        printk("VBus has been turning off port1!\n");
        // *OTGBCWR1 &= ~((unsigned int) 0x02);  
        //mReg = readl(otg_base+BCWR0);  
        mReg = readl(otg_base+OTG_BCWR1);  
        mReg &= ~((unsigned int) 0x02); // VBus Off: BCWR1[1] == 0
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);
        _isVBusOn1 = 0;
        _isSRPEngage = 0;
        _isVBusManualOff = 1;
        Return_To_AIDLE(1);
    }
}
#endif


// A-Device HNP Detection
AHNP_STATE HNP_ADevice(void) {
    unsigned int _bcsr0;

    // unsigned int _temp1;
    // unsigned int _temp2;
    // unsigned int _temp3;
    unsigned int w = 0;

//bufIn[0] = 1;//configIndex;
//usbdDev._PEG_IOControl(PEGASUSUSB_GET_OTG_DESCRIPTOR, bufIn, lenIn, bufOut, lenOut);
//bufIn[1] =(BYTE) 0; // index;
//bufIn[2] =(BYTE) 0; // TestFeature;
//usbdDev._PEG_IOControl(PEGASUSUSB_SET_FEATURE, bufIn, lenIn, bufOut, lenOut);
//bufIn[0] =(BYTE) BHNP_ENABLE; // FeatureSelect;

//Set global suspend by writing 
//  a. write 0x00  // disable HC
//  b. write 0x08  // force suspend mode
//  c. idle 5 ms or more

    printk("HNP start\n");
                                         

    if (!SetFeature_BHNPEnable()) { // 00 03 03 00 00 00 00 00
        printk("SetFeature_BHNPEnable failed! The device does not support HNP\n");
        return DEVICE_NOT_SUPPORT_HNP;
    }
	// Enable hardware HNP start
	writel(readl(otg_base + OTG_BCWR1) | (1 << 7),
	       otg_base + OTG_BCWR1);


    // Pause 200ms to let B-device get ready!
	interruptible_sleep_on_timeout(&timer_queue, HZ/5);
    
    // Going to suspend HC
    if(currentHostState == HOST_EHCI) // EHCI
    {
     suspend_ehci_hnp(otg->otg_ehci);
    }
    else // UHCI
    {
     /*
     stop_hc(uhci);

     //suspend_hc(uhci); // stop UHCI SOF     
     { // Do our own suspend!!
      writel(USBCMD_MAXP,(uhci->regbase + USBCMD)); // disable hc
      udelay(200);
      writel(USBCMD_MAXP|USBCMD_EGSM,(uhci->regbase + USBCMD)); // suspend hc
      writel(USBCMD_MAXP|USBCMD_EGSM,(uhci->regbase + USBCMD)); // suspend hc
      writel(USBCMD_MAXP|USBCMD_EGSM,(uhci->regbase + USBCMD)); // suspend hc
      uhci->is_suspended = 1;
     }
     */
     /* Use port suspend instead, hc suspend will be later */
    // alex stop_hc(uhci);
	 
     writel(readl(uhci->regbase + USBPORTSC1) | USBPORTSC_SUSP, uhci->regbase + USBPORTSC1); 
                   
    }
 
    if(host==HOST_EHCI)
    {
    writel(0xffffffff, medusa_base+IDR); // Buggy, the 2 time HNP failed with full of medusa interrupt,
    writel(0xffffffff ,medusa_base+ISR);  // but it is already disabled... Hmm...
    }
                  
    //during 200ms, polling interval 100us
    while(w++ < 50000) {
        _bcsr0 = readl(otg_base+OTG_BCSR1);
        if ((_bcsr0 & 0x00010000) || ((_bcsr0 & 0x00000007) == 0x00000005)) {
            if(currentHostState == HOST_UHCI)
            { // Do our own suspend!!
                writel(USBCMD_MAXP,(uhci->regbase + USBCMD)); // disable hc
                udelay(200);
                writel(USBCMD_MAXP|USBCMD_EGSM,(uhci->regbase + USBCMD)); // suspend hc
                writel(USBCMD_MAXP|USBCMD_EGSM,(uhci->regbase + USBCMD)); // suspend hc
                writel(USBCMD_MAXP|USBCMD_EGSM,(uhci->regbase + USBCMD)); // suspend hc
                uhci->is_suspended = 1;
            }
            else
            {
                writel(readl(ehci_base1+(0x40/4)) & ~(0x01), ehci_base1+(0x40/4)); 
            }
            change_host_state(DEVICE);    
            isHost = 0;
            
            _hnpA = 1;
            _disconnectA = 0;
            printk("Switch to A-Peripheral!!\n");
            
            return DETECTION_HNP_SUCCESS;
        }
         
        //printk("wait otg: %x %x %x %x\n", readl(otg_base+OTG_BCSR1), readl(otg_base+OTG_BCWR1), readl(uhci->regbase + USBCMD), readl(uhci->regbase + USBPORTSC1));
        udelay(50);
    }
    // HNP failed
    printk("HNP failed %x\n", readl(otg_base+OTG_BCSR1));
    
    if(currentHostState == HOST_EHCI) {// EHCI
        wakeup_ehci(otg->otg_ehci); 
    }
    else { // UHCI
        wakeup_hc(uhci);  // GlobalResume_UHCI
    }

    _hnpA = 0;
    return DETECTION_HNP_FAILED;
}

void HNP_DetectionStartB(void)
{
   _hnpStartB = 1;    
}

void HNP_DetectionB(unsigned int __bcsr0) {  // B-Device HNP Detection
    unsigned int _bcsr0 = __bcsr0;
    unsigned int mReg;
    int w = 0;

    //printk("HNP_DetectionB Begin!!!\n");

    //if (sBHNP != BHNP_IDLE || !_hnpStartB)
    if (sBHNP != BHNP_IDLE)
        return;

    //printk("HNP_DetectionB BHNP_IDLE!!!\n");

    //during 3.125ms
    while (w++ < 10000) {
                
        _bcsr0 = readl(otg_base+OTG_BCSR1);        
        if ((_bcsr0 & 0x100) || (_bcsr0 & 0x200) || (_bcsr0 & 0x800)) {  // if HNP is successful.
            _uhci_suspend_flag |= (1<<0); // Don't suspend when no connection
            mReg = readl(otg_base+OTG_BCWR1); 
            mReg |= 0x00004000; // OTGBCWR1[14] = 1
            writel(mReg,otg_base+OTG_BCWR1);
            
            writel(readl(medusa_base+UDCR) | (1<<6), medusa_base+UDCR); // Soft Disc
            printk("Soft Disc!!\n");   

            // Let A becomes peripheral
	        interruptible_sleep_on_timeout(&timer_queue, HZ/100);

            while((readl(otg_base+OTG_BCSR1)&0x30)!=0x30)
                ;
             
            if(bHighSpeed) // EHCI, variable from medusa
            {                 
                fast_wakeup_ehci(otg->otg_ehci);              
            }
            else // UHCI
            {
 // alex               fast_wakeup_hc(uhci);

                writel(0xffffffff ,medusa_base+ISR); // Clear Medusa ISR
                change_host_state(HOST_UHCI);
                isHost = 1;
            }
            sBHNP = BHNP_SUCCESS;
            printk("Switch to B-Host!!\n");
            _hnpStartB = 0;
            return;
        }
        udelay(5);         
        
    }
    printk("HNP_DetectionB Fail!!! %x\n", _bcsr0);
    mReg = readl(otg_base+OTG_BCWR1);
    mReg |= 0x00008000; // OTGBCWR1[15] = 1
    writel(mReg,otg_base+OTG_BCWR1);

    mReg = readl(otg_base+OTG_BCWR1);
    mReg &= ~((unsigned int) 0x00008000); // OTGBCWR1[15] = 0
    mReg = readl(otg_base+OTG_BCWR1);

    sBHNP = BHNP_FAILED;
    _hnpStartB = 0;
    return;
}

int isHNP_A(void) {
    return _hnpA;
}
void HNP_Enable_BDevice(void) {
    unsigned int mReg;
    _hnpIsBEnable = 1;
    // *OTGBCWR1 |= (unsigned int) 0x00002000;  // OTGBCWR1[13] = 1
    //mReg = readl(otg_base+BCWR0);
    mReg = readl(otg_base+OTG_BCWR1);
    mReg |= 0x00002000;  // OTGBCWR1[13] = 1
    //writel(mReg,otg_base+BCWR0);
    writel(mReg,otg_base+OTG_BCWR1);
}

void HNP_Disable_BDevice(void) {
    unsigned int mReg;
    _hnpIsBEnable = 0;
    // *OTGBCWR1 &= ~((unsigned int) 0x00002000);  // OTGBCWR1[13] = 0
    //mReg = readl(otg_base+BCWR0);  
    mReg = readl(otg_base+OTG_BCWR1);
    mReg &= ~((unsigned int) 0x00002000); // OTGBCWR1[13] = 0
    //writel(mReg,otg_base+BCWR0);
    writel(mReg,otg_base+OTG_BCWR1);
}

int HNP_BDevice(void) {
    unsigned int mReg;
    // OTGBCWR1[12] = 1:: B-device requires to start HNP
    // *OTGBCWR1 |= (unsigned int) 0x00001000;
    //mReg = readl(otg_base+BCWR0);
    mReg = readl(otg_base+OTG_BCWR1);
    mReg |= 0x00001000;
    //writel(mReg,otg_base+BCWR0);
    writel(mReg,otg_base+OTG_BCWR1);
    return 1;
}


// B-device has already in B_HOST, and now want to go back to original state, ie. the device state
void HNP_BDeviceReturnToB(void) {
    unsigned int mReg;
    // *OTGBCWR1 &= ~((unsigned int) 0x00001000);   // OTGBCWR1[12] = 0
    //mReg = readl(otg_base+BCWR0);  
    mReg = readl(otg_base+OTG_BCWR1);
    mReg &= ~((unsigned int) 0x00001000); // OTGBCWR1[12] = 0
    mReg &= ~((unsigned int) 0x00002000); // OTGBCWR1[13] = 0
    //writel(mReg,otg_base+BCWR0);
    writel(mReg,otg_base+OTG_BCWR1);
}


BHNP_STATE isHNP_B(void) {
    return sBHNP;
}



int SRP_DetectionA(void) {  // A-Device SRP Detection
    unsigned int _bcsr0;
    unsigned int mReg;
      
   
    if (!_isVBusOn1) {
     while(_isVBusManualOff) // hardware required detection less than 5ms
     {    
        _bcsr0 = readl(otg_base+OTG_BCSR1);
        if (_bcsr0 & 0x00001000) { // BCSR1[12]==1 at any moment
            mReg = readl(otg_base+OTG_BCWR1);
            mReg |= 0x00000002;  // BCWR1[1] = 1, VBUS Driving
            writel(mReg,otg_base+OTG_BCWR1);
            _isVBusOn1 = 1;
            _isSRPEngage = 1;
            _isVBusManualOff = 0;
            isConnected = 0; // By Macleod 2006.02.09 
             printk("VBUS on!!\n");
            return 1;
        }
        else
        {
            ;
        }
	    interruptible_sleep_on_timeout(&timer_queue, HZ/1000);
        yield();
     }
    }
    return 0;
}
int disconnectA_OTG(void) {
    int __disconnectA = _disconnectA;
    _disconnectA = 0;
    return __disconnectA;
}

void disconnectA_OTG1(void) {
    unsigned int mReg;

    mReg = readl(otg_base+OTG_BCWR1);  
    mReg &= ~((unsigned int) 0x00000002);
    writel(mReg,otg_base+OTG_BCWR1);
    Return_To_AIDLE(1);
}

// If either port1 or port2 is connected, return connected. Otherwise, it is not connected.
int ConnectA_OTG(int _isAHNP) {
    unsigned int _bcsr0;
    unsigned int mReg;
    
    int w;
    int detectElapse, detectDelay;

    int isASessionValid1 = 0;
    int isASessionValid2 = 0;
	int ret = 1;

#ifdef SEPARATE_HC_AND_DC
    static int isVBus_HostState_On = 0;
    if (!isVBus_HostState_On) {
        mReg = readl(otg_base+OTG_BCWR1);   // BCWR1[1] = 1, VBUS Driving
        mReg |= 0x00020002;                 // BCWR1[19:16] = 0010b, A-HOST state
        writel(mReg,otg_base+OTG_BCWR1);
        isVBus_HostState_On = 1;
    }
    return 1;

#endif

    // If HNP end is asserted, detect to port directly.
    // Otherwise, VBus drive procedure is executed.
    if (_isAHNP || isConnected) // isConnected added by Macleod 2006.01.20
        goto ConnectDetect;

    // Vbus Driving Start
       mReg = readl(otg_base+OTG_BCWR1);   // BCWR1[1] = 1, VBUS Driving
    mReg |= 0x00000002;
    writel(mReg,otg_base+OTG_BCWR1);
    _isVBusOn1 = 1;
    
        
    w = 0;
    while(w++<=100)
    {    
	    interruptible_sleep_on_timeout(&timer_queue, HZ/200);
        yield();
    }

    // Check if A session valid for 100ms
    w = 6;
    do {
        if (isASessionValid1 == 0) {
            _bcsr0 = readl(otg_base+OTG_BCSR1);
            if (_bcsr0 & 0x00001000) // BCSR1[12]
                isASessionValid1 = 1;
        }
        if (isASessionValid1) {
            break;
        }
        if (--w <= 0) { //VBus_Over_Current
            break;
        }
        // Polling session valid with a 20ms period.
	    interruptible_sleep_on_timeout(&timer_queue, HZ/50);
    } while(w > 0);

  // Overcurrent Detection
    if (!isASessionValid1) {  // Port1 Overcurrent Detected!!
        mReg = readl(otg_base+OTG_BCWR1);
        mReg &= ~((unsigned int) 0x00000002);
        writel(mReg,otg_base+OTG_BCWR1);
        _isVBusOn1 = 0;
        Return_To_AIDLE(1); 
    }

    if (!(isASessionValid1 || isASessionValid2)) {
        return 0;  // Neither port1 nor port2 is A-Session-Valid
    }
    // ASession Valid

// Connect Event Detection
ConnectDetect:
    detectElapse = _isAHNP ? 40000 : 50;
    detectDelay = _isAHNP ? 25 : 20000;
    
    for(w=0; w < detectElapse; w++) {
        _bcsr0 = readl(otg_base+OTG_BCSR1);
//        if (_bcsr0 & 0x00000300) {  // BCSR1[8] == 1 or BCSR1[9] == 1
           if (_bcsr0 & 0x00000B00) {  // BCSR1[8] == 1 or BCSR1[9] == 1 or  BCSR1[11] == 1

			if (_bcsr0 & 0x00000200)
				ret = 2;
			else
				ret = 1;
            mReg = readl(otg_base+OTG_BCWR1);
            mReg |= 0x00000006;
            writel(mReg,otg_base+OTG_BCWR1);
            _lowPower = 0;
            _disconnectA = 0;

            _bcsr0 = readl(otg_base+OTG_BCSR1);
            while ((_bcsr0 & 0x07) != 0x03)  // BCSR1[2:0] = 011
              _bcsr0 = readl(otg_base+OTG_BCSR1);
            mReg = readl(otg_base+OTG_BCWR1);  
            mReg &= ~((unsigned int) 0x00000004); // OTGBCWR1[2] = 0
            writel(mReg,otg_base+OTG_BCWR1);
            return ret;
        } // end of if
    } // end of for loop
    mReg = readl(otg_base+OTG_BCWR1);
    mReg &= ~((unsigned int) 0x00000003); // BCWR1[0]=0,BCWR1[1]=0
    writel(mReg,otg_base+OTG_BCWR1);
    Return_To_AIDLE(1);
    return 0;
} 

#define WAIT_AIDLE_TIMER    100000

void Return_To_AIDLE(int portno) {
    unsigned int _bcsr0;
    unsigned int mReg;
    unsigned int cnt;

    _bcsr0 = readl(otg_base+OTG_BCSR1);  
    mReg = readl(otg_base+OTG_BCWR1);  
    mReg |= 0x00000100;
    writel(mReg,otg_base+OTG_BCWR1);

    cnt = 0;
    while (!((_bcsr0 & 0x400) || (_bcsr0 & 0x8000))) // SE0 or Session End, by stan
    {
        _bcsr0 = readl(otg_base+OTG_BCSR1);
        yield(); // relase CPU
        
        if(cnt++ > WAIT_AIDLE_TIMER)
        {
          printk("Return to A IDLE wait SE0 and Session END fail!! %x\n", _bcsr0);    
          return;                
        }
        udelay(1);
    }
    
    mReg = readl(otg_base+OTG_BCWR1);
    mReg &= ~((unsigned int) 0x00000100); // BCWR1[3]=1, also BCWR1[0]=0,BCWR1[1]=0
    mReg |= 0x00000008;
    writel(mReg,otg_base+OTG_BCWR1);

    _bcsr0 = readl(otg_base+OTG_BCSR1); 

    cnt = 0;
    while(_bcsr0 & 0x07)
    {
        _bcsr0 = readl(otg_base+OTG_BCSR1);
        yield(); // Release CPU

        if(cnt++ > WAIT_AIDLE_TIMER)
        {
          printk("Return to A IDLE wait not IDLE fail!!\n");    
          return;                
        }
        udelay(1);
    }
    
    mReg = readl(otg_base+OTG_BCWR1);
    mReg &= ~((unsigned int) 0x00000008);  // BCWR1[3]=0
    writel(mReg,otg_base+OTG_BCWR1);
}



void Interrupt_OTG(unsigned int __bcisr0) {
    unsigned int _bcisr0 = __bcisr0;

    if (_bcisr0 == 0) 
        return;

    // A-Device Low Power interrupt
    if (_bcisr0 & 0x00000001) { // BCISR1[0]
        writel(0x00000001,otg_base+OTG_BCISR1);  // clear bcisr0
        _lowPower |= 0x01;
#ifndef SEPARATE_HC_AND_DC
        printk("A-Device Low Power interrupt\n");
#endif
    }

#ifndef SEPARATE_HC_AND_DC

  // A-Device Disconnect Event interrupt
    if (_bcisr0 & 0x00000002) {  // BCISR11[1]
        unsigned int mReg;
        
        // Turn off VBUS
        if(currentHostState != WAIT_EHCI_DISCONNECT_EVENT && !reqHNPA)
        {
         mReg = readl(otg_base+OTG_BCWR1);  
         mReg &= ~((unsigned int) 0x00000002);
         writel(mReg,otg_base+OTG_BCWR1);
         printk("Turn off VBUS!!\n");
        }
        
        writel(0x00000002,otg_base+OTG_BCISR1);  // clear bcisr0
        _disconnectA |= 0x01;  
        //printk("A-Device Disconnect Event %x %x, Port: %x %x\n", _disconnectA, isConnected, readl(ehci_base1+(0x44/4)), readl(uhci->regbase + USBPORTSC1));
        printk("A-Device Disconnect Event\n");
    }
#endif


    // A-Device HNP End
    if (_bcisr0 & 0x00000004) {  // BCISR1[2] == 1
        writel(0x00000004,otg_base+OTG_BCISR1);  // clear bcisr0
        _hnpA = 0;
        printk("A-Device HNP End!!\n");
    }

    // B-Device Disconnect Event interrupt
    if (_bcisr0 & 0x00000008) {  // BCISR[3] = 1        
        GlobalSuspendClear();
        writel(0x00000008,otg_base+OTG_BCISR1);  // clear bcisr0
        _connectB = 0;
        printk("B Device Disconnect!!\n"); 
    }

    
    if (_bcisr0 & 0x00000010) { // BCISR1[4] == 1
       writel(0x00000010,otg_base+OTG_BCISR1);  // clear bcisr0
    }

    // B-Device HNP End interrupt
    if (_bcisr0 & 0x00000020) { // BCISR1[5] == 1
        writel(0x00000020,otg_base+OTG_BCISR1);  // clear bcisr0
        _hnpEndB = 1;
        isHost = 0;
        printk("B-Device HNP End interrupt!!\n"); 
        
    }
} // end of Interrupt_OTG()

int isLowPower_OTG(void) {
    int __lowPower = _lowPower;
    unsigned int mReg;

    _lowPower = 0;
    if (__lowPower & 0x00000001) {
        mReg = readl(otg_base+OTG_BCWR1);  
        mReg |= 0x00000008;
        mReg &= ~((unsigned int) 0x00000002); 
        //writel(mReg,otg_base+BCWR0);
        writel(mReg,otg_base+OTG_BCWR1);
    }
    return __lowPower;
}

int isDisconnectB_OTG(void) {
    return (!_connectB);
}


int Detect_IDPID_OTG(void) {
    unsigned int _P1ID;
    unsigned int mReg;

    mReg = readl(otg_base+OTG_BCWR1);  
    mReg |= 0x00000001;  // p1_id_pup
    writel(mReg,otg_base+OTG_BCWR1);

	interruptible_sleep_on_timeout(&timer_queue, HZ/50);

    _P1ID = readl(otg_base+OTG_BCSR1);

    mReg = readl(otg_base+OTG_BCWR1);
    mReg &= (unsigned int) ~(0x00000001);  // BCWR1[0] ==0
    writel(mReg,otg_base+OTG_BCWR1);

    // If ID Pin = 0, A-Device. Polling Port1 & Port2 Connection
    return !!(_P1ID & 0x00000080); // BCSR1[7]
}

int ConnectB_OTG(void)
{
    unsigned int mReg;

    // Polling BCSR1 to detect B Session Valid state
    mReg = readl(otg_base+OTG_BCSR1);
    if((mReg & 0x00002000) == 0x00002000)  // check OTGBCSR1[13]
    {
    	
        /*if(vdisk_mounted)
        {
     	  printk("Virtual disk is mounted!!\n");
          printk("Please umount virtual disk before connect USB device!!\n");
          return 0;
        }    */	
    	
        // Connected, set p1_bconn_event, enter B_PERI
        mReg = readl(otg_base+OTG_BCWR1);  // OTGBCWR1[11] = 1
        mReg |= 0x00000800;
        writel(mReg,otg_base+OTG_BCWR1);
        _connectB = 1;
        printk("B Device Connect!!\n");

        mReg = readl(otg_base+OTG_BCSR1);
        while(!(mReg & 0x00000010))
           mReg = readl(otg_base+OTG_BCSR1);
        mReg = readl(otg_base+OTG_BCWR1);
        mReg &= (unsigned int) ~(0x00000800);  // OTGBCWR1[11] = 1  //0xfffff7ff;
        writel(mReg,otg_base+OTG_BCWR1);
        return 1;
    }
    return 0;
}

// This function is used by Medusa
void set_otg_feature(int selector)
{
    if (selector == 3)
        HNP_Enable_BDevice();  
    else if (selector == 4)
        ; 
    else if (selector == 5)
        ; 

}

int SetFeature_BHNPEnable(void)
{
    int result;
    int cidx;
    struct usb_device *otg_dev;
    unsigned char *transfer_buffer = kmalloc(64,GFP_KERNEL);



    for (cidx = 0; cidx < USB_MAXCHILDREN; cidx++) {
		if (currentHostState == HOST_EHCI) {
			printk("Host EHCI\n");
			//otg_dev = ehci_to_hcd(otg->otg_ehci)->self.root_hub->children[cidx];
			otg_dev =
			    otg->otg_ehci->self.root_hub->children[cidx];
		} else if (currentHostState == HOST_UHCI) {
//           printk("Host OHCI\n");             
			otg_dev =
			    uhci_to_hcd(otg->otg_uhci)->self.root_hub->
			    children[cidx];
			//otg_dev = otg->otg_uhci->bus->root_hub->children[cidx];
		} else {	// Hey, we are not suppose to be here!!
			printk("Host is neither EHCI nor UHCI!!\n");
			return 0;
		}
		if (otg_dev)
			break;
	}
	
    if(!otg_dev)
    {
        printk("Unable to find OTG device!!!\n");    
        return 0;                
    }

    printk("SetFeature Request\n");
    result = usb_control_msg(otg_dev, usb_sndctrlpipe(otg_dev,0),
        USB_REQ_SET_FEATURE, 0, RH_PORT_BHNP_ENABLE, 0, transfer_buffer, 0, 2*HZ);

    kfree(transfer_buffer);

	
    return !result;
} 

#if 0 // alex HNP support

static AHNP_STATE ADeviceHNP(void) {
    int status;

    // Is any HNP request command from keyobard for A-Device?
    if (!reqHNPA) {
//	printk("ADeviceHNP\n");	
        return NO_REQUEST_HNP; // No need to run ConnectA_OTG()
    } 
    // A-Device HNP starts
    if ((status = HNP_ADevice()) != DETECTION_HNP_SUCCESS) {
        reqHNPA = 0; 
        // if DEVICE_NOT_SUPPORT_HNP || DETECTION_HNP_FAILED
        return status;
    }

    // A-Device HNP is successful! It is in peripheral state Now
    if (initMedusaIndex == 0) {
        initMedusaIndex = 1;
        Init_Medusa();
    }
    
    writel(0xffffffff ,medusa_base+ISR); // Clear Medusa ISR

    change_host_state(DEVICE);
    isHost = 0;
    
    loopfunc = (void (*  )(void)) adevice_loop;

    return DETECTION_HNP_SUCCESS;
}


static BHNP_STATE BDeviceHNP(void) {
    BHNP_STATE _sBHNP;
    unsigned int mReg;

   
    if (!reqHNPB)
        return BHNP_IDLE ;

    if (!_hnpIsBEnable)
        return BHNP_IDLE;


    _sBHNP = isHNP_B();
    if (_sBHNP == BHNP_IDLE) 
    {
        return _sBHNP;
    }

    if (_sBHNP == BHNP_FAILED) {
        HNP_BDeviceReturnToB();  // return to Medusa
        HNP_Disable_BDevice();  // require A-device executes set_otg_feature to reeanble BHNP
        _sBHNP = BHNP_IDLE;
        printk("BHNP_FAILED \n");
        return _sBHNP;
    }


	interruptible_sleep_on_timeout(&timer_queue, HZ/10);

    mReg = readl(otg_base+OTG_BCWR1);  
    mReg &= ~((unsigned int) 0x00004000); // OTGBCWR1[14] = 0
    writel(mReg,otg_base+OTG_BCWR1);
    
    if(bHighSpeed)
        change_host_state(HOST_EHCI);
    else
        change_host_state(HOST_UHCI);
     
    isHost = 1; 
     
    loopfunc = (void (*  )(void)) bdevice_loop;
    return BHNP_SUCCESS;
}

#else
static AHNP_STATE ADeviceHNP(void) {
    //int status;

    return NO_REQUEST_HNP;
    
    
}

static BHNP_STATE BDeviceHNP(void) {
	return BHNP_IDLE ;
	
}

#endif
// #define printk printk

irqreturn_t common_interrupt_handler (struct usb_hcd *hcd)
{
    struct otg_device *otg_int = (struct otg_device *) otg;
    unsigned int ehci_sts, ehci_ier;  
    
//    printk("otg(%x): %x, ehci_sts:%x, medusa:%x, otgier:%x, ehciier:%x, uhciport1:%x, uhciport2:%x, uhcibase:%x, uhcicmd:%x\n", 
//    		otg_base, readl(otg_base+OTG_BCISR1), readl(ehci_base1+1), readl(medusa_base+ISR), readl(otg_base+OTG_BCIER1), readl(ehci_base1+2), readl(uhci->regbase + USBPORTSC1), readl(uhci->regbase + USBPORTSC2), readl(uhci->regbase + USBCMD));
//    printk("UHCI: USBSTS:%x\n",readl(uhci->regbase + USBSTS));
//    printk("otg_isr:%x, otg_sr:%x, otg_wr:%x ehci_cmd:%x, ehci_sts:%x, portsc:%x\n", readl(otg_base+OTG_BCISR1), readl(otg_base+OTG_BCSR1), readl(otg_base+OTG_BCWR1), readl(ehci_base1), readl(ehci_base1+(0x04/4)), readl(ehci_base1+(0x44/4)));
#ifndef SEPARATE_HC_AND_DC
    unsigned int __bcisr0;  
#endif
  	
    ehci_sts = readl(ehci_base1+1);
    
    //printk("sts:%x\n\n",ehci_sts);
    
    if (ehci_sts & STS_PCD) {
    	ehci_ier = readl(ehci_base1+2);
    	ehci_ier &= ~STS_PCD;
    	//writel(ehci_sts,ehci_base1+1);  // clear ehci_sts
    	writel(ehci_ier,ehci_base1+2);  // clear ehci_sts
    	
    	//printk("ehci_sts:%x, ehci_IER:%x, ehci_ier:%x\n",ehci_sts, readl(ehci_base1+2), ehci_ier);
    	//return 0;
    }
#ifndef SEPARATE_HC_AND_DC
         

    __bcisr0 = readl(otg_base+OTG_BCISR1);
    
    //printk("otg: %x, ehci:%x, medusa:%x, otgier:%x, ehciier:%x\n", __bcisr0, readl(ehci_base1+1), readl(medusa_base+ISR), readl(otg_base+OTG_BCIER1), readl(ehci_base1+2));
    // printk("otg_intrcnt: %x %x-%x-%x-%x %x-%x-%x-%x %x %x %x\n", otg_intrcnt, __bcisr0, readl(ehci_base1+1), readl(otg_int->otg_uhci->regbase + USBSTS), readl(medusa_base+ISR), readl(otg_base+OTG_BCIER1), readl(ehci_base1+2), readl(otg->otg_uhci->regbase+2), readl(medusa_base+IER), currentHostState, isHost, readl(otg_int->otg_uhci->regbase + USBCMD));
    // printk("otg_intrcnt: %x %x-0-%x-%x %x-0-%x-%x %x %x %x\n", otg_intrcnt, __bcisr0, readl(otg_int->otg_uhci->regbase + USBSTS), readl(medusa_base+ISR), readl(otg_base+OTG_BCIER1), readl(otg->otg_uhci->regbase+2), readl(medusa_base+IER), currentHostState, isHost, readl(otg_int->otg_uhci->regbase + USBCMD));             
    
    // B-Device HNP Start interrupt
	if (__bcisr0 & 0x00000010)	// BCISR1[4] == 1
		HNP_DetectionB(__bcisr0);

    if (__bcisr0) {
        //printk("Int_OTG:");
        Interrupt_OTG(__bcisr0);  // OTG
        writel(0x00000010,otg_base+OTG_BCISR1);  // clear bcisr1
        return 0; 
    }
#endif

    if (isHost) {
    	//struct uhci_hcd		*_uhci;	
        if (currentHostState == HOST_EHCI) {
            if (otg_int->otg_ehci) {
                //printk("Int_EHCI:");
                ehci_irq(otg_int->otg_ehci);
                //ehci_irq(__uhci, regs);
                //hcd_irq1(irq,otg_int->otg_ehci,regs);
            }
                
            // Clear extra or abnormal interrupt on UHCI   
            if (otg_int->otg_uhci) {  
            	//_uhci = otg_int->otg_uhci;        
                if(readl(otg_int->otg_uhci->regbase + USBSTS))
                //if(readl(_uhci->regbase + USBSTS))
                    writel(0x1f, otg->otg_uhci->regbase+1);
               ;
            }
        }
        if ((currentHostState == HOST_UHCI)) 
		{
            if (otg_int->otg_uhci) {
//                printk("Int_UHCI:");
                //uhci_interrupt(irq,otg_int->otg_uhci,regs);
                uhci_irq(otg_int->otg_uhci,0);
            }
        }
	    if (readl (medusa_base + ISR) &
			  readl (medusa_base + IER))
		{
			    medusa_interrupt (0);
//                      printk("Medusa Fast INT\n");
        }
    }
    else {
//        printk("Int_DC:");
        medusa_interrupt(0);
        // Clear extra or abnormal interrupt on UHCI   
        if (otg_int->otg_uhci)
            if(readl(otg_int->otg_uhci->regbase + USBSTS))
                writel(0x1f, otg->otg_uhci->regbase+1); 
    }
	return 0;
}

//#define printk(msg...)

void adevice_loop(void) {
   printk("ADevice: %x %x %x %x-%x\n", readl(otg_base+OTG_BCISR1), readl(otg_base+OTG_BCSR1), readl(otg_base+OTG_BCWR1), currentHostState, isHost);
    
    if (isHNP_A()) {
        if(!_disconnectA)
            return;
    }

    reqHNPA = 0;
    mode = OTGMODE_HOST;
    isAHNP = 1;
    isConnected = 0;    
    GlobalSuspendClear();
    
    if(bHighSpeed)
        change_host_state(HOST_EHCI);
    else
        change_host_state(HOST_UHCI);
    
    isHost = 1;     
    loopfunc = (void (*  )(void)) otg_loop;
    
    printk("Switch back to A-Host!!\n");
    
    //printk("ADevice: %x %x %x %x-%x %x-%x-%x\n", readl(otg_base+OTG_BCISR1), readl(otg_base+OTG_BCSR1), readl(otg_base+OTG_BCWR1), currentHostState, isHost, readl(ehci_base1), readl(ehci_base1+(0x40/4)), readl(ehci_base1+(0x44/4)));
}

#ifndef A1_HOST_ONLY
void bdevice_loop(void) {    
    //printk("BDevice: %x %x %x %x-%x\n", readl(otg_base+OTG_BCISR1), readl(otg_base+OTG_BCSR1), readl(otg_base+OTG_BCWR1), currentHostState, isHost);        
    if (!_hnpEndB) {
        // Is disconnect from original B-Device?
        if (!isDisconnectB_OTG())
            return;
    }

    _uhci_suspend_flag &= ~(1<<0); // OK to suspend when no connection

    if(bHighSpeed) // EHCI
        suspend_ehci(otg->otg_ehci);
    else{ // UHCI
        stop_hc(uhci);  //lcc0117
    }
    HNP_Disable_BDevice(); // require A-device execute set_otg_feature
    sBHNP = BHNP_IDLE;
    _hnpEndB = 0;
    
    change_host_state(DEVICE);
    isHost = 0;
    
    loopfunc = (void (*  )(void)) otg_loop;

    printk("Switch back to B-Peripheral!!!\n");
}
#endif

// Suppose ehci_base1, otg->otg_uhci, medusa_base is ok
void interrupt_switch(HOST_CONTROLLER _owner) {
  static unsigned int ehci_intr = 0;
  static unsigned int uhci_intr = 0;
  static unsigned int dev_intr = 0;
  
  
  if(!ehci_base1 || !otg->otg_uhci || !medusa_base)
   return;
   
  if(_owner == currentHostState)
   return; 
    
  //printk("interrupt_switch %x\n", _owner);    
  
      
  switch(_owner)
  {
     case HOST_UHCI:
           // Disable EHCI
           if(host==HOST_EHCI)
           if(readl(ehci_base1+2) != 0)
           {
            ehci_intr |= readl(ehci_base1+2);
            writel(0, ehci_base1+2);
            //writel(0x1f, ehci_base1+1); // Clear ISR           
           }            
           
           // Disable Device
           if(readl(medusa_base+IER) != 0)
           {
            dev_intr |= readl(medusa_base+IER);    
            writel(dev_intr, medusa_base+IDR);
            //writel(0xffffffff, medusa_base+ISR); // Clear ISR    
           }
           
           // Enable UHCI           
           if(uhci_intr)
           {
            writel(0x1f, otg->otg_uhci->regbase+1);    
            writel(uhci_intr, otg->otg_uhci->regbase+2);
           }
            uhci_intr = 0;           
           
           break;
                      
     case HOST_EHCI:
           // Disable UHCI
           if(readl(otg->otg_uhci->regbase+2) != 0)
           {
            uhci_intr |= readl(otg->otg_uhci->regbase+2);
            writel(0, otg->otg_uhci->regbase+2);
            //writel(0x1f, otg->otg_uhci->regbase+1); // Clear ISR           
           }
           
           // Disable Device
           if(readl(medusa_base+IER) != 0)
           {
            dev_intr |= readl(medusa_base+IER);    
            writel(dev_intr, medusa_base+IDR);    
            //writel(0xffffffff, medusa_base+ISR); // Clear ISR
           }
           
           // Enable EHCI
           if(ehci_intr)
           {
            writel(0x1f, ehci_base1+1);               
            writel(ehci_intr, ehci_base1+2);
           }
            ehci_intr = 0;              
           
           break;     
           
     case WAIT_EHCI_DISCONNECT_EVENT:
           // Disable UHCI
           if(readl(otg->otg_uhci->regbase+2) != 0)
           {
            uhci_intr |= readl(otg->otg_uhci->regbase+2);
            writel(0, otg->otg_uhci->regbase+2);
            //writel(0x1f, otg->otg_uhci->regbase+1); // Clear ISR           
           }
                      
           // Disable EHCI
           if(readl(ehci_base1+2) != 0)
           {
            ehci_intr |= readl(ehci_base1+2);
            writel(0, ehci_base1+2); 
            //writel(0x1f, ehci_base1+1); // Clear ISR          
           } 
           
           // Disable Device
           if(readl(medusa_base+IER) != 0)
           {
            dev_intr |= readl(medusa_base+IER);    
            writel(dev_intr, medusa_base+IDR);    
            //writel(0xffffffff, medusa_base+ISR); // Clear ISR
           }
           
           break;
          
     case DEVICE:
           // Disable UHCI
           if(readl(otg->otg_uhci->regbase+2) != 0)
           {
            uhci_intr |= readl(otg->otg_uhci->regbase+2);
            writel(0, otg->otg_uhci->regbase+2);  
            //writel(0x1f, otg->otg_uhci->regbase+1); // Clear ISR         
           }

           // Disable EHCI
           if(host==HOST_EHCI)
           if(readl(ehci_base1+2) != 0)
           {
            ehci_intr |= readl(ehci_base1+2);
            writel(0, ehci_base1+2);  
           // writel(0x1f, ehci_base1+1); // Clear ISR         
           }           
           
           // Enable Device
           if(dev_intr)
           {  
            //writel(0xffffffff, medusa_base+ISR);    
            writel(dev_intr, medusa_base+IER);
           }
            dev_intr = 0;  
            
           break;         
           
     case WAIT_UHCI_DISCONNECT_EVENT:  
          printk("error, it msut not be here. WAIT_UHCI_DISCONNECT_EVENT!\n");
          break;         
           
  }

}

HOST_CONTROLLER get_host_state(void) {
    return currentHostState;
}

void change_host_state(HOST_CONTROLLER _owner) {
    if(_owner == currentHostState)
        return;
    
    interrupt_switch(_owner);    
        
    currentHostState = _owner;    
          
    if (_owner == WAIT_EHCI_DISCONNECT_EVENT)
    {
        _disconnectA = 1;
    }
}

//#define printk printk
void ehci_uhci_loop(void) {
//    printk("otg(%x): %x, ehci_sts:%x, medusa:%x, otgier:%x, ehciier:%x, uhciport1:%x, uhciport2:%x, uhcicmd:%x\n", 
//    		otg_base, readl(otg_base+OTG_BCISR1), readl(ehci_base1+1), readl(medusa_base+ISR), readl(otg_base+OTG_BCIER1), readl(ehci_base1+2), readl(uhci->regbase + USBPORTSC1), readl(uhci->regbase + USBPORTSC2), readl(uhci->regbase + USBCMD));
    
    switch (currentHostState) {
    case HOST_EHCI:
   //      printk("HOST_EHCI\n");
         break;
    case WAIT_EHCI_DISCONNECT_EVENT:
         printk("WAIT_EHCI_DISCONNECT_EVENT\n");
         suspend_ehci1(otg->otg_ehci);              
         change_host_state(HOST_UHCI);         

         if (!otg->otg_uhci) {
             printk("uhci_ahb_probe\n");
             uhci_ahb_probe();
             disconnectA_OTG();  // to solve the HW send wrong disconnet OTG interrupt at beginning.
         }
         else {
             printk("wakeup_uhci\n");
             wakeup_hc(uhci); 
             isUhciDisconnect = 0;
         }
         break;
    case HOST_UHCI:
 //Ted        printk("HOST_UHCI\n");
         break;
    case WAIT_UHCI_DISCONNECT_EVENT:
         printk("wakeup_ehci\n");
         suspend_ehci(otg->otg_ehci);  // clear the Configure Flag(CF = 0)
         change_host_state(HOST_EHCI);
         wakeup_ehci(otg->otg_ehci);
         break;
     case DEVICE:  
          printk("error, it msut not be here. DEVICE!\n");
          break;            
    }
}




void otg_loop(void) {
#ifndef SEPARATE_HC_AND_DC
    int disconnectPort, count;     
#endif    

    static int idpin_state = 0;
#ifdef SEPARATE_HC_AND_DC
    unsigned int mReg;
#endif
    
	if (!GlobalLoopEnter())
		return;


#ifdef SEPARATE_HC_AND_DC
    if (isSeperateHCDCOnce)
        return;
#endif  
      
    if (!isAHNP && (!isConnected) && (currentHostState != WAIT_EHCI_DISCONNECT_EVENT)) {
        idpin_state = Detect_IDPID_OTG();
        if (idpin_state == 0) {
            if (mode != OTGMODE_HOST) 
                printk("A-Device\n");
            isHost = 1;
            mode = OTGMODE_HOST;
            if((host==HOST_EHCI) && (get_host_state() == HOST_EHCI || get_host_state() == DEVICE)) {
                change_host_state(HOST_EHCI);
            }
            else {
                change_host_state(HOST_UHCI);
            }
#ifdef SEPARATE_HC_AND_DC
            isSeperateHCDCOnce = 1;
#endif        
        } // end of A-Device
        // B-Device is detected
        else {
            if (mode != OTGMODE_MEDUSA) 
                printk("B-Device\n");
            isHost = 0;
            mode = OTGMODE_MEDUSA;
            change_host_state(DEVICE);
        }
    }

    if (mode == OTGMODE_HOST) {  // A-Device
        //printk("otg_loop(2)\n");
        // SRP check is check at each entry.
#ifndef SEPARATE_HC_AND_DC
        SRP_DetectionA();
#endif

        if ((isConnected == 0) && _isSRPEngage) {
            // HostController is initialized whenever port is connected.
#ifdef SEPARATE_HC_AND_DC
            
            ConnectA_OTG(isAHNP);
            isConnected = 1;
            if (!otg->otg_ehci) {
            	
                ahb_ehci_module_init();
            }
            if(host == HOST_EHCI) {            	
            	
                wakeup_ehci(otg->otg_ehci);
                loopfunc = (void (*  )(void)) ehci_uhci_loop;

                return;
            }
        }
#else
            isConnected = ConnectA_OTG(isAHNP);                   
            if (isConnected) {
                if (isAHNP) {
                    isAHNP = 0;
                }
				if ((isConnected == 2) && (currentHostState == HOST_EHCI)) {
					change_host_state(HOST_UHCI);
					if (!otg->otg_uhci) {
                        uhci_ahb_probe();
                        disconnectA_OTG();  // to solve the HW send wrong disconnet OTG interrupt at beginning.
                        printk("!!uhci_ahb_probe\n");
                    }
                    else {
                        wakeup_hc(uhci); 
                        isUhciDisconnect = 0;
                        printk("!!wakeup_hc\n");
                    }
				}
                else if (currentHostState == HOST_EHCI) {
                    if (!otg->otg_ehci) {
                        ahb_ehci_module_init();
                        disconnectA_OTG();  // to solve the HW send wrong disconnet OTG interrupt at beginning.
                        printk("ahb_ehci_module_init\n");
                    }
                    else {
                        wakeup_ehci(otg->otg_ehci);
                        printk("wakeup_ehci\n");
                    }
                    
                }
                else if (currentHostState == HOST_UHCI) {
                    if (!otg->otg_uhci) {
                        uhci_ahb_probe();
                        disconnectA_OTG();  // to solve the HW send wrong disconnet OTG interrupt at beginning.
                        printk("uhci_ahb_probe\n");
                    }
                    else {
                        wakeup_hc(uhci); 
                        isUhciDisconnect = 0;
                        printk("wakeup_hc\n");
                    }
                }                            
            } // end isConnected
            else { // No connected event
                ;
            }
        } // end of isConnected == 0
        else if (isConnected) {           
            for(count=0; count<150; count++)
            {
	            interruptible_sleep_on_timeout(&timer_queue, HZ/100);
                yield();
            }

            
            disconnectPort = disconnectA_OTG();
            if (disconnectPort & 0x00000001) {
                isConnected = 0;
                switch (currentHostState) {
                case HOST_EHCI:
                     printk("Disconnect HOST_EHCI\n");
                     disconnectA_OTG1(); 
                     suspend_ehci(otg->otg_ehci);
                     break;
                case WAIT_EHCI_DISCONNECT_EVENT:
                     printk("Disconnect WAIT_EHCI_DISCONNECT_EVENT\n");
                     suspend_ehci1(otg->otg_ehci);                     
                     change_host_state(HOST_UHCI);
                     break;
                case HOST_UHCI:
                     printk("Disconnect HOST_UHCI\n");
                     disconnectA_OTG1(); 
                     if(host==HOST_EHCI)
                     {
#if 0  // remarked by alex
			    while((_uhci_suspend_flag&(1<<1)) == 0) {// Synchronize to uhci HC    
                             printk("waiting uhci_sus\n");
				 yield();                         
                         }					 
#endif
                         suspend_ehci(otg->otg_ehci);  // clear the Configure Flag(CF = 0)
                         //suspend_hc(uhci);
                                       
                         change_host_state(HOST_EHCI);
                     }
                     isUhciDisconnect = 1;
                    
                     break;
                case DEVICE:
		default:
                    break;
                }
            }
                if (ADeviceHNP() == DETECTION_HNP_SUCCESS)
                    goto loop_end;
        } // else if (isConnected)
#endif
    }
    else {  // B-Device
        
#ifndef SEPARATE_HC_AND_DC
        if (BDeviceHNP() == BHNP_SUCCESS) {
            printk("HNP request is launched by user for B-Device\n");
            //return;
            goto loop_end;
        }
#endif
        change_host_state(DEVICE);

#ifdef SEPARATE_HC_AND_DC
        if (initMedusaIndex == 0) {
            mReg = readl(otg_base+OTG_BCSR1);
            if((mReg & 0x00002000) == 0x00002000)  // check OTGBCSR1[13]
            {
                initMedusaIndex = 1;
                isSeperateHCDCOnce = 2;
                // Connected, set  enter B_PERI
                // BCWR1[1] = 1, VBUS Driving. BCWR1[19:16] = 1010b, B-PERI state
                writel(0x000a0000,otg_base+OTG_BCWR1);
                if (uhci)
                    stop_uhci(uhci);
                Init_Medusa();
            }
        }
#else
        if (isDisconnectB_OTG()) {
            // If port connected. Medusa program is launched.
            if (ConnectB_OTG()) {
                if (initMedusaIndex == 0) {
                    initMedusaIndex = 1;
                    if (uhci)
                        stop_uhci(uhci);
                    Init_Medusa();
                }
            }
        }       
#endif
    }
#ifndef SEPARATE_HC_AND_DC
loop_end:
    ;
#endif

}

//#define printk(msg...)

void otg_disconstruct(void) {
    kfree(otg);
    otg = NULL;

}
//#define printk printk

void otg_construct(void) {
    // global variables initialize
    isHost = 0;
    reqHNPA = 0;
    reqHNPB = 0;
    reqSRPB = 0;
    mode = 0;

    currentHostState = host;  

    //otg_base = (unsigned long *)IO_ADDRESS(OTG_BASE_ADDR); //ioremap_nocache(OTG_BASE_ADDR,4096);
    otg_base = (unsigned long* )ioremap_nocache(OTG_BASE_ADDR,4096);    
    medusa_base = (unsigned long* )ioremap_nocache(MEDUSA_BASE_ADDR,256);  // unmap after finish use.
    //otg_base = OTGBASE;

    printk("otg_base is %08x \n",(unsigned int)otg_base);
    printk("medusa_base is %x  \n",(unsigned int)medusa_base);

    otg =(struct otg_device *) kmalloc(sizeof(struct otg_device), GFP_KERNEL);
    memset(otg, 0, sizeof(struct otg_device));
    
    if (!otg) {
        err("couldn't allocate uhci structure");
        printk("Couldn't allocate memory for otg_device \n");
        return;
    }
    otg->irq = INT_USB;

    // UHCI Initialization
    uhci_hcd_init();    
    uhci_ahb_probe(); // By Macleod 2006.01.23, HNP needs pre-initial to prevent timing issue!

	//lcc, for FPGA frame timing setting	
	writel(0x01,(uhci->regbase + (0x94/4)));

#ifdef SEPARATE_HC_AND_DC
    
    if(host == HOST_EHCI) {
        printk("stop uhci\n");
        stop_uhci(uhci);
    }
#else
    stop_uhci(uhci);
#endif

    
    // EHCI Initialization
    if(host == HOST_EHCI)
    {
    	
        ahb_ehci_module_init(); // EHCI
    IRQ_SET_HIGH_LEVEL(otg->irq);
    IRQ_SET_LEVEL_TRIGGER(otg->irq);
         
        disconnectA_OTG();
        suspend_ehci(otg->otg_ehci);
    }
    
    //info(OTG_DRIVER_DESC " " OTG_DRIVER_VERSION); 
  
    
    if(host == HOST_UHCI)
        printk("Host: UHCI only\n");
    else
        printk("Host: EHCI/UHCI\n");
    
}



void Init_OTG(void) {
// global variable initialize
    _disconnectA = 0;
    _lowPower = 0;
    _connectB = 0;
    _hnpIsBEnable = 0;
    _hnpEndB = 0;
    _hnpA = 0;
    _isVBusOn1 = 0;
    _isSRPEngage = 1;
    sBHNP = BHNP_IDLE;
    
//    printk("Init_OTG(() enter\n");
    
//    if(host == HOST_EHCI) {
//        _enableEHCI = 0x40000000;
//    }
//    else {
//        _enableEHCI = 0x00000000; 
//    }    
    
	// force Host
    _enableEHCI = 0x40020002;

// OTGBC Initialization
    writel(_enableEHCI,otg_base+OTG_BCWR1);

   
// Enable IRQ after Configuration
#ifdef SEPARATE_HC_AND_DC
     writel(0x00000000,otg_base+OTG_BCIER1);
#else
     writel(0x0000003f,otg_base+OTG_BCIER1);
#endif

    // clear BCISR
    writel(0x0000fffd,otg_base+OTG_BCISR1);
}
// #define printk(msg...)

void otg_timer_func(unsigned long foo)
{    
    wakeup_thread();    
}

// #define printk printk

int otg_thread(void *foo)
{
    daemonize("guc-otg"); 

//    printk("otg_thread() enter\n");
    
    otg_construct();
    Init_OTG();

//    printk("otg_thread(1)\n");
    
    loopfunc = (void (*  )(void)) otg_loop;

    init_timer(&otg_timer);
    otg_timer.function = otg_timer_func;

    thread_state = THREAD_START;
    
//    printk("otg_thread(2)\n");
        
    while(thread_state != THREAD_STOP)
    {        	
    	//printk("otg_thread(3)\n");
    	
        loopfunc();   
        mod_timer(&otg_timer, jiffies + HZ/2);    
        sleep_thread();        
    }
    
    del_timer(&otg_timer);

#ifdef MODULE
    uhci_hcd_cleanup();
    ahb_ehci_module_cleanup();
#endif    

#if 1 //ted
    uhci_hcd_cleanup();
	// force Host
    _enableEHCI = 0x40020002;	//ted
    // OTGBC Initialization
     writel(_enableEHCI,otg_base+OTG_BCWR1);

     printk("Ted testing....\n");
#endif

    otg_disconstruct();

    thread_state = THREAD_DEAD; 


    return 0;    
}
// #define printk(msg...)

void start_otg_thread(void)
{
    thread_state = THREAD_INITIAL;    
    kernel_thread(otg_thread, (void *)NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);
}

void stop_otg_thread(void)
{
    thread_state = THREAD_STOP;
    wakeup_thread();
    while(thread_state != THREAD_DEAD)
    {
        yield();    
    } 
}

/*
static int otg_open(struct inode *inode, struct file *file)
{
    //MOD_INC_USE_COUNT;    
    return 0;
}

static int otg_close(struct inode *inode, struct file *file)
{
    //MOD_DEC_USE_COUNT;
    return 0;
} */

// By Macleod 2006.02.15, extern from usb.c
// A. Check support list (HID, Storage and HUB classes)
// B. Set A_HNP_SUPPORT feature, if OTG configuration descriptor existence.
extern int (*usb_otg_new_device_hook)(struct usb_device *); 

#define USB_DT_OTG_CONFIG	0x09

#define printk printk
#define num_dev  
unsigned long dev_list[]={
                  0x00000000,  // root hub
                  0x03EB3301,  // Generic Hub       Teac - US-4S-WM
                  0x045E0040,  // HID                 Microsoft - Optical USB Mouse
                  0x045E0084,  // HID                 Microsoft - Basic Optical
                  0x046DC001,  // HID                 Logiitech - Mini Wheel Mouse
                  0x046DC00F,  // HID                 Logiitech - Mouse Man Traveler                  
                  0x046DC018,  // HID                 Logiitech - USB Optical Mouse
                  0x046DC20C,  // HID                 Logiitech - Wingman precision  
		    0x046DC501,  // HID                 Logiitech - Cordless Mouse Receiver                                    
                  0x04B46560,  // Generic Hub       Teac - US-4S-20BK
                  0x04FC0C15,  // Mass Storage     NexStar-3 - Hard Drive
                  0x050D0233,  // Generic Hub       Belkin - F5U233
                  0x058F0200,  // Generic Hub       Alcor Micro - Mini Hub   
                  0x058F6386,  // Mass Storage     Transcend - Jet Flash                                   
                  0x058F6387,  // Mass Storage     Alcor Micro - Flash Disk        
                  0x058F9254,  // Generic Hub             - Mini Hub                  
                  0x05AC020B,  // Generic Hub       Apple Computer - Keyboard 
		    0x07815151,  // Mass Storage     SanDisk - Cruzer Micro
                  0x0C451060,  // Mass Storage     Sonix - Flash Disk
                  0x0EA02168,  // Mass Storage     PQI - Flash Disk
                  0x12f71a00,  // Mass Storage     Memorex Travel Drive - Flash Disk
		    0xFFFFFFFF
};
		    	  	

static int usb_otg_new_device(struct usb_device *dev)
{
   //int result;
   int i;
   unsigned long  VidPid;
   unsigned char DeviceClass= dev->descriptor.bDeviceClass; 	

//  	printk("VID: %x, PID: %x\n",dev->descriptor.idVendor, dev->descriptor.idProduct);

     // OET filter
//        if(dev->descriptor.idVendor == 0x1a0a)
//           usb_oet_filter(dev->descriptor.idProduct);

//printk("usb_otg_new_device 1 \n");

 

     // A. Check support class list (HID, Storage and HUB classes)
 //       if((_opt_test_a_continue && DeviceClass !=USB_CLASS_VENDOR_SPEC) || _opt_test_b_continue)
  	if(DeviceClass != USB_CLASS_PER_INTERFACE &&
  	   DeviceClass != USB_CLASS_HID &&
  	   DeviceClass != USB_CLASS_MASS_STORAGE &&
  	   DeviceClass != USB_CLASS_HUB)
  	{
  	    printk(">>>>>>  Unsupported Device Class %x !! <<<<<<\n",DeviceClass); 	 
  	    return 0; 	 
  	}
	
    // check Support Device List
        VidPid=dev->descriptor.idVendor<<16|dev->descriptor.idProduct;
//	 printk("VendorIdProductId:%lx\n",VidPid);
	 i=0;
        while(dev_list[i]!=0xFFFFFFFF){
		if(VidPid==dev_list[i]) {
			//printk(">>>>>> Supported Device!! <<<<<<\n");
			break;	
	       }
		i++;
        }	
	 if(VidPid!=0x0){	 // check root hub
	    if(dev_list[i]==0xFFFFFFFF  )	printk(">>>>>> Device(ID=%lx) not in the Target Peripheral List!! <<<<<<\n",VidPid);
	 }	  	
		  	
/*
       
          if(dev->descriptor.idVendor  != 0x1a0a ||
  	     dev->descriptor.idProduct != 0xbadd)
  	  {
  	  printk(">>>>>> Unsupported Device!! <<<<<<\n");
  	    device_not_support = 1;
  	    return -1;
  	  }     	     
  	
 */ 	
           return 0;	
}
int __init init_otg_module(void)
{ 

    //start_otg_ioctl();
    start_otg_thread();
    //vdisk_init();
    usb_otg_new_device_hook = usb_otg_new_device;
    return 0;
}

void __exit cleanup_otg_module(void)
{
    usb_otg_new_device_hook = NULL;	
    //vdisk_cleanup();
    //uhci_hcd_cleanup();
    stop_otg_thread();    
    //stop_otg_ioctl();    
}

module_init(init_otg_module);
module_exit(cleanup_otg_module);

MODULE_LICENSE("GPL");

#define printk printk
