

#define SDRAM_DMA

//Virtual Disk (SDRAM)
//#define VDISK_BASE      0x3e000000
#define VDISK_BASE      0x44000000
//#define VDISK_BASE      0xa0100000
// 64 MB = 64 *1024*1024 = 0x4000000
// 0x20000 = 128kB
// vdisk(63MB) range = 0xa0100000 ~ 0xa3ffffff

//Disk Memory
#define MBR_OFFSET      0xC0000000
#define CMDFF_OFFSET    0xC0080500


//************MEDUSA REGISTERS****************//

// Control Registers
#define ACR    0  // Application control Register
#define MDAR   1  // Master Destination Address Register 
#define UDCR   2  // Usb and Device Control Register
#define FNCR   3  // Frame Number Control Register
#define FHHR   4  // Flush,handshake and halt Bit Register
#define PRIR   5  // Post Request Information Register
#define STR0   6  // Setup Transaction0 Register
#define STR1   7  // Setup Transaction1 Register

// Buffer Control Registers
#define BFCR   8  // Buffer Flush Control Register 20080724 Shirley update for this new register
#define TBCR0  12 // TxBuffer0 ControlRegister
#define TBCR1  13 // TxBuffer1 ControlRegister
#define TBCR2  14 // TxBuffer2 ControlRegister
#define TBCR3  15 // TxBuffer3 ControlRegister

//Interrupt Control Registers
#define IER    20 // Interrupt Enable Register
#define IDR    21 // Interrupt Disable Register
#define ISR    22 // Interrupt Status Register

//Configuration Registers
#define CCR    28 // Current Configuration Register
#define PIR0   29 // Physical Interface Register0
#define PIR1   30 // Physical Interface Register1

//EndPoint Registers
#define EDR0   32 // EndPoint Descriptor Register0
#define EDR1   33 // EndPoint Descriptor Register1
#define EDR2   34 // EndPoint Descriptor Register2
#define EDR3   35 // EndPoint Descriptor Register3
#define EDR4   36 // EndPoint Descriptor Register4
#define EDR5   37 // EndPoint Descriptor Register5
#define EDR6   38 // EndPoint Descriptor Register6


// Virtual Disk Size
#define VIRDISKSIZE     0x01EA0000

// CSW Status
#define   GOOD                0
#define   CMD_FAIL            1
#define   PHASE_ERROR         2

//-----------------------------------
// Stream pipe transaction stage
//-----------------------------------
#define BULK_SETUP      0
#define BULK_DATA       1
#define BULK_STATUS     2

//-----------------------------------
// Message pipe SETUP data
//-----------------------------------
#define GMAXLUN         0
#define GET_DESCRIPTOR  1
#define SET_DESCRIPTOR  2
#define VENDOR66        3
#define VENDOR67        4
#define VENDOR68        5
#define UNSUPPORT       6

//-----------------------------------
// Message pipe transaction stage
//-----------------------------------
#define CTRL_SETUP      0
#define CTRL_DATA       1
#define CTRL_STATUS     2
#define CTRL_OTHER      3
#define CTRL_OUT        4
#define CTRL_IN         5

//-----------------------------------
// SCSI Command
//-----------------------------------
#define   TESTUNIT            0x00
#define   REQSENSE            0x03
#define   INQUERY             0x12
#define   MODESENSE           0x1A
#define   MODESENSE10         0x5A
#define   STARTSTOP           0x1B
#define   REMOVAL             0x1E
#define   CMD_23              0x23
#define   CAPACITY            0x25
#define   READ10              0x28
#define   WRITE10             0x2A
#define   VERIFY              0x2F
#define   CMD_FF              0xFF
#define	  READ12			  0xA8
#define	  WRITE12			  0xAA
#define   MODESEL6			  0x15
#define   MODESEL10			  0x55
//-----------------------------------
// Medusa IRQ event
//-----------------------------------
#define USB_NO_EVT          0x0
#define DMA_DONE_EVT        0x1
#define DMA_ERR_EVT         0x2
#define USB_CONN_EVT        0x4
#define USB_RESET_EVT       0x8
#define USB_CTRL_SETUP_EVT  0x10
#define USB_CTRL_OUT_EVT    0x20
#define USB_CTRL_IN_EVT     0x40
#define USB_CTRL_QUERY_EVT  0x80
#define USB_BULKIN_EVT      0x100
#define USB_BULKOUT_EVT     0x200
#define USB_DISCONN_EVT     0x400
#define USB_OTH_EVT         0x800


//-----------------------------------
// SCSI Command Sense Key
//-----------------------------------
#define   NO_SENSE       0
#define   RECOVER_ERR    1
#define   NOT_READY      2
#define   MEDIEM_ERR     3
#define   HARDWARE_ERR   4
#define   ILLEGAL_REQ    5
#define   UNIT_ATTEN     6
#define   DATA_PROT      7
#define   BLANK_CHECK    8
#define   VENDOR_SPEC    9
#define   COPY_ABORT     10
#define   ABORT_CMD      11
#define   OBSOLETE       12
#define   VOLUME_OVFW    13
#define   MISCOMPARE     14
//-----------------------------------
// SCSI Command ASC/ASCQ
//-----------------------------------
#define   LU_NOT_SUP          0x0025
#define   NO_ADD_SENSE        0x0000
#define   INVALID_CDB         0x0024
#define   MISCOMP_VFY         0x001d
#define   INVALID_OPC         0x0020
#define   MEDIA_NOT_PRESENT   0x3A


//-----------------------------------
// CBW/CSW Signature
//-----------------------------------
#define   CBWSIGNATURE        0x43425355
#define   CSWSIGNATURE        0x53425355

struct USBHandle 
{
    int bulk_cs;                     // BULK Endpoint Current Stage
                                            // 0:SETUP, 1:DATA, 2:STATUS
    int cswtag;                      // CSW Tag
    int cswres_c;                    // Current CSW Residue Data
    int cswstatus_c;                 // Current CSW Status
    int data_length_c;               // Current executed datalength
    int data_cnt;                    // Receive PRIR Data Count
    int data_length;                 // SCSI Command request datalength
    unsigned int noff;               // read command offset
    int command;                     // command code
    int dma_flag;

    int direction;                   // SCSI Command direction
                                     // 0x00: OUT, 0x80: IN
    unsigned int CBW_BUFFER[8] ;     // command blcok wrapper   buffer
    unsigned int SKEY_BUFFER[5];     // SCSI SENSE KEY buffer
    unsigned int CAP_BUFFER[2];      // SCSI command CAPACITY data buffer
    unsigned int INQRY_BUFFER[9];    // INQUERY command return data buffer
    unsigned int CMD23_BUFFER[3];    // command 23 data buffer
    unsigned int MODE_BUFFER[3];     // MODE SENSE command data buffer

    unsigned int Device_DescBUFFER[18]; //usb device descriptor buffer

    //for my checking
    //unsigned int Device_DescBUFFER[64]; //usb device descriptor buffer
    //unsigned int Device_DescBUFFER1[18]; //usb device descriptor buffer

    unsigned int Configure_DescBUFFER[16]; // usb configuration descriptor buffer
    unsigned int Qualifier_DescBUFFER[3];  // usb qualifier descriptor buffer
    unsigned int OtherSpeed_DescBUFFER[16]; // usb other speed configuration descriptor buffer
    unsigned int String_DescBuffer[32];    //usb string descriptor buffer
    unsigned int OTG_DescBuffer[1];  //USB OTG descriptor buffer    

    int data_addr;                   // Bulk Data Stage RAM access addr
    unsigned int Clba;               // CBWCB LBA,logic block address
    int cbwb_addr;                   // Bulk CBWB address
    int stdcmd;                      // Standard Command Type
    int ctrl_ns;                     // Ctrl Next stage
    int des_dataok;                  // Descriptor data transfer count
    int des_addr;                    // Descriptor RAM address
    int pep_c;                       // Current Active Physical Endp
    int lba_c;                       // Current LBA
};
struct Device_Descriptor
{
    unsigned int buffer[18];
};
struct Configuration_Descriptor
{
    unsigned int buffer[18];
};
struct CBW_BUFFER
{
    unsigned int buffer[16];
    
};
struct Skey_Buffer
{
    unsigned int buffer[5];
};

struct Capab
{
    unsigned int buffer[2];
};

struct csw_buffer
{
    unsigned int buffer[8];
};
//unsigned int csw_flag =1;

struct StdInquiryData
{ 
    unsigned int buffer[36];
};

struct ScsiCmd
{
    unsigned int buffer[3];
};

struct Mode_Buffer
{
    unsigned int buffer[3];
};
struct String_Descriptor
{
    unsigned int buffer[28];
};

//Shirley 2006/01/16
struct Other_Speed
{
    unsigned int buffer[16];    
};



void usbInitInMain(void);
void load_usb_descriptors(struct USBHandle *usb_handle);
void set_scsi_capicitybuf(struct USBHandle *usb_handle);
void reset_medusa(void);
void msgpipe(struct USBHandle *usb_handle, int stage);
void bulkout(struct USBHandle *usb_handle);
void bulkin(struct USBHandle *usb_handle);
void datain(struct USBHandle *usb_handle);
void dataout(struct USBHandle *usb_handle);
void cbwcheck(struct USBHandle *usb_handle);
void cswcheck(struct USBHandle *usb_handle);
void write10(struct USBHandle *usb_handle);
void read10(struct USBHandle *usb_handle);
void mass_reset(struct USBHandle *usb_handle);
void InitSectors(void);

int ReadPhyVDiskNByte(unsigned int nSector, unsigned int nOffset,
               unsigned int nSize, unsigned char *pBuf);
int WritePhyVDiskNByte(unsigned int nSector, unsigned int nOffset, 
               unsigned int nSize, unsigned char *pBuf);

void setBootSector(unsigned int *buffer);
void testunit(struct USBHandle *usb_handle);
void reqsense(struct USBHandle *usb_handle);
void inquery(struct USBHandle *usb_handle);
void modesense(struct USBHandle *usb_handle);
void startstop(struct USBHandle *usb_handle);
void removal(struct USBHandle *usb_handle);
void cmd23(struct USBHandle *usb_handle);
void capacity(struct USBHandle *usb_handle);
void verify(struct USBHandle *usb_handle);
void cmdff(struct USBHandle *usb_handle);
void Data_Structures(unsigned int);
void Allocate_memory(void);
void Speed_Switch(unsigned int);
//struct USBHandle ;

//signed int isFirstTimeMedusa =1;



void Init_Hw(void);
/*struct Dev_Desc
{
    unsigned int Device_DescBUFFER1[18]; //usb device descriptor buffer
}*/



void reset_medusa(void);
int Init_Medusa(void);

extern struct USBHandle *handle_s;


