//  ***************************************************************************
// 
//   Copyright (c) 2009  Evatronix SA 
//
//  ***************************************************************************
//
//   Please review the terms of the license agreement before using     
//   this file. If you are not an authorized user, please destroy this 
//   source code file and notify Evatronix SA immediately that you     
//   inadvertently received an unauthorized copy.                      
//
//  ***************************************************************************
/// @file           nf_error.h
/// @brief          Aditional helpful functions.
/// @version        $Revision: 1.5 $
/// @author         Piotr Sroka
/// @date           $Date: 2010-04-16 08:01:06 $
//  ***************************************************************************


#ifndef NF_ERROR_H
#define NF_ERROR_H

/** no errors */
#define NF_ERR_NO_ERRORS                0x00u
/** error - invalid parameter passed to function */
#define NF_ERR_INVALID_PARAMETER        0x01u
/** error caused by trying to write/erase protected area  */
#define NF_ERR_PROTECTED                0x02u
/** current page of memory operation error */
#define NF_ERR_CURR_PAGE_OP_ERR         0x03u
/** previous page memory  operation error */
#define NF_ERR_PRIOR_PAGE_OP_FAIL       0x04u
/** current and previous page memory  operation error */
#define NF_ERR_PRIOR_CURR_PAGE_OP_FAIL  0x05u
/**  The ECC module detected uncorrectable errors number 
 * during the read operation */
#define NF_ERR_ECC_FATAL                0x06u
/** The ECC module detected
 * that the error level sat by the ECC_CTRL.ERR_THRESHOLD was exceeded*/
#define NF_ERR_ECC_TRSH                 0x07u
/** there is no free fields in lookup table */
#define NF_ERR_NO_LOOKUP_TABLE_FULL     0x08u
/** invalid address */
#define NF_ERR_INVALID_ADDRESS          0x09u
/** unique id of nandflash memory contains errors */
#define NF_ERR_WRONG_UNIQUE_ID          0x0Au
/** operation timeout */
#define NF_ERR_TIMEOUT                  0x0Bu
/** buffer is not aligned to 4 */
#define NF_ERR_DATA_NOT_ALIGNED_TO_4B   0x0Du
/** scatter gather mode is not supported
 when option USE_INDIRECT_BUFFER is set */
#define NF_ERR_DMA_SG_UNSUPPORTED_IB    0x0Eu
/** error occurs during the DMA transfer */
#define NF_ERR_DMA_ERROR                0x0Fu
/** ECC code exceed page boundary. 
 ECC code is to big or ECC offset is to big, or spare area is to small*/
#define NF_ERR_ECC_OUT_OFF_PAGE         0x10u
/** bbt table not found on nand flash memory */
#define NF_ERR_BBT_NOT_EXISTS           0x11u
/** bbt table invalid */
#define NF_ERR_BBT_ORGINAL_INVALID      0x12u
/** copy of bbt table is invalid */
#define NF_ERR_BBT_COPY_INVALID         0x13u
/** page size or page_shift parameter are wrong initialized */
#define NF_ERR_BBT_PAGE_SIZE_IMPROPER   0x14u
/** unasigned factory bad block object to memory object */
#define NF_ERR_UNINITIALIZED_BBT        0x15u
/** to many blocks per memory. BBT doesn't support bigger or equal 0x10000 */
#define NF_ERR_TO_MANY_BLOCK_COUNT      0x16u
/** error try to program/erase write protect memory */
#define NF_ERR_MEMORY_WRITE_PROTECTED   0x17u
/** unsupported operation  */
#define NF_ERR_UNSUPPORTED_OPERATION    0x18u

#endif

