/*
 *  linux/arch/arm/mach-umvp/mm.c
 *
 *  Copyright (C) Global Unichip Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/init.h>

#include <asm/io.h>
#include <asm/pgtable.h>
#include <asm/page.h>
#include <asm/mach/map.h>
#include <mach/hardware.h>
#include <mach/umvp_serial.h>

static struct map_desc umvp2500_io_desc[] __initdata =
{
	{ IO_ADDRESS(UHC_BASE_ADDR),		__phys_to_pfn(UHC_BASE_ADDR),		SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(MEDUSA_BASE_ADDR),		__phys_to_pfn(MEDUSA_BASE_ADDR),	SZ_4K,		MT_DEVICE},		
	{ IO_ADDRESS(OTG_BASE_ADDR),		__phys_to_pfn(OTG_BASE_ADDR),		SZ_4K,		MT_DEVICE},			
	{ IO_ADDRESS(EHC_AHB_BASE_ADDR),	__phys_to_pfn(EHC_AHB_BASE_ADDR),	SZ_4K,		MT_DEVICE},		
	{ IO_ADDRESS(UMVP_VIC_BASE),		__phys_to_pfn(UMVP_VIC_BASE),		SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(UMVP_TIMER_BASE),		__phys_to_pfn(UMVP_TIMER_BASE),		SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(UMVP_DAI_BASE), 		__phys_to_pfn(UMVP_DAI_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_UART0_BASE),		__phys_to_pfn(UMVP_UART0_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_UART1_BASE),		__phys_to_pfn(UMVP_UART1_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_UART2_BASE),		__phys_to_pfn(UMVP_UART2_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_UART3_BASE),		__phys_to_pfn(UMVP_UART3_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_UART4_BASE),		__phys_to_pfn(UMVP_UART4_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_DMAP_BASE),		__phys_to_pfn(UMVP_DMAP_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_SDMMC_BASE),		__phys_to_pfn(UMVP_SDMMC_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_WDT_BASE),		__phys_to_pfn(UMVP_WDT_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_I2C0_BASE),		__phys_to_pfn(UMVP_I2C0_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_I2C1_BASE),		__phys_to_pfn(UMVP_I2C1_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_I2C2_BASE),		__phys_to_pfn(UMVP_I2C2_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_GPIO0_BASE),		__phys_to_pfn(UMVP_GPIO0_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_GPIO1_BASE),		__phys_to_pfn(UMVP_GPIO1_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_GPIO2_BASE),		__phys_to_pfn(UMVP_GPIO2_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_GPIO3_BASE),		__phys_to_pfn(UMVP_GPIO3_BASE),		SZ_4K,		MT_DEVICE},
 	{ IO_ADDRESS(UMVP_GPIO4_BASE),		__phys_to_pfn(UMVP_GPIO4_BASE),		SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(UMVP_VCAP_BASE),       __phys_to_pfn(UMVP_VCAP_BASE),      SZ_4K,      MT_DEVICE},
	{ IO_ADDRESS(UMVP_SYSTEM_BASE),		__phys_to_pfn(UMVP_SYSTEM_BASE),	SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(UMVP_ETHERNET_BASE),	__phys_to_pfn(UMVP_ETHERNET_BASE),	SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(UMVP_LCD_BASE),		__phys_to_pfn(UMVP_LCD_BASE),		SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(UMVP2500_INTERNAL_SRAM_BASE),			__phys_to_pfn(UMVP2500_INTERNAL_SRAM_BASE),			SZ_4K,		MT_DEVICE},
	{ IO_ADDRESS(UMVP_POM_BASE),		__phys_to_pfn(UMVP_POM_BASE),		SZ_4K,		MT_DEVICE},
};

void __init umvp2500_map_io(void)
{
	unsigned int i;
	iotable_init(umvp2500_io_desc, ARRAY_SIZE(umvp2500_io_desc));
	for (i=0; i<ARRAY_SIZE(umvp2500_io_desc); i++) {
//		printk(KERN_WARNING "vir=0x%08x pfn=0x%08x \n",
		printk(KERN_WARNING "vir=0x%08lx pfn=0x%08lx \n",
			 umvp2500_io_desc[i].virtual, umvp2500_io_desc[i].pfn);
	}
}
