#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/i2c.h>
#include <linux/platform_device.h>

#include <asm/system.h>
#include <asm/io.h>
#include <mach/hardware.h>

static struct resource umvp_resources0[] = {
	[0] = {
		.start	= UMVP_I2C0_BASE,
		.end	= UMVP_I2C0_BASE + 0x10000 - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct resource umvp_resources1[] = {
	[0] = {
		.start	= UMVP_I2C1_BASE,
		.end	= UMVP_I2C1_BASE + 0x10000 - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct resource umvp_resources2[] = {
	[0] = {
		.start	= UMVP_I2C2_BASE,
		.end	= UMVP_I2C2_BASE + 0x10000 - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device umvp_i2c0_device = {
	.name		= "umvp_i2c0",
	.id		= 0,
	.resource	= umvp_resources0,
	.num_resources	= ARRAY_SIZE(umvp_resources0),
};

static struct platform_device umvp_i2c1_device = {
	.name		= "umvp_i2c1",
	.id		= 1,
	.resource	= umvp_resources1,
	.num_resources	= ARRAY_SIZE(umvp_resources1),
};


static struct platform_device umvp_i2c2_device = {
	.name		= "umvp_i2c2",
	.id		= 2,
	.resource	= umvp_resources2,
	.num_resources	= ARRAY_SIZE(umvp_resources2),
};

void __init umvp_add_device_i2c(struct i2c_board_info *devices, int nr_devices)
{
	int ret;
	i2c_register_board_info(0, devices, nr_devices);
#if 0 //Ted
//	ret = platform_device_register(&umvp_i2c0_device);
	platform_device_register(&umvp_i2c1_device);
#else
	ret = platform_device_register(&umvp_i2c0_device);
#endif
	printk(KERN_INFO "ret = %d \n", ret);
	//platform_device_register(&umvp_i2c2_device);
}
