/*
 * linux/arch/arm/mach-umvp2500/board_umvp2500.c
 *
 * Copyright (C) Global Unichip Corp
 * Author: Rudolph Lu <rudolph.lu@globalunichip.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <linux/delay.h>
#include <linux/workqueue.h>
#include <linux/i2c.h>
#include <linux/i2c/at24.h>
#include <linux/input.h>
#include <linux/err.h>
#include <linux/clk.h>
#include <linux/io.h>

#include <mach/hardware.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/flash.h>
#include <mach/general.h>
#include <mach/hardware.h>
#include <mach/lcm.h>

#ifdef CONFIG_MACH_UMVP2500

extern void umvp2500_map_io(void);
extern void umvp2500_init_irq(void);
extern struct sys_timer umvp2500_timer;
extern void __init umvp_add_device_i2c(struct i2c_board_info *, int );
	
static void A1_power_off(void)
{
	/* A place holder for post-processing before system power off */
}

static void __init umvp2500_init(void)
{
	pm_power_off = A1_power_off;
}

//MACHINE_START(UMVP2500, "GUC UMVP2500 board")
MACHINE_START(UMVP2500, "ACTi A1")
	.nr		= MACH_TYPE_UMVP2500,
	.phys_io	= IO_START,
	.io_pg_offst	= (IO_ADDRESS(IO_START) >> 18) & 0xfffc,
	.boot_params	= PHYS_OFFSET + 0x100,
	.map_io		= umvp2500_map_io,
	.init_irq	= umvp2500_init_irq,
	.init_machine	= umvp2500_init,//umvp2500_init,
	.timer		= &umvp2500_timer,
MACHINE_END
 
#endif
