#!/bin/sh
####################################################################################
# fw_upg_patch.sh
#    Sometimes, we need some workaround to allow new firmware works after
# firmware upgrade but before reboot. Firmware has to execute this script right
# after burn firmware image to the flash.
####################################################################################

#### leave this script if there is no workaround need.
workaround_need=1
#### give the bootloader image file name here to workaround the bootloader
update_bootloader=""
update_bootloader_env=0
update_others=1

image_dir="/var/www/images/tmp/fw_upg_patch"

if [ $workaround_need == 0 ]; then
	echo "$0:no need to do any workaround after firmware upgrade"
	exit 0
fi

#### check if it need to upgrade the bootloader
if [ ! "$update_bootloader" == "" ]; then
	bootloader_bin="$image_dir/$update_bootloader"
	if [ -f $bootloader_bin ]; then
		echo "$0:workaround to upgrade bootloader $update_bootloader"
		nandwrite -p /dev/mtd_uboot $bootloader_bin
	else
		echo "$0:error. not found $update_bootloader to workaround bootloader"
	fi
fi
#### update the bootloader variables if needs
if [ $update_bootloader_env == 1 ]; then
	echo "$0: update bootloader variables"
fi

#### additioanl path 
if [ $update_others == 1 ]; then
	echo "$0:workaround ...."
	$image_dir/bootpsize
fi

exit 0
